<?php
/**
 *	Module made by Nukium
 *
 *  @author    Nukium
 *  @copyright 2021 Nukium SAS
 *  @license   All rights reserved
 *
 * ███    ██ ██    ██ ██   ██ ██ ██    ██ ███    ███
 * ████   ██ ██    ██ ██  ██  ██ ██    ██ ████  ████
 * ██ ██  ██ ██    ██ █████   ██ ██    ██ ██ ████ ██
 * ██  ██ ██ ██    ██ ██  ██  ██ ██    ██ ██  ██  ██
 * ██   ████  ██████  ██   ██ ██  ██████  ██      ██
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; 
}

if (!class_exists('WC_Gls_tracking_state')) {
    require_once ( GLS_PLUGIN_PATH . 'classes/class-gls-tracking-state.php' );
}

if (!class_exists('GlsApi')) {
    require_once ( GLS_PLUGIN_PATH . 'classes/GlsApi.php' );
}

class WC_Gls_Admin_Order_Meta_Boxes {

    public function __construct() {
        add_action( 'admin_notices', array( $this, 'display_admin_notices' ) );
        add_action( 'add_meta_boxes', array( $this, 'add_meta_boxes' ), 40 );
        add_filter( 'admin_footer-post.php', array( $this, 'add_footer_form' ) );
    }

    public function display_admin_notices() {

        if ( 'shop_order' === $GLOBALS['post_type'] && isset($_GET['post'])) {

            global $post, $wpdb;

            
            $order = wc_get_order($post->ID);
            foreach( $order->get_items( 'shipping' ) as $item_id => $shipping_item_obj ) {
                if ($shipping_item_obj->get_method_id() === 'gls_relais' ) {
                    $orderIsGlsRelais = true;
                    break;
                }
            }

            if ($orderIsGlsRelais) {

                $cart_carrier_detail = $wpdb->get_row("SELECT * FROM {$wpdb->prefix}woocommerce_gls_cart_carrier WHERE order_id = '" . $order->get_id() . "'");
                if ( !$cart_carrier_detail || ( $cart_carrier_detail && empty($cart_carrier_detail->parcel_shop_id) ) ) {
                    $class = 'notice notice-warning';
                    $message = __( 'There is no GLS Relais associated to the carrier, please select one.', 'woocommerce-gls' );

                    printf( '<div class="%1$s"><p><a href="#orderGlsChangeRelayModal">%2$s</a></p></div>', esc_attr( $class ), esc_html( $message ) );
                }

            }
        }
    }

    public function add_meta_boxes() {
        foreach ( wc_get_order_types( 'order-meta-boxes' ) as $type ) {
			$order_type_object = get_post_type_object( $type );
            add_meta_box( 'woocommerce-gls-order-label', sprintf( __( '%s: GLS carrier', 'woocommerce-gls' ), $order_type_object->labels->singular_name ), 'WC_Gls_Admin_Order_Meta_Boxes::output_order_label', $type, 'side', 'default' );
        }
    }

    public function add_footer_form( $post ) {
        if ( 'shop_order' !== $GLOBALS['post_type'] )
            return;

        global $post;

        $options = get_option( 'woocommerce_gls_admin_order_label_settings' );
        Nukium::load_view('admin/order-meta-box-label', array(
            'id_order' => $post->ID,
            'order_status_selected' => ( isset($options['label_single_new_order_state']) ? $options['label_single_new_order_state'] : ''),
            'display_form' => true,
        ));
    }

    public static function output_order_label( $post ) {
        global $wpdb;

        $options = get_option( 'woocommerce_gls_admin_order_label_settings' );
        $display_btn_change_relay = false;
        $orderIsGls = false;

        
        $order = wc_get_order($post->ID);
        foreach( $order->get_items( 'shipping' ) as $item_id => $shipping_item_obj ) {
            if ($shipping_item_obj->get_method_id() === 'gls_relais' ) {
                $display_btn_change_relay = true;
                $orderIsGls = true;
                break;
            }
            if (array_key_exists($shipping_item_obj->get_method_id(), WC_Gls::$carrier_definition)) {
                $orderIsGls = true;
            }
        }

        $trackingState = false;
        $trackingStateTime = '';
        $current_state = '';
        if ($orderIsGls) {
            $trackingState = WC_Gls_tracking_state::get_by_order_id($post->ID);
            if ($trackingState !== false && $trackingState instanceof WC_Gls_tracking_state) {
                $current_state = WC_Gls::$trackingStates[$trackingState->current_state];
                $trackingStateTime = new DateTime($trackingState->date_upd);
            }
        }

        $trackingStateTimeDisplayed = '';
        if (!empty($trackingStateTime)) {
            $trackingStateTimeDisplayed = sprintf(
                '<time datetime="%1$s" title="%2$s">%2$s</time>',
                esc_attr( $trackingStateTime->format('c') ),
                esc_html( date_i18n( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ) , $trackingStateTime->getTimestamp()) )
            );
        }

        $view_params = array(
            'id_order' => $post->ID,
            'order_status_selected' => ( isset($options['label_single_new_order_state']) ? $options['label_single_new_order_state'] : ''),
            'display_form' => false,
            'display_btn_change_relay' => $display_btn_change_relay,
            'trackingState' => $trackingState,
            'trackingStateTimeDisplayed' => $trackingStateTimeDisplayed,
            'current_state' => $current_state,
            'is_gls' => $orderIsGls,
        );

        if ($display_btn_change_relay) {
            $shipping_settings = get_option( 'woocommerce_gls_relais_settings' );
			if (!empty($shipping_settings)) {

				$error = array();
                $cart_carrier_detail = $wpdb->get_row("SELECT * FROM {$wpdb->prefix}woocommerce_gls_cart_carrier WHERE order_id = '" . $order->get_id() . "'");
				$relay_points = '';

                
                if ($order->get_shipping_country() != 'FR') {
                    $error = array('code' => '', 'message' => __( 'Service available only in France.', 'woocommerce-gls' ));
                } else {
                    
                    @ini_set('default_socket_timeout', '5');
                    $gls = new GlsController(array(
                        'GLS_WSLOGIN' => get_option( 'gls_settings_wslogin' ),
                        'GLS_WSPWD' => get_option( 'gls_settings_wspwd' ),
                    ));

                    $result = $gls->searchRelay($order->get_shipping_country(), $order->get_shipping_postcode(), $order->get_shipping_city());

                    @ini_restore('default_socket_timeout');

                    
                    if (isset($result->exitCode->ErrorCode)) {

                        if ((int)$result->exitCode->ErrorCode == 998 || (int)$result->exitCode->ErrorCode == 999) {

                            
                            $error = array('code' => $result->exitCode->ErrorCode, 'message' => __( 'We haven\'t found any GLS Relais in your delivery area. Please expand your search.', 'woocommerce-gls' ));

                        } elseif ((int)$result->exitCode->ErrorCode == 0) {

                            $relay_points = $result->SearchResults;

                            
                            if($shipping_settings['GLS_GLSRELAIS_XL_ONLY'] == 'yes') {
                                foreach ($relay_points as $key => $value) {
                                    if (!empty($value->Parcelshop->Address->Name1) && substr($value->Parcelshop->Address->Name1, -2)  != 'XL') {
                                        unset($relay_points[$key]);
                                    }
                                }
                                $relay_points = array_values($relay_points);
                            }

                            if (count($relay_points) <= 0) {
                                $error = array('code' => 998, 'message' => __( 'We haven\'t found any GLS Relais in your delivery area. Please expand your search.', 'woocommerce-gls' ));
                            }
                        } else {
                            $error = array('code' => $result->exitCode->ErrorCode, 'message' => $result->exitCode->ErrorDscr);
                        }
                    } else {
                        
                        $error = array('code' => '', 'message' => __( 'Service temporarily unavailable, try again later.', 'woocommerce-gls' ));
                    }
                }

				$view_params = array_merge($view_params, array(
					'trans_days' => array(
							'0' => __( 'Monday', 'woocommerce-gls' ),
							'1' => __( 'Tuesday', 'woocommerce-gls' ),
							'2' => __( 'Wednesday', 'woocommerce-gls' ),
							'3' => __( 'Thursday', 'woocommerce-gls' ),
							'4' => __( 'Friday', 'woocommerce-gls' ),
							'5' => __( 'Saturday', 'woocommerce-gls' ),
							'6' => __( 'Sunday', 'woocommerce-gls' )),
					'labels' => 'ABCDEFGHIJKLMNOPQRSTUVWXYZ',
					'only_xl' => (bool)($shipping_settings['GLS_GLSRELAIS_XL_ONLY'] == 'yes'),
					'relay_points' => $relay_points,
					'is_relay_carrier' => true,
					'error' => $error,
					'current_relay' => ($cart_carrier_detail && !empty($cart_carrier_detail->parcel_shop_id) ? $cart_carrier_detail->parcel_shop_id : ''),
				));
            }
        }

        Nukium::load_view('admin/order-meta-box-label', $view_params);
    }

    public function change_relay_point() {

        global $wpdb;

        check_ajax_referer( 'gls-ajax-request' );

        $return = array(
            'result' => false,
            'message' => ''
        );

        $id_order = (int)$_POST['gls_id_order'];
        $gls_relay_id = $_POST['gls_relay_id'];
        $order = wc_get_order($id_order);
        $id_carrier = 'gls_relais';

        if (!empty($gls_relay_id) && !empty($id_order) && $order instanceof WC_Order) {

            
            $gls = new GlsController(array(
                'GLS_WSLOGIN' => get_option( 'gls_settings_wslogin' ),
                'GLS_WSPWD' => get_option( 'gls_settings_wspwd' ),
            ));
            $relay_detail = $gls->getRelayDetail($gls_relay_id);

            
            if ($relay_detail) {

                $order_detail = $wpdb->get_row("SELECT * FROM {$wpdb->prefix}woocommerce_gls_cart_carrier WHERE order_id = '" . $order->get_id() . "'");

                
                $gls_product = WC_Gls::get_gls_product($id_carrier);

                if ($order_detail) {
                    $query = $wpdb->query( $wpdb->prepare( "
                        UPDATE {$wpdb->prefix}woocommerce_gls_cart_carrier
                        SET parcel_shop_id = '%s', name = '%s', address1 = '%s', address2 = '%s', postcode = '%s', city = '%s', phone = '%s',
                            phone_mobile = '%s', country = '%s', parcel_shop_working_day = '%s', shipping_method_id = '%s', gls_product = '%s'
                        WHERE order_id=%d
                        " , $gls_relay_id,
                        $relay_detail['Name1'],
                        $relay_detail['Street1'],
                        $relay_detail['Street2'],
                        $relay_detail['ZipCode'],
                        $relay_detail['City'],
                        $relay_detail['Phone'],
                        $relay_detail['Mobile'],
                        $relay_detail['Country'],
                        json_encode($relay_detail['GLSWorkingDay']),
                        $id_carrier,
                        $gls_product,
                        (int)$order->get_id())
                    );

                } else {

                    $query = $wpdb->query( $wpdb->prepare( "
                        INSERT INTO {$wpdb->prefix}woocommerce_gls_cart_carrier
                        (`session_id`, `customer_id`, `order_id`, `shipping_method_id`, `gls_product`, `parcel_shop_id`, `name`, `address1`, `address2`, `postcode`, `city`, `phone`, `phone_mobile`, `customer_phone_mobile`, `country`, `parcel_shop_working_day`)
                        VALUES ('%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s')
                        ",
                        $order->get_customer_id(),
                        $order->get_customer_id(),
                        (int)$order->get_id(),
                        $id_carrier,
                        $gls_product,
                        $gls_relay_id,
                        $relay_detail['Name1'],
                        $relay_detail['Street1'],
                        $relay_detail['Street2'],
                        $relay_detail['ZipCode'],
                        $relay_detail['City'],
                        $relay_detail['Phone'],
                        $relay_detail['Mobile'],
                        $order->get_billing_phone(),
                        $relay_detail['Country'],
                        json_encode($relay_detail['GLSWorkingDay'])
                    ) );

                }

                if (!$query) {
                    $return['message'] = __('Unexpected error occurred while saving delivery informations.', 'woocommerce-gls' );
                } else {
                    
                    $order->set_shipping_company($relay_detail['Name1']);
                    $order->set_shipping_address_1($relay_detail['Street1']);
                    $order->set_shipping_address_2($relay_detail['Street2']);
                    $order->set_shipping_city($relay_detail['City']);
                    $order->set_shipping_state('');
                    $order->set_shipping_postcode($relay_detail['ZipCode']);
                    $order->set_shipping_country($relay_detail['Country']);
                    $order->save();

                    $return['result'] = true;
                }

            } else {
                $return['message'] = __('GLS Relais informations not found. Please select another one.', 'woocommerce-gls' );
            }
        } else {
            $return['message'] = __('Please select a GLS Relais', 'woocommerce-gls' );
        }

        header('Content-Type: application/json');
        wp_die(
            wp_json_encode($return)
        );
    }

    public function update_tracking_state() {

        global $wpdb;

        check_ajax_referer( 'gls-ajax-request' );

        $return = array(
            'result' => false,
            'message' => ''
        );


        $id_order = (int)$_POST['gls_id_order'];
        $order = wc_get_order($id_order);

        if (!empty($id_order) && $order instanceof WC_Order) {

            try {

                $result = WC_Gls::cronGetTracking($id_order);
                if ($result) {
                    if (isset($result['error'])) {
                        $return = array(
                            'result' => false,
                            'message' => $result['message'],
                        );
                    } else {
                        $return = array(
                            'result' => true,
                            'current_state' => (isset($result['current_state']) ? $result['current_state'] : ''),
                            'current_state_date' => (isset($result['current_state_date']) ? $result['current_state_date'] : ''),
                            'message' => (isset($result['message']) ? $result['message'] : ''),
                        );
                    }
                }

            } catch (Exception $e) {
                $return['message'] = $e->getMessage() . ' [' . $e->getCode() . ']';
            }

        } else {
            $return['message'] = __('An error occured with this order', 'woocommerce-gls' );
        }

        header('Content-Type: application/json');
        wp_die(
            wp_json_encode($return)
        );
    }

    public function refresh_meta_box() {

        check_ajax_referer( 'gls-ajax-request' );

        $return = array(
            'result' => false,
            'message' => ''
        );

        $id_order = (int)$_POST['gls_id_order'];
        if ($id_order > 0) {
            $post = get_post( $id_order );

            ob_start();
            self::output_order_label($post);
            $buffer = ob_get_contents();
            @ob_end_clean();

            if (!empty($buffer)) {
                $return['content'] = $buffer;
                $return['result'] = true;
            } else {
                $return['message'] = __('Error retrieving GLS content', 'woocommerce-gls' );
            }
        } else {
            $return['message'] = __('Order not found', 'woocommerce-gls' );
        }

        header('Content-Type: application/json');
        wp_die(
            wp_json_encode($return)
        );

    }

}

$gls_admin_order_meta_boxes = new WC_Gls_Admin_Order_Meta_Boxes();

add_action( 'wp_ajax_gls_change_relay_point', array( $gls_admin_order_meta_boxes, 'change_relay_point' ) );
add_action( 'wp_ajax_nopriv_gls_change_relay_point', array( $gls_admin_order_meta_boxes, 'change_relay_point' ) );

add_action( 'wp_ajax_gls_update_tracking_state', array( $gls_admin_order_meta_boxes, 'update_tracking_state' ) );
add_action( 'wp_ajax_nopriv_gls_update_tracking_state', array( $gls_admin_order_meta_boxes, 'update_tracking_state' ) );

add_action( 'wp_ajax_gls_refresh_meta_box', array( $gls_admin_order_meta_boxes, 'refresh_meta_box' ) );
add_action( 'wp_ajax_nopriv_gls_refresh_meta_box', array( $gls_admin_order_meta_boxes, 'refresh_meta_box' ) );
