<?php
/**
 *  Module made by Nukium
 *
 *  @author    Nukium
 *  @copyright 2021 Nukium SAS
 *  @license   All rights reserved
 *
 * ███    ██ ██    ██ ██   ██ ██ ██    ██ ███    ███
 * ████   ██ ██    ██ ██  ██  ██ ██    ██ ████  ████
 * ██ ██  ██ ██    ██ █████   ██ ██    ██ ██ ████ ██
 * ██  ██ ██ ██    ██ ██  ██  ██ ██    ██ ██  ██  ██
 * ██   ████  ██████  ██   ██ ██  ██████  ██      ██
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

class GlsController
{
	

	private	$soap_location 	= 	'http://www.gls-group.eu/276-I-PORTAL-WEBSERVICE/services/ParcelShopSearch/wsdl/2010_01_ParcelShopSearch.wsdl';

	

	private $ws_login = '';

	

	private $ws_pwd = '';

	

	private $soap_client	=	null;

	public function __construct($_params = null)
	{
		if (!is_null($_params)) {
		    $this->ws_login = $_params['GLS_WSLOGIN'];
		    $this->ws_pwd = $_params['GLS_WSPWD'];
		}
	}

	

    public function searchRelay($_country = 'FR', $_cp, $_city = '', $_street = '')
	{
		$soapclient = $this->_get_soap_client();

		if ($soapclient) {
    		
    		$credentials = array('UserName' => $this->ws_login, 'Password' => $this->ws_pwd);
    		$address = array('ZipCode' => $_cp, 'Country' => $_country, 'City' => $_city, 'Name1' => '', 'Street1' => $_street);
    		$params = array('Credentials' => $credentials, 'Address' => $address);

    		try {

        		$response = $soapclient->GetParcelShops($params);

        		
        		if (!empty($response) && isset($response->exitCode->ErrorCode) && ((int)$response->exitCode->ErrorCode == 998 || (int)$response->exitCode->ErrorCode == 999))  {
        		    $address = array('ZipCode' => $_cp, 'Country' => $_country, 'City' => '', 'Name1' => '', 'Street1' => '');
        		    $params = array('Credentials' => $credentials, 'Address' => $address);
        		    $response = $soapclient->GetParcelShops($params);
        		}

    		} catch (SoapFault $e) {}

    		if (!empty($response)) {
    			return $response;
    		} else {
    			return null;
    		}
		}

        return null;
	}

	

	public function getRelayDetail($_id) {

        $soapclient = $this->_get_soap_client();

        if ($soapclient) {
	        
			$credentials = array('UserName' => $this->ws_login, 'Password' => $this->ws_pwd);
	        $params = array('ParcelShopId' => $_id, 'Credentials' => $credentials);

            try {
	           $response = $soapclient->GetParcelShopById($params);
            } catch (SoapFault $e) {}

	        if (!empty($response)) {

	            if($response->ExitCode->ErrorCode == 0) {
	                
	                return array(
	                    'parcelShopById' => $_id,
	                    'Name1' => $response->ParcelShop->Address->Name1,
	                    'Street1' => $response->ParcelShop->Address->Street1,
	                    'ZipCode' => $response->ParcelShop->Address->ZipCode,
	                    'City' => $response->ParcelShop->Address->City,
	                    'Country' => $response->ParcelShop->Address->Country,
	                    'Phone' => $response->ParcelShop->Phone->Contact,
	                    'Mobile' => $response->ParcelShop->Mobile->Contact,
	                    'email' => $response->ParcelShop->Email,
	                    'url' => $response->ParcelShop->URL,
	                    'latitude' => $response->ParcelShop->GLSCoordinates->Latitude,
	                    'longitude' => $response->ParcelShop->GLSCoordinates->Longitude,
	                    'GLSWorkingDay' => $response->ParcelShop->GLSWorkingDay,
	                    'Name2' => (!empty($response->ParcelShop->Address->Name2) ? $response->ParcelShop->Address->Name2 : ''),
	                    'Name3' => (!empty($response->ParcelShop->Address->Name3) ? $response->ParcelShop->Address->Name3 : ''),
	                    'ContactName' => (!empty($response->ParcelShop->Address->ContactName) ? $response->ParcelShop->Address->ContactName : ''),
	                    'BlockNo1' => (!empty($response->ParcelShop->Address->BlockNo1) ? $response->ParcelShop->Address->BlockNo1 : ''),
	                    'Street2' => (!empty($response->ParcelShop->Address->Street2) ? $response->ParcelShop->Address->Street2 : ''),
	                    'BlockNo2' => (!empty($response->ParcelShop->Address->BlockNo2) ? $response->ParcelShop->Address->BlockNo2 : ''),
	                    'Province' => (!empty($response->ParcelShop->Address->Province) ? $response->ParcelShop->Address->Province : ''),
	                );
	            } else {
	                
	            }
	        } else {
	            
	        }
	    }
	    return false;
	}

	

	private function _get_soap_client()
	{
        if (empty($this->soap_client)) {
            try {
                $this->soap_client = @new SoapClient($this->soap_location,
        			array(
        			    'trace'	=> 1,
        				'cache_wsdl'=>WSDL_CACHE_NONE,
        				'exceptions'=>true,
        				'connection_timeout'=>15,
        		));

                
                $soap_client_connected = false;
                if (is_array($this->soap_client->__getFunctions())) {
                    foreach ($this->soap_client->__getFunctions() as $value) {
                        if (strpos($value, 'GetParcelShops') !== false) {
                            $soap_client_connected = true;
                            break;
                        }
                    }
                }

                if (!$soap_client_connected) {
                    return false;
                }

            } catch (SoapFault $e) {
                return false;
            } catch (Exception $e) {
                return false;
            }
        }

        return $this->soap_client;
	}

}