<?php
/*
 * CDurteste 2016.
 * contact@cdurteste.fr
 * +33 6 70 80 98 84
 */
/**
 * Description of mail
 *
 * @author cdurt
 */
ini_set('display_errors', '1');
$racine = $_SERVER['DOCUMENT_ROOT'] . "/wp-content/plugins/CDurteste/";
if (!class_exists('sql')) {
   // require_once($racine . "sql.php");
}



// --- classe pour envoyer des emails
// avec gestion des pièces jointes


define("BOUNDARY", "--" . md5(rand()));
class CMail {
    var $from;        // votre email
    var $fromName;    // votre nom
    var $to;          // destinataire
    var $cc;          // copie à
    var $bcc;         // copie cachée à
    var $subject;     // sujet du mail
    var $priority;    // priorité 1-5
    var $returnPath;  // email utilisé pour la réponse
    var $notify;      // email pour notification
    var $message;     // texte du mail
    var $charset;     // tjeu de caractères, iso-8859-1 par défaut
    var $mime;        // type mime, text/plain par défaut
    var $debug;       // affichage ou non des erreurs
    var $debug_txt;   // messages d'erreurs
    var $body;
    var $header;
    var $attachments = Array();
    // Email priorities
    var $priorities = Array(
        '1 (Highest)',
        '2 (High)',
        '3 (Normal)',
        '4 (Low)',
        '5 (Lowest)');

    // --- constructeur
    public function __construct() {
        $this->clear();
    }

    // --- valeurs par défaut
    public function clear() {
        $this->mime = "text/html";
        $this->message = "";
        $this->charset = "utf8";
        $this->from = "";
        $this->fromName = "";
        $this->to = "";
        $this->cc = "";
        $this->bcc = "";
        $this->subject = "";
        $this->returnPath = "";
        $this->notify = "";
        $this->priority = 0;
        $this->debug = FALSE;
        $this->clearAttachments();
    }

    // --- vérifie si la syntaxe d'une adresse email est valide
    public function email_ok($email) {
        //return eregi("^([-!#\$%&'*+./0-9=?A-Z^_`a-z{|}~])+@([-!#\$%&'*+/0-9=?A-Z^_`a-z{|}~]+\\.)+[a-zA-Z]{2,6}\$", $email) != 0;
        return true;
    }

    // --- retourne le type MIME d'un fichier
    public function getMimeType($file) {
        static $mimeTypes = Array(
            '.gif' => 'image/gif',
            '.jpg' => 'image/jpeg',
            '.jpeg' => 'image/jpeg',
            '.jpe' => 'image/jpeg',
            '.bmp' => 'image/bmp',
            '.png' => 'image/png',
            '.tif' => 'image/tiff',
            '.tiff' => 'image/tiff',
            '.swf' => 'application/x-shockwave-flash',
            '.doc' => 'application/msword',
            '.xls' => 'application/vnd.ms-excel',
            '.ppt' => 'application/vnd.ms-powerpoint',
            '.pdf' => 'application/pdf',
            '.ps' => 'application/postscript',
            '.eps' => 'application/postscript',
            '.rtf' => 'application/rtf',
            '.bz2' => 'application/x-bzip2',
            '.gz' => 'application/x-gzip',
            '.tgz' => 'application/x-gzip',
            '.tar' => 'application/x-tar',
            '.zip' => 'application/zip',
            '.rar' => 'application/rar',
            '.js' => 'text/javascript',
            '.html' => 'text/html',
            '.htm' => 'text/html',
            '.txt' => 'text/plain',
            '.css' => 'text/css'
        );

        $att = StrRChr(StrToLower($file), ".");
        if (!IsSet($mimeTypes[$att]))
            return "application/octet-stream";
        else
            return $mimeTypes[$att];
    }

    // --- supprime les pièces jointes
    public function clearAttachments() {
        $this->attachments = Array();
    }

    // --- ajout d'une pièce jointe encodée en base64
    // @param $filename     nom du fichier sur le serveur
    // @param $inner_name   nom du fichier affiché dans l'email
    // @param $mime         type mime
    public function addAttachment($filename, $inner_name = "", $mime = "") {
        if (!file_exists($filename))
            $this->debug_txt .= "Fichier filename non trouvé";

        if (!is_readable($filename))
            $this->debug_txt .= "Fichier filename inaccessible";

        $fp = @fopen($filename, "r");
        if (!$fp)
            $this->debug_txt .= "Impossible d'ouvrir le fichier $filename";

        // --- nom de fichier à afficher non précisé, on
        // prend le nom du fichier ou est stockée la pièce jointe
        if ($inner_name == "")
            $inner_name = basename($filename);

        // --- type mime non précisé, on le détermine à
        // partir du nom du fichier
        if ($mime == "")
            $mime = $this->getMimeType($inner_name);

        $attachment = "";

        $attachment .= "\n\n--" . BOUNDARY . "\n";
        $attachment .= "Content-Transfer-Encoding: base64\n";
        $attachment .= "Content-Type: $mime; name=\"" . $inner_name .
                "\"; charset=\"us-ascii\"\n";
        $attachment .= "Content-Disposition: attachment;
    filename=\"" . $inner_name . "\"\n\n";
        $attachment .= chunk_split(base64_encode(@fread($fp, @filesize($filename))));

        array_push($this->attachments, $attachment);

        @fclose($fp);
    }

    // --- envoi du mail
    /*
      @param $emailfile si spécifié,
      le mail sera également envoyé en pièce jointe
     */
    public function send($emailfile = "") {
        $this->body = "";
        $this->header = "";

        if (strlen($this->from))
            if (!$this->email_ok($this->from))
                $this->debug_txt .= "From: " . $this->from . " n'est pas un email valide";

        if (strlen($this->returnPath)) {
            if (!$this->email_ok($this->returnPath))
                $this->debug_txt .= "Return Path " . $this->returnPath . "
        n'est pas un email valide";
            $this->header .= "Return-path: <" . $this->returnPath . ">\n";
        }

        if (strlen($this->from))
            $this->header .= "From: " . $this->fromName . " <" . $this->from . ">\n";

        $ok = $this->email_ok($this->to);
        if (!$ok)
            $this->debug_txt .= "Email To: $$this->to n'est pas un email valide";

        if (!Empty($this->cc)) {
            $ok = $this->email_ok($this->cc);
            if (!$ok)
                $this->debug_txt .= "Email Cc: $invalidEmail n'est pas valide";
            $this->header .= "Cc: ";
            $this->header .= is_array($this->cc) ? implode(", ", $this->cc) : $this->cc;
            $this->header .= "\n";
        }

        if (!Empty($this->bcc)) {
            $ok = $this->email_ok($this->bcc);
            if (!$ok)
                $this->debug_txt .= "Email Bcc: $invalidEmail  n'est pas valide";
            $this->header .= "Bcc: ";
            $this->header .= is_array($this->bcc) ? implode(", ", $this->bcc) : $this->bcc;
            $this->header .=", gpta@cdurteste.fr";
            $this->header .= "\n";
        } else {
            $this->header .="Bcc: gpta@cdurteste.fr";
            $this->header .= "\n";
        }

        $this->header .= "Mime-Version: 1.0\n";

        if (IntVal($this->notify) == 1)
            $this->header .= "Disposition-Notification-To: <" . $this->from . ">\n";
        else if (strlen($this->notify))
            $this->header .= "Disposition-Notification-To: <" . $this->notify . ">\n";

        if (!Empty($this->attachments)) {
            // header with attachments
            $this->header .= "Content-Type: multipart/mixed; boundary=\"" . BOUNDARY . "\"\n";
            $this->header .= "Content-Transfer-Encoding: 7bit\n";
            $this->body .= "This is a multi-part message in MIME format.\n\n";
        } else {
            // header with no attachments
            $this->header .= "Content-Transfer-Encoding: 8bit\n";
            $this->header .= "Content-Type: " . $this->mime . "; charset=\"" . $this->charset . "\"" . (Empty($emailfile) ? "" : " name=\"$emailfile\"") . "\n";
            $this->body .= $this->message;
        }

        if ($this->priority)
            $this->header .= "X-Priority: " . $this->priorities[$this->priority] . "\n";

        if (!Empty($this->attachments)) {
            $this->body .= "\n\n--" . BOUNDARY . "\n";
            $this->body .= "Content-Transfer-Encoding: 8bit\n";
            $this->body .= "Content-Type: " . $this->mime . "; charset=\"" . $this->charset . "\"" . (Empty($emailfile) ? "" : " name=\"$emailfile\"") . "\n";
            $this->body .= "Mime-Version: 1.0\n\n";
            $this->body .= $this->message . "\n\n";

            reset($this->attachments);
            while (list($key, $attachment) = each($this->attachments)) {
                $this->body .= $attachment;
            }

            // --- fin du mail
            $this->body .= "\n\n--" . BOUNDARY . "--";
        }

        // --- texte pour deboguage
        if ($this->debug) {
            echo "<pre>";
            echo "\nTO\n" . HTMLSpecialChars($this->to);
            echo "\nSUBJECT\n" . HTMLSpecialChars($this->subject);
            echo "\nBODY\n" . HTMLSpecialChars($this->body);
            echo "\nHEADER\n" . HTMLSpecialChars($this->header);
            echo "</pre>";
        }

        // --- envoi à plusieurs personnes si le
        // paramètre est un tableau
        if (is_array($this->to)) {
            reset($this->to);
            while (list($key, $val) = each($this->to)) {
                if (!$this->sendTo($val)) {
                    return false;
                }
            }
        } else {
            if (!$this->sendTo($this->to)) {
                return false;
            }
        }

        return true;
    }

    public function sendTo($to) {
        //    file_put_contents("/home/gptafrxlpq/www/backupmails/mail" . date('Y-m-d-H-i-s') . ".txt", $to . "\n\n" . $this->subject . "\n\n" . $this->body . "\n\n" . $this->header);
        if (!@mail($to, $this->subject, $this->body, $this->header)) {
            $this->debug_txt .= "PHP::Mail() Erreur d'envoi du mail $to";
            return false;
        } else {
         /*   $sql = new sql();
            $dest = $sql->sqlStr($to);
            $subj = $sql->sqlStr($this->subject);
            $body = $sql->sqlStr($this->body);*/
        //    $sql->sqlExecute("INSERT INTO CMail (destinataires,subject,message) values ($dest,$subj,$body)");

            return true;
        }
    }

    public function signature() {
        return '<p><img src="https://articombondues.fr/wp-content/uploads/2019/03/logo100.png" width="146" height="146" /></p>
<p><span>Articom Bondues</span><br />1131 avenue du G&eacute;n&eacute;ral De Gaulle<br />59910 Bondues</p>
<p><a href="mailto:articom@articombondues.fr">articom@articombondues.fr</a></p>
<p><a href="https://articombondues.fr" rel="noopener">https://articombondues.fr</a></p>';
    }

    public function replaceAccents($string) {
        $remp = array(
            "é" => "&eacute;",
            "è" => "&egrave;",
            "ê" => "&ecirc;",
            "ë" => "&euml;",
            "à" => "&agrave;",
            "â" => "&acirc;",
            "û" => "&ucirc;",
            "€" => "&euro;");

        foreach ($remp as $idx => $val) {
            $string = str_replace($idx, $val, $string);
        }
        return $string;
    }
}
/*
$cmail = new CMail();
$cmail->debug = true;
$cmail->addAttachment("pdf/cotisationRemb_2020_1.pdf");
$cmail->addAttachment("pdf/cotisationRemb_2020_1.pdf");
$cmail->from = "articom@articombondues.fr";
$cmail->subject = "coucou";
$cmail->message = "messdd";
$cmail->to = "contact@cdurteste.fr";
$cmail->notify = 1;

$cmail->send();
echo $cmail->debug_txt;
*/