<?php
/**
 * Plugin Name: GLS, votre partenaire transport
 * Description: Donnez le choix à vos clients du mode de livraison qui leur convient.
 * Version: 2.2.2
 * Author: Nukium
 * License: Open Software License (OSL 3.0) - http://opensource.org/licenses/osl-3.0.php
 * Text Domain: woocommerce-gls
 */

/**
 *    Module made by Nukium
 *
 *  @author    Nukium
 *  @copyright 2021 Nukium SAS
 *  @license   All rights reserved
 *
 * ███    ██ ██    ██ ██   ██ ██ ██    ██ ███    ███
 * ████   ██ ██    ██ ██  ██  ██ ██    ██ ████  ████
 * ██ ██  ██ ██    ██ █████   ██ ██    ██ ██ ████ ██
 * ██  ██ ██ ██    ██ ██  ██  ██ ██    ██ ██  ██  ██
 * ██   ████  ██████  ██   ██ ██  ██████  ██      ██
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */


if (!defined('ABSPATH'))
    exit;

define( 'GLS_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
define( 'GLS_PLUGIN_URL', plugins_url('', __FILE__) );
define( 'GLS_TEMPLATE_PATH', plugin_dir_path( __FILE__ ) . 'views/templates/' );
define( 'GLS_JS_PATH', plugin_dir_path( __FILE__ ) . 'views/js/' );
define( 'GLS_CSS_PATH', plugin_dir_path( __FILE__ ) . 'views/css/' );
define( 'GLS_PLUGIN_NAME', plugin_basename(__FILE__) );

if (!class_exists('Nukium'))
    require_once( GLS_PLUGIN_PATH . 'lib/Nukium.php' );

if (!class_exists('NkmCsv'))
    require_once( GLS_PLUGIN_PATH . 'lib/NkmCsv.php' );

if (!class_exists('GlsController'))
    require_once( GLS_PLUGIN_PATH . '/classes/GlsController.php' );

if (!class_exists('WC_Gls_tracking_state')) {
    require_once ( GLS_PLUGIN_PATH . 'classes/class-gls-tracking-state.php' );
}

if (!class_exists('GlsApi')) {
    require_once ( GLS_PLUGIN_PATH . 'classes/GlsApi.php' );
}

class WC_Gls {

    public static $carrier_definition = array(
        'gls_chezvous' => array(
            'name' => 'GLS Chez vous',
            'delay' => array(
                'fr_FR' => 'Colis livré en 24h à 48h.',
                'default' => 'Colis livré en 24h à 48h.',
            ),
            'product_code' => array('FR' => '02', 'default' => '01'),
            'mobile' => false,
        ),
        'gls_relais' => array(
            'name' => 'GLS Relais',
            'delay' => array(
                'fr_FR' => 'Retrait dans l\'un des Relais GLS de votre choix. Vous êtes informé par email ou SMS de l\'arrivée de votre colis.',
                'default' => 'Retrait dans l\'un des Relais GLS de votre choix. Vous êtes informé par email ou SMS de l\'arrivée de votre colis.',
            ),
            'product_code' => array('default' => '17'),
            'mobile' => true,
        ),
        'gls_chezvousplus' => array(
            'name' => 'GLS Chez vous +',
            'delay' => array(
                'fr_FR' => 'Vous êtes prévenus par email et SMS de la date et du créneau horaire de livraison.',
                'default' => 'Vous êtes prévenus par email et SMS de la date et du créneau horaire de livraison.',
            ),
            'product_code' => array('FR' => '18', 'default' => '19'),
            'mobile' => true,
        ),
        'gls_13h' => array(
            'name' => 'GLS avant 13h',
            'delay' => array(
                'fr_FR' => 'Livraison Express en 24H en France métropolitaine, remise en mains propres le lendemain avant 13H.',
                'default' => 'Livraison Express en 24H en France métropolitaine, remise en mains propres le lendemain avant 13H.',
            ),
            'product_code' => array('default' => '16'),
            'mobile' => true,
        ),
    );

    public static $product_code = array(
        '01' => 'EuroBusinessParcel',
        '02' => 'BusinessParcel',
        '17' => 'ShopDeliveryService',
        '18' => 'FlexDeliveryService',
        '19' => 'FlexDeliveryService',
        '16' => 'ExpressParcelGuaranted',
    );

    public static $trackingStates = array(
        'PREADVICE' => 'En cours de préparation',
        'INTRANSIT' => 'Acheminement en cours',
        'INWAREHOUSE' => 'Au dépôt de livraison',
        'INDELIVERY' => 'En livraison',
        'DELIVERED' => 'Livré',
        'NOTDELIVERED' => 'Ne peut pas être livré aujourd\'hui',
        'DELIVEREDPS' => 'Livré en GLS Relais'
    );

    public static $trackingUrl = 'https://gls-group.eu/FR/fr/suivi-colis?match=@';

    private static $ftp_host = 'ftp.gls-france.com';
    private static $ftp_login = 'addonline';
    private static $ftp_pwd = '-mAfXmTqC';

    public static $importDirectory = 'import/';

    public function main() {

        include_once(ABSPATH.'wp-admin/includes/plugin.php');
        if (is_plugin_active('woocommerce/woocommerce.php')) {

            add_action( 'plugins_loaded', array($this, 'init') );
            add_action( 'plugins_loaded', array($this, 'gls_update_db_check'), 8);

            
            add_action( 'wp_enqueue_scripts', 'gls_enqueue_style' );
            add_action( 'wp_enqueue_scripts', 'gls_enqueue_script', 9);

            add_filter('script_loader_tag', 'add_js_async_attribute', 10, 2);
            add_filter('script_loader_tag', 'add_js_defer_attribute', 10, 2);

            add_filter( 'woocommerce_email_classes', array($this, 'custom_gls_emails') );
            add_action( 'woocommerce_init', array( $this, 'load_wc_mailer' ) );

            load_plugin_textdomain( 'woocommerce-gls', false, basename( dirname( __FILE__ ) ) . '/languages/' );

        }
    }

    public function init() {

        
        self::$trackingStates = array(
            'PREADVICE' => __('In preparation', 'woocommerce-gls'),
            'INTRANSIT' => __('In transit', 'woocommerce-gls'),
            'INWAREHOUSE' => __('In delivery depot', 'woocommerce-gls'),
            'INDELIVERY' => __('In delivery', 'woocommerce-gls'),
            'DELIVERED' => __('Delivered', 'woocommerce-gls'),
            'NOTDELIVERED' => __('Cannot be delivered today', 'woocommerce-gls'),
            'DELIVEREDPS' => __('Delivered in GLS Relais', 'woocommerce-gls')
        );

        
        require_once GLS_PLUGIN_PATH . 'classes/class-gls-load-scripts.php';

        
        require_once GLS_PLUGIN_PATH . 'classes/class-gls-settings.php';

        
        require_once GLS_PLUGIN_PATH . 'classes/class-gls-admin-order.php';

        require_once GLS_PLUGIN_PATH . 'classes/class-table-rate-shipping.php';
        
        require_once GLS_PLUGIN_PATH . 'classes/class-gls-chezvous.php';
        require_once GLS_PLUGIN_PATH . 'classes/class-gls-chezvousplus.php';
        require_once GLS_PLUGIN_PATH . 'classes/class-gls-13h.php';
        require_once GLS_PLUGIN_PATH . 'classes/class-gls-relais.php';

        
        require_once GLS_PLUGIN_PATH . 'classes/class-gls-admin-order-label.php';

        
        require_once GLS_PLUGIN_PATH . 'classes/class-gls-admin-packing-list.php';

        
        require_once GLS_PLUGIN_PATH . 'classes/class-gls-admin-order-meta-boxes.php';

        add_action( 'gls_order_get_tracking',  __CLASS__.'::cronGetTracking' );

    }

    public static function activate() {

        add_option( 'gls_db_version', '2.2.2' );

        self::_installDBConfig();

        if (! wp_next_scheduled ( 'gls_order_export_cron' )) {
            wp_schedule_event(time(), 'hourly', 'gls_order_export_cron');
        }

        if (! wp_next_scheduled ( 'gls_order_import_cron' )) {
            wp_schedule_event(time(), 'hourly', 'gls_order_import_cron');
        }

        if (! wp_next_scheduled ( 'gls_order_get_tracking' )) {
            wp_schedule_event(time(), 'hourly', 'gls_order_get_tracking');
        }

    }

    public static function deactivate() {

        global $wpdb;
        require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );

        $sql = "DROP TABLE IF EXISTS {$wpdb->prefix}woocommerce_gls_agency_postcode";
        $wpdb->query($sql);

        $sql = "DROP TABLE IF EXISTS {$wpdb->prefix}woocommerce_gls_cart_carrier";
        $wpdb->query($sql);

        $sql = "DROP TABLE IF EXISTS {$wpdb->prefix}woocommerce_gls_label";
        $wpdb->query($sql);

        $sql = "DROP TABLE IF EXISTS {$wpdb->prefix}woocommerce_gls_tracking_state";
        $wpdb->query($sql);

        delete_option( 'GLS_LAST_SYNCHRO_DATE' );
        delete_option( 'GLS_SYNCHRO_FILE_CONTENT_HASH' );
        delete_option( 'gls_db_version' );

        

        wp_clear_scheduled_hook('gls_order_export_cron');
        wp_clear_scheduled_hook('gls_order_import_cron');
        wp_clear_scheduled_hook('gls_order_get_tracking');
    }

    

    public static function plugin_url() {
        return untrailingslashit( plugins_url( '/', __FILE__ ) );
    }

    

    public function gls_update_db_check() {

        $plugin_data = get_plugin_data( __FILE__ );
        if (is_array($plugin_data)
            && count($plugin_data) > 0
            && isset($plugin_data['Version'])
            && get_option( 'gls_db_version' ) != $plugin_data['Version']
        ) {
            
            $prefix_option = get_option( 'gls_settings_order_prefix' );
            if (empty($prefix_option)) {
                add_option( 'gls_settings_order_prefix', 'yes' );
            }

            $google_maps_option = get_option( 'gls_settings_gmaps_enable' );
            if (empty($google_maps_option)) {
                add_option( 'gls_settings_gmaps_enable', 'yes' );
            }

            update_option( 'gls_db_version', $plugin_data['Version'] );

            self::_installDBTable();
        }

    }

    private static function _installDBTable() {

        global $wpdb;
        require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );

        
        $sql = "CREATE TABLE {$wpdb->prefix}woocommerce_gls_cart_carrier (
            id int(11) unsigned NOT NULL AUTO_INCREMENT,
            session_id varchar(255) NOT NULL DEFAULT '',
            customer_id varchar(255) NOT NULL DEFAULT '',
            order_id int(11) unsigned NOT NULL DEFAULT 0,
            shipping_method_id varchar(255) NOT NULL DEFAULT '',
            gls_product varchar(255) NOT NULL,
            parcel_shop_id varchar(255) DEFAULT NULL,
            name varchar(255) NULL DEFAULT NULL,
            address1 varchar(255) NULL DEFAULT NULL,
            address2 varchar(255) NULL DEFAULT NULL,
            postcode varchar(255) NULL DEFAULT NULL,
            city varchar(255) NULL DEFAULT NULL,
            phone varchar(255) NULL DEFAULT NULL,
            phone_mobile varchar(255) NULL DEFAULT NULL,
            customer_phone_mobile varchar(255) NOT NULL,
            country varchar(3) NULL DEFAULT NULL,
            parcel_shop_working_day text NULL DEFAULT NULL,
            PRIMARY KEY  (id),
            KEY session_id (session_id),
            KEY customer_id (customer_id),
            KEY order_id (order_id)
        ) DEFAULT CHARSET=utf8;";
        dbDelta( $sql );

        
        $sql = "CREATE TABLE {$wpdb->prefix}woocommerce_gls_agency_postcode (
            id int(11) unsigned NOT NULL AUTO_INCREMENT,
            agency_code varchar(255) NOT NULL,
            postcode_start varchar(5) NOT NULL,
            postcode_end varchar(5) NOT NULL,
            PRIMARY KEY  (id),
            KEY agency_code (agency_code)
        ) DEFAULT CHARSET=utf8;";
        dbDelta( $sql );

        
        $sql = "CREATE TABLE {$wpdb->prefix}woocommerce_gls_label (
            id int(11) unsigned NOT NULL AUTO_INCREMENT,
            order_id int(11) unsigned NOT NULL DEFAULT 0,
            shipping_number varchar(255) NOT NULL,
            weight decimal(20,6) NOT NULL,
            gls_product varchar(255) NOT NULL,
            delivery_date datetime NOT NULL,
            reference1 varchar(5) NOT NULL,
            reference2 varchar(5) NOT NULL,
            date_add datetime NOT NULL,
            PRIMARY KEY  (id),
            KEY order_id (order_id)
        ) DEFAULT CHARSET=utf8;";
        dbDelta( $sql );

        
        $sql = "CREATE TABLE {$wpdb->prefix}woocommerce_gls_tracking_state (
            id int(11) unsigned NOT NULL AUTO_INCREMENT,
            order_id int(11) unsigned NOT NULL DEFAULT 0,
            current_state varchar(30) NOT NULL,
            date_add datetime NOT NULL,
            date_upd datetime NOT NULL,
            PRIMARY KEY  (id),
            KEY order_id (order_id)
        ) DEFAULT CHARSET=utf8;";
        dbDelta( $sql );
    }

    private static function _installDBConfig() {

        
        global $wpdb;
        require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );

        
        add_option( 'GLS_LAST_SYNCHRO_DATE', date('Y-m-d H:i:s') );
        add_option( 'GLS_SYNCHRO_FILE_CONTENT_HASH', '' );
        add_option( 'gls_settings_order_prefix', 'yes' );
        add_option( 'gls_settings_gmaps_enable', 'no' );

        self::_installDBTable();

        
        $csv_file = new NkmCSVReader();
        $csv_content = $csv_file->parse_file(GLS_PLUGIN_PATH . self::$importDirectory .'tbzipdeltimes.csv', false, true);
        self::synchronizeAgencyPostcodeRestriction(true, $csv_content);
    }

    

    public static function synchronizeAgencyPostcodeRestriction($_force = false, $_file_content = null) {

        global $wpdb;

        
        $toSynchronize = false;
        $last_update_date = get_option( 'GLS_LAST_SYNCHRO_DATE', '' );

        
        $last_update = new DateTime($last_update_date);
        $now = new DateTime();
        if (empty($last_update_date) || $last_update->format('Ymd') < $now->format('Ymd')) {

            
            update_option( 'GLS_LAST_SYNCHRO_DATE', date('Y-m-d H:i:s') );

            
            $filename = 'tbzipdeltimes_'.date('Ymd').'.csv';
            $handle = fopen(GLS_PLUGIN_PATH . self::$importDirectory . $filename, 'w');

            
            $conn_id = ftp_connect(self::$ftp_host, 21, 5);
            $login_result = ftp_login($conn_id, self::$ftp_login, self::$ftp_pwd);

            if ($login_result) {

                foreach (ftp_nlist($conn_id, ".") as $f) {

                    
                    if (preg_match('/^tbzipdeltimes_(\d{8}).csv$/i', $f, $date)) {
                        
                        if (empty($last_update_date) || $date[1] > $last_update->format('Ymd')) {
                            
                            if (ftp_fget($conn_id, $handle, $f, FTP_ASCII, 0)) {
                                
                                $hash = md5_file(GLS_PLUGIN_PATH . self::$importDirectory . $filename);
                                if ($hash != get_option( 'GLS_SYNCHRO_FILE_CONTENT_HASH', '' )) {
                                    update_option( 'GLS_SYNCHRO_FILE_CONTENT_HASH', $hash );
                                    $toSynchronize = true;
                                    $csv_file = new NkmCSVReader();
                                    $_file_content = $csv_file->parse_file(GLS_PLUGIN_PATH . self::$importDirectory . $filename, false, true);
                                    break;
                                }
                            }
                        }
                    }
                }
            }

            
            ftp_close($conn_id);
            fclose($handle);
            unlink(GLS_PLUGIN_PATH . self::$importDirectory . $filename);
        }

        if ($_force || $toSynchronize) {
            if (!empty($_file_content) && is_array($_file_content) && count($_file_content) > 0) {
                $query = '';
                $values = array();
                foreach ($_file_content as $line) {
                    array_push($values, $line[0], $line[1], $line[2]);
                    $query .= "('%s', '%s', '%s'),";
                }
                $query = trim($query, ',');
                if (!empty($query)) {
                    $sql = "TRUNCATE TABLE {$wpdb->prefix}woocommerce_gls_agency_postcode";
                    $result = $wpdb->query($sql);
                    if ($result) {
                        $query = "INSERT INTO {$wpdb->prefix}woocommerce_gls_agency_postcode (agency_code, postcode_start, postcode_end) VALUES " . $query;
                        $wpdb->query($wpdb->prepare("$query ", $values));
                    }
                }
            }
        }
    }

    

    public static function get_gls_product($id_carrier, $country = 'FR') {

        $gls_product = '';
        if (isset(self::$carrier_definition[$id_carrier])) {
            if (isset(self::$carrier_definition[$id_carrier]['product_code'][$country])) {
                $gls_product = self::$carrier_definition[$id_carrier]['product_code'][$country];
            } else {
                $gls_product = self::$carrier_definition[$id_carrier]['product_code']['default'];
            }
        }
        return $gls_product;
    }

    public function custom_gls_emails( $email_classes ) {

        $email_classes['WC_Email_Gls_Label_Return'] = include( GLS_PLUGIN_PATH . 'classes/class-wc-email-gls-label-return.php' );

        return $email_classes;

    }

    public function load_wc_mailer() {

        add_action( 'woocommerce_gls_generate_single_return_label', array( $this , 'send_single_return_label_notification' ) );

    }

    public function send_single_return_label_notification( $args = array() ) {

        try {

            WC()->mailer();

            do_action( 'woocommerce_gls_generate_single_return_label_notification', $args );

        } catch ( Exception $e ) {
        }
    }

    

    public static function getAdditionalPrice( $_country_iso, $_postcode , $_add_price_config) {

        $_postcode = str_replace(' ', '', $_postcode);
        if (!empty($_country_iso) && !empty($_postcode)) {
            if ($_country_iso == 'FR' && preg_match('/^20\d{3}$/', $_postcode) && isset($_add_price_config['add_price_corsica'])) {
                
                return $_add_price_config['add_price_corsica'];
            } elseif ($_country_iso == 'FR'
                && in_array(
                    $_postcode,
                    array('22870','29242','29253','29259','29990','56360','56590','56780','56840','85350')
                )
                && isset($_add_price_config['add_price_fr_island'])
            ) {
                
                return $_add_price_config['add_price_fr_island'];
            } elseif ($_country_iso == 'GB' && preg_match('/^(GY|HS|IM|JE|KW15|KW16|KW17|ZE){1}.*$/', $_postcode) && isset($_add_price_config['add_price_gb_island'])) {
                
                return $_add_price_config['add_price_gb_island'];
            } elseif (isset($_add_price_config['add_price_islands']) && (($_country_iso == 'ES' && preg_match('/^(7|07).*$/', $_postcode))
                || ($_country_iso == 'GR' && in_array(
                    $_postcode,
                    array('18010','18020','18040','18050','18900','28100','29100','31100','37002','37003','49100',
                    '64004','68002','70014','70300','70400','71300','72100','72200','72300','73100','74100','81100',
                    '81107','81400','82100','83100','83300','84001','84002','84003','84005','84006','84100','84200',
                    '84300','84400','84500','84600','84700','84801','85100','85200','85300','85400','85700','85900')
                ))
                || ($_country_iso == 'IT' && preg_match('/^(07|08|09|9).*$/', $_postcode)))
            ) {
                
                return $_add_price_config['add_price_islands'];
            } elseif (isset($_add_price_config['add_price_sp_pt_island']) &&
                (($_country_iso == 'ES' && preg_match('/^(35|38|51|52).*$/', $_postcode))
                || ($_country_iso == 'PT' && preg_match('/^9.*$/', $_postcode)))
            ) {
                
                return $_add_price_config['add_price_sp_pt_island'];
            } elseif (isset($_add_price_config['add_price_mountain']) &&
                $_country_iso == 'FR' &&
                in_array(
                    $_postcode,
                    array('04160','04170','04240','04260','04310','04330','04360','04370','04400','04510','04530','04600',
                    '04850','05100','05120','05150','05160','05170','05200','05220','05240','05250','05260','05290','05310',
                    '05320','05330','05340','05350','05460','05470','05500','05560','05600','05700','05800','06380','06390',
                    '06420','06430','06440','06450','06460','06470','06540','06620','06660','06710','06750','06830','06850',
                    '06910','09110','09140','09220','09230','09300','09390','09460','15140','15300','25160','25190','25240',
                    '25370','25380','25430','25470','31110','38112','38114','38142','38190','38250','38350','38410','38520',
                    '38580','38650','38660','38680','38700','38710','38730','38740','38750','38770','38830','38860','38880',
                    '38930','38970','63113','63240','63610','63680','63850','64440','64490','64560','64570','65110','65120',
                    '65170','65240','65260','65400','65510','65710','66120','66210','66230','66260','66320','66340','66360',
                    '66480','66720','66730','66760','66800','66820','73120','73130','73140','73150','73170','73210','73220',
                    '73260','73270','73300','73320','73340','73350','73360','73440','73450','73470','73480','73500','73520',
                    '73530','73550','73570','73590','73620','73630','73640','73660','73670','73700','73710','73720','73730','73790',
                    '73870','74110','74120','74170','74190','74220','74230','74250','74260','74310','74340','74360','74390','74400',
                    '74420','74430','74440','74450','74470','74480','74490','74550','74560','74660','74740','74920','83560','83630')
                )
            ) {
                
                return $_add_price_config['add_price_mountain'];
            }
        }
        return null;
    }

    

    public static function isDisableForZone( $_country_iso, $_postcode , $_config) {

        $_postcode = str_replace(' ', '', $_postcode);
        if (!empty($_country_iso) && !empty($_postcode) && (
            ($_country_iso == 'FR' && preg_match('/^20\d{3}$/', $_postcode) && isset($_config['disable_corsica']) && $_config['disable_corsica'] == 'yes')
            || ($_country_iso == 'GP' && isset($_config['disable_dom_tom']) && $_config['disable_dom_tom'] == 'yes')
            || ($_country_iso == 'MQ' && isset($_config['disable_dom_tom']) && $_config['disable_dom_tom'] == 'yes')
            || ($_country_iso == 'GF' && isset($_config['disable_dom_tom']) && $_config['disable_dom_tom'] == 'yes')
            || ($_country_iso == 'RE' && isset($_config['disable_dom_tom']) && $_config['disable_dom_tom'] == 'yes')
            || ($_country_iso == 'YT' && isset($_config['disable_dom_tom']) && $_config['disable_dom_tom'] == 'yes')
            || ($_country_iso == 'PM' && isset($_config['disable_dom_tom']) && $_config['disable_dom_tom'] == 'yes')
            || ($_country_iso == 'BL' && isset($_config['disable_dom_tom']) && $_config['disable_dom_tom'] == 'yes')
            || ($_country_iso == 'MF' && isset($_config['disable_dom_tom']) && $_config['disable_dom_tom'] == 'yes')
            || ($_country_iso == 'WF' && isset($_config['disable_dom_tom']) && $_config['disable_dom_tom'] == 'yes')
            || ($_country_iso == 'PF' && isset($_config['disable_dom_tom']) && $_config['disable_dom_tom'] == 'yes')
            || ($_country_iso == 'NC' && isset($_config['disable_dom_tom']) && $_config['disable_dom_tom'] == 'yes')
            || ($_country_iso == 'TF' && isset($_config['disable_dom_tom']) && $_config['disable_dom_tom'] == 'yes')
            || ($_country_iso == 'FR' && preg_match('/^971\d{2}$/', $_postcode) && isset($_config['disable_dom_tom']) && $_config['disable_dom_tom'] == 'yes')
            || ($_country_iso == 'FR' && preg_match('/^972\d{2}$/', $_postcode) && isset($_config['disable_dom_tom']) && $_config['disable_dom_tom'] == 'yes')
            || ($_country_iso == 'FR' && preg_match('/^973\d{2}$/', $_postcode) && isset($_config['disable_dom_tom']) && $_config['disable_dom_tom'] == 'yes')
            || ($_country_iso == 'FR' && preg_match('/^974\d{2}$/', $_postcode) && isset($_config['disable_dom_tom']) && $_config['disable_dom_tom'] == 'yes')
            || ($_country_iso == 'FR' && preg_match('/^976\d{2}$/', $_postcode) && isset($_config['disable_dom_tom']) && $_config['disable_dom_tom'] == 'yes')
            || ($_country_iso == 'FR' && preg_match('/^975\d{2}$/', $_postcode) && isset($_config['disable_dom_tom']) && $_config['disable_dom_tom'] == 'yes')
            || ($_country_iso == 'FR' && preg_match('/^986\d{2}$/', $_postcode) && isset($_config['disable_dom_tom']) && $_config['disable_dom_tom'] == 'yes')
            || ($_country_iso == 'FR' && preg_match('/^987\d{2}$/', $_postcode) && isset($_config['disable_dom_tom']) && $_config['disable_dom_tom'] == 'yes')
            || ($_country_iso == 'FR' && preg_match('/^988\d{2}$/', $_postcode) && isset($_config['disable_dom_tom']) && $_config['disable_dom_tom'] == 'yes')
            || ($_country_iso == 'FR' && preg_match('/^984\d{2}$/', $_postcode) && isset($_config['disable_dom_tom']) && $_config['disable_dom_tom'] == 'yes')
        )) {
            return true;
        }

        return false;
    }

    

    public static function cronGetTracking($idOrder = false) {

        global $wpdb;

        $date = new DateTime();
        $date->modify('-1 month');
        
        $sql = "SELECT p.*, gts.current_state as current_tracking_state, gts.id as id_gls_tracking_state FROM {$wpdb->posts} p
            INNER JOIN {$wpdb->prefix}woocommerce_order_items oi ON p.id = oi.order_id
            INNER JOIN {$wpdb->prefix}woocommerce_order_itemmeta oim ON oim.order_item_id = oi.order_item_id
            LEFT JOIN {$wpdb->prefix}woocommerce_gls_tracking_state gts ON p.id = gts.order_id
            WHERE p.post_type = 'shop_order'
            AND oi.order_item_type = 'shipping'
            AND oim.meta_key = 'method_id'
            AND oim.meta_value IN ('" .
            implode("','", array_keys(self::$carrier_definition)) . "')";

        if ($idOrder !== false && (int)$idOrder > 0) {
            $sql .= " AND p.id = '" . (int)$idOrder . "'";
        } else {
            $sql .= " AND (gts.`current_state` IS NULL OR gts.`current_state` != 'DELIVERED')
                AND p.post_status != 'wc-cancelled'
                AND DATE_FORMAT(p.`post_date`, '%Y-%m-%d') <= '" . date('Y-m-d') . "'
                AND DATE_FORMAT(p.`post_date`, '%Y-%m-%d') >= '" . $date->format('Y-m-d') . "'";
            $sql .= ' ORDER BY p.id DESC';
        }

        $result = $wpdb->get_results( $sql );

        $api = new GlsApi(get_option( 'gls_settings_api_login' ), get_option( 'gls_settings_api_pwd' ));
        if ($api && $result) {
            foreach ($result as $row) {
                
                $order = wc_get_order((int)$row->ID);
                
                $tracking_numbers = '';
                $pattern = '/'.str_replace(array('@', '/', '?'), array('', '\/', '\?'), WC_Gls::$trackingUrl).'([^"]+)/';
                foreach ($order->get_customer_order_notes() as $note) {
                    if (preg_match($pattern, $note->comment_content, $matches)) {
                        $tracking_numbers = $matches[1];
                        break;
                    }
                }

                if (!empty($tracking_numbers)) {
                    try {
                        $tracking = $api->get('tracking/references/' . $tracking_numbers);
                        if ($tracking && isset($tracking->parcels) && is_array($tracking->parcels) && count($tracking->parcels) > 0) {
                            $status = '';
                            $updateStatus = true;
                            foreach ($tracking->parcels as $p) {
                                if (empty($status)) {
                                    $status = $p->status;
                                } elseif ($status != $p->status) {
                                    $updateStatus = false;
                                }
                            }

                            if ($updateStatus && !empty($status) && $status != $row->current_tracking_state) {
                                
                                $newOrderState = get_option( 'gls_settings_tracking_api_order_state_'.$status );

                                
                                if (empty($newOrderState) && empty($idOrder)) {
                                    $api->reset();
                                    continue;
                                }

                                

                                if (!empty($newOrderState) && $newOrderState != $order->get_status()) {
                                    $order->update_status($newOrderState);
                                }

                                
                                $glsTrackingObject = new WC_Gls_tracking_state();
                                if (!is_null($row->id_gls_tracking_state)) {
                                    $glsTrackingObject->update( $row->id_gls_tracking_state , array( 'current_state' => $status));
                                } else {
                                    $glsTrackingObject->create( array( 'order_id' => $row->ID, 'current_state' => $status) );
                                }

                                if ($idOrder !== false && (int)$idOrder > 0) {
                                    
                                    return array(
                                        'current_state' => self::$trackingStates[$status],
                                        'current_state_date' => esc_html( date_i18n( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ) ) )
                                    );
                                }
                            } elseif ($idOrder !== false && (int)$idOrder > 0) {
                                return array('message' => __('State is already up-to-date' , 'woocommerce-gls'));
                            }
                        } else {
                            
                            $error_msg = '';
                            if (is_array($api->error) && count($api->error) > 0) {
                                foreach ($api->error as $error) {
                                    if (is_array($error) && isset($error['message'])) {
                                        $error_msg = $error['message'] . ' [' . $error['code'] . ']';
                                    } else {
                                        $error_msg = $error;
                                    }
                                }
                            }

                            if (empty($error_msg)) {
                                $error_msg = __('An error occured , please contact technical support.', 'woocommerce-gls');
                            }

                            if ($idOrder !== false && (int)$idOrder > 0) {
                                return array('error' => true, 'message' => $error_msg);
                            }
                        }
                        $api->reset();
                    } catch (Exception $e) {
                        
                    }
                } elseif ($idOrder !== false && (int)$idOrder > 0) {
                    return array('error' => true, 'message' => __('There is no tracking number on the order', 'woocommerce-gls'));
                }
            }
            return true;
        } else {
            
        }

        return array('error' => true, 'message' => __('An error occured, please contact technical support.', 'woocommerce-gls'));
    }

}

function wc_gls_admin_scripts_styles($hook) {

    if ( strpos($hook, 'woocommerce-gls-import') === false
        && strpos($hook, 'woocommerce-gls-export') === false
        && strpos($hook, 'woocommerce_page_wc-settings') === false
        && strpos($hook, 'woocommerce-gls-label') === false
        && strpos($hook, 'woocommerce-gls-packing-list') === false
        && strpos($hook, 'post') === false ) {
            return;
    }

    if ( strpos($hook, 'post') === false ) {
        wp_enqueue_style( 'woocommerce_admin_styles', WC()->plugin_url() . '/assets/css/admin.css', array(), WC_VERSION );
        wp_enqueue_script( 'jquery-tiptip', WC()->plugin_url() . '/assets/js/jquery-tiptip/jquery.tipTip.min.js', array( 'jquery' ), WC_VERSION, true );
    }

    wp_enqueue_style( 'gls-backend-css', WC_Gls::plugin_url() . '/views/css/back.css', array('wp-jquery-ui-dialog'), get_option( 'gls_db_version' ));

    if ( strpos($hook, 'woocommerce-gls-label') !== false ) {

        wp_enqueue_style( 'gls-backend-label-css', WC_Gls::plugin_url() . '/views/css/back-label.css', array('wp-jquery-ui-dialog'), get_option( 'gls_db_version' ));
        wp_enqueue_style( 'jquery-ui-theme' , WC_Gls::plugin_url() . '/views/css/jquery-ui.css', array('wp-jquery-ui-dialog'), get_option( 'gls_db_version' ));
        
        wp_enqueue_script( 'gls-backend-label-js' , WC_Gls::plugin_url() . '/views/js/back-label.js', array( 'jquery', 'jquery-ui-widget', 'jquery-ui-core', 'jquery-ui-dialog', 'jquery-ui-tooltip', 'jquery-ui-datepicker'), get_option( 'gls_db_version' ), true );
        wp_localize_script( 'gls-backend-label-js', 'gls_backend_label_var' , array(
            'ajax_uri' => wp_nonce_url(admin_url( 'admin-ajax.php' ) , 'gls-admin-ajax-request' ),
            'print_block' => __('Fill in the order informations before you can print the associated label', 'woocommerce-gls'),
            'print_ready' => __('Print label', 'woocommerce-gls'),
            'modal_title' => __('Please wait, file is being prepared', 'woocommerce-gls'),
            'modal_title_ready' => __('File is ready', 'woocommerce-gls'),
            'download_labels_url' => WC_Gls::plugin_url() . '/tmp/'
        ) );

    } elseif ( strpos($hook, 'woocommerce-gls-packing-list') !== false ) {

        wp_enqueue_style( 'jquery-ui-theme' , WC_Gls::plugin_url() . '/views/css/jquery-ui.css', array('wp-jquery-ui-dialog'), get_option( 'gls_db_version' ));
        wp_enqueue_script( 'gls-backend-packing-list-js' , WC_Gls::plugin_url() . '/views/js/back-packing-list.js', array( 'jquery', 'jquery-ui-widget', 'jquery-ui-core', 'jquery-ui-dialog', 'jquery-ui-tooltip', 'jquery-ui-datepicker'), get_option( 'gls_db_version' ), true );

    } elseif ( strpos($hook, 'woocommerce-gls-import') !== false
        || strpos($hook, 'woocommerce-gls-export') !== false
        || strpos($hook, 'woocommerce_page_wc-settings') !== false
        || strpos($hook, 'post') !== false ) {

        $dependencies = array( 'jquery', 'jquery-ui-widget', 'jquery-ui-core', 'jquery-ui-tooltip');

		if(strpos($hook, 'post') !== false) {

            $dependencies[] = 'jquery-ui-dialog';

            if (get_option( 'gls_settings_gmaps_enable' ) !== 'yes') {
                wp_enqueue_style( 'gls-openstreetmap-css', 'https://unpkg.com/leaflet/dist/leaflet.css', false, get_option( 'gls_db_version' ));
            }

            wp_register_script( 'gls-backend-js', WC_Gls::plugin_url() . '/views/js/back.js', $dependencies, get_option( 'gls_db_version' ), true );

            $var_js = array(
                'btn_cancel_title' => __('Cancel', 'woocommerce-gls'),
                'btn_save_title' => __('Save', 'woocommerce-gls'),
                'gls_js_general_error' => __('Unexpected error occured.', 'woocommerce-gls'),
                'gls_js_update_success' => __('Successfully updated', 'woocommerce-gls'),
                'gls_js_search_error' => __('Please fill-in a <strong>valid postcode</strong>.', 'woocommerce-gls'),
                'ajaxurl' => wp_nonce_url(admin_url( 'admin-ajax.php' ) , 'gls-ajax-request' ),
                'google_maps_enable' => (bool)(get_option( 'gls_settings_gmaps_enable' ) === 'yes'),
                'gls_marker_path' => esc_url(WC_Gls::plugin_url() . '/views/img/front/'),
            );

            wp_localize_script( 'gls-backend-js', 'gls_var', $var_js );

            wp_enqueue_script( 'gls-googlemaps-js', 'https://maps.googleapis.com/maps/api/js?key='.get_option('gls_settings_gmaps_api_key') );
            wp_enqueue_script( 'gls-openstreetmap-js', 'https://unpkg.com/leaflet/dist/leaflet.js' );
            wp_enqueue_script( 'gls-backend-js');

        } else {

            wp_enqueue_script( 'gls-backend-js' , WC_Gls::plugin_url() . '/views/js/back.js', $dependencies, get_option( 'gls_db_version' ), true );

		}

    }

}



function woocommerce_gls_add_settings_link( $links ) {
    $settings_link = '<a href="' . admin_url('admin.php?page=wc-settings&tab=gls_settings') . '">' . __('Settings') . '</a>';
    array_unshift( $links, $settings_link );
    return $links;
}
add_filter( 'plugin_action_links_' . GLS_PLUGIN_NAME, 'woocommerce_gls_add_settings_link' );

function gls_gpdr_exporter( $email_address, $page = 1 ) {

    global $wpdb;

    $number = 500; 
    $page = (int) $page;

    $export_items = array();

    $data_order = $wpdb->get_results( $wpdb->prepare( "
		SELECT gls.* FROM {$wpdb->postmeta} pm, {$wpdb->prefix}woocommerce_gls_cart_carrier gls
		WHERE pm.meta_key = '_billing_email'
        AND pm.meta_value = '%s'
        AND pm.post_id = gls.order_id
    ", $email_address ) );

    if ($data_order) {

        foreach ($data_order as $row) {

            if ( ! empty( $row->customer_phone_mobile ) ) {
                $item_id = "gls-cart-carrier";
                $group_id = 'gls-cart-carrier';
                $group_label = __( 'GLS' , 'woocommerce-gls');
                $data = array(
                    array(
                        'name' => __( 'Order ID' , 'woocommerce-gls'),
                        'value' => $row->order_id
                    ),
                    array(
                        'name' => __( 'Customer phone mobile' , 'woocommerce-gls'),
                        'value' => $row->customer_phone_mobile
                    )
                );

                $export_items[] = array(
                'group_id' => $group_id,
                'group_label' => $group_label,
                'item_id' => $item_id,
                'data' => $data,
                );
            }
        }
    }

    
    
    $done = true;
    return array(
      'data' => $export_items,
      'done' => $done,
    );
}

function register_gls_gpdr_exporter( $exporters ) {
    $exporters['woocommerce-gls'] = array(
      'exporter_friendly_name' => __( 'GLS Plugin' , 'woocommerce-gls'),
      'callback' => 'gls_gpdr_exporter',
    );
    return $exporters;
}

add_filter(
    'wp_privacy_personal_data_exporters',
    'register_gls_gpdr_exporter',
    10
);

function gls_gpdr_eraser( $email_address, $page = 1 ) {

    global $wpdb;

    $number = 500; 
    $page = (int) $page;

    $items_removed = false;

    $data_order = $wpdb->get_results( $wpdb->prepare( "
		SELECT gls.* FROM {$wpdb->postmeta} pm, {$wpdb->prefix}woocommerce_gls_cart_carrier gls
		WHERE pm.meta_key = '_billing_email'
        AND pm.meta_value = '%s'
        AND pm.post_id = gls.order_id
    ", $email_address ) );

    if ($data_order) {

        foreach ($data_order as $row) {

            if ( ! empty( $row->customer_phone_mobile ) ) {
                $query = $wpdb->update( "{$wpdb->prefix}woocommerce_gls_cart_carrier", array( 'customer_phone_mobile' => '' ), array( 'id' => $row->id ) );
                $items_removed = true;
            }
        }
    }

    
    
    $done = true;
    return array(
        'items_removed' => $items_removed,
        'items_retained' => false,
        'messages' => array(),
        'done' => $done,
    );
}

function register_gls_gpdr_eraser( $erasers ) {
    $erasers['woocommerce-gls'] = array(
      'eraser_friendly_name' => __( 'GLS Plugin' , 'woocommerce-gls'),
      'callback'             => 'gls_gpdr_eraser',
      );
    return $erasers;
}

add_filter(
    'wp_privacy_personal_data_erasers',
    'register_gls_gpdr_eraser',
    10
);

$module = new WC_Gls();

register_activation_hook(__FILE__, array($module, 'activate'));
register_deactivation_hook(__FILE__, array($module, 'deactivate'));



$module->main();
?>