<?php
/**
 *  Module made by Nukium
 *
 *  @author    Nukium
 *  @copyright 2021 Nukium SAS
 *  @license   All rights reserved
 *
 * ███    ██ ██    ██ ██   ██ ██ ██    ██ ███    ███
 * ████   ██ ██    ██ ██  ██  ██ ██    ██ ████  ████
 * ██ ██  ██ ██    ██ █████   ██ ██    ██ ██ ████ ██
 * ██  ██ ██ ██    ██ ██  ██  ██ ██    ██ ██  ██  ██
 * ██   ████  ██████  ██   ██ ██  ██████  ██      ██
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
?>

<?php
$orders = array();
?>

<table width="100%" id="body" border="0" cellpadding="0" cellspacing="0" style="margin:0;">
	<tr>
		<td colspan="12">
            <table class="product" width="100%" cellpadding="4" cellspacing="0">
                <thead>
                    <tr>
                        <th class="product header small" width="9%"><?php _e( 'Shipping No.', 'woocommerce-gls' ); ?></th>
                        <th class="product header small" width="14%"><?php _e( 'Product/Service', 'woocommerce-gls' ); ?></th>
                        <th class="product header small" width="8%"><?php _e( 'Order', 'woocommerce-gls' ); ?></th>
                        <th class="product header small" width="8%"><?php _e( 'Order date', 'woocommerce-gls' ); ?></th>
                        <th class="product header small" width="16%"><?php _e( 'Recipient name', 'woocommerce-gls' ); ?></th>
                        <th class="product header small" width="17%"><?php _e( 'Address', 'woocommerce-gls' ); ?></th>
                        <th class="product header small" width="7%"><?php _e( 'Postcode', 'woocommerce-gls' ); ?></th>
                        <th class="product header small" width="10%"><?php _e( 'City', 'woocommerce-gls' ); ?></th>
                        <th class="product header small" width="6%"><?php _e( 'Country', 'woocommerce-gls' ); ?></th>
                        <th class="product header-right small" width="5%"><?php _e( 'Weight (kg)', 'woocommerce-gls' ); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($packages as $package): ?>
                        <?php
                            if (!array_key_exists($package->ID, $orders)) {
                                $the_order = wc_get_order($package->ID);
                                $orders[$package->ID] = $the_order;
                            } else {
                                $the_order = $orders[$package->ID];
                            }
                        ?>
		                <tr class="product">
                            <td class="center"><?php echo $package->shipping_number ?></td>
                            <td><?php echo (isset($gls_product_code[$package->gls_product]) ? $gls_product_code[$package->gls_product] : $package->gls_product); ?></td>
                            <td class="center"><?php echo $package->ID; ?></td>
                            <td class="center"><?php echo esc_attr( $the_order->get_date_created()->date( 'd/m/Y' ) ); ?></td>
                            <td><?php
                                if ( $the_order->get_billing_first_name() || $the_order->get_billing_last_name() ) {
                                    

                                    $username = trim( sprintf( _x( '%1$s %2$s', 'full name', 'woocommerce' ), $the_order->get_billing_first_name(), $the_order->get_billing_last_name() ) );
                                } elseif ( $the_order->get_billing_company() ) {
                                    $username = trim( $the_order->get_billing_company() );
                                } else {
                                    $username = __( 'Guest', 'woocommerce' );
                                }
                                echo $username;
                            ?></td>
                            <td><?php echo ($the_order->get_shipping_address_1() ? $the_order->get_shipping_address_1() : ''); ?><?php echo (!empty($the_order->get_shipping_address_2()) ? '<br>'.$the_order->get_shipping_address_2() : ''); ?></td>
                            <td><?php echo $the_order->get_shipping_postcode() ?></td>
                            <td><?php echo $the_order->get_shipping_city() ?></td>
                            <td><?php echo $the_order->get_shipping_country() ?></td>
                            <td class="right"><?php echo floatval($package->weight); ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </td>
    </tr>

    <tr>
		<td colspan="12" height="30">&nbsp;</td>
	</tr>

    <tr>
		<td colspan="12">
            <table>
                <tr class="big">
                    <td style="width: 35%" class="border">
                        <b><?php _e( 'Customer signature', 'woocommerce-gls' ); ?></b>
                        <br><br><br><br><br>
                    </td>
                    <td style="width: 30%"></td>
                    <td style="width: 35%" class="border">
                        <b><?php _e( 'Carrier signature', 'woocommerce-gls' ); ?></b>
                        <br><br><br><br><br>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
</table>
