<?php
/**
 *	Module made by Nukium
 *
 *  @author    Nukium
 *  @copyright 2021 Nukium SAS
 *  @license   All rights reserved
 *
 * ███    ██ ██    ██ ██   ██ ██ ██    ██ ███    ███
 * ████   ██ ██    ██ ██  ██  ██ ██    ██ ████  ████
 * ██ ██  ██ ██    ██ █████   ██ ██    ██ ██ ████ ██
 * ██  ██ ██ ██    ██ ██  ██  ██ ██    ██ ██  ██  ██
 * ██   ████  ██████  ██   ██ ██  ██████  ██      ██
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$labels = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
?>

<?php if ($relay_points): ?>
	<?php foreach ($relay_points as $k => $v): ?>
    	<?php if ($k < 10  && (!$only_xl || ($only_xl && substr($v->Parcelshop->Address->Name1, -2) == 'XL') )): ?>
        	<div class="row <?php echo ($k > 10 ? 'hidden relay-disable' : 'show relay-enable'); ?>">
            	<div class="col-12">
                	<div class="card gls-relay-infos">
                    	<div class="card-body">
		                	<div class="row gutters-sm">
		                    	<div class="col-auto col-select-relay">
		  							<input type="radio" name="gls_relay" id="gls-relay-<?php echo $v->Parcelshop->ParcelShopId?>" class="gls-select-relay" data-glsrelayid="<?php echo $v->Parcelshop->ParcelShopId?>" value="<?php echo $v->Parcelshop->ParcelShopId?>"<?php if (isset($current_relay) && $current_relay == $v->Parcelshop->ParcelShopId):?> checked<?php endif;?> />
								</div>
								<label class="col" for="gls-relay-<?php echo $v->Parcelshop->ParcelShopId?>">
	                                <div class="card-title">
	                                	<span class="gls-relay-name"><strong><?php echo $v->Parcelshop->Address->Name1?></strong></span><span class="separator"> - </span><span class="gls-relay-label"><?php echo substr($labels, $k, 1); ?></span>
	                                </div>
	                                <div class="card-text">
	                                	<div class="gls-relay-address">
			                            	<?php echo $v->Parcelshop->Address->Street1?>
			                                <br/>
			                                <?php echo $v->Parcelshop->Address->ZipCode?> <?php echo $v->Parcelshop->Address->City?>
	                                    </div>
									</div>
								</label>
								<div class="col-auto">
									<div class="gls-relay-distance text-muted">
                                    	<?php echo number_format($v->AirLineDistance, 2)?> <?php _e( 'km' , 'woocommerce-gls' )?>
                                    </div>
                                </div>
							</div>
						</div>
					</div>
				</div>
			</div>
		<?php endif; ?>
	<?php endforeach; ?>
	<script type="text/javascript">
    	var glsGmapsMarkers = [];
        <?php foreach ($relay_points as $k => $v): ?>
        	<?php if ($k < 10  && (!$only_xl || ($only_xl && substr($v->Parcelshop->Address->Name1, -2) == 'XL') )): ?>
            	var opening_hours = "";
                <?php if (isset($v->Parcelshop->GLSWorkingDay) && is_array($v->Parcelshop->GLSWorkingDay) && count($v->Parcelshop->GLSWorkingDay) > 0): ?>
	            	opening_hours += '<table class="gls-relay-info-open-hours"><tbody>';
                    <?php foreach ($trans_days as $day => $dname): ?>
	                    opening_hours += '<tr';
						    <?php if(((int)date('w') - 1) == (int)$day): ?>
						    	opening_hours += ' class="today"';
					    	<?php endif;?>
					    	opening_hours += '>';
	                    	<?php if (isset($v->Parcelshop->GLSWorkingDay[$day])): ?>
	                    		opening_hours += '<th><?php echo $dname; ?></th>';
	                    		opening_hours += '<td><?php echo substr($v->Parcelshop->GLSWorkingDay[$day]->OpeningHours->Hours->From, 0, 2)?>:<?php echo substr($v->Parcelshop->GLSWorkingDay[$day]->OpeningHours->Hours->From, 2, 2)?> - ';
	                    		<?php if (!empty($v->Parcelshop->GLSWorkingDay[$day]->Breaks->Hours->From)):?>
									opening_hours += '<?php echo substr($v->Parcelshop->GLSWorkingDay[$day]->Breaks->Hours->From, 0, 2)?>:<?php echo substr($v->Parcelshop->GLSWorkingDay[$day]->Breaks->Hours->From, 2, 2)?><br/><?php echo substr($v->Parcelshop->GLSWorkingDay[$day]->Breaks->Hours->To, 0, 2)?>:<?php echo substr($v->Parcelshop->GLSWorkingDay[$day]->Breaks->Hours->To, 2, 2)?> - <?php echo substr($v->Parcelshop->GLSWorkingDay[$day]->OpeningHours->Hours->To, 0, 2)?>:<?php echo substr($v->Parcelshop->GLSWorkingDay[$day]->OpeningHours->Hours->To, 2, 2)?>';
								<?php else: ?>
									opening_hours += '<?php echo substr($v->Parcelshop->GLSWorkingDay[$day]->OpeningHours->Hours->To, 0, 2)?>:<?php echo substr($v->Parcelshop->GLSWorkingDay[$day]->OpeningHours->Hours->To, 2, 2)?>';
								<?php endif; ?>
								opening_hours += '</td>';
							<?php else:?>
	                    		opening_hours += '<th><?php echo $dname; ?></th><td><?php _e( 'Closed' , 'woocommerce-gls' ); ?></td>';
							<?php endif; ?>
						opening_hours += '</tr>';
        			<?php endforeach; ?>
                    opening_hours += '</tbody></table>';
				<?php endif; ?>
                glsGmapsMarkers.push({"lat" : <?php echo $v->Parcelshop->GLSCoordinates->Latitude?>, "lng" : <?php echo $v->Parcelshop->GLSCoordinates->Longitude?>, "name" : "<?php echo $v->Parcelshop->Address->Name1?>", "id" : "<?php echo substr($labels, $k, 1); ?>", "infos" : opening_hours});
			<?php endif; ?>
		<?php endforeach; ?>
	</script>
<?php endif; ?>