/*
 *	Module made by Nukium
 *
 *  @author    Nukium
 *  @copyright 2021 Nukium SAS
 *  @license   All rights reserved
 *
 * ███    ██ ██    ██ ██   ██ ██ ██    ██ ███    ███
 * ████   ██ ██    ██ ██  ██  ██ ██    ██ ████  ████
 * ██ ██  ██ ██    ██ █████   ██ ██    ██ ██ ████ ██
 * ██  ██ ██ ██    ██ ██  ██  ██ ██    ██ ██  ██  ██
 * ██   ████  ██████  ██   ██ ██  ██████  ██      ██
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

jQuery(document).ready(function() {

	if (typeof jQuery.fn.tipTip === "function") {
        var tiptip_args = {
            'attribute': 'data-tip',
            'fadeIn': 50,
            'fadeOut': 50,
            'delay': 200
        };

        jQuery( '.tips, .help_tip, .woocommerce-help-tip' ).tipTip( tiptip_args );
    }

	jQuery('#woocommerce_gls_admin_order_label_label_order_id').on('keypress', function(e) {
		if(e.which == 13) {
			e.preventDefault();
	        jQuery('button[name="generateLabelStep3Single"]').trigger('click');
	    }
	});

	if(jQuery('#cb-select-all-1').length > 0) {
		jQuery('#cb-select-all-1').trigger('click');
	}

	if(jQuery('input[name="gls_label_single_type"]').val() == 'return') {
		jQuery('.packages .card-footer, .packages .packages-count, .packages .package-title').remove();
	}

	jQuery('#table-labels tr:not(.extra-content)').on('click', function(e) {

		e.preventDefault();
		if(jQuery(this).parent('tbody').length > 0) {
			jQuery(this).find('a.toggler').trigger('click');
		}

	});

	jQuery('#table-labels th a.toggler').on('click', function(e) {

		e.preventDefault();

		if(jQuery(this).attr('aria-expanded') == 'false') {

			jQuery('#table-labels a.toggler').attr('aria-expanded', 'true');
			jQuery('#table-labels#table-labels a.toggler i').removeClass('icon-angle-down').addClass('icon-angle-up');
			jQuery('.extra-content').each(function() {
				jQuery(this).find('.extra-content-form').stop(true, false).slideDown();
			});

		} else {

			jQuery('#table-labels a.toggler').attr('aria-expanded', 'false');
			jQuery('#table-labels a.toggler i').removeClass('icon-angle-up').addClass('icon-angle-down');
			jQuery('.extra-content').each(function() {
				jQuery(this).find('.extra-content-form').stop(true, false).slideUp();
			});

		}

	});

	jQuery('#table-labels td a.toggler').on('click', function(e) {

		e.preventDefault();
		e.stopImmediatePropagation();
		jQuery(this).attr('aria-expanded', function(_, attr) { return !(attr == 'true') });
		jQuery(this).children('i').toggleClass('icon-angle-down icon-angle-up');
		jQuery(this).closest('tr').next().find('.extra-content-form').stop(true, false).slideToggle();
		return false;

	});

	if(jQuery('#table-labels tbody tr:not(.extra-content)').length == 1) {
		jQuery('#table-labels tbody tr td a.toggler').trigger('click');
		jQuery('#table-labels a.toggler').hide();
		jQuery('#table-labels tr:not(.extra-content)').off('click');
	}

	function updatePrintingState(order_id) {

		var total_controls = 0;
		var completed_controls = 0;

		jQuery('#extra-content-form-' + order_id + ' .form-group').each(function() {

			if(jQuery(this).css('display') !== 'none') {

				jQuery(this).children('.control-label.required').next().children('.form-control').each(function() {

					total_controls++;
					if(jQuery(this).val() != '') {
						completed_controls++;
					}

				});
			}

		});

		if(total_controls > 0) {

			var progress = (completed_controls / total_controls) * 100;
			jQuery('#printing-progress-' + order_id + ' .progress-bar').css('width', progress + '%').attr('aria-valuenow', progress);

			if(progress == 100) {

				jQuery('#printing-progress-' + order_id + ' .progress-bar').removeClass('bg-primary').addClass('bg-success');
				jQuery('#button-print-' + order_id).removeClass('btn-disabled').tipTip({ content: gls_backend_label_var.print_ready });
				jQuery('#button-print-' + order_id).removeClass('btn-disabled').tipTip({ content: gls_backend_label_var.print_ready });

			} else {

				jQuery('#printing-progress-' + order_id + ' .progress-bar').removeClass('bg-success').addClass('bg-primary');
				jQuery('#button-print-' + order_id).addClass('btn-disabled').tipTip({ content: gls_backend_label_var.print_block });

            }

            if(jQuery('.button-print:not(.btn-disabled)').length > 0) {
                jQuery('#gls-btn-print-all').prop('disabled', false);
            } else {
                jQuery('#gls-btn-print-all').prop('disabled', true);
            }

		}

	}

	jQuery.fn.getOrderId = function() {

		if(jQuery(this).closest('.extra-content-form').length > 0) {

			return parseInt(jQuery(this).closest('.extra-content-form').attr('id').replace('extra-content-form-', ''));

		} else if(jQuery(this).closest('tr').next().hasClass('extra-content')) {

			return parseInt(jQuery(this).closest('tr').next().find('.extra-content-form').attr('id').replace('extra-content-form-', ''));

		}

	};

	var gls_label_single_type = jQuery('input[name="gls_label_single_type"]').val();

	jQuery('.button-print').on('click', function(e, deferred) {

		e.preventDefault();
		e.stopImmediatePropagation();

		var toggler = jQuery(this).closest('tr').children('td:first').children('.toggler');

		if(jQuery(this).hasClass('btn-disabled')) {

			if(jQuery(toggler).attr('aria-expanded') == 'false') {
				jQuery(toggler).trigger('click');
			}

        } else if(!jQuery(this).hasClass('btn-processing')) {

            // Disable double clic
            jQuery(this).addClass('btn-processing');

			jQuery(this).children('i').toggleClass('icon-print icon-spinner icon-spin');

			var order_id = jQuery(this).getOrderId();

			jQuery('input[name="gls_label_single_type"]').val(gls_label_single_type);
            jQuery('local_print_'+order_id).val(0);

			var data = jQuery('#extra-content-form-' + order_id).serializeArray();
			data.push({name: "action", value: "gls_generate_label"});

			jQuery.ajax({
				type: 'POST',
				url: gls_backend_label_var.ajax_uri,
				cache: false,
		        dataType: 'json',
		        context: this,
		        data: jQuery.param(data)
			}).done(function(jsonData) {

				if (jsonData.hasError === true) {

					jQuery('#button-print-' + order_id).removeClass('button-primary').addClass('button-danger-outline');
                    jQuery('#button-print-' + order_id).removeClass('btn-processing');
                    jQuery('#button-print-' + order_id).tipTip({ content: jsonData.errors });
					jQuery(this).children('i').toggleClass('icon-print icon-spinner icon-spin');
                    if (typeof deferred !== 'undefined') {
                        manageMergePDFSteps('error');
                        deferred.resolve();
                    }
                } else if(jsonData.data) {

                    if(jsonData.data != 'local_print') {
                        for (var i = 0, len = jsonData.data['labels'].length; i < len; i++) {
                            downloadFile(jsonData.data['labels'][i], 'order-' + order_id + '-label-' + (i+1) + '.pdf');
                        }
                    }

					if(jQuery('#extra-content-form-' + order_id).find('.gls-service option:selected').attr('data-mobile-required') !== undefined
						&& jQuery('#extra-content-form-' + order_id).find('.gls-service option:selected').attr('data-mobile-required') == 'true'
						&& jQuery('#extra-content-form-' + order_id).find('input[name="return_label"]:checked').val() !== undefined
						&& jQuery('#extra-content-form-' + order_id).find('input[name="return_label"]:checked').val() == '1') {

						jQuery('input[name="gls_label_single_type"]').val('return_shipment');

						data = jQuery('#extra-content-form-' + order_id).serializeArray();
						data.push({name: "action", value: "gls_generate_label"});

						jQuery.ajax({
							type: 'POST',
							url: gls_backend_label_var.ajax_uri,
							cache: false,
					        dataType: 'json',
					        context: this,
					        data: jQuery.param(data)
						}).done(function(jsonData) {

							if (jsonData.hasError === true) {

								jQuery('#button-print-' + order_id).removeClass('button-primary').addClass('button-danger-outline');
								jQuery('#button-print-' + order_id).removeClass('btn-processing');
								jQuery('#button-print-' + order_id).tipTip({ content: jsonData.errors });
                                jQuery(this).children('i').toggleClass('icon-print icon-spinner icon-spin');
                                if (typeof deferred !== 'undefined') {
                                    manageMergePDFSteps('error');
                                    deferred.resolve();
                                }

                            } else if(jsonData.data) {

								if(jQuery(toggler).attr('aria-expanded') == 'true') {
									jQuery(toggler).trigger('click');
								}

								jQuery(this).closest('tr').next().find('.extra-content-form :input').prop('disabled', true);

								var parent = jQuery(this).parent();
								parent.children('.button-print').remove();
								parent.html('<span class="icon-stack icon-lg"><i class="icon icon-circle icon-stack-2x text-success"></i><i class="icon icon-check icon-stack-1x icon-inverse"></i></span>');

                                if(jsonData.data == 'local_print') {
                                    manageMergePDFSteps();
                                    if (typeof deferred !== 'undefined' && deferred.state() == "pending") {
                                        if (typeof deferred !== 'undefined') {
                                            deferred.resolve(order_id);
                                        }
                                    }
                                } else {
                                    for (var i = 0, len = jsonData.data['labels'].length; i < len; i++) {
                                        downloadFile(jsonData.data['labels'][i], 'order-' + order_id + '-label-' + (i+1) + '.pdf');
                                    }
                                }
							}

						}).fail(function() {

                            jQuery(this).removeClass('btn-processing');
                            jQuery(this).children('i').toggleClass('icon-print icon-spinner icon-spin');
                            // TODO display error
                            if (typeof deferred !== 'undefined') {
                                manageMergePDFSteps('error');
                                deferred.resolve();
                            }
						});

					} else {

						if(jQuery(toggler).attr('aria-expanded') == 'true') {
							jQuery(toggler).trigger('click');
						}

						jQuery(this).closest('tr').next().find('.extra-content-form :input').prop('disabled', true);

						var parent = jQuery(this).parent();
						parent.children('.button-print').remove();
						parent.html('<span class="icon-stack icon-lg"><i class="icon icon-circle icon-stack-2x text-success"></i><i class="icon icon-check icon-stack-1x icon-inverse"></i></span>');

                        if(jsonData.data == 'local_print') {
                            manageMergePDFSteps();
                            if (typeof deferred !== 'undefined' && deferred.state() == "pending") {
                                if (typeof deferred !== 'undefined') {
                                    deferred.resolve(order_id);
                                }
                            }
                        }
					}

				}

			}).fail(function() {

                jQuery(this).removeClass('btn-processing');
                jQuery(this).children('i').toggleClass('icon-print icon-spinner icon-spin');
                // TODO display error
                if (typeof deferred !== 'undefined') {
                    manageMergePDFSteps('error');
                    deferred.resolve();
                }
			});
		}

	});

	var default_package_item = jQuery('.extra-content-form:first .package:first').clone(true);

	jQuery('.extra-content-form').each(function() {

		jQuery(this).get(0).reset();
		updatePrintingState(jQuery(this).children().getOrderId());

	});

	jQuery('body').on('input', '.extra-content-form .form-control', function() {

		updatePrintingState(jQuery(this).getOrderId());

	});

	jQuery('.add-package').on('click', function(e) {

		e.preventDefault();

		var order_id = jQuery(this).getOrderId();
		var package_item = default_package_item;
		var nb_packages = jQuery(this).closest('.packages').find('.package').length + 1;
		package_item.find('.package-index').text(nb_packages);
		package_item.find('.remove-package').removeClass('d-none');
		jQuery(this).closest('.packages').find('.card-body').append(package_item.clone(true));

		jQuery(this).closest('.packages').find('.packages-count').text(nb_packages);

		updatePrintingState(order_id);

	});

	jQuery('body').on('click', '.remove-package', function(e) {

		e.preventDefault();

		if(jQuery(this).closest('.packages').find('.package').length > 1) {

			var packages = jQuery(this).closest('.packages');
			var order_id = jQuery(this).getOrderId();

			jQuery(this).closest('.package').remove();

			var count = 0;
			jQuery(packages).find('.package').each(function() {
				count++;
				jQuery(this).find('.package-index').text(count);
			});
			packages.find('.packages-count').text(count);

			updatePrintingState(order_id);

		}

	});

	jQuery('.gls-service').on('change', function(e) {

		var mobile = jQuery(this).children('option:selected').attr('data-mobile-required');

		if(typeof mobile !== 'undefined' && mobile === 'true') {

			jQuery(this).closest('.form-group').siblings('.mobile-group').find('.form-control').prop('disabled', false);
			jQuery(this).closest('.form-group').siblings('.mobile-group').stop(true, false).slideDown();

		} else {

			jQuery(this).closest('.form-group').siblings('.mobile-group').stop(true, false).slideUp(function() {
				jQuery(this).find('.form-control').prop('disabled', true);
			});

		}

		updatePrintingState(jQuery(this).getOrderId());

	});
	jQuery('.gls-service').trigger('change');

	function downloadFile(base64str, filename) {

		var binary = atob(base64str.replace(/\s/g, ''));
		var blen = binary.length;
		var buffer = new ArrayBuffer(blen);
		var view = new Uint8Array(buffer);
		for (var n = 0; n < blen; n++) {
		    view[n] = binary.charCodeAt(n);
		}
		var newBlob = new Blob( [view], { type: "application/pdf" });

		if (window.navigator && window.navigator.msSaveOrOpenBlob) {
		    window.navigator.msSaveOrOpenBlob(newBlob, filename);
		} else {
			var url = URL.createObjectURL(newBlob);
		    var a = document.createElement("a");
		    document.body.appendChild(a);
		    a.style = "display: none";
		    a.href = url;
		    a.download = filename;
		    a.click();
		    setTimeout(function() {
			    URL.revokeObjectURL(url);
		    }, 100);
		}
	}

    var printAllError;
    function manageMergePDFSteps(state) {

        if (typeof state == 'undefined') {
            state = 'success';
        }

        var loadCounter = parseInt(jQuery('#gls-btn-print-all').attr('data-counter'));

        jQuery('#gls-btn-print-all').attr('data-counter', loadCounter - 1);
        jQuery(this).children('i').toggleClass('icon-print icon-spinner icon-spin');

        var currentProgress = parseInt(jQuery('#modalMergeLabels .progress-bar').attr('aria-valuenow'));
        var progress = Math.round(currentProgress + ((100 - currentProgress) / loadCounter));

        jQuery('#modalMergeLabels .progress-bar').css('width', progress + '%').attr('aria-valuenow', progress);
        if((currentProgress == 0) || (progress >= 100)) {
            if(currentProgress == 0) {
                printAllError = false;
                jQuery('#modalMergeLabels .progress-steps > li:first-child .icon-circle').toggleClass('text-muted text-primary');
                jQuery('#modalMergeLabels .progress-steps > li:first-child .icon-check').removeClass('hidden');
                jQuery('#modalMergeLabels .progress-steps .total-counter').text(parseInt(loadCounter - 2));
            }
            if(progress >= 100) {
                jQuery('#modalMergeLabels .progress-steps > li:last-child .icon-circle').toggleClass('text-muted text-primary');
                jQuery('#modalMergeLabels .progress-steps > li:last-child .icon-check').removeClass('hidden');
                jQuery('#modalMergeLabels .progress-bar').removeClass('bg-primary').addClass('bg-success');
            }
        } else {
            if (state == 'success') {
                jQuery('#modalMergeLabels .progress-steps .counter').text(parseInt(jQuery('#modalMergeLabels .progress-steps .counter').text()) + 1);
            } else if (state == 'error') {
                printAllError = true;
            }
            if(loadCounter == 2) {
                if (printAllError) {
                    jQuery('#modalMergeLabels .progress-steps > li:eq(1) .icon-circle').toggleClass('text-muted text-warning');
                    jQuery('#modalMergeLabels .progress-steps > li:eq(1) .icon-check').toggleClass('icon-check icon-minus')
                    if(jQuery('#modalMergeLabels .progress-steps .counter').text() != '0') {
                        jQuery('#gls-generate-label-warning').slideDown();
                    }
                } else {
                    jQuery('#modalMergeLabels .progress-steps > li:eq(1) .icon-circle').toggleClass('text-muted text-primary');
                }
                jQuery('#modalMergeLabels .progress-steps > li:eq(1) .icon-stack-1x').removeClass('hidden');
            }
        }

    }

    var modal_content = jQuery('#modalMergeLabels .modal-body').html();

    jQuery('#modalMergeLabels').dialog({
        autoOpen: false,
        width: 600,
        modal: true,
        closeOnEscape: false,
        draggable: false,
        resizable: false,
        open: function( event, ui ) {
            jQuery('#modalMergeLabels .modal-body').html(modal_content);
        }
    });

    jQuery('#gls-btn-print-all').on('click', function(e) {

        e.preventDefault();

        jQuery('#gls-btn-print-all').attr('data-counter', jQuery('.button-print:not(.btn-disabled)').length + 2);
        jQuery('#modalMergeLabels').dialog('option', 'title', gls_backend_label_var.modal_title);
        jQuery('#modalMergeLabels').dialog('open');

        // Suppression du dossier temporaire
        jQuery.ajax({
            type: 'POST',
            url: gls_backend_label_var.ajax_uri,
            cache: false,
            dataType: 'json',
            context: this,
            data: [{name: 'prepareMerge', value: 1}, {name: 'action', value: 'gls_generate_all_labels'}]
        }).done(function(jsonData) {

            if (jsonData.hasError === true) {
                jQuery('#gls-generate-label-error').slideDown();
            } else {
                manageMergePDFSteps();

                var list = [];
                var orders = [];
                jQuery('.button-print').each(function(i) {
					if(!jQuery(this).hasClass('btn-disabled') && !jQuery(this).hasClass('btn-processing')) {
						var order_id = jQuery(this).getOrderId();
						var def = new jQuery.Deferred();
						orders.push(order_id);
						list.push(def);
						// Add timetout 500ms to prevent 500 error
						setTimeout(() => {
							jQuery('#local_print_'+order_id).val(1);
							jQuery(this).trigger('click', def);
						}, i * 500);
                    }
                });

                jQuery.when.apply(jQuery, list).then(function() {
                    jQuery.ajax({
                        type: 'POST',
                        url: gls_backend_label_var.ajax_uri,
                        cache: false,
                        dataType: 'json',
                        context: this,
                        data: [{name: 'mergePDF', value: 1}, {name: 'action', value: 'gls_generate_all_labels'}]
                    }).done(function(jsonData2) {
                        if (jsonData2.hasError === true) {
                            jQuery('#modalMergeLabels').dialog( "close" );
                        } else if(jsonData2.data) {
                            manageMergePDFSteps();
                            jQuery('#gls-btn-print-all').prop('disabled', true);
                            jQuery('#modalMergeLabels').dialog('option', 'position', { my: 'center', at: 'center', of: window });
                            jQuery('#modalMergeLabels').dialog('option', 'title', gls_backend_label_var.modal_title_ready);
                            jQuery('#modalMergeLabels .btn').prop('disabled', false).attr('data-file', jsonData2.data.pdf);
                            jQuery('#modalMergeLabels .btn').on('click', function() {
                                window.open(gls_backend_label_var.download_labels_url + jQuery(this).attr('data-file'));
                            });
                        }
                    }).fail(function() {
                        jQuery('#gls-generate-label-error').slideDown();
                    });
                }, function () {
                    // generation failed
                    jQuery.each(list, function (index, deferred) {
                        if(deferred.state() == "pending") {
                            deferred.reject();
                        }
                    });
                    jQuery('#gls-generate-label-error').slideDown();
                });
            }
        }).fail(function() {
            jQuery('#gls-generate-label-error').slideDown();
        });
    });

});
