<?php


if (!defined('ABSPATH'))
    exit;

class WC_Gls_tracking_state {

    public $id = '';
    public $order_id = '';
    public $current_state = '';
    public $date_add = '';
    public $date_upd = '';

    public function __construct( $values = array() ) {
		if ( is_array( $values ) && count( $values ) > 0 ) {
            foreach ($values as $key => $value) {
                if (isset($this->{$key})) {
                    $this->{$key} = $value;
                }
            }
        }
    }

    public static function get_by_order_id( $order_id ) {
		global $wpdb;

		$row = $wpdb->get_row( $wpdb->prepare( "SELECT gts.* FROM {$wpdb->prefix}woocommerce_gls_tracking_state gts WHERE gts.order_id=%d", $order_id ), ARRAY_A);
		if ( $row ) {
			return new WC_Gls_tracking_state( $row );
		}

		return false;
    }

    public function create( $data = array(), $return = false ) {
		global $wpdb;

        if (!isset($data['id'])) {

            foreach ($data as $key => $value) {
                if (!isset($this->{$key})) {
                    unset($data[$key]);
                }
            }
            $data['date_add'] = current_time( 'mysql' );
            $data['date_upd'] = current_time( 'mysql' );

            $wpdb->insert( $wpdb->prefix . 'woocommerce_gls_tracking_state', $data );

            if ( $return ) {
                return WC_Gls_tracking_state::get( $wpdb->insert_id );
            }
            return true;
        }

		return false;
    }

    public function update( $id, $data = array(), $return = false ) {

		global $wpdb;

        if (is_numeric($id) && (int)$id > 0) {

            foreach ($data as $key => $value) {
                if (!isset($this->{$key}) || $key == 'id') {
                    unset($data[$key]);
                }
            }
            $data['date_upd'] = current_time( 'mysql' );

            $updated = $wpdb->update( $wpdb->prefix . 'woocommerce_gls_tracking_state', $data, array( 'id' => (int)$id ) );

            if ( $return ) {
                return WC_Gls_tracking_state::get( $id );
            }
            return true;
        }

        return false;
    }
}