<?php
/**
 *	Module made by Nukium
 *
 *  @author    Nukium
 *  @copyright 2021 Nukium SAS
 *  @license   All rights reserved
 *
 * ███    ██ ██    ██ ██   ██ ██ ██    ██ ███    ███
 * ████   ██ ██    ██ ██  ██  ██ ██    ██ ████  ████
 * ██ ██  ██ ██    ██ █████   ██ ██    ██ ██ ████ ██
 * ██  ██ ██ ██    ██ ██  ██  ██ ██    ██ ██  ██  ██
 * ██   ████  ██████  ██   ██ ██  ██████  ██      ██
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<div class="wrap woocommerce">
	<form action="<?php echo esc_url($admin_url); ?>" method="post" enctype="multipart/form-data">
	    <?php echo $settings; ?>
	    <div class="automation-help notice notice-info">
	    	<p>
	        	<input name="importOrderAutomatic" class="button-secondary woocommerce-save-button" type="submit" value="<?php esc_attr_e('Run the automatic tracking numbers import now', 'woocommerce-gls' ); ?>>" />
	        </p>
	    	<?php _e('Here is the path to the import folder:', 'woocommerce-gls' ); ?>
	    	<div class="input-group">
	            <input type="text" class="form-control copy-input" value="<?php echo $import_path; ?>" disabled>
	            <span class="input-group-btn">
	            	<button class="button copy-button" type="button" data-placement="button"><i class="icon-copy"></i> <?php _e('Copy', 'woocommerce-gls' ); ?></button>
	            </span>
	        </div>
		</div>
	    <p class="submit">
	    	<input name="saveImportOrder" class="button-secondary woocommerce-save-button" type="submit" value="<?php esc_attr_e( 'Save', 'woocommerce-gls' ); ?>" />
	    	<input name="importOrder" class="button-primary woocommerce-save-button" type="submit" value="<?php esc_attr_e( 'Import now', 'woocommerce-gls' ); ?>" />
	    </p>
	</form>
</div>