/*
 *	Module made by Nukium
 *
 *  @author    Nukium
 *  @copyright 2021 Nukium SAS
 *  @license   All rights reserved
 *
 * ███    ██ ██    ██ ██   ██ ██ ██    ██ ███    ███
 * ████   ██ ██    ██ ██  ██  ██ ██    ██ ████  ████
 * ██ ██  ██ ██    ██ █████   ██ ██    ██ ██ ████ ██
 * ██  ██ ██ ██    ██ ██  ██  ██ ██    ██ ██  ██  ██
 * ██   ████  ██████  ██   ██ ██  ██████  ██      ██
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

var glsmap,infowindow,bounds;

jQuery(document).ready(function() {

	var original_checked_relay = jQuery('input.gls-select-relay:checked');

	jQuery('body').on('keyup', '.gls-customer-mobile', function() {

		var checked_carrier = gls_get_checked_carrier();
		var mobile = jQuery('#gls-customer-mobile-'+checked_carrier).val();

		if(gls_validate_mobile()) {

			jQuery.ajax({
				type: "POST",
				url: gls_var.ajaxurl,
				cache: false,
		        dataType: "json",
		        data: {
		        	action: "gls_save_mobile",
		        	gls_customer_mobile: mobile,
		        	is_relay: (checked_carrier == gls_var.glsrelais_carrier_id) ? 1 : 0}
			}).done(function(data) {
				if(!data.result) {
					alert(data.message);
				}
			}).fail(function() {
				alert(gls_var.gls_js_general_error);
			});

		}

    });

	jQuery('body').on('click', '.gls-search-form-toggler', function(e) {
		e.preventDefault();
		jQuery('#gls-search-form').slideToggle();
	});

	jQuery('body').on('change', 'input.gls-select-relay', function(e) {

		e.preventDefault();
    	//__ TODO: gestion d'erreur
		checked_carrier = gls_get_checked_carrier();

		jQuery.ajax({
			type: 'POST',
			url: gls_var.ajaxurl,
			cache: false,
	        dataType: 'json',
	        context: this,
	        data: {
	        	action: 'gls_select_relay',
	        	glsrelayid: jQuery(this).attr('data-glsrelayid'),
	        	gls_customer_mobile: jQuery('#gls-customer-mobile-'+checked_carrier).val()
        	}
		}).done(function(data) {
			if(!data.result) {
				jQuery(this).prop('checked', false);
				if(jQuery(original_checked_relay).length > 0) {
					jQuery(original_checked_relay).prop('checked', true);
				}
				alert(data.message);
			} else {
                original_checked_relay = jQuery('input.gls-select-relay:checked');
                jQuery('input[name="gls_relay_required"]').remove();
			}
		}).fail(function() {
			jQuery(this).prop('checked', false);
			if(jQuery(original_checked_relay).length > 0) {
				jQuery(original_checked_relay).prop('checked', true);
			}
			alert(gls_var.gls_js_general_error);
			return false;
		});
		return false;

	});

	/**
	 * Recherche de nouveaux GLS Relais
	 */
	jQuery('body').on('click', '.gls-search-relay', function(e) {

		e.preventDefault();
		if(jQuery('#gls-search').val()) {

			if(typeof jQuery.fn.block !== 'undefined') {
				jQuery('.gls-relay-list').addClass( 'processing' ).block({
					message: null,
					overlayCSS: {
						background: '#fff',
						opacity: 0.6
					}
				});
			}

			jQuery.ajax({
				type: 'POST',
				url: gls_var.ajaxurl,
				cache: false,
		        dataType: 'json',
		        context: this,
		        data: {action: 'gls_search_relay', search: jQuery('#gls-search').val()}
			}).done(function(data) {
				if(typeof jQuery.fn.unblock !== 'undefined') {
					jQuery('.gls-relay-list').removeClass( 'processing' ).unblock();
				}
				if(!data.result) {
					alert(data.message);
				} else {
					jQuery('.gls-relay-list').html(data.point_relay_tpl).show();
					jQuery('.gls-relay-map').show();
					initGlsMap();
					jQuery('.gls-container > .alert').hide();
				}
			}).fail(function() {
				alert(gls_var.gls_js_general_error)
				return false;
			});

		} else {
			alert(gls_var.gls_js_search_error)
		}
		return false;

	});

	jQuery('body').on('keypress', '#gls-search', function(e) {
		if(e.which == 13) {
			e.preventDefault();
	        jQuery('.gls-search-relay').trigger('click');
	    }
	});

	jQuery('body').on('search', '#gls-search', function(e) {
		e.preventDefault();
        jQuery('.gls-search-relay').trigger('click');
	});

	/**
	 * Check avant étape confirmation et paiement
	 */
	jQuery('form.checkout').on('submit checkout_place_order', function() {
		jQuery('.gls-prevent-submit').remove();
		check_gls_option();
	});

	if (jQuery('#billing_phone').length > 0) {
		jQuery('#billing_phone').blur(function() {
			var checked_carrier = gls_get_checked_carrier();
			if (jQuery('#billing_phone').val() != ''
				&& jQuery('input[id^="gls-customer-mobile-'+ checked_carrier + '"]').length > 0
				&& jQuery('input[id^="gls-customer-mobile-'+ checked_carrier + '"]').val() == '') {
				jQuery('input[id^="gls-customer-mobile-'+ checked_carrier + '"]').val(jQuery('#billing_phone').val());
			}
		});
	}

    // Action on checkout change or loaded
	jQuery(document.body).on('updated_checkout', function() {

        var checked_carrier = gls_get_checked_carrier();

        if (jQuery('#billing_phone').length > 0
            && jQuery('#billing_phone').val() != ''
            && jQuery('input[id^="gls-customer-mobile-'+ checked_carrier + '"]').length > 0
            && jQuery('input[id^="gls-customer-mobile-'+ checked_carrier + '"]').val() == '') {
            jQuery('input[id^="gls-customer-mobile-'+ checked_carrier + '"]').val(jQuery('#billing_phone').val());
        }

        if(jQuery('input[id^="gls-customer-mobile-'+ checked_carrier + '"]').length > 0) {
            jQuery('input[id^="gls-customer-mobile-'+ checked_carrier + '"]').trigger('keyup');
            check_gls_option();
        }

        initGlsMap();

	});

});

function gls_get_checked_carrier() {
	var checked_carrier = jQuery('input[name^="shipping_method"]:checked').val();
	if (typeof checked_carrier === 'undefined') {
		checked_carrier = jQuery('input[name^="shipping_method"][type="hidden"]').val();
	}
	return checked_carrier;
}

function check_gls_option() {

	var checked_carrier = gls_get_checked_carrier();
	var no_error = true;

	check_mobile = false;
	if(checked_carrier == gls_var.glsrelais_carrier_id || checked_carrier == gls_var.gls13h_carrier_id || checked_carrier == gls_var.glschezvousplus_carrier_id) {
		check_mobile = true;
	}

	if(check_mobile) {
		no_error &= gls_validate_mobile();
	}

	if(checked_carrier == gls_var.glsrelais_carrier_id) {

		$carrier_selected = false;
		jQuery('.gls-select-relay').each(function() {
			if(jQuery(this).is(':checked')) {
				$carrier_selected = true;
			}
		});
		if(!$carrier_selected) {
			jQuery('form.checkout').append('<input type="hidden" class="gls-prevent-submit" name="gls_relay_required" value="1" />');
		}
		no_error &= $carrier_selected;

	}

	return no_error;
}

function gls_validate_mobile() {

	var checked_carrier = gls_get_checked_carrier();
	jQuery('input[name="gls_mobile_required"]').remove();

	if(jQuery('#gls-customer-mobile-'+checked_carrier).val() && gls_mobile_number_checker(jQuery('#gls-customer-mobile-'+checked_carrier).val())) {

		jQuery('#gls-customer-mobile-'+checked_carrier).closest('div.form-row').removeClass('woocommerce-invalid').addClass('woocommerce-validated');
		return true;

	} else {

		jQuery('#gls-customer-mobile-'+checked_carrier).closest('div.form-row').removeClass('woocommerce-validated').addClass('woocommerce-invalid');
		jQuery('form.checkout').append('<input type="hidden" class="gls-prevent-submit" name="gls_mobile_required" value="1" />');
		return false;
	}

}

/**
 * Validation du numéro de mobile du destinataire
 */
function gls_mobile_number_checker(phone_mobile) {

	var regex = new RegExp(/^(\+[\d]|0)([\d _.-]{6,})$/);

	if((jQuery('.shipping_address').is(':visible') && jQuery('#shipping_country').val() == 'FR') || (jQuery('.shipping_address').is(':hidden') && jQuery('#billing_country').val() == 'FR')) {
		regex = new RegExp(/^(\+33|0)([\d _.-]{9,})$/);
	}

	var numbers = phone_mobile.substr(-8);
	var pattern = ['00000000','11111111','22222222','33333333','44444444','55555555','66666666','77777777','88888888','99999999','12345678','23456789','98765432'];

	if (regex.test(phone_mobile) && jQuery.inArray(numbers, pattern) == -1) {
		// GSM OK : fonction suivante
		return true;
	} else {
		return false;
	}

}

/**
 * Initialisation de la carte
 */
function initGlsMap() {

	if(document.getElementById('gls-map')) {

        if(gls_var.google_maps_enable && typeof google !== 'undefined') {

            glsmap = new google.maps.Map(document.getElementById('gls-map'), {
                zoom: 12,
                maxZoom: 18,
                mapTypeId: google.maps.MapTypeId.ROADMAP,
                fullscreenControl: false
            });

            infowindow = new google.maps.InfoWindow({ });

            bounds = new google.maps.LatLngBounds();

            //__ Si des marqueurs google maps existent, on les ajoute sur la carte
            if(typeof glsGmapsMarkers !== 'undefined') {
                if(glsGmapsMarkers.length > 0) {
                    glsGmapsMarkers.forEach(function(item, index) {
                        addGlsMapMarker(new google.maps.LatLng(item['lat'], item['lng']), item['name'], item['id'], item['infos']);
                    });
                }
            }

            glsmap.fitBounds(bounds);

        } else {

            if(typeof glsmap !== 'undefined') {
                glsmap.remove();
            }
            glsmap = L.map('gls-map', {
                zoom: 12,
                scrollWheelZoom: false
            });
            L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'
            }).addTo(glsmap);

            bounds = [];

            //__ Si des marqueurs existent, on les ajoute sur la carte
            if(typeof glsGmapsMarkers !== 'undefined') {
                if(glsGmapsMarkers.length > 0) {
                    glsGmapsMarkers.forEach(function(item, index) {
                        addGlsMapMarker([item['lat'], item['lng']], item['name'], item['id'], item['infos']);
                    });
                }
            }

            glsmap.fitBounds(new L.LatLngBounds(bounds));
            setTimeout(function() {
                glsmap.invalidateSize();
            }, 50);

        }

	}

}

/**
 * Ajout des GLS Relais sur la carte
 */
function addGlsMapMarker(lat_lng, name, id, infos) {

    if (gls_var.google_maps_enable) {

        var marker = new google.maps.Marker({
            position: lat_lng,
            label: id,
            map: glsmap
        });

        bounds.extend(marker.position);

        google.maps.event.addListener(marker, 'click', (function (marker, name, infos) {

            return function () {
                infowindow.setContent('<div id="content" style="padding-right:17px;">'+
                    '<div id="firstHeading" class="h6">' + name + '</div>'+
                    '<div id="bodyContent" style="width:180px">' + infos + '</div>'+
                '</div>');
                infowindow.open(glsmap, marker);
            }

        })(marker, name, infos));

    } else {

        var marker = L.marker(lat_lng, {
            title: id,
            alt: name,
            icon: L.divIcon({
                className: 'nkmgls-osmap-marker-icon',
                html: '<div class="gls-marker-wrapper" data-marker-id="' + id + '"><img class="gls-marker-img" src="' + gls_var.gls_marker_path + 'gls-marker.png" alt="' + id + '"></div>',
                iconSize:[54,40],
                iconAnchor:[27,40],
                popupAnchor:[0,-36]
            })
        }).addTo(glsmap);
        marker.bindPopup('<div id="content" style="padding-right:17px;">'+
            '<div id="firstHeading" class="h6">' + name + '</div>'+
            '<div id="bodyContent" style="width:180px">' + infos + '</div>'+
        '</div>');

        bounds.push(lat_lng);

    }
}
