<?php
/**
 * This class handles notices to admin
 *
 * @package   WooCommerce_iZettle_Integration
 * @author    BjornTech <info@bjorntech.com>
 * @license   GPL-3.0
 * @link      http://bjorntech.com
 * @copyright 2017-2020 BjornTech - BjornTech AB
 */

defined('ABSPATH') || exit;

if (!class_exists('IZ_Notice', false)) {

    class IZ_Notice
    {
        public function __construct()
        {
            add_action('admin_notices', array($this, 'check_displaylist'), 100);
        }

        public static function add($message, $type = 'info', $id = false, $dismiss = true, $time = false)
        {

            $id = $id === false ? uniqid('id-') : 'id-' . esc_html($id);

            /*         if (WC_Zettle_Helper::wc_version_check('4.3.0')) {
            require_once dirname(__FILE__) . '/izettle-admin-notes.php';

            switch ($type) {
            case 'error':
            $message_type = \Automattic\WooCommerce\Admin\Notes\WC_Admin_Note::E_WC_ADMIN_NOTE_ERROR; // used for presenting error conditions.
            break;
            case 'warning':
            $message_type = \Automattic\WooCommerce\Admin\Notes\WC_Admin_Note::E_WC_ADMIN_NOTE_WARNING; // used for presenting warning conditions.
            break;
            case 'update':
            $message_type = \Automattic\WooCommerce\Admin\Notes\WC_Admin_Note::E_WC_ADMIN_NOTE_UPDATE; // i.e. used when a new version is available.
            break;
            case 'marketing':
            $message_type = \Automattic\WooCommerce\Admin\Notes\WC_Admin_Note::E_WC_ADMIN_NOTE_MARKETING; // used for adding marketing messages.
            break;
            case 'info':
            default:
            $message_type = \Automattic\WooCommerce\Admin\Notes\WC_Admin_Note::E_WC_ADMIN_NOTE_INFORMATIONAL; // used for presenting informational messages.
            break;
            }
            \Automattic\WooCommerce\Admin\Notes\WC_Admin_Notes_iZettle::add_activity_panel_inbox_note($id, $message, $message_type);
            }*/

            $notices = get_site_transient('izettle_notices');
            if (!$notices) {
                $notices = array();
            }
            $notice = array(
                'type' => $type,
                'valid_to' => $time === false ? false : $time,
                'messsage' => $message,
                'dismissable' => $dismiss,
            );

            $notices[$id] = $notice;

            set_site_transient('izettle_notices', $notices);

            return $id;
        }

        public static function clear($id = false)
        {

            /*    if (WC_Zettle_Helper::wc_version_check('4.0.0')) {
            require_once dirname(__FILE__) . '/izettle-admin-notes.php';
            \Automattic\WooCommerce\Admin\Notes\WC_Admin_Notes_iZettle::clear($id);
            }*/

            $notices = get_site_transient('izettle_notices');
            if ($id) {
                if (isset($notices[$id])) {
                    unset($notices[$id]);
                }
            } else {
                $notices = array();
            }
            set_site_transient('izettle_notices', $notices);
        }

        public static function display($message, $type = 'error', $dismiss = false, $id = '')
        {
            $dismissable = $dismiss ? 'is-dismissible' : '';
            $date = date_i18n(get_option('date_format') . ' ' . get_option('time_format'), date('U') + (get_option('gmt_offset') * HOUR_IN_SECONDS));
            $message = $date . ' - Zettle: ' . $message;
            echo '<div class="iz_notice ' . $dismissable . ' notice notice-' . $type . ' ' . $id . '"><p>' . $message . '</p></div>';
        }

        public function check_displaylist()
        {
            $notices = get_site_transient('izettle_notices');
            if (false !== $notices && !empty($notices)) {
                foreach ($notices as $key => $notice) {
                    self::display($notice['messsage'], $notice['type'], $notice['dismissable'], $key);
                    if ($notice['valid_to'] !== false && $notice['valid_to'] < time()) {
                        unset($notices[$key]);
                    }
                }
            }

            set_site_transient('izettle_notices', $notices);
        }

    }

    new IZ_Notice();
}
