<?php
/**
 *	Module made by Nukium
 *
 *  @author    Nukium
 *  @copyright 2021 Nukium SAS
 *  @license   All rights reserved
 *
 * ███    ██ ██    ██ ██   ██ ██ ██    ██ ███    ███
 * ████   ██ ██    ██ ██  ██  ██ ██    ██ ████  ████
 * ██ ██  ██ ██    ██ █████   ██ ██    ██ ██ ████ ██
 * ██  ██ ██ ██    ██ ██  ██  ██ ██    ██ ██  ██  ██
 * ██   ████  ██████  ██   ██ ██  ██████  ██      ██
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

function gls_enqueue_style() {

    if (is_checkout()) {
        wp_enqueue_style( 'gls-frontend-css', WC_Gls::plugin_url() . '/views/css/front.css', false, get_option( 'gls_db_version' ));
        if (get_option( 'gls_settings_gmaps_enable' ) !== 'yes') {
            wp_enqueue_style( 'gls-openstreetmap-css', 'https://unpkg.com/leaflet/dist/leaflet.css', false, get_option( 'gls_db_version' ));
        }
    }
}

function gls_enqueue_script() {

    if (is_checkout()) {
        $dependencies = array( 'jquery');
        if (get_option( 'gls_settings_gmaps_enable' ) === 'yes') {
            $dependencies[] = 'gls-googlemaps-js';
        } else {
            $dependencies[] = 'gls-openstreetmap-js';
        }

        wp_register_script( 'gls-frontend-js', WC_Gls::plugin_url() . '/views/js/front.js', $dependencies, get_option( 'gls_db_version' ), true );

        $var_js = array(
            
            'glsrelais_carrier_id' => 'gls_relais',
            'gls13h_carrier_id' => 'gls_13h',
            'glschezvousplus_carrier_id' => 'gls_chezvousplus',
            'gls_js_general_error' => __('Unexpected error occured.', 'woocommerce-gls'),
            'gls_js_search_error' => __('Please fill-in a <strong>valid postcode</strong>.', 'woocommerce-gls'),
            'ajaxurl' => wp_nonce_url(admin_url( 'admin-ajax.php' ) , 'gls-ajax-request' ),
            'google_maps_enable' => (bool)(get_option( 'gls_settings_gmaps_enable' ) === 'yes'),
            'gls_marker_path' => esc_url(WC_Gls::plugin_url() . '/views/img/front/'),
        );

        wp_localize_script( 'gls-frontend-js', 'gls_var', $var_js );
        wp_enqueue_script( 'gls-googlemaps-js', 'https://maps.googleapis.com/maps/api/js?key='.get_option('gls_settings_gmaps_api_key') );
        wp_enqueue_script( 'gls-openstreetmap-js', 'https://unpkg.com/leaflet/dist/leaflet.js' );
        wp_enqueue_script( 'gls-frontend-js' );
    }
}



function add_js_async_attribute( $tag, $handle ) {
	if ( 'gls-googlemaps-js' !== $handle ) {
		return $tag;
	}

	return preg_replace( '/^<script /i', '<script async ', $tag );
}


function add_js_defer_attribute( $tag, $handle ) {
	if ( 'gls-googlemaps-js' !== $handle ) {
		return $tag;
	}

	return preg_replace( '/^<script /i', '<script defer ', $tag );
}

add_action( 'wp_ajax_gls_search_relay', 'displayAjaxSearchRelay' );
add_action( 'wp_ajax_nopriv_gls_search_relay', 'displayAjaxSearchRelay' );



function displayAjaxSearchRelay()
{
	
	$shipping_settings = get_option( 'woocommerce_gls_relais_settings' );
	$return = array('result' => false, 'message' => '', 'point_relay_tpl' => '', 'point_relay_maps' => array());

	$postcode='';
	$city='';

	
	$search_tmp = explode(' ', $_POST['search']);
	foreach ($search_tmp as $value) {
		if (is_numeric($value) && strlen($value) === 5) {
			
			$postcode = $value;
		} else {
			
			$city .= $value;
		}
	}

	if (!empty($postcode)) {

		
		$gls = new GlsController(array(
			'GLS_WSLOGIN' => get_option( 'gls_settings_wslogin' ),
			'GLS_WSPWD' => get_option( 'gls_settings_wspwd' ),
		));

		
		$result = $gls->searchRelay('FR', $postcode, $city);

		if (isset($result->exitCode->ErrorCode)) {

			if ((int)$result->exitCode->ErrorCode == 998 || (int)$result->exitCode->ErrorCode == 999) {

				
				$return['message'] = __('We haven\'t found any GLS Relais in your delivery area. Please expand your search.', 'woocommerce-gls');

			} elseif ((int)$result->exitCode->ErrorCode == 0) {

				$relay_points = $result->SearchResults;

				
				if($shipping_settings['GLS_GLSRELAIS_XL_ONLY'] == 'yes') {
					foreach ($relay_points as $key => $value) {
						if (!empty($value->Parcelshop->Address->Name1) && substr($value->Parcelshop->Address->Name1, -2)  != 'XL') {
							unset($relay_points[$key]);
						}
					}
					$relay_points = array_values($relay_points);
				}

				if (count($relay_points) <= 0) {
					$return['message'] = __('We haven\'t found any GLS Relais in your delivery area. Please expand your search.', 'woocommerce-gls');
				} else {
					$args = array(
						'trans_days' => array(
							'0' => __('Monday', 'woocommerce-gls'),
							'1' => __('Tuesday', 'woocommerce-gls'),
							'2' => __('Wednesday', 'woocommerce-gls'),
							'3' => __('Thursday', 'woocommerce-gls'),
							'4' => __('Friday', 'woocommerce-gls'),
							'5' => __('Saturday', 'woocommerce-gls'),
							'6' => __('Sunday', 'woocommerce-gls')),
						'relay_points' => $relay_points,
						'only_xl' => (bool)($shipping_settings['GLS_GLSRELAIS_XL_ONLY'] == 'yes'),
					);

                    if( isset( $_POST['from_admin_order'] ) && (int)$_POST['from_admin_order'] === 1) {
                        $return['point_relay_tpl'] = Nukium::load_view( 'admin/search-result', $args, true );
                    } else {
					$return['point_relay_tpl'] = Nukium::load_view( 'front/search-result', $args, true );
                    }

					$return['result'] = true;
				}

			} else {
				$return['message'] = $result->exitCode->ErrorCode.': '.$result->exitCode->ErrorDscr;
			}

		} else {
			$return['message'] = __('Unexpected error occured while searching GLS Relais.', 'woocommerce-gls');
		}
	} else {
		$return['message'] = __('Please fill in a valid postcode.', 'woocommerce-gls');
	}

	header('Content-Type: application/json');
	wp_die(
		wp_json_encode($return)
	);
}

add_action( 'wp_ajax_gls_save_mobile', 'displayAjaxSavePhoneMobile' );
add_action( 'wp_ajax_nopriv_gls_save_mobile', 'displayAjaxSavePhoneMobile' );



function displayAjaxSavePhoneMobile()
{
	check_ajax_referer( 'gls-ajax-request' );

	global $woocommerce, $wpdb;

	$return = array('result' => false, 'message' => '');

	$id_customer = $woocommerce->session->get_session_cookie()[0];
	$id_carrier = $woocommerce->session->chosen_shipping_methods[0];
	$id_session = $woocommerce->session->get_session_cookie()[3];
	$customer_country_iso = $woocommerce->customer->get_shipping_country();

	$phone_mobile = $_POST['gls_customer_mobile'];
	$is_relay = $_POST['is_relay'];

	
	$gls_product = WC_Gls::get_gls_product($id_carrier, $customer_country_iso);

	$query_row = $wpdb->get_row("SELECT * FROM {$wpdb->prefix}woocommerce_gls_cart_carrier WHERE customer_id = '".$id_customer.'\' AND session_id = \''.$id_session.'\' AND order_id=0');

	if($query_row !== null) {

		$sql = "UPDATE {$wpdb->prefix}woocommerce_gls_cart_carrier SET customer_phone_mobile='%s', shipping_method_id='%s', gls_product='%s'";
		
		if (!$is_relay) {
			$sql .= ',parcel_shop_id = NULL, name = NULL, address1 = NULL, address2 = NULL, postcode = NULL,
                    city = NULL, phone = NULL, phone_mobile = NULL, country = NULL, parcel_shop_working_day = NULL';
		}
		$sql .= " WHERE id='%d'";

		$query = $wpdb->query( $wpdb->prepare( $sql , $phone_mobile, $id_carrier, $gls_product, $query_row->id) );
 		if($query !== false) {
			$return['result'] = true;
		} else {
			$return['message'] = __('Unexpected error occurred.', 'woocommerce-gls');
		}

	} else {

		$sql = "INSERT INTO {$wpdb->prefix}woocommerce_gls_cart_carrier (customer_id, session_id, shipping_method_id, gls_product, customer_phone_mobile) VALUES ('%s', '%s', '%s', '%s', '%s')";
		$query = $wpdb->query( $wpdb->prepare( $sql , $id_customer, $id_session, $id_carrier, $gls_product, $phone_mobile) );

		if($query) {
                $return['result'] = true;
		} else {
			$return['message'] = __('Unexpected error occurred.', 'woocommerce-gls');
		}
	}

	header('Content-Type: application/json');
	wp_die(
		wp_json_encode($return)
	);
}

add_action( 'wp_ajax_gls_select_relay', 'displayAjaxSelectRelayPoint' );
add_action( 'wp_ajax_nopriv_gls_select_relay', 'displayAjaxSelectRelayPoint' );



function displayAjaxSelectRelayPoint()
{
	global $woocommerce, $wpdb;

	$id_customer = $woocommerce->session->get_session_cookie()[0];
	$id_carrier = $woocommerce->session->chosen_shipping_methods[0];
	$id_session = $woocommerce->session->get_session_cookie()[3];

	

	$return = array('result' => false, 'message' => '');

	$gls_relay_id = $_POST['glsrelayid'];

	
	$gls = new GlsController(array(
		'GLS_WSLOGIN' => get_option( 'gls_settings_wslogin' ),
		'GLS_WSPWD' => get_option( 'gls_settings_wspwd' ),
	));
	$relay_detail = $gls->getRelayDetail($gls_relay_id);

	
	if ($relay_detail) {

		
		$gls_product = WC_Gls::get_gls_product($id_carrier, $relay_detail['Country']);

		
		$wpdb->query( $wpdb->prepare( "DELETE FROM {$wpdb->prefix}woocommerce_gls_cart_carrier WHERE session_id = %s AND customer_id = %s AND order_id=0" , $id_session, $id_customer ) );
		
		$query = $wpdb->query( $wpdb->prepare(
			"
			INSERT INTO {$wpdb->prefix}woocommerce_gls_cart_carrier
			(`session_id`, `customer_id`, `order_id`, `shipping_method_id`, `gls_product`, `parcel_shop_id`, `name`, `address1`, `address2`, `postcode`, `city`, `phone`, `phone_mobile`, `customer_phone_mobile`, `country`, `parcel_shop_working_day`)
			VALUES ('%s', '%s', 0, '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s')
			",
			$id_session,
            $id_customer,
			$id_carrier,
			$gls_product,
			$_POST['glsrelayid'],
			$relay_detail['Name1'],
			$relay_detail['Street1'],
			$relay_detail['Street2'],
			$relay_detail['ZipCode'],
			$relay_detail['City'],
			$relay_detail['Phone'],
			$relay_detail['Mobile'],
			$_POST['gls_customer_mobile'],
			$relay_detail['Country'],
			json_encode($relay_detail['GLSWorkingDay'])
		) );

		if (!$query) {
			$return['message'] = __('Unexpected error occurred while saving delivery informations.', 'woocommerce-gls');
		} else {
			$return['result'] = true;
		}

	} else {
		$return['message'] = __('GLS Relais informations not found. Please select another one.', 'woocommerce-gls');
	}

	header('Content-Type: application/json');
	wp_die(
		wp_json_encode($return)
	);
}

add_action('woocommerce_checkout_process', 'gls_prevent_checkout_submission'); 

function gls_prevent_checkout_submission() {

	if ( isset($_POST['gls_mobile_required']) ) {

		wc_add_notice( __( 'Please fill-in a valid <strong>mobile number</strong> (e.g. +XXXXXXXXXXX or 0XXXXXXXXX) for your GLS shipping.', 'woocommerce-gls' ), 'error');

	}

	if ( isset($_POST['gls_relay_required']) ) {

		wc_add_notice( __( 'Please select a <strong>GLS Relais</strong> on the list.', 'woocommerce-gls' ), 'error');

	}

}

add_action('woocommerce_checkout_order_processed' , 'gls_checkout_process', 10, 3);



function gls_checkout_process($order_id, $posted_data, $order) {

    global $woocommerce, $wpdb;

    
    $id_customer = $woocommerce->session->get_session_cookie()[0];
	$id_carrier = $woocommerce->session->chosen_shipping_methods[0];
    $id_session = $woocommerce->session->get_session_cookie()[3];

    
    if (array_key_exists($id_carrier, WC_Gls::$carrier_definition)) {

        if(!$order || !is_object($order)) {
            $order = wc_get_order( $order_id );
        }

        if ($order) {
            $insert_default = false;

            $query_row = $wpdb->get_row("SELECT * FROM {$wpdb->prefix}woocommerce_gls_cart_carrier WHERE customer_id = '".$id_customer.'\' AND session_id = \''.$id_session.'\' AND order_id=0');
            if($query_row !== null) {

				if ($id_carrier != $query_row->shipping_method_id) {
                    $wpdb->query( $wpdb->prepare( "DELETE FROM {$wpdb->prefix}woocommerce_gls_cart_carrier WHERE session_id = %s AND customer_id = %s AND order_id=0" , $id_session, $id_customer ) );
                    $insert_default = true;
				} else {
					
					if ($id_carrier == 'gls_relais') {
						$order->set_shipping_company($query_row->name);
						$order->set_shipping_address_1($query_row->address1);
						$order->set_shipping_address_2($query_row->address2);
						$order->set_shipping_city($query_row->city);
						$order->set_shipping_state('');
						$order->set_shipping_postcode($query_row->postcode);
						$order->set_shipping_country($query_row->country);
						$order->save();
					}

					$query = $wpdb->query( $wpdb->prepare( "
						UPDATE {$wpdb->prefix}woocommerce_gls_cart_carrier
						SET customer_id='%s', order_id='%d'
						WHERE id='%d'
						" , $order->get_customer_id(), $order_id, $query_row->id) );

					if($query === false) {
						wc_add_notice( __( 'Error on saving GLS information on the order', 'woocommerce-gls' ), 'error');
					}
				}

            } else {
                $insert_default = true;
            }

            if ($insert_default) {
                $gls_product = WC_Gls::get_gls_product($id_carrier, $order->get_shipping_country());

                $sql = "INSERT INTO {$wpdb->prefix}woocommerce_gls_cart_carrier (customer_id, session_id, shipping_method_id, gls_product, order_id) VALUES ('%s', '%s', '%s', '%s', '%d')";
                $query = $wpdb->query( $wpdb->prepare( $sql , $order->get_customer_id(), $id_session, $id_carrier, $gls_product, $order_id) );

                if($query === false) {
                    wc_add_notice( __( 'Unexpected error occurred', 'woocommerce-gls' ), 'error');

                }
            }

        } else {
            wc_add_notice( __( 'Unexpected error occurred', 'woocommerce-gls' ), 'error');
        }

    }

}
