(()=>{"use strict";var __webpack_modules__={536:(__unused_webpack_module,__unused_webpack___webpack_exports__,__webpack_require__)=>{eval("\n;// CONCATENATED MODULE: ./resources/js/modules/ErrorHandler.js\nclass ErrorHandler {\n  constructor(genericErrorText) {\n    this.genericErrorText = genericErrorText;\n    this.wrapper = document.querySelector('.woocommerce-notices-wrapper');\n    this.messagesList = document.querySelector('ul.woocommerce-error');\n  }\n\n  genericError() {\n    if (this.wrapper.classList.contains('ppcp-persist')) {\n      return;\n    }\n\n    this.clear();\n    this.message(this.genericErrorText);\n  }\n\n  appendPreparedErrorMessageElement(errorMessageElement) {\n    if (this.messagesList === null) {\n      this.prepareMessagesList();\n    }\n\n    this.messagesList.replaceWith(errorMessageElement);\n  }\n\n  message(text, persist = false) {\n    if (!typeof String || text.length === 0) {\n      throw new Error('A new message text must be a non-empty string.');\n    }\n\n    if (this.messagesList === null) {\n      this.prepareMessagesList();\n    }\n\n    if (persist) {\n      this.wrapper.classList.add('ppcp-persist');\n    } else {\n      this.wrapper.classList.remove('ppcp-persist');\n    }\n\n    let messageNode = this.prepareMessagesListItem(text);\n    this.messagesList.appendChild(messageNode);\n    jQuery.scroll_to_notices(jQuery('.woocommerce-notices-wrapper'));\n  }\n\n  prepareMessagesList() {\n    if (this.messagesList === null) {\n      this.messagesList = document.createElement('ul');\n      this.messagesList.setAttribute('class', 'woocommerce-error');\n      this.messagesList.setAttribute('role', 'alert');\n      this.wrapper.appendChild(this.messagesList);\n    }\n  }\n\n  prepareMessagesListItem(message) {\n    const li = document.createElement('li');\n    li.innerHTML = message;\n    return li;\n  }\n\n  sanitize(text) {\n    const textarea = document.createElement('textarea');\n    textarea.innerHTML = text;\n    return textarea.value.replace('Error: ', '');\n  }\n\n  clear() {\n    if (this.messagesList === null) {\n      return;\n    }\n\n    this.messagesList.innerHTML = '';\n  }\n\n}\n\n/* harmony default export */ const modules_ErrorHandler = (ErrorHandler);\n;// CONCATENATED MODULE: ./resources/js/modules/OnApproveHandler/onApproveForContinue.js\nconst onApprove = (context, errorHandler) => {\n  return (data, actions) => {\n    return fetch(context.config.ajax.approve_order.endpoint, {\n      method: 'POST',\n      body: JSON.stringify({\n        nonce: context.config.ajax.approve_order.nonce,\n        order_id: data.orderID,\n        funding_source: window.ppcpFundingSource\n      })\n    }).then(res => {\n      return res.json();\n    }).then(data => {\n      if (!data.success) {\n        errorHandler.genericError();\n        return actions.restart().catch(err => {\n          errorHandler.genericError();\n        });\n      }\n\n      location.href = context.config.redirect;\n    });\n  };\n};\n\n/* harmony default export */ const onApproveForContinue = (onApprove);\n;// CONCATENATED MODULE: ./resources/js/modules/Helper/PayerData.js\nconst payerData = () => {\n  const payer = PayPalCommerceGateway.payer;\n\n  if (!payer) {\n    return null;\n  }\n\n  const phone = document.querySelector('#billing_phone') || typeof payer.phone !== 'undefined' ? {\n    phone_type: \"HOME\",\n    phone_number: {\n      national_number: document.querySelector('#billing_phone') ? document.querySelector('#billing_phone').value : payer.phone.phone_number.national_number\n    }\n  } : null;\n  const payerData = {\n    email_address: document.querySelector('#billing_email') ? document.querySelector('#billing_email').value : payer.email_address,\n    name: {\n      surname: document.querySelector('#billing_last_name') ? document.querySelector('#billing_last_name').value : payer.name.surname,\n      given_name: document.querySelector('#billing_first_name') ? document.querySelector('#billing_first_name').value : payer.name.given_name\n    },\n    address: {\n      country_code: document.querySelector('#billing_country') ? document.querySelector('#billing_country').value : payer.address.country_code,\n      address_line_1: document.querySelector('#billing_address_1') ? document.querySelector('#billing_address_1').value : payer.address.address_line_1,\n      address_line_2: document.querySelector('#billing_address_2') ? document.querySelector('#billing_address_2').value : payer.address.address_line_2,\n      admin_area_1: document.querySelector('#billing_state') ? document.querySelector('#billing_state').value : payer.address.admin_area_1,\n      admin_area_2: document.querySelector('#billing_city') ? document.querySelector('#billing_city').value : payer.address.admin_area_2,\n      postal_code: document.querySelector('#billing_postcode') ? document.querySelector('#billing_postcode').value : payer.address.postal_code\n    }\n  };\n\n  if (phone) {\n    payerData.phone = phone;\n  }\n\n  return payerData;\n};\n;// CONCATENATED MODULE: ./resources/js/modules/Helper/CheckoutMethodState.js\nconst PaymentMethods = {\n  PAYPAL: 'ppcp-gateway',\n  CARDS: 'ppcp-credit-card-gateway',\n  OXXO: 'ppcp-oxxo-gateway',\n  CARD_BUTTON: 'ppcp-card-button-gateway'\n};\nconst ORDER_BUTTON_SELECTOR = '#place_order';\nconst getCurrentPaymentMethod = () => {\n  const el = document.querySelector('input[name=\"payment_method\"]:checked');\n\n  if (!el) {\n    return null;\n  }\n\n  return el.value;\n};\nconst isSavedCardSelected = () => {\n  const savedCardList = document.querySelector('#saved-credit-card');\n  return savedCardList && savedCardList.value !== '';\n};\n;// CONCATENATED MODULE: ./resources/js/modules/ActionHandler/CartActionHandler.js\n\n\n\n\nclass CartActionHandler {\n  constructor(config, errorHandler) {\n    this.config = config;\n    this.errorHandler = errorHandler;\n  }\n\n  configuration() {\n    const createOrder = (data, actions) => {\n      const payer = payerData();\n      const bnCode = typeof this.config.bn_codes[this.config.context] !== 'undefined' ? this.config.bn_codes[this.config.context] : '';\n      return fetch(this.config.ajax.create_order.endpoint, {\n        method: 'POST',\n        body: JSON.stringify({\n          nonce: this.config.ajax.create_order.nonce,\n          purchase_units: [],\n          payment_method: PaymentMethods.PAYPAL,\n          funding_source: window.ppcpFundingSource,\n          bn_code: bnCode,\n          payer,\n          context: this.config.context\n        })\n      }).then(function (res) {\n        return res.json();\n      }).then(function (data) {\n        if (!data.success) {\n          console.error(data);\n          throw Error(data.data.message);\n        }\n\n        return data.data.id;\n      });\n    };\n\n    return {\n      createOrder,\n      onApprove: onApproveForContinue(this, this.errorHandler),\n      onError: error => {\n        this.errorHandler.genericError();\n      }\n    };\n  }\n\n}\n\n/* harmony default export */ const ActionHandler_CartActionHandler = (CartActionHandler);\n;// CONCATENATED MODULE: ./resources/js/modules/ContextBootstrap/MiniCartBootstap.js\n\n\n\nclass MiniCartBootstap {\n  constructor(gateway, renderer) {\n    this.gateway = gateway;\n    this.renderer = renderer;\n    this.actionHandler = null;\n  }\n\n  init() {\n    this.actionHandler = new ActionHandler_CartActionHandler(PayPalCommerceGateway, new modules_ErrorHandler(this.gateway.labels.error.generic));\n    this.render();\n    jQuery(document.body).on('wc_fragments_loaded wc_fragments_refreshed', () => {\n      this.render();\n    });\n  }\n\n  shouldRender() {\n    return document.querySelector(this.gateway.button.mini_cart_wrapper) !== null || document.querySelector(this.gateway.hosted_fields.mini_cart_wrapper) !== null;\n  }\n\n  render() {\n    if (!this.shouldRender()) {\n      return;\n    }\n\n    this.renderer.render(this.actionHandler.configuration(), {\n      button: {\n        wrapper: this.gateway.button.mini_cart_wrapper,\n        style: this.gateway.button.mini_cart_style\n      }\n    });\n  }\n\n}\n\n/* harmony default export */ const ContextBootstrap_MiniCartBootstap = (MiniCartBootstap);\n;// CONCATENATED MODULE: ./resources/js/modules/Helper/UpdateCart.js\n\n\nclass UpdateCart {\n  constructor(endpoint, nonce) {\n    this.endpoint = endpoint;\n    this.nonce = nonce;\n  }\n  /**\n   *\n   * @param onResolve\n   * @param {Product[]} products\n   * @returns {Promise<unknown>}\n   */\n\n\n  update(onResolve, products) {\n    return new Promise((resolve, reject) => {\n      fetch(this.endpoint, {\n        method: 'POST',\n        body: JSON.stringify({\n          nonce: this.nonce,\n          products\n        })\n      }).then(result => {\n        return result.json();\n      }).then(result => {\n        if (!result.success) {\n          reject(result.data);\n          return;\n        }\n\n        const resolved = onResolve(result.data);\n        resolve(resolved);\n      });\n    });\n  }\n\n}\n\n/* harmony default export */ const Helper_UpdateCart = (UpdateCart);\n;// CONCATENATED MODULE: ./resources/js/modules/Helper/ButtonsToggleListener.js\n/**\n * When you can't add something to the cart, the PayPal buttons should not show.\n * Therefore we listen for changes on the add to cart button and show/hide the buttons accordingly.\n */\nclass ButtonsToggleListener {\n  constructor(element, showCallback, hideCallback) {\n    this.element = element;\n    this.showCallback = showCallback;\n    this.hideCallback = hideCallback;\n    this.observer = null;\n  }\n\n  init() {\n    const config = {\n      attributes: true\n    };\n\n    const callback = () => {\n      if (this.element.classList.contains('disabled')) {\n        this.hideCallback();\n        return;\n      }\n\n      this.showCallback();\n    };\n\n    this.observer = new MutationObserver(callback);\n    this.observer.observe(this.element, config);\n    callback();\n  }\n\n  disconnect() {\n    this.observer.disconnect();\n  }\n\n}\n\n/* harmony default export */ const Helper_ButtonsToggleListener = (ButtonsToggleListener);\n;// CONCATENATED MODULE: ./resources/js/modules/Entity/Product.js\nclass Product {\n  constructor(id, quantity, variations) {\n    this.id = id;\n    this.quantity = quantity;\n    this.variations = variations;\n  }\n\n  data() {\n    return {\n      id: this.id,\n      quantity: this.quantity,\n      variations: this.variations\n    };\n  }\n\n}\n\n/* harmony default export */ const Entity_Product = (Product);\n;// CONCATENATED MODULE: ./resources/js/modules/ActionHandler/SingleProductActionHandler.js\n\n\n\n\n\n\nclass SingleProductActionHandler {\n  constructor(config, updateCart, showButtonCallback, hideButtonCallback, formElement, errorHandler) {\n    this.config = config;\n    this.updateCart = updateCart;\n    this.showButtonCallback = showButtonCallback;\n    this.hideButtonCallback = hideButtonCallback;\n    this.formElement = formElement;\n    this.errorHandler = errorHandler;\n  }\n\n  configuration() {\n    if (this.hasVariations()) {\n      const observer = new Helper_ButtonsToggleListener(this.formElement.querySelector('.single_add_to_cart_button'), this.showButtonCallback, this.hideButtonCallback);\n      observer.init();\n    }\n\n    return {\n      createOrder: this.createOrder(),\n      onApprove: onApproveForContinue(this, this.errorHandler),\n      onError: error => {\n        this.errorHandler.genericError();\n      }\n    };\n  }\n\n  createOrder() {\n    var getProducts = null;\n\n    if (!this.isGroupedProduct()) {\n      getProducts = () => {\n        const id = document.querySelector('[name=\"add-to-cart\"]').value;\n        const qty = document.querySelector('[name=\"quantity\"]').value;\n        const variations = this.variations();\n        return [new Entity_Product(id, qty, variations)];\n      };\n    } else {\n      getProducts = () => {\n        const products = [];\n        this.formElement.querySelectorAll('input[type=\"number\"]').forEach(element => {\n          if (!element.value) {\n            return;\n          }\n\n          const elementName = element.getAttribute('name').match(/quantity\\[([\\d]*)\\]/);\n\n          if (elementName.length !== 2) {\n            return;\n          }\n\n          const id = parseInt(elementName[1]);\n          const quantity = parseInt(element.value);\n          products.push(new Entity_Product(id, quantity, null));\n        });\n        return products;\n      };\n    }\n\n    const createOrder = (data, actions) => {\n      this.errorHandler.clear();\n\n      const onResolve = purchase_units => {\n        const payer = payerData();\n        const bnCode = typeof this.config.bn_codes[this.config.context] !== 'undefined' ? this.config.bn_codes[this.config.context] : '';\n        return fetch(this.config.ajax.create_order.endpoint, {\n          method: 'POST',\n          body: JSON.stringify({\n            nonce: this.config.ajax.create_order.nonce,\n            purchase_units,\n            payer,\n            bn_code: bnCode,\n            payment_method: PaymentMethods.PAYPAL,\n            funding_source: window.ppcpFundingSource,\n            context: this.config.context\n          })\n        }).then(function (res) {\n          return res.json();\n        }).then(function (data) {\n          if (!data.success) {\n            console.error(data);\n            throw Error(data.data.message);\n          }\n\n          return data.data.id;\n        });\n      };\n\n      const promise = this.updateCart.update(onResolve, getProducts());\n      return promise;\n    };\n\n    return createOrder;\n  }\n\n  variations() {\n    if (!this.hasVariations()) {\n      return null;\n    }\n\n    const attributes = [...this.formElement.querySelectorAll(\"[name^='attribute_']\")].map(element => {\n      return {\n        value: element.value,\n        name: element.name\n      };\n    });\n    return attributes;\n  }\n\n  hasVariations() {\n    return this.formElement.classList.contains('variations_form');\n  }\n\n  isGroupedProduct() {\n    return this.formElement.classList.contains('grouped_form');\n  }\n\n}\n\n/* harmony default export */ const ActionHandler_SingleProductActionHandler = (SingleProductActionHandler);\n;// CONCATENATED MODULE: ./resources/js/modules/ContextBootstrap/SingleProductBootstap.js\n\n\n\n\nclass SingleProductBootstap {\n  constructor(gateway, renderer, messages) {\n    this.gateway = gateway;\n    this.renderer = renderer;\n    this.messages = messages;\n  }\n\n  handleChange() {\n    if (!this.shouldRender()) {\n      this.renderer.hideButtons(this.gateway.hosted_fields.wrapper);\n      this.renderer.hideButtons(this.gateway.button.wrapper);\n      this.messages.hideMessages();\n      return;\n    }\n\n    this.render();\n  }\n\n  init() {\n    document.querySelector('form.cart').addEventListener('change', this.handleChange.bind(this));\n\n    if (!this.shouldRender()) {\n      this.renderer.hideButtons(this.gateway.hosted_fields.wrapper);\n      this.messages.hideMessages();\n      return;\n    }\n\n    this.render();\n  }\n\n  shouldRender() {\n    return document.querySelector('form.cart') !== null && !this.priceAmountIsZero();\n  }\n\n  priceAmount() {\n    let priceText = \"0\";\n\n    if (document.querySelector('form.cart ins .woocommerce-Price-amount')) {\n      priceText = document.querySelector('form.cart ins .woocommerce-Price-amount').innerText;\n    } else if (document.querySelector('form.cart .woocommerce-Price-amount')) {\n      priceText = document.querySelector('form.cart .woocommerce-Price-amount').innerText;\n    } else if (document.querySelector('.product .woocommerce-Price-amount')) {\n      priceText = document.querySelector('.product .woocommerce-Price-amount').innerText;\n    }\n\n    priceText = priceText.replace(/,/g, '.');\n    return parseFloat(priceText.replace(/([^\\d,\\.\\s]*)/g, ''));\n  }\n\n  priceAmountIsZero() {\n    return this.priceAmount() === 0;\n  }\n\n  render() {\n    const actionHandler = new ActionHandler_SingleProductActionHandler(this.gateway, new Helper_UpdateCart(this.gateway.ajax.change_cart.endpoint, this.gateway.ajax.change_cart.nonce), () => {\n      this.renderer.showButtons(this.gateway.button.wrapper);\n      this.renderer.showButtons(this.gateway.hosted_fields.wrapper);\n      this.messages.renderWithAmount(this.priceAmount());\n    }, () => {\n      this.renderer.hideButtons(this.gateway.button.wrapper);\n      this.renderer.hideButtons(this.gateway.hosted_fields.wrapper);\n      this.messages.hideMessages();\n    }, document.querySelector('form.cart'), new modules_ErrorHandler(this.gateway.labels.error.generic));\n    this.renderer.render(actionHandler.configuration());\n  }\n\n}\n\n/* harmony default export */ const ContextBootstrap_SingleProductBootstap = (SingleProductBootstap);\n;// CONCATENATED MODULE: ./resources/js/modules/ContextBootstrap/CartBootstap.js\n\n\n\nclass CartBootstrap {\n  constructor(gateway, renderer) {\n    this.gateway = gateway;\n    this.renderer = renderer;\n  }\n\n  init() {\n    if (!this.shouldRender()) {\n      return;\n    }\n\n    this.render();\n    jQuery(document.body).on('updated_cart_totals updated_checkout', () => {\n      this.render();\n    });\n  }\n\n  shouldRender() {\n    return document.querySelector(this.gateway.button.wrapper) !== null || document.querySelector(this.gateway.hosted_fields.wrapper) !== null;\n  }\n\n  render() {\n    const actionHandler = new ActionHandler_CartActionHandler(PayPalCommerceGateway, new modules_ErrorHandler(this.gateway.labels.error.generic));\n    this.renderer.render(actionHandler.configuration());\n  }\n\n}\n\n/* harmony default export */ const CartBootstap = (CartBootstrap);\n;// CONCATENATED MODULE: ./resources/js/modules/OnApproveHandler/onApproveForPayNow.js\nconst onApproveForPayNow_onApprove = (context, errorHandler, spinner) => {\n  return (data, actions) => {\n    spinner.block();\n    errorHandler.clear();\n    return fetch(context.config.ajax.approve_order.endpoint, {\n      method: 'POST',\n      body: JSON.stringify({\n        nonce: context.config.ajax.approve_order.nonce,\n        order_id: data.orderID,\n        funding_source: window.ppcpFundingSource\n      })\n    }).then(res => {\n      return res.json();\n    }).then(data => {\n      spinner.unblock();\n\n      if (!data.success) {\n        if (data.data.code === 100) {\n          errorHandler.message(data.data.message);\n        } else {\n          errorHandler.genericError();\n        }\n\n        if (typeof actions !== 'undefined' && typeof actions.restart !== 'undefined') {\n          return actions.restart();\n        }\n\n        throw new Error(data.data.message);\n      }\n\n      document.querySelector('#place_order').click();\n    });\n  };\n};\n\n/* harmony default export */ const onApproveForPayNow = (onApproveForPayNow_onApprove);\n;// CONCATENATED MODULE: ./resources/js/modules/ActionHandler/CheckoutActionHandler.js\n\n\n\n\nclass CheckoutActionHandler {\n  constructor(config, errorHandler, spinner) {\n    this.config = config;\n    this.errorHandler = errorHandler;\n    this.spinner = spinner;\n  }\n\n  configuration() {\n    const spinner = this.spinner;\n\n    const createOrder = (data, actions) => {\n      const payer = payerData();\n      const bnCode = typeof this.config.bn_codes[this.config.context] !== 'undefined' ? this.config.bn_codes[this.config.context] : '';\n      const errorHandler = this.errorHandler;\n      const formSelector = this.config.context === 'checkout' ? 'form.checkout' : 'form#order_review';\n      const formData = new FormData(document.querySelector(formSelector)); // will not handle fields with multiple values (checkboxes, <select multiple>), but we do not care about this here\n\n      const formJsonObj = Object.fromEntries(formData);\n      const createaccount = jQuery('#createaccount').is(\":checked\") ? true : false;\n      const paymentMethod = getCurrentPaymentMethod();\n      const fundingSource = window.ppcpFundingSource;\n      return fetch(this.config.ajax.create_order.endpoint, {\n        method: 'POST',\n        body: JSON.stringify({\n          nonce: this.config.ajax.create_order.nonce,\n          payer,\n          bn_code: bnCode,\n          context: this.config.context,\n          order_id: this.config.order_id,\n          payment_method: paymentMethod,\n          funding_source: fundingSource,\n          form: formJsonObj,\n          createaccount: createaccount\n        })\n      }).then(function (res) {\n        return res.json();\n      }).then(function (data) {\n        if (!data.success) {\n          spinner.unblock(); //handle both messages sent from Woocommerce (data.messages) and this plugin (data.data.message)\n\n          if (typeof data.messages !== 'undefined') {\n            const domParser = new DOMParser();\n            errorHandler.appendPreparedErrorMessageElement(domParser.parseFromString(data.messages, 'text/html').querySelector('ul'));\n          } else {\n            errorHandler.clear();\n\n            if (data.data.details.length > 0) {\n              errorHandler.message(data.data.details.map(d => `${d.issue} ${d.description}`).join('<br/>'), true);\n            } else {\n              errorHandler.message(data.data.message, true);\n            }\n          }\n\n          throw new Error(data.data.message);\n        }\n\n        const input = document.createElement('input');\n        input.setAttribute('type', 'hidden');\n        input.setAttribute('name', 'ppcp-resume-order');\n        input.setAttribute('value', data.data.purchase_units[0].custom_id);\n        document.querySelector(formSelector).append(input);\n        return data.data.id;\n      });\n    };\n\n    return {\n      createOrder,\n      onApprove: onApproveForPayNow(this, this.errorHandler, this.spinner),\n      onCancel: () => {\n        spinner.unblock();\n      },\n      onError: () => {\n        this.errorHandler.genericError();\n        spinner.unblock();\n      }\n    };\n  }\n\n}\n\n/* harmony default export */ const ActionHandler_CheckoutActionHandler = (CheckoutActionHandler);\n;// CONCATENATED MODULE: ./resources/js/modules/Helper/Hiding.js\nconst getElement = selectorOrElement => {\n  if (typeof selectorOrElement === 'string') {\n    return document.querySelector(selectorOrElement);\n  }\n\n  return selectorOrElement;\n};\n\nconst isVisible = element => {\n  return !!(element.offsetWidth || element.offsetHeight || element.getClientRects().length);\n};\nconst setVisible = (selectorOrElement, show, important = false) => {\n  const element = getElement(selectorOrElement);\n\n  if (!element) {\n    return;\n  }\n\n  const currentValue = element.style.getPropertyValue('display');\n\n  if (!show) {\n    if (currentValue === 'none') {\n      return;\n    }\n\n    element.style.setProperty('display', 'none', important ? 'important' : '');\n  } else {\n    if (currentValue === 'none') {\n      element.style.removeProperty('display');\n    } // still not visible (if something else added display: none in CSS)\n\n\n    if (!isVisible(element)) {\n      element.style.setProperty('display', 'block');\n    }\n  }\n};\nconst hide = (selectorOrElement, important = false) => {\n  setVisible(selectorOrElement, false, important);\n};\nconst show = selectorOrElement => {\n  setVisible(selectorOrElement, true);\n};\n;// CONCATENATED MODULE: ./resources/js/modules/ContextBootstrap/CheckoutBootstap.js\n\n\n\n\n\nclass CheckoutBootstap {\n  constructor(gateway, renderer, messages, spinner) {\n    this.gateway = gateway;\n    this.renderer = renderer;\n    this.messages = messages;\n    this.spinner = spinner;\n    this.standardOrderButtonSelector = ORDER_BUTTON_SELECTOR;\n    this.buttonChangeObserver = new MutationObserver(el => {\n      this.updateUi();\n    });\n  }\n\n  init() {\n    this.render(); // Unselect saved card.\n    // WC saves form values, so with our current UI it would be a bit weird\n    // if the user paid with saved, then after some time tries to pay again,\n    // but wants to enter a new card, and to do that they have to choose “Select payment” in the list.\n\n    jQuery('#saved-credit-card').val(jQuery('#saved-credit-card option:first').val());\n    jQuery(document.body).on('updated_checkout', () => {\n      this.render();\n    });\n    jQuery(document.body).on('updated_checkout payment_method_selected', () => {\n      this.updateUi();\n    });\n    jQuery(document).on('hosted_fields_loaded', () => {\n      jQuery('#saved-credit-card').on('change', () => {\n        this.updateUi();\n      });\n    });\n    this.updateUi();\n  }\n\n  shouldRender() {\n    if (document.querySelector(this.gateway.button.cancel_wrapper)) {\n      return false;\n    }\n\n    return document.querySelector(this.gateway.button.wrapper) !== null || document.querySelector(this.gateway.hosted_fields.wrapper) !== null;\n  }\n\n  render() {\n    if (!this.shouldRender()) {\n      return;\n    }\n\n    if (document.querySelector(this.gateway.hosted_fields.wrapper + '>div')) {\n      document.querySelector(this.gateway.hosted_fields.wrapper + '>div').setAttribute('style', '');\n    }\n\n    const actionHandler = new ActionHandler_CheckoutActionHandler(PayPalCommerceGateway, new modules_ErrorHandler(this.gateway.labels.error.generic), this.spinner);\n    this.renderer.render(actionHandler.configuration());\n    this.buttonChangeObserver.observe(document.querySelector(this.standardOrderButtonSelector), {\n      attributes: true\n    });\n  }\n\n  updateUi() {\n    const currentPaymentMethod = getCurrentPaymentMethod();\n    const isPaypal = currentPaymentMethod === PaymentMethods.PAYPAL;\n    const isCard = currentPaymentMethod === PaymentMethods.CARDS;\n    const isSeparateButtonGateway = [PaymentMethods.CARD_BUTTON].includes(currentPaymentMethod);\n    const isSavedCard = isCard && isSavedCardSelected();\n    const isNotOurGateway = !isPaypal && !isCard && !isSeparateButtonGateway;\n    const isFreeTrial = PayPalCommerceGateway.is_free_trial_cart;\n    const hasVaultedPaypal = PayPalCommerceGateway.vaulted_paypal_email !== '';\n    const paypalButtonWrappers = { ...Object.entries(PayPalCommerceGateway.separate_buttons).reduce((result, [k, data]) => {\n        return { ...result,\n          [data.id]: data.wrapper\n        };\n      }, {})\n    };\n    setVisible(this.standardOrderButtonSelector, isPaypal && isFreeTrial && hasVaultedPaypal || isNotOurGateway || isSavedCard, true);\n    setVisible('.ppcp-vaulted-paypal-details', isPaypal);\n    setVisible(this.gateway.button.wrapper, isPaypal && !(isFreeTrial && hasVaultedPaypal));\n    setVisible(this.gateway.messages.wrapper, isPaypal && !isFreeTrial);\n    setVisible(this.gateway.hosted_fields.wrapper, isCard && !isSavedCard);\n\n    for (const [gatewayId, wrapper] of Object.entries(paypalButtonWrappers)) {\n      setVisible(wrapper, gatewayId === currentPaymentMethod);\n    }\n\n    if (isPaypal && !isFreeTrial) {\n      this.messages.render();\n    }\n\n    if (isCard) {\n      if (isSavedCard) {\n        this.disableCreditCardFields();\n      } else {\n        this.enableCreditCardFields();\n      }\n    }\n  }\n\n  disableCreditCardFields() {\n    jQuery('label[for=\"ppcp-credit-card-gateway-card-number\"]').addClass('ppcp-credit-card-gateway-form-field-disabled');\n    jQuery('#ppcp-credit-card-gateway-card-number').addClass('ppcp-credit-card-gateway-form-field-disabled');\n    jQuery('label[for=\"ppcp-credit-card-gateway-card-expiry\"]').addClass('ppcp-credit-card-gateway-form-field-disabled');\n    jQuery('#ppcp-credit-card-gateway-card-expiry').addClass('ppcp-credit-card-gateway-form-field-disabled');\n    jQuery('label[for=\"ppcp-credit-card-gateway-card-cvc\"]').addClass('ppcp-credit-card-gateway-form-field-disabled');\n    jQuery('#ppcp-credit-card-gateway-card-cvc').addClass('ppcp-credit-card-gateway-form-field-disabled');\n    jQuery('label[for=\"vault\"]').addClass('ppcp-credit-card-gateway-form-field-disabled');\n    jQuery('#ppcp-credit-card-vault').addClass('ppcp-credit-card-gateway-form-field-disabled');\n    jQuery('#ppcp-credit-card-vault').attr(\"disabled\", true);\n    this.renderer.disableCreditCardFields();\n  }\n\n  enableCreditCardFields() {\n    jQuery('label[for=\"ppcp-credit-card-gateway-card-number\"]').removeClass('ppcp-credit-card-gateway-form-field-disabled');\n    jQuery('#ppcp-credit-card-gateway-card-number').removeClass('ppcp-credit-card-gateway-form-field-disabled');\n    jQuery('label[for=\"ppcp-credit-card-gateway-card-expiry\"]').removeClass('ppcp-credit-card-gateway-form-field-disabled');\n    jQuery('#ppcp-credit-card-gateway-card-expiry').removeClass('ppcp-credit-card-gateway-form-field-disabled');\n    jQuery('label[for=\"ppcp-credit-card-gateway-card-cvc\"]').removeClass('ppcp-credit-card-gateway-form-field-disabled');\n    jQuery('#ppcp-credit-card-gateway-card-cvc').removeClass('ppcp-credit-card-gateway-form-field-disabled');\n    jQuery('label[for=\"vault\"]').removeClass('ppcp-credit-card-gateway-form-field-disabled');\n    jQuery('#ppcp-credit-card-vault').removeClass('ppcp-credit-card-gateway-form-field-disabled');\n    jQuery('#ppcp-credit-card-vault').attr(\"disabled\", false);\n    this.renderer.enableCreditCardFields();\n  }\n\n}\n\n/* harmony default export */ const ContextBootstrap_CheckoutBootstap = (CheckoutBootstap);\n;// CONCATENATED MODULE: ./resources/js/modules/Helper/Subscriptions.js\nconst isChangePaymentPage = () => {\n  const urlParams = new URLSearchParams(window.location.search);\n  return urlParams.has('change_payment_method');\n};\n;// CONCATENATED MODULE: ./resources/js/modules/ContextBootstrap/PayNowBootstrap.js\n\n\n\nclass PayNowBootstrap extends ContextBootstrap_CheckoutBootstap {\n  constructor(gateway, renderer, messages, spinner) {\n    super(gateway, renderer, messages, spinner);\n  }\n\n  updateUi() {\n    if (isChangePaymentPage()) {\n      return;\n    }\n\n    super.updateUi();\n  }\n\n}\n\n/* harmony default export */ const ContextBootstrap_PayNowBootstrap = (PayNowBootstrap);\n// EXTERNAL MODULE: ./node_modules/deepmerge/dist/cjs.js\nvar cjs = __webpack_require__(996);\nvar cjs_default = /*#__PURE__*/__webpack_require__.n(cjs);\n;// CONCATENATED MODULE: ./resources/js/modules/Renderer/Renderer.js\n\n\nclass Renderer {\n  constructor(creditCardRenderer, defaultSettings, onSmartButtonClick, onSmartButtonsInit) {\n    this.defaultSettings = defaultSettings;\n    this.creditCardRenderer = creditCardRenderer;\n    this.onSmartButtonClick = onSmartButtonClick;\n    this.onSmartButtonsInit = onSmartButtonsInit;\n    this.renderedSources = new Set();\n  }\n\n  render(contextConfig, settingsOverride = {}) {\n    const settings = cjs_default()(this.defaultSettings, settingsOverride);\n    const enabledSeparateGateways = Object.fromEntries(Object.entries(settings.separate_buttons).filter(([s, data]) => document.querySelector(data.wrapper)));\n    const hasEnabledSeparateGateways = Object.keys(enabledSeparateGateways).length !== 0;\n\n    if (!hasEnabledSeparateGateways) {\n      this.renderButtons(settings.button.wrapper, settings.button.style, contextConfig, hasEnabledSeparateGateways);\n    } else {\n      // render each button separately\n      for (const fundingSource of paypal.getFundingSources().filter(s => !(s in enabledSeparateGateways))) {\n        let style = settings.button.style;\n\n        if (fundingSource !== 'paypal') {\n          style = {\n            shape: style.shape\n          };\n        }\n\n        this.renderButtons(settings.button.wrapper, style, contextConfig, hasEnabledSeparateGateways, fundingSource);\n      }\n    }\n\n    this.creditCardRenderer.render(settings.hosted_fields.wrapper, contextConfig);\n\n    for (const [fundingSource, data] of Object.entries(enabledSeparateGateways)) {\n      this.renderButtons(data.wrapper, data.style, contextConfig, hasEnabledSeparateGateways, fundingSource);\n    }\n  }\n\n  renderButtons(wrapper, style, contextConfig, hasEnabledSeparateGateways, fundingSource = null) {\n    if (!document.querySelector(wrapper) || this.isAlreadyRendered(wrapper, fundingSource, hasEnabledSeparateGateways) || 'undefined' === typeof paypal.Buttons) {\n      return;\n    }\n\n    if (fundingSource) {\n      contextConfig.fundingSource = fundingSource;\n    }\n\n    const btn = paypal.Buttons({\n      style,\n      ...contextConfig,\n      onClick: this.onSmartButtonClick,\n      onInit: this.onSmartButtonsInit\n    });\n\n    if (!btn.isEligible()) {\n      return;\n    }\n\n    btn.render(wrapper);\n    this.renderedSources.add(wrapper + fundingSource ?? '');\n  }\n\n  isAlreadyRendered(wrapper, fundingSource, hasEnabledSeparateGateways) {\n    // Simply check that has child nodes when we do not need to render buttons separately,\n    // this will reduce the risk of breaking with different themes/plugins\n    // and on the cart page (where we also do not need to render separately), which may fully reload this part of the page.\n    // Ideally we should also find a way to detect such full reloads and remove the corresponding keys from the set.\n    if (!hasEnabledSeparateGateways) {\n      return document.querySelector(wrapper).hasChildNodes();\n    }\n\n    return this.renderedSources.has(wrapper + fundingSource ?? '');\n  }\n\n  hideButtons(element) {\n    const domElement = document.querySelector(element);\n\n    if (!domElement) {\n      return false;\n    }\n\n    domElement.style.display = 'none';\n    return true;\n  }\n\n  showButtons(element) {\n    const domElement = document.querySelector(element);\n\n    if (!domElement) {\n      return false;\n    }\n\n    domElement.style.display = 'block';\n    return true;\n  }\n\n  disableCreditCardFields() {\n    this.creditCardRenderer.disableFields();\n  }\n\n  enableCreditCardFields() {\n    this.creditCardRenderer.enableFields();\n  }\n\n}\n\n/* harmony default export */ const Renderer_Renderer = (Renderer);\n;// CONCATENATED MODULE: ./resources/js/modules/Helper/DccInputFactory.js\nconst dccInputFactory = original => {\n  const styles = window.getComputedStyle(original);\n  const newElement = document.createElement('span');\n  newElement.setAttribute('id', original.id);\n  newElement.setAttribute('class', original.className);\n  Object.values(styles).forEach(prop => {\n    if (!styles[prop] || !isNaN(prop) || prop === 'background-image') {\n      return;\n    }\n\n    newElement.style.setProperty(prop, '' + styles[prop]);\n  });\n  return newElement;\n};\n\n/* harmony default export */ const DccInputFactory = (dccInputFactory);\n;// CONCATENATED MODULE: ./resources/js/modules/Renderer/CreditCardRenderer.js\n\n\n\n\nclass CreditCardRenderer {\n  constructor(defaultConfig, errorHandler, spinner) {\n    this.defaultConfig = defaultConfig;\n    this.errorHandler = errorHandler;\n    this.spinner = spinner;\n    this.cardValid = false;\n    this.formValid = false;\n    this.currentHostedFieldsInstance = null;\n  }\n\n  render(wrapper, contextConfig) {\n    if (this.defaultConfig.context !== 'checkout' && this.defaultConfig.context !== 'pay-now' || wrapper === null || document.querySelector(wrapper) === null) {\n      return;\n    }\n\n    if (typeof paypal.HostedFields === 'undefined' || !paypal.HostedFields.isEligible()) {\n      const wrapperElement = document.querySelector(wrapper);\n      wrapperElement.parentNode.removeChild(wrapperElement);\n      return;\n    }\n\n    const buttonSelector = wrapper + ' button';\n\n    if (this.currentHostedFieldsInstance) {\n      this.currentHostedFieldsInstance.teardown().catch(err => console.error(`Hosted fields teardown error: ${err}`));\n      this.currentHostedFieldsInstance = null;\n    }\n\n    const gateWayBox = document.querySelector('.payment_box.payment_method_ppcp-credit-card-gateway');\n\n    if (!gateWayBox) {\n      return;\n    }\n\n    const oldDisplayStyle = gateWayBox.style.display;\n    gateWayBox.style.display = 'block';\n    const hideDccGateway = document.querySelector('#ppcp-hide-dcc');\n\n    if (hideDccGateway) {\n      hideDccGateway.parentNode.removeChild(hideDccGateway);\n    }\n\n    const cardNumberField = document.querySelector('#ppcp-credit-card-gateway-card-number');\n    const stylesRaw = window.getComputedStyle(cardNumberField);\n    let styles = {};\n    Object.values(stylesRaw).forEach(prop => {\n      if (!stylesRaw[prop]) {\n        return;\n      }\n\n      styles[prop] = '' + stylesRaw[prop];\n    });\n    const cardNumber = DccInputFactory(cardNumberField);\n    cardNumberField.parentNode.replaceChild(cardNumber, cardNumberField);\n    const cardExpiryField = document.querySelector('#ppcp-credit-card-gateway-card-expiry');\n    const cardExpiry = DccInputFactory(cardExpiryField);\n    cardExpiryField.parentNode.replaceChild(cardExpiry, cardExpiryField);\n    const cardCodeField = document.querySelector('#ppcp-credit-card-gateway-card-cvc');\n    const cardCode = DccInputFactory(cardCodeField);\n    cardCodeField.parentNode.replaceChild(cardCode, cardCodeField);\n    gateWayBox.style.display = oldDisplayStyle;\n    const formWrapper = '.payment_box payment_method_ppcp-credit-card-gateway';\n\n    if (this.defaultConfig.enforce_vault && document.querySelector(formWrapper + ' .ppcp-credit-card-vault')) {\n      document.querySelector(formWrapper + ' .ppcp-credit-card-vault').checked = true;\n      document.querySelector(formWrapper + ' .ppcp-credit-card-vault').setAttribute('disabled', true);\n    }\n\n    paypal.HostedFields.render({\n      createOrder: contextConfig.createOrder,\n      styles: {\n        'input': styles\n      },\n      fields: {\n        number: {\n          selector: '#ppcp-credit-card-gateway-card-number',\n          placeholder: this.defaultConfig.hosted_fields.labels.credit_card_number\n        },\n        cvv: {\n          selector: '#ppcp-credit-card-gateway-card-cvc',\n          placeholder: this.defaultConfig.hosted_fields.labels.cvv\n        },\n        expirationDate: {\n          selector: '#ppcp-credit-card-gateway-card-expiry',\n          placeholder: this.defaultConfig.hosted_fields.labels.mm_yy\n        }\n      }\n    }).then(hostedFields => {\n      document.dispatchEvent(new CustomEvent(\"hosted_fields_loaded\"));\n      this.currentHostedFieldsInstance = hostedFields;\n      hostedFields.on('inputSubmitRequest', () => {\n        this._submit(contextConfig);\n      });\n      hostedFields.on('cardTypeChange', event => {\n        if (!event.cards.length) {\n          this.cardValid = false;\n          return;\n        }\n\n        const validCards = this.defaultConfig.hosted_fields.valid_cards;\n        this.cardValid = validCards.indexOf(event.cards[0].type) !== -1;\n\n        const className = this._cardNumberFiledCLassNameByCardType(event.cards[0].type);\n\n        this._recreateElementClassAttribute(cardNumber, cardNumberField.className);\n\n        if (event.fields.number.isValid) {\n          cardNumber.classList.add(className);\n        }\n      });\n      hostedFields.on('validityChange', event => {\n        const formValid = Object.keys(event.fields).every(function (key) {\n          return event.fields[key].isValid;\n        });\n\n        const className = this._cardNumberFiledCLassNameByCardType(event.cards[0].type);\n\n        event.fields.number.isValid ? cardNumber.classList.add(className) : this._recreateElementClassAttribute(cardNumber, cardNumberField.className);\n        this.formValid = formValid;\n      });\n      show(buttonSelector);\n\n      if (document.querySelector(wrapper).getAttribute('data-ppcp-subscribed') !== true) {\n        document.querySelector(buttonSelector).addEventListener('click', event => {\n          event.preventDefault();\n\n          this._submit(contextConfig);\n        });\n        document.querySelector(wrapper).setAttribute('data-ppcp-subscribed', true);\n      }\n    });\n    document.querySelector('#payment_method_ppcp-credit-card-gateway').addEventListener('click', () => {\n      document.querySelector('label[for=ppcp-credit-card-gateway-card-number]').click();\n    });\n  }\n\n  disableFields() {\n    if (this.currentHostedFieldsInstance) {\n      this.currentHostedFieldsInstance.setAttribute({\n        field: 'number',\n        attribute: 'disabled'\n      });\n      this.currentHostedFieldsInstance.setAttribute({\n        field: 'cvv',\n        attribute: 'disabled'\n      });\n      this.currentHostedFieldsInstance.setAttribute({\n        field: 'expirationDate',\n        attribute: 'disabled'\n      });\n    }\n  }\n\n  enableFields() {\n    if (this.currentHostedFieldsInstance) {\n      this.currentHostedFieldsInstance.removeAttribute({\n        field: 'number',\n        attribute: 'disabled'\n      });\n      this.currentHostedFieldsInstance.removeAttribute({\n        field: 'cvv',\n        attribute: 'disabled'\n      });\n      this.currentHostedFieldsInstance.removeAttribute({\n        field: 'expirationDate',\n        attribute: 'disabled'\n      });\n    }\n  }\n\n  _submit(contextConfig) {\n    this.spinner.block();\n    this.errorHandler.clear();\n\n    if (this.formValid && this.cardValid) {\n      const save_card = this.defaultConfig.can_save_vault_token ? true : false;\n      let vault = document.getElementById('ppcp-credit-card-vault') ? document.getElementById('ppcp-credit-card-vault').checked : save_card;\n\n      if (this.defaultConfig.enforce_vault) {\n        vault = true;\n      }\n\n      const contingency = this.defaultConfig.hosted_fields.contingency;\n      const hostedFieldsData = {\n        vault: vault\n      };\n\n      if (contingency !== 'NO_3D_SECURE') {\n        hostedFieldsData.contingencies = [contingency];\n      }\n\n      if (this.defaultConfig.payer) {\n        hostedFieldsData.cardholderName = this.defaultConfig.payer.name.given_name + ' ' + this.defaultConfig.payer.name.surname;\n      }\n\n      if (!hostedFieldsData.cardholderName) {\n        const firstName = document.getElementById('billing_first_name') ? document.getElementById('billing_first_name').value : '';\n        const lastName = document.getElementById('billing_last_name') ? document.getElementById('billing_last_name').value : '';\n        hostedFieldsData.cardholderName = firstName + ' ' + lastName;\n      }\n\n      this.currentHostedFieldsInstance.submit(hostedFieldsData).then(payload => {\n        payload.orderID = payload.orderId;\n        this.spinner.unblock();\n        return contextConfig.onApprove(payload);\n      }).catch(err => {\n        this.spinner.unblock();\n        this.errorHandler.clear();\n\n        if (err.details) {\n          this.errorHandler.message(err.details.map(d => `${d.issue} ${d.description}`).join('<br/>'), true);\n        }\n      });\n    } else {\n      this.spinner.unblock();\n      const message = !this.cardValid ? this.defaultConfig.hosted_fields.labels.card_not_supported : this.defaultConfig.hosted_fields.labels.fields_not_valid;\n      this.errorHandler.message(message);\n    }\n  }\n\n  _cardNumberFiledCLassNameByCardType(cardType) {\n    return cardType === 'american-express' ? 'amex' : cardType.replace('-', '');\n  }\n\n  _recreateElementClassAttribute(element, newClassName) {\n    element.removeAttribute('class');\n    element.setAttribute('class', newClassName);\n  }\n\n}\n\n/* harmony default export */ const Renderer_CreditCardRenderer = (CreditCardRenderer);\n;// CONCATENATED MODULE: ./resources/js/modules/DataClientIdAttributeHandler.js\nconst storageKey = 'ppcp-data-client-id';\n\nconst validateToken = (token, user) => {\n  if (!token) {\n    return false;\n  }\n\n  if (token.user !== user) {\n    return false;\n  }\n\n  const currentTime = new Date().getTime();\n  const isExpired = currentTime >= token.expiration * 1000;\n  return !isExpired;\n};\n\nconst storedTokenForUser = user => {\n  const token = JSON.parse(sessionStorage.getItem(storageKey));\n\n  if (validateToken(token, user)) {\n    return token.token;\n  }\n\n  return null;\n};\n\nconst storeToken = token => {\n  sessionStorage.setItem(storageKey, JSON.stringify(token));\n};\n\nconst dataClientIdAttributeHandler = (script, config) => {\n  fetch(config.endpoint, {\n    method: 'POST',\n    body: JSON.stringify({\n      nonce: config.nonce\n    })\n  }).then(res => {\n    return res.json();\n  }).then(data => {\n    const isValid = validateToken(data, config.user);\n\n    if (!isValid) {\n      return;\n    }\n\n    storeToken(data);\n    script.setAttribute('data-client-token', data.token);\n    document.body.append(script);\n  });\n};\n\n/* harmony default export */ const DataClientIdAttributeHandler = (dataClientIdAttributeHandler);\n;// CONCATENATED MODULE: ./resources/js/modules/Renderer/MessageRenderer.js\nclass MessageRenderer {\n  constructor(config) {\n    this.config = config;\n  }\n\n  render() {\n    if (!this.shouldRender()) {\n      return;\n    }\n\n    paypal.Messages({\n      amount: this.config.amount,\n      placement: this.config.placement,\n      style: this.config.style\n    }).render(this.config.wrapper);\n    jQuery(document.body).on('updated_cart_totals', () => {\n      paypal.Messages({\n        amount: this.config.amount,\n        placement: this.config.placement,\n        style: this.config.style\n      }).render(this.config.wrapper);\n    });\n  }\n\n  renderWithAmount(amount) {\n    if (!this.shouldRender()) {\n      return;\n    }\n\n    const newWrapper = document.createElement('div');\n    newWrapper.setAttribute('id', this.config.wrapper.replace('#', ''));\n    const sibling = document.querySelector(this.config.wrapper).nextSibling;\n    document.querySelector(this.config.wrapper).parentElement.removeChild(document.querySelector(this.config.wrapper));\n    sibling.parentElement.insertBefore(newWrapper, sibling);\n    paypal.Messages({\n      amount,\n      placement: this.config.placement,\n      style: this.config.style\n    }).render(this.config.wrapper);\n  }\n\n  shouldRender() {\n    if (typeof paypal.Messages === 'undefined' || typeof this.config.wrapper === 'undefined') {\n      return false;\n    }\n\n    if (!document.querySelector(this.config.wrapper)) {\n      return false;\n    }\n\n    return true;\n  }\n\n  hideMessages() {\n    const domElement = document.querySelector(this.config.wrapper);\n\n    if (!domElement) {\n      return false;\n    }\n\n    domElement.style.display = 'none';\n    return true;\n  }\n\n}\n\n/* harmony default export */ const Renderer_MessageRenderer = (MessageRenderer);\n;// CONCATENATED MODULE: ./resources/js/modules/Helper/Spinner.js\nclass Spinner {\n  constructor(target = 'form.woocommerce-checkout') {\n    this.target = target;\n  }\n\n  setTarget(target) {\n    this.target = target;\n  }\n\n  block() {\n    jQuery(this.target).block({\n      message: null,\n      overlayCSS: {\n        background: '#fff',\n        opacity: 0.6\n      }\n    });\n  }\n\n  unblock() {\n    jQuery(this.target).unblock();\n  }\n\n}\n\n/* harmony default export */ const Helper_Spinner = (Spinner);\n;// CONCATENATED MODULE: ./resources/js/modules/ActionHandler/FreeTrialHandler.js\n\n\n\nclass FreeTrialHandler {\n  constructor(config, spinner, errorHandler) {\n    this.config = config;\n    this.spinner = spinner;\n    this.errorHandler = errorHandler;\n  }\n\n  handle() {\n    this.spinner.block();\n    fetch(this.config.ajax.vault_paypal.endpoint, {\n      method: 'POST',\n      body: JSON.stringify({\n        nonce: this.config.ajax.vault_paypal.nonce,\n        return_url: location.href\n      })\n    }).then(res => {\n      return res.json();\n    }).then(data => {\n      if (!data.success) {\n        this.spinner.unblock();\n        console.error(data);\n        this.errorHandler.message(data.data.message);\n        throw Error(data.data.message);\n      }\n\n      location.href = data.data.approve_link;\n    }).catch(error => {\n      this.spinner.unblock();\n      console.error(error);\n      this.errorHandler.genericError();\n    });\n  }\n\n}\n\n/* harmony default export */ const ActionHandler_FreeTrialHandler = (FreeTrialHandler);\n;// CONCATENATED MODULE: ./resources/js/button.js\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n // TODO: could be a good idea to have a separate spinner for each gateway,\n// but I think we care mainly about the script loading, so one spinner should be enough.\n\nconst buttonsSpinner = new Helper_Spinner(document.querySelector('.ppc-button-wrapper'));\nconst cardsSpinner = new Helper_Spinner('#ppcp-hosted-fields');\n\nconst bootstrap = () => {\n  const errorHandler = new modules_ErrorHandler(PayPalCommerceGateway.labels.error.generic);\n  const spinner = new Helper_Spinner();\n  const creditCardRenderer = new Renderer_CreditCardRenderer(PayPalCommerceGateway, errorHandler, spinner);\n  const freeTrialHandler = new ActionHandler_FreeTrialHandler(PayPalCommerceGateway, spinner, errorHandler);\n\n  const onSmartButtonClick = (data, actions) => {\n    window.ppcpFundingSource = data.fundingSource;\n\n    if (PayPalCommerceGateway.basic_checkout_validation_enabled) {\n      // TODO: quick fix to get the error about empty form before attempting PayPal order\n      // it should solve #513 for most of the users, but proper solution should be implemented later.\n      const requiredFields = jQuery('form.woocommerce-checkout .validate-required:visible :input');\n      requiredFields.each((i, input) => {\n        jQuery(input).trigger('validate');\n      });\n      const invalidFields = Array.from(jQuery('form.woocommerce-checkout .validate-required.woocommerce-invalid:visible'));\n\n      if (invalidFields.length) {\n        const billingFieldsContainer = document.querySelector('.woocommerce-billing-fields');\n        const shippingFieldsContainer = document.querySelector('.woocommerce-shipping-fields');\n        const nameMessageMap = PayPalCommerceGateway.labels.error.required.elements;\n        const messages = invalidFields.map(el => {\n          const name = el.querySelector('[name]')?.getAttribute('name');\n\n          if (name && name in nameMessageMap) {\n            return nameMessageMap[name];\n          }\n\n          let label = el.querySelector('label').textContent.replaceAll('*', '').trim();\n\n          if (billingFieldsContainer?.contains(el)) {\n            label = PayPalCommerceGateway.labels.billing_field.replace('%s', label);\n          }\n\n          if (shippingFieldsContainer?.contains(el)) {\n            label = PayPalCommerceGateway.labels.shipping_field.replace('%s', label);\n          }\n\n          return PayPalCommerceGateway.labels.error.required.field.replace('%s', `<strong>${label}</strong>`);\n        }).filter(s => s.length > 2);\n        errorHandler.clear();\n\n        if (messages.length) {\n          messages.forEach(s => errorHandler.message(s));\n        } else {\n          errorHandler.message(PayPalCommerceGateway.labels.error.required.generic);\n        }\n\n        return actions.reject();\n      }\n    }\n\n    const form = document.querySelector('form.woocommerce-checkout');\n\n    if (form) {\n      jQuery('#ppcp-funding-source-form-input').remove();\n      form.insertAdjacentHTML('beforeend', `<input type=\"hidden\" name=\"ppcp-funding-source\" value=\"${data.fundingSource}\" id=\"ppcp-funding-source-form-input\">`);\n    }\n\n    const isFreeTrial = PayPalCommerceGateway.is_free_trial_cart;\n\n    if (isFreeTrial && data.fundingSource !== 'card') {\n      freeTrialHandler.handle();\n      return actions.reject();\n    }\n  };\n\n  const onSmartButtonsInit = () => {\n    buttonsSpinner.unblock();\n  };\n\n  const renderer = new Renderer_Renderer(creditCardRenderer, PayPalCommerceGateway, onSmartButtonClick, onSmartButtonsInit);\n  const messageRenderer = new Renderer_MessageRenderer(PayPalCommerceGateway.messages);\n  const context = PayPalCommerceGateway.context;\n\n  if (context === 'mini-cart' || context === 'product') {\n    if (PayPalCommerceGateway.mini_cart_buttons_enabled === '1') {\n      const miniCartBootstrap = new ContextBootstrap_MiniCartBootstap(PayPalCommerceGateway, renderer);\n      miniCartBootstrap.init();\n    }\n  }\n\n  if (context === 'product' && PayPalCommerceGateway.single_product_buttons_enabled === '1') {\n    const singleProductBootstrap = new ContextBootstrap_SingleProductBootstap(PayPalCommerceGateway, renderer, messageRenderer);\n    singleProductBootstrap.init();\n  }\n\n  if (context === 'cart') {\n    const cartBootstrap = new CartBootstap(PayPalCommerceGateway, renderer);\n    cartBootstrap.init();\n  }\n\n  if (context === 'checkout') {\n    const checkoutBootstap = new ContextBootstrap_CheckoutBootstap(PayPalCommerceGateway, renderer, messageRenderer, spinner);\n    checkoutBootstap.init();\n  }\n\n  if (context === 'pay-now') {\n    const payNowBootstrap = new ContextBootstrap_PayNowBootstrap(PayPalCommerceGateway, renderer, messageRenderer, spinner);\n    payNowBootstrap.init();\n  }\n\n  if (context !== 'checkout') {\n    messageRenderer.render();\n  }\n};\n\ndocument.addEventListener('DOMContentLoaded', () => {\n  if (!typeof PayPalCommerceGateway) {\n    console.error('PayPal button could not be configured.');\n    return;\n  }\n\n  if (PayPalCommerceGateway.context !== 'checkout' && PayPalCommerceGateway.data_client_id.user === 0 && PayPalCommerceGateway.data_client_id.has_subscriptions) {\n    return;\n  }\n\n  const paypalButtonGatewayIds = [PaymentMethods.PAYPAL, ...Object.entries(PayPalCommerceGateway.separate_buttons).map(([k, data]) => data.id)]; // Sometimes PayPal script takes long time to load,\n  // so we additionally hide the standard order button here to avoid failed orders.\n  // Normally it is hidden later after the script load.\n\n  const hideOrderButtonIfPpcpGateway = () => {\n    // only in checkout and pay now page, otherwise it may break things (e.g. payment via product page),\n    // and also the loading spinner may look weird on other pages\n    if (!['checkout', 'pay-now'].includes(PayPalCommerceGateway.context) || isChangePaymentPage() || PayPalCommerceGateway.is_free_trial_cart && PayPalCommerceGateway.vaulted_paypal_email !== '') {\n      return;\n    }\n\n    const currentPaymentMethod = getCurrentPaymentMethod();\n    const isPaypalButton = paypalButtonGatewayIds.includes(currentPaymentMethod);\n    const isCards = currentPaymentMethod === PaymentMethods.CARDS;\n    setVisible(ORDER_BUTTON_SELECTOR, !isPaypalButton && !isCards, true);\n\n    if (isPaypalButton) {\n      // stopped after the first rendering of the buttons, in onInit\n      buttonsSpinner.block();\n    } else {\n      buttonsSpinner.unblock();\n    }\n\n    if (isCards) {\n      cardsSpinner.block();\n    } else {\n      cardsSpinner.unblock();\n    }\n  };\n\n  jQuery(document).on('hosted_fields_loaded', () => {\n    cardsSpinner.unblock();\n  });\n  let bootstrapped = false;\n  hideOrderButtonIfPpcpGateway();\n  jQuery(document.body).on('updated_checkout payment_method_selected', () => {\n    if (bootstrapped) {\n      return;\n    }\n\n    hideOrderButtonIfPpcpGateway();\n  });\n  const script = document.createElement('script');\n  script.addEventListener('load', event => {\n    bootstrapped = true;\n    bootstrap();\n  });\n  script.setAttribute('src', PayPalCommerceGateway.button.url);\n  Object.entries(PayPalCommerceGateway.script_attributes).forEach(keyValue => {\n    script.setAttribute(keyValue[0], keyValue[1]);\n  });\n\n  if (PayPalCommerceGateway.data_client_id.set_attribute) {\n    DataClientIdAttributeHandler(script, PayPalCommerceGateway.data_client_id);\n    return;\n  }\n\n  document.body.append(script);\n});//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///536\n")},996:module=>{eval("\n\nvar isMergeableObject = function isMergeableObject(value) {\n\treturn isNonNullObject(value)\n\t\t&& !isSpecial(value)\n};\n\nfunction isNonNullObject(value) {\n\treturn !!value && typeof value === 'object'\n}\n\nfunction isSpecial(value) {\n\tvar stringValue = Object.prototype.toString.call(value);\n\n\treturn stringValue === '[object RegExp]'\n\t\t|| stringValue === '[object Date]'\n\t\t|| isReactElement(value)\n}\n\n// see https://github.com/facebook/react/blob/b5ac963fb791d1298e7f396236383bc955f916c1/src/isomorphic/classic/element/ReactElement.js#L21-L25\nvar canUseSymbol = typeof Symbol === 'function' && Symbol.for;\nvar REACT_ELEMENT_TYPE = canUseSymbol ? Symbol.for('react.element') : 0xeac7;\n\nfunction isReactElement(value) {\n\treturn value.$$typeof === REACT_ELEMENT_TYPE\n}\n\nfunction emptyTarget(val) {\n\treturn Array.isArray(val) ? [] : {}\n}\n\nfunction cloneUnlessOtherwiseSpecified(value, options) {\n\treturn (options.clone !== false && options.isMergeableObject(value))\n\t\t? deepmerge(emptyTarget(value), value, options)\n\t\t: value\n}\n\nfunction defaultArrayMerge(target, source, options) {\n\treturn target.concat(source).map(function(element) {\n\t\treturn cloneUnlessOtherwiseSpecified(element, options)\n\t})\n}\n\nfunction getMergeFunction(key, options) {\n\tif (!options.customMerge) {\n\t\treturn deepmerge\n\t}\n\tvar customMerge = options.customMerge(key);\n\treturn typeof customMerge === 'function' ? customMerge : deepmerge\n}\n\nfunction getEnumerableOwnPropertySymbols(target) {\n\treturn Object.getOwnPropertySymbols\n\t\t? Object.getOwnPropertySymbols(target).filter(function(symbol) {\n\t\t\treturn target.propertyIsEnumerable(symbol)\n\t\t})\n\t\t: []\n}\n\nfunction getKeys(target) {\n\treturn Object.keys(target).concat(getEnumerableOwnPropertySymbols(target))\n}\n\nfunction propertyIsOnObject(object, property) {\n\ttry {\n\t\treturn property in object\n\t} catch(_) {\n\t\treturn false\n\t}\n}\n\n// Protects from prototype poisoning and unexpected merging up the prototype chain.\nfunction propertyIsUnsafe(target, key) {\n\treturn propertyIsOnObject(target, key) // Properties are safe to merge if they don't exist in the target yet,\n\t\t&& !(Object.hasOwnProperty.call(target, key) // unsafe if they exist up the prototype chain,\n\t\t\t&& Object.propertyIsEnumerable.call(target, key)) // and also unsafe if they're nonenumerable.\n}\n\nfunction mergeObject(target, source, options) {\n\tvar destination = {};\n\tif (options.isMergeableObject(target)) {\n\t\tgetKeys(target).forEach(function(key) {\n\t\t\tdestination[key] = cloneUnlessOtherwiseSpecified(target[key], options);\n\t\t});\n\t}\n\tgetKeys(source).forEach(function(key) {\n\t\tif (propertyIsUnsafe(target, key)) {\n\t\t\treturn\n\t\t}\n\n\t\tif (propertyIsOnObject(target, key) && options.isMergeableObject(source[key])) {\n\t\t\tdestination[key] = getMergeFunction(key, options)(target[key], source[key], options);\n\t\t} else {\n\t\t\tdestination[key] = cloneUnlessOtherwiseSpecified(source[key], options);\n\t\t}\n\t});\n\treturn destination\n}\n\nfunction deepmerge(target, source, options) {\n\toptions = options || {};\n\toptions.arrayMerge = options.arrayMerge || defaultArrayMerge;\n\toptions.isMergeableObject = options.isMergeableObject || isMergeableObject;\n\t// cloneUnlessOtherwiseSpecified is added to `options` so that custom arrayMerge()\n\t// implementations can use it. The caller may not replace it.\n\toptions.cloneUnlessOtherwiseSpecified = cloneUnlessOtherwiseSpecified;\n\n\tvar sourceIsArray = Array.isArray(source);\n\tvar targetIsArray = Array.isArray(target);\n\tvar sourceAndTargetTypesMatch = sourceIsArray === targetIsArray;\n\n\tif (!sourceAndTargetTypesMatch) {\n\t\treturn cloneUnlessOtherwiseSpecified(source, options)\n\t} else if (sourceIsArray) {\n\t\treturn options.arrayMerge(target, source, options)\n\t} else {\n\t\treturn mergeObject(target, source, options)\n\t}\n}\n\ndeepmerge.all = function deepmergeAll(array, options) {\n\tif (!Array.isArray(array)) {\n\t\tthrow new Error('first argument should be an array')\n\t}\n\n\treturn array.reduce(function(prev, next) {\n\t\treturn deepmerge(prev, next, options)\n\t}, {})\n};\n\nvar deepmerge_1 = deepmerge;\n\nmodule.exports = deepmerge_1;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///996\n")}},__webpack_module_cache__={};function __webpack_require__(Q){var F=__webpack_module_cache__[Q];if(void 0!==F)return F.exports;var B=__webpack_module_cache__[Q]={exports:{}};return __webpack_modules__[Q](B,B.exports,__webpack_require__),B.exports}__webpack_require__.n=Q=>{var F=Q&&Q.__esModule?()=>Q.default:()=>Q;return __webpack_require__.d(F,{a:F}),F},__webpack_require__.d=(Q,F)=>{for(var B in F)__webpack_require__.o(F,B)&&!__webpack_require__.o(Q,B)&&Object.defineProperty(Q,B,{enumerable:!0,get:F[B]})},__webpack_require__.o=(Q,F)=>Object.prototype.hasOwnProperty.call(Q,F);var __webpack_exports__=__webpack_require__(536)})();