<?php
/**
 *	Module made by Nukium
 *
 *  @author    Nukium
 *  @copyright 2021 Nukium SAS
 *  @license   All rights reserved
 *
 * ███    ██ ██    ██ ██   ██ ██ ██    ██ ███    ███
 * ████   ██ ██    ██ ██  ██  ██ ██    ██ ████  ████
 * ██ ██  ██ ██    ██ █████   ██ ██    ██ ██ ████ ██
 * ██  ██ ██ ██    ██ ██  ██  ██ ██    ██ ██  ██  ██
 * ██   ████  ██████  ██   ██ ██  ██████  ██      ██
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<div class="wrap woocommerce">
	<form action="<?php  echo esc_url($admin_url); ?>" method="post" target="_blank">
		<h3 class="wc-settings-sub-title ">
			<?php _e('Packages', 'woocommerce-gls')?>
		</h3>
		<p class="submit">
            <input name="cancelPrintPackingList" class="button-secondary woocommerce-cancel-button" type="submit" value="<?php esc_attr_e( 'Cancel', 'woocommerce-gls' ); ?>" />
            <input name="printPackingList" class="button-primary woocommerce-save-button" type="submit" value="<?php esc_attr_e( 'Print', 'woocommerce-gls' ); ?>" />
		</p>
		<table class="wp-list-table widefat fixed striped posts">
			<thead>
				<tr>
					<td id="cb" class="manage-column column-cb check-column">
						<label class="screen-reader-text" for="cb-select-all-1"></label>
						<input id="cb-select-all-1" type="checkbox">
                    </td>
                    <th scope="col" id="shipping_number" class="manage-column column-shipping_number column-primary"><?php _e( 'Tracking ID', 'woocommerce-gls' )?></th>
                    <th scope="col" id="order_weight" class="manage-column column-order_weight"><?php _e( 'Weight', 'woocommerce-gls' );?> (kg)</th>
					<th scope="col" id="package_date" class="manage-column column-package_date"><?php _e( 'Package date', 'woocommerce-gls' ); ?></th>
					<th scope="col" id="order_title" class="manage-column column-order_title column-primary"><?php _e( 'Order', 'woocommerce' )?></th>
					<th scope="col" id="shipping_address" class="manage-column column-shipping_address"><?php _e( 'Ship to', 'woocommerce-gls' ); ?></th>
					<th scope="col" id="order_status" class="manage-column column-order_status"><?php _e( 'Status', 'woocommerce-gls' ) ?></th>
					<th scope="col" id="order_date" class="manage-column column-order_date"><?php _e( 'Order date', 'woocommerce-gls' ); ?></th>
				</tr>
			</thead>
			<tbody id="the-list">
				<?php foreach ($orders as $row): ?>
					<?php
                    $the_order = wc_get_order($row->ID);
                    $package_date = new DateTime($row->date_add);
					?>
					<tr class="post-<?php echo $row->id; ?>">
						<th scope="row" class="check-column">
							<label class="screen-reader-text" for="cb-select-<?php echo $row->id; ?>"></label>
							<input id="cb-select-<?php echo $row->id; ?>" type="checkbox" name="packagePost[]" value="<?php echo $row->id; ?>">
                        </th>
                        <td><?php echo $row->shipping_number; ?></td>
                        <td class="order_weight column-order_weight">
                            <?php if ($row->weight > 0): ?>
                                <?php echo number_format($row->weight, 3); ?>
                            <?php else: ?>
                                0
                            <?php endif; ?>
                        </td>
                        <td class="package_date column-package_date">
							<?php
							printf(
								'<time datetime="%1$s" title="%2$s">%3$s</time>',
								esc_attr( $package_date->format('c') ),
								esc_html( date_i18n( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ) , $package_date->getTimestamp()) ),
								esc_html( date_i18n( get_option( 'date_format' ) , $package_date->getTimestamp()) )
							);
							?>
						</td>
						<td class="order_title column-order_title has-row-actions column-primary">
							<?php
							if ( $the_order->get_customer_id() ) {
								$user     = get_user_by( 'id', $the_order->get_customer_id() );
								$username = '<a href="user-edit.php?user_id=' . absint( $the_order->get_customer_id() ) . '" target="_blank">';
								$username .= esc_html( ucwords( $user->display_name ) );
								$username .= '</a>';
							} elseif ( $the_order->get_billing_first_name() || $the_order->get_billing_last_name() ) {
								

								$username = trim( sprintf( _x( '%1$s %2$s', 'full name', 'woocommerce' ), $the_order->get_billing_first_name(), $the_order->get_billing_last_name() ) );
							} elseif ( $the_order->get_billing_company() ) {
								$username = trim( $the_order->get_billing_company() );
							} else {
								$username = __( 'Guest', 'woocommerce' );
							}

							

							printf(
								__( '%1$s by %2$s', 'woocommerce-gls' ),
								'<strong>#' . esc_attr( $the_order->get_order_number() ) . '</strong>',
								$username
							);

							if ( $the_order->get_billing_email() ) {
								echo '<br><small class="meta email"><a href="' . esc_url( 'mailto:' . $the_order->get_billing_email() ) . '">' . esc_html( $the_order->get_billing_email() ) . '</a></small>';
							}
							?>
						</td>
						<td class="billing_address column-billing_address hidden">
							<?php
							if ( $address = $the_order->get_formatted_billing_address() ) {
								echo esc_html( preg_replace( '#<br\s*/?>#i', ', ', $address ) );
							} else {
								echo '&ndash;';
							}

							if ( $the_order->get_billing_phone() ) {
								echo '<br><small class="meta">' . __( 'Phone:', 'woocommerce-gls' ) . ' ' . esc_html( $the_order->get_billing_phone() ) . '</small>';
							}
							?>
						</td>
						<td class="shipping_address column-shipping_address">
							<?php
							if ( $address = $the_order->get_formatted_shipping_address() ) {
								echo '<a target="_blank" href="' . esc_url( $the_order->get_shipping_address_map_url() ) . '">' . esc_html( preg_replace( '#<br\s*/?>#i', ', ', $address ) ) . '</a>';
							} else {
								echo '&ndash;';
							}

							if ( $the_order->get_shipping_method() ) {
								echo '<br><small class="meta">' . __( 'With', 'woocommerce-gls' ) . ' ' . esc_html( $the_order->get_shipping_method() ) . '</small>';
							}
							?>
						</td>
						<td class="order_status column-order_status">
							<?php
							printf( '<mark class="order-status status-%s"><span>%s</span></mark>', esc_attr( sanitize_html_class( $the_order->get_status() ) ), esc_attr( wc_get_order_status_name( $the_order->get_status() ) ), esc_html( wc_get_order_status_name( $the_order->get_status() ) ) );
							?>
                        </td>
                        <td class="order_date column-order_date">
							<?php
							printf(
								'<time datetime="%1$s" title="%2$s">%3$s</time>',
								esc_attr( $the_order->get_date_created()->date( 'c' ) ),
								esc_html( $the_order->get_date_created()->date_i18n( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ) ) ),
								esc_html( $the_order->get_date_created()->date_i18n( apply_filters( 'woocommerce_admin_order_date_format', get_option( 'date_format' ) ) ) )
							);
							?>
						</td>
					</tr>
				<?php endforeach;?>
			</tbody>
		</table>

		<p class="submit">
            <input name="cancelPrintPackingList" class="button-secondary woocommerce-cancel-button" type="submit" value="<?php esc_attr_e( 'Cancel', 'woocommerce-gls' ); ?>" />
            <input name="printPackingList" class="button-primary woocommerce-save-button" type="submit" value="<?php esc_attr_e( 'Print', 'woocommerce-gls' ); ?>" />
        </p>

	</form>
</div>