<?php
/**
 *	Module made by Nukium
 *
 *  @author    Nukium
 *  @copyright 2021 Nukium SAS
 *  @license   All rights reserved
 *
 * ███    ██ ██    ██ ██   ██ ██ ██    ██ ███    ███
 * ████   ██ ██    ██ ██  ██  ██ ██    ██ ████  ████
 * ██ ██  ██ ██    ██ █████   ██ ██    ██ ██ ████ ██
 * ██  ██ ██ ██    ██ ██  ██  ██ ██    ██ ██  ██  ██
 * ██   ████  ██████  ██   ██ ██  ██████  ██      ██
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<tr>
	<td colspan="2">
		<div class="col-12 gls-container">

			<?php if (!$error || (isset($error['code']) && $error['code'] == 998 || $error['code'] == 999)): ?>
				<?php if ($force_gsm): ?>
			    	<div class="form-row form-row-wide validate-required validate-phone gls-mobile">
			        	<label for="gls-customer-mobile-<?php echo $id_carrier; ?>" class="form-control-label"><?php echo $customer_mobile_title ?> <?php echo $name_carrier; ?> <abbr class="required" title="required">*</abbr></label>
			            <input type="tel" id="gls-customer-mobile-<?php echo $id_carrier; ?>" name="gls_customer_mobile_<?php echo $id_carrier; ?>" class="form-control input-text gls-customer-mobile" value="<?php echo $current_customer_mobile; ?>" autocomplete="nope" />
					</div>
				<?php endif; ?>
				<?php if ($is_relay_carrier): ?>
			        <div class="row">
			        	<div class="col-12">
			        		<div class="gls-heading">
								<h4><?php _e( 'The following GLS Relais are available around your address', 'woocommerce-gls' ); ?></h4>
								<div class="gls-sub-heading">
									<?php _e( 'You have the choice between the following alternatives:', 'woocommerce-gls' ); ?>
									<ul>
										<li><?php _e( 'a Point Relais®, among the approved merchants of the Mondial Relay network', 'woocommerce-gls' ); ?></li>
										<li><?php _e( 'a Voisin-Relais of the Pickme network: network of trusted individuals in Paris, selected by our partner Pickme, identified in the list by their first names', 'woocommerce-gls' ); ?></li>
									</ul>
								</div>
			        		</div>
			        	</div>
						<div class="col-12">
							<div class="gls-search">
								<a href="#gls-search-form" class="gls-search-form-toggler"><?php _e( '> Find GLS Relais around another address', 'woocommerce-gls' ); ?></a>
								<div id="gls-search-form" style="display: none;">
					            	<div class="form-row input-group mb-0">
					                	<input type="search" name="gls_search" id="gls-search" class="form-control input-text" placeholder="<?php _e( 'Postcode (required), City (optional)', 'woocommerce-gls' ); ?>" />
					                    <div class="input-group-btn input-group-append">
					                    	<button type="button" class="button button-primary gls-search-relay">
					                    		<?php _e( 'Search', 'woocommerce-gls' ); ?>
											</button>
					                    </div>
									</div>
								</div>
							</div>
			            </div>
						<?php if ($relay_points): ?>
			                <div class="col-12 gls-relay-list">
			                    <?php foreach ($relay_points as $k => $v): ?>
			                        <?php if ($k < 10  && (!$only_xl || ($only_xl && substr($v->Parcelshop->Address->Name1, -2) == 'XL') )): ?>
			                            <div class="row <?php echo ($k > 10 ? 'hidden relay-disable' : 'show relay-enable'); ?>">
			                                <div class="col-12">
			                                	<div class="card gls-relay-infos">
			                                		<div class="card-body">
					                                	<div class="row">
					                                		<div class="col-auto col-select-relay">
					  											<input type="radio" name="gls_relay" id="gls-relay-<?php echo $v->Parcelshop->ParcelShopId?>" class="gls-select-relay" data-glsrelayid="<?php echo $v->Parcelshop->ParcelShopId?>" value="<?php echo $v->Parcelshop->ParcelShopId?>"<?php if ($current_relay == $v->Parcelshop->ParcelShopId):?> checked<?php endif;?> />
															</div>
															<label class="col" for="gls-relay-<?php echo $v->Parcelshop->ParcelShopId?>">
							                                	<div class="card-title">
							                                		<span class="gls-relay-name"><strong><?php echo $v->Parcelshop->Address->Name1?></strong></span><span class="separator"> - </span><span class="gls-relay-label"><?php echo substr($labels, $k, 1); ?></span>
							                                	</div>
							                                    <div class="card-text">
							                                    	<div class="gls-relay-address">
									                                    <?php echo $v->Parcelshop->Address->Street1?>
									                                    <br/>
									                                    <?php echo $v->Parcelshop->Address->ZipCode?> <?php echo $v->Parcelshop->Address->City?>
								                                    </div>
																</div>
															</label>
															<div class="col-auto">
																<div class="gls-relay-distance text-muted">
							                                    	<?php echo number_format($v->AirLineDistance, 2)?> <?php _e( 'km' , 'woocommerce-gls' )?>
							                                    </div>
							                                </div>
														</div>
													</div>
												</div>
			                                </div>
			                            </div>
			                        <?php endif; ?>
			                    <?php endforeach; ?>
			                    <script type="text/javascript">
			                		var glsGmapsMarkers = [];
			                		<?php foreach ($relay_points as $k => $v): ?>
			                        	<?php if ($k < 10 && (!$only_xl || ($only_xl && substr($v->Parcelshop->Address->Name1, -2) == 'XL') )): ?>
				                        	var opening_hours = "";
				                        	<?php if (isset($v->Parcelshop->GLSWorkingDay) && is_array($v->Parcelshop->GLSWorkingDay) && count($v->Parcelshop->GLSWorkingDay) > 0): ?>
			                        			opening_hours += '<table class="gls-relay-info-open-hours"><tbody>';
		                    					<?php foreach ($trans_days as $day => $dname): ?>
		                    						opening_hours += '<tr';
		                    						    <?php if(((int)date('w') - 1) == (int)$day): ?>
		                    						    	opening_hours += ' class="today"';
	                    						    	<?php endif;?>
	                    						    	opening_hours += '>';
		                    							<?php if (isset($v->Parcelshop->GLSWorkingDay[$day])): ?>
			                    							opening_hours += '<th><?php echo $dname; ?></th>';
			                    							opening_hours += '<td><?php echo substr($v->Parcelshop->GLSWorkingDay[$day]->OpeningHours->Hours->From, 0, 2)?>:<?php echo substr($v->Parcelshop->GLSWorkingDay[$day]->OpeningHours->Hours->From, 2, 2)?> - ';
			                    								<?php if (!empty($v->Parcelshop->GLSWorkingDay[$day]->Breaks->Hours->From)):?>
																	opening_hours += '<?php echo substr($v->Parcelshop->GLSWorkingDay[$day]->Breaks->Hours->From, 0, 2)?>:<?php echo substr($v->Parcelshop->GLSWorkingDay[$day]->Breaks->Hours->From, 2, 2)?><br/><?php echo substr($v->Parcelshop->GLSWorkingDay[$day]->Breaks->Hours->To, 0, 2)?>:<?php echo substr($v->Parcelshop->GLSWorkingDay[$day]->Breaks->Hours->To, 2, 2)?> - <?php echo substr($v->Parcelshop->GLSWorkingDay[$day]->OpeningHours->Hours->To, 0, 2)?>:<?php echo substr($v->Parcelshop->GLSWorkingDay[$day]->OpeningHours->Hours->To, 2, 2)?>';
																<?php else: ?>
																	opening_hours += '<?php echo substr($v->Parcelshop->GLSWorkingDay[$day]->OpeningHours->Hours->To, 0, 2)?>:<?php echo substr($v->Parcelshop->GLSWorkingDay[$day]->OpeningHours->Hours->To, 2, 2)?>';
																<?php endif; ?>
															opening_hours += '</td>';
			                    						<?php else:?>
			                    							opening_hours += '<th><?php echo $dname; ?></th><td><?php _e( 'Closed' , 'woocommerce-gls' ); ?></td>';
														<?php endif; ?>
													opening_hours += '</tr>';
		                    					<?php endforeach; ?>
		                    					opening_hours += '</tbody></table>';
											<?php endif; ?>
					                        glsGmapsMarkers.push({"lat" : <?php echo $v->Parcelshop->GLSCoordinates->Latitude?>, "lng" : <?php echo $v->Parcelshop->GLSCoordinates->Longitude?>, "name" : "<?php echo $v->Parcelshop->Address->Name1?>", "id" : "<?php echo substr($labels, $k, 1); ?>", "infos" : opening_hours});
				                        <?php endif; ?>
			                        <?php endforeach; ?>
								</script>
			                </div>
			                <div class="col-12 gls-relay-map">
			                    <div id="gls-map"></div>
			                </div>
						<?php endif; ?>
			        </div>
				<?php endif; ?>
			<?php endif; ?>

			<?php if ($error): ?>
			    <div class="woocommerce-error" role="alert">
			        <span data-title="<?php if (!empty($error['code'])):?><?php _e( sprintf('Code: %s', $error['code']) , 'woocommerce-gls' ); ?><?php endif; ?>" class="alert-text"><?php echo $error['message']?></span>
			    </div>
			<?php endif; ?>

		</div>
	</td>
</tr>