<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; 
}

if ( ! class_exists( 'WC_Email_Gls_Label_Return', false ) ) :

class WC_Email_Gls_Label_Return extends WC_Email {

	

	public $followup;

	

	public $firstname;

	

	public $lastname;

	

	public function __construct() {

		$this->id             = 'gls_label_return';
		$this->customer_email = true;
		$this->title          = __( 'GLS label return', 'woocommerce-gls' );
		$this->description    = __( 'GLS label return is sent when you create a single GLS label return for an order, this label is sent as an attachment to the email.', 'woocommerce-gls' );
		$this->template_html  = 'emails/gls-label-return.php';
		$this->template_plain = 'emails/plain/gls-label-return.php';
		$this->template_base  = GLS_TEMPLATE_PATH;

		
		add_action( 'woocommerce_gls_generate_single_return_label_notification', array( $this, 'trigger' ) );

		$this->placeholders   = array(
			'{site_title}'   => $this->get_blogname(),
			'{order_date}'   => '',
			'{order_number}' => '',
		);

		
		parent::__construct();
	}

	

	public function get_default_subject() {
		return __( 'Your order return request on {site_title} has been accepted', 'woocommerce-gls' );
	}

	

	public function get_default_heading() {
		return __( 'Order {order_number} - Return request accepted', 'woocommerce' );
	}

	

	public function trigger( $args ) {

		if ( ! empty( $args ) ) {
			$defaults = array(
			    'lastname' => '',
			    'firstname' => '',
			    'followup' => '',
			    'order_id' => '',
			    'file_attachment' => array(),
			);

			$args = wp_parse_args( $args, $defaults );
			extract( $args );

			if ( $order_id && ( $this->object = wc_get_order( $order_id ) ) ) {
                $this->recipient                      = $this->object->get_billing_email();
				$this->followup                       = $followup;
				$this->placeholders['{order_date}']   = wc_format_datetime( $this->object->get_date_created() );
				$this->placeholders['{order_number}'] = $this->object->get_order_number();
				$this->firstname = $firstname;
				$this->lastname = $lastname;
			}

			if ( $this->is_enabled() && $this->get_recipient() ) {

    		    $this->send( $this->get_recipient(), $this->get_subject(), $this->get_content(), $this->get_headers(), $file_attachment );

    		}
		}

	}

	

	public function get_content_html() {
		return wc_get_template_html( $this->template_html, array(
			'order'         => $this->object,
			'email_heading' => $this->get_heading(),
			'followup'      => $this->followup,
		    'firstname'      => $this->firstname,
		    'lastname'      => $this->lastname,
		    'sent_to_admin' => false,
			'plain_text'    => false,
			'email'			=> $this,
		), $this->template_base, $this->template_base );
	}

	

	public function get_content_plain() {
		return wc_get_template_html( $this->template_plain, array(
			'order'         => $this->object,
			'email_heading' => $this->get_heading(),
			'followup'      => $this->followup,
		    'firstname'      => $this->firstname,
		    'lastname'      => $this->lastname,
		    'sent_to_admin' => false,
			'plain_text'    => true,
			'email'			=> $this,
		), $this->template_base, $this->template_base );
	}

	

	public function send( $to, $subject, $message, $headers, $attachments ) {

	    add_filter( 'wp_mail_from', array( $this, 'get_from_address' ) );
	    add_filter( 'wp_mail_from_name', array( $this, 'get_from_name' ) );
	    add_filter( 'wp_mail_content_type', array( $this, 'get_content_type' ) );

	    $message = apply_filters( 'woocommerce_mail_content', $this->style_inline( $message ) );

	    $return  = $this->send_mail_with_attachment( $to, $subject, $message, $headers, $attachments );

	    remove_filter( 'wp_mail_from', array( $this, 'get_from_address' ) );
	    remove_filter( 'wp_mail_from_name', array( $this, 'get_from_name' ) );
	    remove_filter( 'wp_mail_content_type', array( $this, 'get_content_type' ) );

	    return $return;
	}

	public function send_mail_with_attachment($to, $subject, $body, $headers, $attachmentstring = array() ) {

        global $phpmailer;

        if ( ! ( $phpmailer instanceof PHPMailer ) ) {
			if ( ! class_exists('PHPMailer')) {
				require_once ABSPATH . WPINC . '/class-phpmailer.php';
			}
			if ( ! class_exists('SMTP') ) {
            	require_once ABSPATH . WPINC . '/class-smtp.php';
			}
            $phpmailer = new PHPMailer( true );
        }

        $phpmailer->CharSet = 'UTF-8';
        $phpmailer->ClearAllRecipients();
        $phpmailer->ClearAttachments();
        $phpmailer->ClearCustomHeaders();
        $phpmailer->ClearReplyTos();
        $phpmailer->setFrom( $this->get_from_address(), $this->get_from_name(), false );
        $phpmailer->Sender = $phpmailer->From;
        $phpmailer->addAddress($to);
        $phpmailer->isHTML(true);   
        $phpmailer->Subject = $subject;
        $phpmailer->Body    = $body;
        if( is_array($attachmentstring) && count($attachmentstring) > 0 ) {
            foreach ( $attachmentstring as $value ) {
                $phpmailer->AddStringAttachment($value['content'], $value['name'], 'base64', $value['mime']);
            }
        }
        $result = $phpmailer->Send();
        return $result;
    }
}

endif;

return new WC_Email_Gls_Label_Return();
