<?php


if (!defined('ABSPATH'))
    exit;



include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
if ( is_plugin_active( 'woocommerce/woocommerce.php' ) ) {

	

	function woocommerce_gls_relais_init() {

		if ( !class_exists('WC_Gls_Relais') && class_exists( 'WC_Gls_Table_Rate_Shipping' )) {

			

			class WC_Gls_Relais extends WC_Gls_Table_Rate_Shipping {

				public function __construct() {

					$this->id 					= 'gls_relais';
					$this->title 				= 'GLS Relais';
					$this->method_description 	= ''; 
					$this->method_title 		= __( WC_Gls::$carrier_definition[$this->id]['name'] );

					parent::__construct();

					$this->init();
				}

				function init() {

					
					$this->init_form_fields(); 
					$this->init_settings(); 

					$this->enabled = $this->settings['enabled'];
					$this->title = $this->settings['title']; 

					
					add_action( 'woocommerce_update_options_shipping_' . $this->id, array( $this, 'process_admin_options' ) );

					parent::init();
				}

				

				function init_form_fields() {

					if (isset(WC_Gls::$carrier_definition[$this->id]['delay'][get_locale()])) {
						$description 	= __( WC_Gls::$carrier_definition[$this->id]['delay'][get_locale()] ); 
					} else {
						$description 	= __( WC_Gls::$carrier_definition[$this->id]['delay']['default'] ); 
					}

					$this->form_fields = array(
						'enabled' => array(
							'title' 		=> __( 'Enable', 'woocommerce-gls' ),
							'type' 			=> 'checkbox',
							'label' 		=> __( 'Enable this shipping method', 'woocommerce-gls' ),
							'default' 		=> 'no',
						),
						'title' => array(
							'title' => __( 'Title', 'woocommerce' ),
							'type' => 'text',
							'description' => __( 'This controls the title which the user sees during checkout.', 'woocommerce-gls' ),
							'default' => __( $this->method_title, 'woocommerce-gls' )
						),
						'description' => array(
							'title' => __( 'Description', 'woocommerce-gls' ),
							'type' => 'textarea',
							'description' => __( 'This controls the description which the user sees during checkout.', 'woocommerce-gls' ),
							'default' => __( $description , 'woocommerce-gls')
						),
						'GLS_GLSRELAIS_XL_ONLY' => array(
							'title' 		=> __( 'XL GLS Relais', 'woocommerce-gls' ),
							'type' 			=> 'checkbox',
							'label' 		=> __( 'Display only XL GLS Relais', 'woocommerce-gls' ),
							'default' 		=> 'no',
						),
						'tax_status' => array(
							'title' 		=> __( 'Tax Status', 'woocommerce-gls' ),
							'type' 			=> 'select',
							'default' 		=> 'taxable',
							'options'		=> array(
								'taxable' 	=> __( 'Taxable', 'woocommerce-gls' ),
								'none' 		=> __( 'None', 'woocommerce-gls' ),
							),
						),
	                    'handling_fee' => array(
                            'title' 		=> __( 'Handling Fee', 'woocommerce-gls' ),
                            'description' 		=> __( 'Fee, excluding tax. Leave blank to disable.', 'woocommerce-gls' ),
                            'type' 			=> 'price',
                            'default' 		=> '0.00',
                            'desc_tip'     => true,
						),
						'add_price_mountain' => array(
                            'title' 		=> __( 'Additional price for mountain area', 'woocommerce-gls' ),
                            'type' 			=> 'price',
                            'default' 		=> '0.00',
						),
						'add_price_fr_island' => array(
                            'title' 		=> __( 'Additional price for French islands', 'woocommerce-gls' ),
                            'description' 		=> __( 'Corsica and DOM-TOM excluded.', 'woocommerce-gls' ),
                            'type' 			=> 'price',
                            'default' 		=> '0.00',
                            'desc_tip'     => true,
						),
						'add_price_corsica' => array(
                            'title' 		=> __( 'Additional price for Corsica', 'woocommerce-gls' ),
                            'type' 			=> 'price',
                            'default' 		=> '0.00',
						),
						'add_price_gb_island' => array(
                            'title' 		=> __( 'Additional price for British islands', 'woocommerce-gls' ),
                            'type' 			=> 'price',
                            'default' 		=> '0.00',
						),
						'add_price_sp_pt_island' => array(
                            'title' 		=> __( 'Additional price for Spanish and Portuguese islands', 'woocommerce-gls' ),
                            'description' 		=> __( 'Balearic Islands excluded.', 'woocommerce-gls' ),
                            'type' 			=> 'price',
                            'default' 		=> '0.00',
                            'desc_tip'     => true,
						),
						'add_price_islands' => array(
                            'title' 		=> __( 'Additional price for islands from other countries', 'woocommerce-gls' ),
                            'type' 			=> 'price',
                            'default' 		=> '0.00',
						),
                        'disable_corsica' => array(
                            'title' 		=> __( 'Corsica delivery zone', 'woocommerce-gls' ),
							'type' 			=> 'checkbox',
							'label' 		=> __( 'Disable delivery in Corsica', 'woocommerce-gls' ),
							'default' 		=> 'no',
						),
                        'disable_dom_tom' => array(
                            'title' 		=> __( 'DROM-COM delivery zone', 'woocommerce-gls' ),
							'type' 			=> 'checkbox',
							'label' 		=> __( 'Disable delivery in DROM-COM', 'woocommerce-gls' ),
							'default' 		=> 'no',
						),
						'zones_table' => array(
							'type'				=> 'zones_table',
						),
						'table_rates_table' => array(
							'type'				=> 'table_rates_table'
						),
					);
				}

                

                public function calculate_shipping($package = array())
                {
                	global $woocommerce;

                	$available_table_rates = $this->get_available_table_rates($package);
                	$table_rate = $this->pick_cheapest_table_rate($available_table_rates);

                	if ($this->settings['tax_status'] == 'none') {
                		$tax = false;
                	} else {
                		$tax = '';
                	}

                	if (!get_option( 'gls_settings_wslogin' ) || !get_option( 'gls_settings_wspwd' )) {
                		$table_rate = false;
                	}

                	if ($table_rate != false) {

                        if (WC_Gls::isDisableForZone($woocommerce->customer->get_shipping_country(), $woocommerce->customer->get_shipping_postcode(), $this->settings)) {
                            return false;
                        }

                		$cost = (float)$table_rate['cost'] + floatval(str_replace(',', '.', $this->settings['handling_fee']));

                        $extra_price = WC_Gls::getAdditionalPrice($woocommerce->customer->get_shipping_country(), $woocommerce->customer->get_shipping_postcode(), $this->settings);
                        if (is_numeric($extra_price) && (float)$extra_price > 0) {
                            $cost += (float)$extra_price;
                        }

						$rate = array(
                			'id' => $this->id,
                			'label' => $this->title,
                			'cost' => $cost,
                			'taxes' => $tax,
                			'calc_tax' => 'per_order'
						);

                		
                		$this->add_rate( $rate );
					}
                }

			}

		}

	}

	add_action( 'woocommerce_shipping_init', 'woocommerce_gls_relais_init' );

	function add_gls_relais_shipping_method( $methods ) {
		$methods[] = 'WC_Gls_Relais';
		return $methods;
	}

	add_filter( 'woocommerce_shipping_methods', 'add_gls_relais_shipping_method' );

	function woocommerce_gls_relais_checkout_controller() {

		global $woocommerce;

		
		if (isset($woocommerce->session->chosen_shipping_methods) &&
			is_array($woocommerce->session->chosen_shipping_methods) &&
			count($woocommerce->session->chosen_shipping_methods) > 0 &&
			$woocommerce->session->chosen_shipping_methods[0] == 'gls_relais') {

			$shipping_settings = get_option( 'woocommerce_gls_relais_settings' );
			if (!empty($shipping_settings)) {

				$error = array();

				

				$cart_carrier_detail = '';

				$customer_default_phone_mobile = $woocommerce->customer->get_billing_phone();

				$relay_points = '';

				


                
                if ($woocommerce->customer->get_shipping_country() != 'FR') {
                    $error = array('code' => '', 'message' => __( 'Service available only in France.', 'woocommerce-gls' ));
                } else {
                    
                    @ini_set('default_socket_timeout', '5');
                    $gls = new GlsController(array(
                        'GLS_WSLOGIN' => get_option( 'gls_settings_wslogin' ),
                        'GLS_WSPWD' => get_option( 'gls_settings_wspwd' ),
                    ));

                    $result = $gls->searchRelay($woocommerce->customer->get_shipping_country(), $woocommerce->customer->get_shipping_postcode(), $woocommerce->customer->get_shipping_city());

                    @ini_restore('default_socket_timeout');

                    
                    if (isset($result->exitCode->ErrorCode)) {

                        if ((int)$result->exitCode->ErrorCode == 998 || (int)$result->exitCode->ErrorCode == 999) {

                            
                            $error = array('code' => $result->exitCode->ErrorCode, 'message' => __( 'We haven\'t found any GLS Relais in your delivery area. Please expand your search.', 'woocommerce-gls' ));

                        } elseif ((int)$result->exitCode->ErrorCode == 0) {

                            $relay_points = $result->SearchResults;

                            
                            if($shipping_settings['GLS_GLSRELAIS_XL_ONLY'] == 'yes') {
                                foreach ($relay_points as $key => $value) {
                                    if (!empty($value->Parcelshop->Address->Name1) && substr($value->Parcelshop->Address->Name1, -2)  != 'XL') {
                                        unset($relay_points[$key]);
                                    }
                                }
                                $relay_points = array_values($relay_points);
                            }

                            if (count($relay_points) <= 0) {
                                $error = array('code' => 998, 'message' => __( 'We haven\'t found any GLS Relais in your delivery area. Please expand your search.', 'woocommerce-gls' ));
                            }
                        } else {
                            $error = array('code' => $result->exitCode->ErrorCode, 'message' => $result->exitCode->ErrorDscr);
                        }
                    } else {
                        
                        $error = array('code' => '', 'message' => __( 'Service temporarily unavailable, try again later.', 'woocommerce-gls' ));
                    }
                }

				$args = array(
					'trans_days' => array(
							'0' => __( 'Monday', 'woocommerce-gls' ),
							'1' => __( 'Tuesday', 'woocommerce-gls' ),
							'2' => __( 'Wednesday', 'woocommerce-gls' ),
							'3' => __( 'Thursday', 'woocommerce-gls' ),
							'4' => __( 'Friday', 'woocommerce-gls' ),
							'5' => __( 'Saturday', 'woocommerce-gls' ),
							'6' => __( 'Sunday', 'woocommerce-gls' )),
					'labels' => 'ABCDEFGHIJKLMNOPQRSTUVWXYZ',
					'only_xl' => (bool)($shipping_settings['GLS_GLSRELAIS_XL_ONLY'] == 'yes'),
					'relay_points' => $relay_points,
					'force_gsm' => true,
					'is_relay_carrier' => true,
					'error' => $error,
					'name_carrier' => $shipping_settings['title'],
					'id_carrier' => $woocommerce->session->chosen_shipping_methods[0],
					'current_relay' => ($cart_carrier_detail && !empty($cart_carrier_detail['parcel_shop_id']) ? $cart_carrier_detail['parcel_shop_id'] : ''),
					'current_customer_mobile' => ($cart_carrier_detail && !empty($cart_carrier_detail['customer_phone_mobile']) ? $cart_carrier_detail['customer_phone_mobile'] : $customer_default_phone_mobile),
					'customer_mobile_title' => __('Please fill in your mobile number, you will be notified by sms for the delivery', 'woocommerce-gls' ),
				);

				Nukium::load_view( 'front/shipping-extra-content', $args );
			}

		}
	}

	add_action( 'woocommerce_review_order_after_shipping', 'woocommerce_gls_relais_checkout_controller' );

}
