<?php


if (!defined('ABSPATH'))
    exit;

class WC_Gls_label {

    private $id = '';
    private $order_id = '';
    private $shipping_number = '';
    private $weight = 0;
    private $gls_product = '';
    private $delivery_date = '';
    private $reference1 = '';
    private $reference2 = '';
    private $date_add = '';

    public function __construct( $values = array() ) {
		if ( is_array( $values ) && count( $values ) > 0 ) {
            foreach ($values as $key => $value) {
                if (isset($this->{$key})) {
                    $this->{$key} = $value;
                }
            }
        }
    }

    static function get( $id ) {
		global $wpdb;

		$row = $wpdb->get_row( $wpdb->prepare( "SELECT gl.* FROM {$wpdb->prefix}woocommerce_gls_label gl WHERE gl.id=%d", $id ), ARRAY_A);
		if ( $row ) {
			return new WC_Gls_label( $row );
		}

		return false;
    }

    public function create( $data = array(), $return = false ) {
		global $wpdb;

        if (!isset($data['id'])) {

            foreach ($data as $key => $value) {
                if (!isset($this->{$key})) {
                    unset($data[$key]);
                }
            }

            
            $data['reference1'] = substr($data['reference1'], 5);
            $data['reference2'] = substr($data['reference2'], 5);

            $data['date_add'] = date('Y-m-d H:i:s');

            $wpdb->insert( $wpdb->prefix . 'woocommerce_gls_label', $data );

            if ( $return ) {
                return WC_Gls_label::get( $wpdb->insert_id );
            }
            return true;
        }

		return false;
	}
}