<?php
/**
 *	Module made by Nukium
 *
 *  @author    Nukium
 *  @copyright 2021 Nukium SAS
 *  @license   All rights reserved
 *
 * ███    ██ ██    ██ ██   ██ ██ ██    ██ ███    ███
 * ████   ██ ██    ██ ██  ██  ██ ██    ██ ████  ████
 * ██ ██  ██ ██    ██ █████   ██ ██    ██ ██ ████ ██
 * ██  ██ ██ ██    ██ ██  ██  ██ ██    ██ ██  ██  ██
 * ██   ████  ██████  ██   ██ ██  ██████  ██      ██
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; 
}

require dirname(__FILE__).'/../vendor/autoload.php';

if (!class_exists('Nukium'))
    require_once ( GLS_PLUGIN_PATH . 'lib/Nukium.php' );

include ( GLS_PLUGIN_PATH . 'lib/NkmHelper.php' );

if (!class_exists('GlsApi'))
    require_once ( GLS_PLUGIN_PATH . 'classes/GlsApi.php' );

if (!class_exists('WC_Gls_label')) {
    require_once ( GLS_PLUGIN_PATH . 'classes/class-gls-label.php' );
}

if ( ! class_exists( 'WC_Gls_Admin_Order_Label' ) ) :

class WC_Gls_Admin_Order_Label extends WC_Settings_API {

    public $id = 'gls_admin_order_label';

    public $errors = array();

    public $debug = false;

    public $tmpDirectory = 'tmp';

    public function __construct() {

        
        if (isset($_GET['page']) && $_GET['page'] == 'woocommerce-gls-label') {
            $this->init_settings();
        }
    }

    public function init() {

        add_submenu_page('woocommerce', __('GLS Labels', 'woocommerce-gls'), __('GLS Labels', 'woocommerce-gls'), 'manage_woocommerce', 'woocommerce-gls-label', array($this, 'display_page'), 8);
        add_action( 'admin_enqueue_scripts', 'wc_gls_admin_scripts_styles' );
        add_action( 'admin_notices', array($this, 'display_notices') );

        
        load_plugin_textdomain( 'woocommerce-gls', false, basename( dirname( __FILE__ ) ) . '/languages/' );

        $this->init_form_fields();
    }

    

    public function display_notices() {
        settings_errors( 'gls-order-error' );
    }

    public function display_page() {

        
        $this->init_settings();

        $this->admin_options();
    }

    

    public function init_form_fields() {

        $shipping_methods_options = array();
        
        
        
        
        
        
        foreach( WC_Gls::$carrier_definition as $key => $value ) {
            $shipping_methods_options[$key] = $value['name'];
        }

        $shipping_methods_options['not_gls'] = __( 'All other carriers', 'woocommerce-gls' );

        $order_state = wc_get_order_statuses();
        array_unshift($order_state, __( '(No change)', 'woocommerce-gls' ));

        $label_type_query = array();
        if (get_option( 'gls_settings_api_shop_return_service' ) === 'yes') {
            $label_type_query = array(
                'return' => __('Return', 'woocommerce-gls' ),
                'shipment' => __('Shipment', 'woocommerce-gls' )
            );
        } else {
            $label_type_query = array(
                'shipment' => __('Shipment', 'woocommerce-gls' )
            );
        }

        $this->form_fields    = array(
            'label_section_title' =>    array(
                'title' 	=> __( 'Delivery label printing', 'woocommerce-gls' ),
                'type' 		=> 'title',
                'id' 		=> 'gls-order-label-title',
                'description' => __('Generate your GLS shipping labels.', 'woocommerce-gls'),
            ),
            'label_carrier_filter' =>    array(
                'title' => __( 'Carriers', 'woocommerce-gls' ),
                'type' => 'multiselect',
                'options'     => $shipping_methods_options,
            ),
            'label_order_state_filter' =>    array(
                'title' => __( 'Order statuses', 'woocommerce-gls' ),
                'type' => 'multiselect',
                'options'     => wc_get_order_statuses(),
            ),
            'label_new_order_state'         => array(
                'title'       => __( 'Change order status to', 'woocommerce-gls' ),
                'type'        => 'select',
                'options'     => $order_state,
            ),
            'label_section_end' => array(
                'type' => 'label_section_end',
                'id' => 'generateLabelStep2',
                'title' => __( 'Next', 'woocommerce-gls' ),
            ),
            'return_label_section_title' =>    array(
                'title' 	=> __( 'Single delivery label printing', 'woocommerce-gls' ),
                'type' 		=> 'title',
                'id' 		=> 'gls-order-return-label-title',
                'description' => __('Generate your GLS shipping labels for a single order by searching for its ID or reference.', 'woocommerce-gls'),
            ),
            'label_single_type'         => array(
                'title'       => __( 'Label type', 'woocommerce-gls' ),
                'type'        => 'select',
                'options'     => $label_type_query,
            ),
            'label_order_id' => array(
                'title'             => __( 'Order ID', 'woocommerce-gls' ),
                'type'              => 'text',
                'default'           => '',
            ),
            'label_single_new_order_state'         => array(
                'title'       => __( 'Change order status to', 'woocommerce-gls' ),
                'type'        => 'select',
                'options'     => $order_state,
            ),
            'label_section_end_2' => array(
                'type' => 'label_section_end',
                'id' => 'generateLabelStep3Single',
                'title' => __( 'Next', 'woocommerce-gls' ),
            ),
        );

    }

    public function generate_label_section_end_html( $key, $data ) {

        $defaults  = array(
            'title'             => '',
            'class'             => '',
            'css'               => '',
        );
        $data = wp_parse_args( $data, $defaults );

        return Nukium::load_view('admin/order-label-btn', array('input_name' => $data['id'], 'input_value' => $data['title']), true);
    }

    public function admin_options() {

        
        ob_start();
        parent::admin_options();
        $buffer = ob_get_contents();
        @ob_end_clean();

        $admin_url = admin_url( 'admin.php?page=woocommerce-gls-label' );

        
        $weight_ratio = 1;
        if (get_option('woocommerce_weight_unit') == 'g') {
            $weight_ratio = 0.001;
        }

        if (isset($_POST['generateLabelStep2']) || isset($_POST['generateLabelStep3Cancel'])) {

            $error = true;

            $data_order = $this->_getOrders();
            if (!empty($data_order)) {
                

                $error = false;
                Nukium::load_view('admin/order-export-step2', array('orders' => $data_order, 'admin_url' => $admin_url));
            }

            if ($error) {
                add_settings_error( 'gls-order-error', 'gls-export-order-error', __('No order has been found.', 'woocommerce-gls'), 'error' );

                settings_errors( 'gls-order-error' );
                Nukium::load_view('admin/order-label', array(
                    'settings' => $buffer,
                    'admin_url' => $admin_url,
                ));
            }

        } elseif ( isset($_POST['generateLabelStep3']) || isset($_POST['generateLabelStep3Single']) ) {

            


            $error = true;

            $data_order = $this->_getOrders();
            if (!empty($data_order)) {

                $shipping_methods = WC()->shipping->get_shipping_methods();
                $shipping_methods_options = array();
                foreach ( $shipping_methods as $key => $value ) {
                    if ( strpos($value->id, 'gls') !== false  && $value->id != 'gls_13h' ) {
                        $shipping_methods_options[$key] = $value->method_title;
                    }
                }

                $data = array(
                    'list' => $data_order,
                    'carriers' => WC()->shipping->get_shipping_methods(),
                    'gls_carriers' => WC_Gls::$carrier_definition,
                    'cee_countries' => WC()->countries->get_european_union_countries(),
                    'shop_return_service' => get_option( 'gls_settings_api_shop_return_service' ),
                    'admin_url' => $admin_url,
                    'gls_label_single_type' => (isset($_POST['generateLabelStep3Single']) && isset($_POST['woocommerce_gls_admin_order_label_label_single_type']) ? $_POST['woocommerce_gls_admin_order_label_label_single_type'] : ''),
                    'weight_ratio' => $weight_ratio,
                );

                if ( isset($_POST['gls_print_label_from_order'])
                    && (int)$_POST['gls_print_label_from_order'] == 1
                    && isset($_POST['woocommerce_gls_admin_order_label_label_order_id'])
                    && (int)$_POST['woocommerce_gls_admin_order_label_label_order_id'] >= 0) {
                    $data['admin_url'] = admin_url( 'post.php?post='.$_POST['woocommerce_gls_admin_order_label_label_order_id'].'&action=edit' );
                }


                $error = false;
                Nukium::load_view('admin/order-label-step3', $data);
            }

            if ($error) {
                add_settings_error( 'gls-order-error', 'gls-export-order-error', __('No order has been found.', 'woocommerce-gls'), 'error' );

                settings_errors( 'gls-order-error' );
                Nukium::load_view('admin/order-label', array(
                    'settings' => $buffer,
                    'admin_url' => $admin_url,
                ));
            }

        } else {
            settings_errors( 'gls-order-error' );
            Nukium::load_view('admin/order-label', array(
                'settings' => $buffer,
                'admin_url' => $admin_url,
            ));
        }
    }

    

    private function _getOrders() {

        global $wpdb;

        $_orders = array();

        if ( isset($_POST['generateLabelStep3']) || isset($_POST['generateLabelStep3Single']) ) {
            if (isset($_POST['generateLabelStep3']) && (
                !isset($_POST['orderPost']) ||
                ( isset($_POST['orderPost']) && (!is_array($_POST['orderPost']) || (is_array($_POST['orderPost']) && count($_POST['orderPost']) <= 0)) )
                ) ) {

                add_settings_error( 'gls-order-error', 'gls-export-detail-order-error', __('Please select one or more order.', 'woocommerce-gls'), 'error' );
                return;

            } elseif ( isset($_POST['generateLabelStep3Single']) && isset($_POST['woocommerce_gls_admin_order_label_label_order_id']) && empty($_POST['woocommerce_gls_admin_order_label_label_order_id'])) {

                add_settings_error( 'gls-order-error', 'gls-export-detail-order-error', __('No order has been found.', 'woocommerce-gls'), 'error' );
                return;

            } elseif (!isset($_POST['orderPost']) && !isset($_POST['woocommerce_gls_admin_order_label_label_order_id'])) {

                add_settings_error( 'gls-order-error', 'gls-export-detail-order-error', __('An error occured, please try again.', 'woocommerce-gls'), 'error' );
                return;

            }
        }

        $label_order_state = $this->settings['label_order_state_filter'];
        $label_order_carrier = $this->settings['label_carrier_filter'];

        if ( ( is_array($label_order_state) && count($label_order_state) > 0 && is_array($label_order_carrier) && count($label_order_carrier) > 0 )
            || count($_orders) > 0
            || ( isset($_POST['generateLabelStep3Single']) && isset($_POST['woocommerce_gls_admin_order_label_label_order_id']) && (int)$_POST['woocommerce_gls_admin_order_label_label_order_id'] > 0 )
        ) {

            $sql = "SELECT p.*, gls.*, pm.meta_value AS shipping_country, oim.meta_value AS method_id FROM {$wpdb->posts} p
                        INNER JOIN {$wpdb->postmeta} pm ON p.id = pm.post_id
                        LEFT JOIN {$wpdb->prefix}woocommerce_order_items oi ON p.id = oi.order_id AND oi.order_item_type = 'shipping'
                        LEFT JOIN {$wpdb->prefix}woocommerce_order_itemmeta oim ON oim.order_item_id = oi.order_item_id AND oim.meta_key = 'method_id'
                        LEFT JOIN {$wpdb->prefix}woocommerce_gls_cart_carrier gls ON p.id = gls.order_id
                        WHERE p.post_type = 'shop_order'
                        AND pm.meta_key = '_shipping_country'";

            if (isset($_POST['generateLabelStep3']) && isset($_POST['orderPost']) && is_array($_POST['orderPost']) && count($_POST['orderPost']) > 0 ) {

                $sql .= ' AND p.ID IN ('.implode(',', $_POST['orderPost']).')';

            } elseif (isset($_POST['generateLabelStep3Single']) && isset($_POST['woocommerce_gls_admin_order_label_label_order_id']) && (int)$_POST['woocommerce_gls_admin_order_label_label_order_id'] > 0) {

                
                $sql .= ' AND p.ID = \''.(int)$_POST['woocommerce_gls_admin_order_label_label_order_id'] .'\'';

                if ( isset( $_POST['woocommerce_gls_admin_order_label_label_single_type'] ) && $_POST['woocommerce_gls_admin_order_label_label_single_type'] === 'return' ) {
                    $sql .= ' AND pm.meta_value = \'FR\'';
                }

                $sql .= ' LIMIT 1';

            } else {

                $sql .= ' AND p.post_status IN (\''.implode('\',\'', $label_order_state).'\')';

                if(in_array('not_gls', $label_order_carrier)) {
                    $sql .= ' AND (gls.shipping_method_id IS NULL';
                    if (count($label_order_carrier) > 1) {
                        $sql .= " OR gls.shipping_method_id IN ('".implode('\',\'', $label_order_carrier)."')";
                    }
                    $sql .= ')';
                } else {
                    $sql .= " AND gls.shipping_method_id IN ('".implode('\',\'', $label_order_carrier)."')";
                }

                $sql .= ' GROUP BY p.ID';
            }

            return $wpdb->get_results( $sql );
        }
        return false;
    }

    public function save() {
        if ( $this->get_post_data() && ( isset($_POST['generateLabelStep2']) || isset($_POST['generateLabelStep3Single']) ) ) {
            parent::process_admin_options();
        }
    }

    public function generate_label() {

        check_ajax_referer( 'gls-admin-ajax-request' );

        global $wpdb;

        $lang = explode('-', get_bloginfo('language'));
        $lang = $lang[0];

        $return = array(
            'hasError' => false,
            'errors' => '',
            'data' => '',
        );

        $api = new GlsApi(get_option( 'gls_settings_api_login' ), get_option( 'gls_settings_api_pwd' ), $lang, false, false);
        if ($api) {

            $order = wc_get_order((int)$_POST['order']);

            if ((int)$_POST['order'] > 0 && $order instanceof WC_Order) {

                ob_start();

                $this->init_settings();

                $id_carrier = null;
                if (isset($_POST['gls_service'])) {
                    $id_carrier = $_POST['gls_service'];
                }

                $is_gls_relais = false;
                $is_chezvousplus = false;
                $is_gls_13h = false;
                if( $id_carrier == 'gls_relais' ) {
                    $is_gls_relais = true;
                } elseif( $id_carrier == 'gls_chezvousplus' ) {
                    $is_chezvousplus = true;
                } elseif( $id_carrier == 'gls_13h' ) {
                    $is_gls_13h = true;
                }

                $old_is_gls_relais = false;
                foreach ($order->get_shipping_methods() as $shipping_method_id => $shipping_method) {
                    if ($shipping_method->get_method_id() == 'gls_relais' && !$is_gls_relais ) {
                        $old_is_gls_relais = true;
                    }
                }

                
                $customer_address = array(
                    'firstname' => $order->get_shipping_first_name(),
                    'lastname' => $order->get_shipping_last_name(),
                    'company' => $order->get_shipping_company(),
                    'address1' => $order->get_shipping_address_1(),
                    'address2' => $order->get_shipping_address_2(),
                    'city' => $order->get_shipping_city(),
                    'postcode' => $order->get_shipping_postcode(),
                    'country' => $order->get_shipping_country(),
                );

                
                $customer_invoice_address = array(
                    'firstname' => $order->get_billing_first_name(),
                    'lastname' => $order->get_billing_last_name(),
                    'company' => $order->get_billing_company(),
                    'address1' => $order->get_billing_address_1(),
                    'address2' => $order->get_billing_address_2(),
                    'city' => $order->get_billing_city(),
                    'postcode' => $order->get_billing_postcode(),
                    'country' => $order->get_billing_country(),
                );

                
                $shop_address = array(
                    'firstname' => '',
                    'lastname' => '',
                    'company' => get_option( 'gls_settings_api_shop_return_address_name' ),
                    'address1' => get_option( 'gls_settings_api_shop_return_address_address1' ),
                    'address2' => get_option( 'gls_settings_api_shop_return_address_address2' ),
                    'city' => get_option( 'gls_settings_api_shop_return_address_city' ),
                    'postcode' => get_option( 'gls_settings_api_shop_return_address_postcode' ),
                    'country' => get_option( 'gls_settings_api_shop_return_address_country' ),
                );

                if ($old_is_gls_relais) {
                    $customer_address = $customer_invoice_address;
                }

                if ($_POST['gls_label_single_type'] == 'return' || $_POST['gls_label_single_type'] == 'return_shipment') {
                    $delivery_adresses = $shop_address;
                    if ($is_gls_relais) {
                        $customer_address = $customer_invoice_address;
                    }
                } else {
                    $delivery_adresses = $customer_address;
                }

                $delivery_country_iso = $delivery_adresses['country'];
                $customer_country_iso = $customer_address['country'];

                if (!empty($delivery_adresses['company'])) {
                    $delivery_name = strtoupper(nkmStripAccents($delivery_adresses['company']));
                } else {
                    $delivery_name = strtoupper(nkmStripAccents($delivery_adresses['firstname'].' '.$delivery_adresses['lastname']));
                }

                if ($delivery_country_iso == 'IE') {
                    
                }

                
                $cart_carrier_detail = $wpdb->get_row("SELECT * FROM {$wpdb->prefix}woocommerce_gls_cart_carrier WHERE order_id = '" . $order->get_id() . "'");

                
                if (isset($_POST['mobile']) && !empty($_POST['mobile'])) {
                    $customer_mobile = preg_replace('/[^0-9\+]/', '', $_POST['mobile']);
                } elseif ($cart_carrier_detail && !empty($cart_carrier_detail->customer_phone_mobile)) {
                    $customer_mobile = preg_replace('/[^0-9\+]/', '', $cart_carrier_detail->customer_phone_mobile);
                } else {
                    $customer_mobile = preg_replace('/[^0-9\+]/', '', $order->get_billing_phone());
                }

                
                $tab_adresse = nkmCutSentenceMulti($delivery_adresses['address1'], 35);
                $reference1 = $reference2 = '';
                if ($_POST['reference1']) {
                    $reference1 = substr($_POST['reference1'], 0, 20);
                }
                if ($_POST['reference2']) {
                    $reference2 = substr($_POST['reference2'], 0, 20);
                }

                $data = array(
                    'shipperId' => get_option( 'gls_settings_api_customer_id' ).' '.get_option( 'gls_settings_api_contact_id' ),
                    'references' => array(
                        substr($_POST['reference1'], 0, 20),
                        substr($_POST['reference2'], 0, 20)
                    ),
                    'addresses' => array(
                        'delivery' => array(
                            'name1' => substr($delivery_name, 0, 35),
                            'street1' => strtoupper(nkmStripAccents($tab_adresse[0])),
                            'country' => $delivery_country_iso,
                            'zipCode' => $delivery_adresses['postcode'],
                            'city' => substr(strtoupper(nkmStripAccents($delivery_adresses['city'])), 0, 35),
                        ),
                    ),
                    'labelSize' => get_option( 'gls_settings_api_delivery_label_format' ),
                );

                if (isset($tab_adresse[1])) {
                    
                    $data['addresses']['delivery']['name2'] = strtoupper(nkmStripAccents($tab_adresse[1]));
                    
                    $data['addresses']['delivery']['name3'] = substr(strtoupper(nkmStripAccents($delivery_adresses['address2'])), 0, 35);
                } else {
                    
                    $data['addresses']['delivery']['name2'] = substr(strtoupper(nkmStripAccents($delivery_adresses['address2'])), 0, 35);
                }

                
                if(isset($_POST['delivery_date'])) {
                    $data['shipmentDate'] = $_POST['delivery_date'];
                }

                
                if (isset($_POST['incoterm'])) {
                    $data['incoterm'] = $_POST['incoterm'];
                }

               
               if ($_POST['gls_label_single_type'] == 'return' || $_POST['gls_label_single_type'] == 'return_shipment') {

                    if (!empty($customer_address['company'])) {
                        $customer_name = strtoupper(nkmStripAccents($customer_address['company']));
                    } else {
                        $customer_name = strtoupper(nkmStripAccents($customer_address['firstname'].' '.$customer_address['lastname']));
                    }

                    
                    $tab_adresse = nkmCutSentenceMulti($customer_address['address1'], 35);

                    
                    $data['addresses']['pickup'] = array(
                        'name1' => substr($customer_name, 0, 35),
                        'street1' => strtoupper(nkmStripAccents($tab_adresse[0])),
                        'country' => $customer_country_iso,
                        'zipCode' => $customer_address['postcode'],
                        'city' => substr(strtoupper(nkmStripAccents($customer_address['city'])), 0, 35),
                        'email' => $order->get_billing_email(),
                        'phone' => preg_replace('/[^0-9\+]/', '', $order->get_billing_phone()),
                        'mobile' => $customer_mobile,
                    );

                    if (isset($tab_adresse[1])) {
                        
                        $data['addresses']['pickup']['name2'] = strtoupper(nkmStripAccents($tab_adresse[1]));
                        
                        $data['addresses']['pickup']['name3'] = substr(strtoupper(nkmStripAccents($customer_address['address2'])), 0, 35);
                    } else {
                        
                        $data['addresses']['pickup']['name2'] = substr(strtoupper(nkmStripAccents($customer_address['address2'])), 0, 35);
                    }

                } else {

                    
                    $data['addresses']['delivery']['email'] = $order->get_billing_email();
                    $data['addresses']['delivery']['phone'] = preg_replace('/[^0-9\+]/', '', $order->get_billing_phone());
                    $data['addresses']['delivery']['mobile'] = $customer_mobile;
                }

                
                $data = $this->formatData($data);

                

                $return_label = false;
                if (isset($_POST['return_label']) && $_POST['return_label'] && !$is_gls_relais && !$is_chezvousplus && !$is_gls_13h) {

                    $return_label = true;

                    
                    $tab_adresse = nkmCutSentenceMulti($shop_address['address1'], 35);

                    $data['addresses']['return'] = array(
                        'name1' => substr($shop_address['company'], 0, 35),
                        'street1' => strtoupper(nkmStripAccents($tab_adresse[0])),
                        'country' => $shop_address['country'],
                        'zipCode' => $shop_address['postcode'],
                        'city' => substr(strtoupper(nkmStripAccents($shop_address['city'])), 0, 35),
                    );

                    if (isset($tab_adresse[1])) {
                        
                        $data['addresses']['return']['name2'] = strtoupper(nkmStripAccents($tab_adresse[1]));
                        
                        $data['addresses']['return']['name3'] = substr(strtoupper(nkmStripAccents($shop_address['address2'])), 0, 35);
                    } else {
                        
                        $data['addresses']['return']['name2'] = substr(strtoupper(nkmStripAccents($shop_address['address2'])), 0, 35);
                    }
                }

                
                if ($_POST['gls_label_single_type'] == 'return' || $_POST['gls_label_single_type'] == 'return_shipment') {
                    $return_label = true;
                }

                if (!$return_label) {
                    $data['addresses']['delivery']['contact'] = substr(strtoupper(nkmStripAccents($customer_address['firstname'].' '.$customer_address['lastname'])), 0, 35);
                }

                $parcels = array();
                $parcels_return = array();
                $total_weight = 0;
                foreach ($_POST['weight'] as $key => $value) {

                    if (is_numeric($value) && !empty($value)) {

                        $tmp = array(
                            'weight' => floatval(str_replace(',', '.', $value)),
                        );
                        $total_weight += floatval(str_replace(',', '.', $value));

                        if($return_label) {

                            $service_detail = array('name' => 'shopreturnservice');

                            
                            
                            if ($_POST['gls_label_single_type'] == 'return' || $_POST['gls_label_single_type'] == 'return_shipment') {
                                $shopreturn_infos = array();
                                $shopreturn_infos[] = array('name' => 'returnonly', 'value' => 'Y');
                                $service_detail['infos'] = $shopreturn_infos;
                            } else {
                                
                                array_push($parcels_return, $tmp);
                            }

                            $tmp['services'] = array();
                            array_push($tmp['services'], $service_detail);

                        } elseif ($is_gls_relais) {

                            $relais_infos = array();
                            $relais_infos[] = array('name' => 'parcelshopid', 'value' => (!empty($cart_carrier_detail->parcel_shop_id) ? $cart_carrier_detail->parcel_shop_id : ''));

                            $tmp['services'] = array();
                            array_push($tmp['services'], array(
                                'name' => 'shopDeliveryService',
                                'infos' => $relais_infos,
                            ));

                        } elseif ($is_chezvousplus) {

                            $tmp['services'] = array();
                            array_push($tmp['services'], array(
                                'name' => 'flexDeliveryService',
                            ));

                        } elseif ($is_gls_13h) {

                            $gls13h_infos = array();
                            $gls13h_infos[] = array('name' => 'deliverytime', 'value' => '13:00');

                            $tmp['services'] = array();
                            array_push($tmp['services'], array(
                                'name' => 'express',
                                'infos' => $gls13h_infos,
                            ));

                        }

                        array_push($parcels, $tmp);

                    } else {
                        $return['hasError'] = true;
                        $return['errors'] = sprintf(__('Wrong weight on package #%s', 'woocommerce-gls'), $key+1);
                        break;
                    }

                }
                $data['parcels'] = $parcels;

                if (is_array($parcels_return) && count($parcels_return) > 0) {
                    $data['returns'] = $parcels_return;
                 }

                 if (!$return['hasError']) {

                    $result = $api->post('shipments', $data);

                    if ($result === false) {

                        $return['hasError'] = true;
                        $return['errors'] = '';
                        foreach ($api->error as $error) {
                            if (!empty($return['errors'])) {
                                $return['errors'] .= "\r\n";
                            }
                            if (is_array($error) && isset($error['message'])) {
                                $return['errors'] .= $error['message'] . ' - ' . __('Error code:', 'woocommerce-gls') . ' ' . $error['code'];
                            } else {
                                $return['errors'] .= $error;
                            }
                        }

                    } else {

                        

                        $old_tracking_number = '';
                        $pattern = '/'.str_replace(array('@', '/', '?'), array('', '\/', '\?'), WC_Gls::$trackingUrl).'([^"]+)/';

                        foreach ($order->get_customer_order_notes() as $note) {
                            if (preg_match($pattern, $note->comment_content, $matches)) {
                                $old_tracking_number = $matches[1];
                                break;
                            }
                        }

                        $shippingNumbers = array();
                        if (!empty($old_tracking_number)) {
                            $shippingNumbers = explode(',', $old_tracking_number);
                        }

                        if (isset($result->parcels) && is_array($result->parcels) && count($result->parcels) > 0) {

                            foreach ($result->parcels as $p) {
                                $shippingNumbers[] = $p->trackId;
                            }

                            
                            if (isset($result->returns) && is_array($result->returns) && count($result->returns) > 0) {
                                foreach ($result->returns as $p) {
                                    $shippingNumbers[] = $p->trackId;
                                }
                            }

                            $tracking_number = implode(',', $shippingNumbers);

                            

                            $note = __('You can track your package using the following link:', 'woocommerce-gls');
                            $link = str_replace('@', $tracking_number, WC_Gls::$trackingUrl);
                            $note .= ' <a href="'.$link.'">'.$link.'</a>';

                            if (!$order->add_order_note($note, 1, true)) {
                                $return['hasError'] = true;
                                $return['errors'] = __('The customer order note cannot be created.', 'woocommerce-gls');
                            } else {
                                

                                $shipping_methods = WC()->shipping->get_shipping_methods();
                                $gls_shipping_methods = array();
                                foreach ( $shipping_methods as $key => $value ) {
                                    if ( strpos($value->id, 'gls') !== false ) {
                                        $gls_shipping_methods[$value->id] = $value->method_title;
                                    }
                                }

                                $current_shipping_methods = $order->get_shipping_methods();
                                if (is_array($current_shipping_methods) && count($current_shipping_methods) > 0) {

                                    foreach ($order->get_shipping_methods() as $shipping_method_id => $shipping_method) {

                                        if (!empty($id_carrier) && $shipping_method->get_method_id() != $id_carrier) {

                                            if (isset($gls_shipping_methods[$id_carrier])) {
                                                wc_update_order_item($shipping_method_id, array('order_item_name' => $gls_shipping_methods[$id_carrier]));
                                            }
                                            wc_update_order_item_meta($shipping_method_id, 'method_id', $id_carrier);
                                            wc_update_order_item_meta($shipping_method_id, 'instance_id', 0);

                                            
                                            if ($old_is_gls_relais) {
                                                $order->set_shipping_first_name($customer_invoice_address['firstname']);
                                                $order->set_shipping_last_name($customer_invoice_address['lastname']);
                                                $order->set_shipping_company($customer_invoice_address['company']);
                                                $order->set_shipping_address_1($customer_invoice_address['address1']);
                                                $order->set_shipping_address_2($customer_invoice_address['address2']);
                                                $order->set_shipping_city($customer_invoice_address['city']);
                                                $order->set_shipping_state('');
                                                $order->set_shipping_postcode($customer_invoice_address['postcode']);
                                                $order->set_shipping_country($customer_invoice_address['country']);
                                                $order->save();
                                            }

                                            
                                            $gls_product = WC_Gls::get_gls_product($id_carrier, $delivery_country_iso);
                                            $query = $wpdb->query( $wpdb->prepare( "
                                                UPDATE {$wpdb->prefix}woocommerce_gls_cart_carrier
                                                SET customer_phone_mobile='%s', shipping_method_id='%s', gls_product='%s', parcel_shop_id = NULL, name = NULL, address1 = NULL,
                                                    address2 = NULL, postcode = NULL, city = NULL, phone = NULL, phone_mobile = NULL, country = NULL, parcel_shop_working_day = NULL
                                                WHERE order_id=%d
                                                " , $customer_mobile, $id_carrier, $gls_product, (int)$order->get_id()) );
                                        }
                                    }

                                } else {
                                    
                                    if (!empty($id_carrier)) {

                                        $item_id = wc_add_order_item((int)$order->get_id(), array(
                                            'order_item_name' => (isset($gls_shipping_methods[$id_carrier]) ? $gls_shipping_methods[$id_carrier] : ''),
                                            'order_item_type' => 'shipping',

                                        ));
                                        if (!empty($item_id)) {
                                            wc_add_order_item_meta($item_id, 'method_id', $id_carrier);
                                            wc_add_order_item_meta($item_id, 'instance_id', 0);
                                        }

                                        
                                        $gls_product = WC_Gls::get_gls_product($id_carrier, $delivery_country_iso);
                                        if (!empty($cart_carrier_detail)) {
                                            $query = $wpdb->query( $wpdb->prepare( "
                                                UPDATE {$wpdb->prefix}woocommerce_gls_cart_carrier
                                                SET customer_phone_mobile='%s', shipping_method_id='%s', gls_product='%s', parcel_shop_id = NULL, name = NULL, address1 = NULL,
                                                    address2 = NULL, postcode = NULL, city = NULL, phone = NULL, phone_mobile = NULL, country = NULL, parcel_shop_working_day = NULL
                                                WHERE order_id=%d
                                                " , $customer_mobile, $id_carrier, $gls_product, (int)$order->get_id()) );
                                        } else {
                                            $query = $wpdb->query( $wpdb->prepare( "
                                                INSERT INTO {$wpdb->prefix}woocommerce_gls_cart_carrier
                                                (customer_phone_mobile, shipping_method_id, gls_product, order_id, session_id, customer_id)
                                                VALUES ('%s', '%s', '%s', %d, '%s', '%s')
                                                " , $customer_mobile, $id_carrier, $gls_product, (int)$order->get_id(), $order->get_customer_id(), $order->get_customer_id()) );
                                        }

                                    }
                                }

                                if ($_POST['gls_label_single_type'] != 'return' && $_POST['gls_label_single_type'] != 'return_shipment') {
                                    
                                    if (!isset($gls_product)) {
                                        $gls_product = WC_Gls::get_gls_product($id_carrier, $delivery_country_iso);
                                    }
                                    foreach ($result->parcels as $k => $p) {
                                        
                                        if (isset($data['parcels'][$k])) {
                                            $glsLabel = new WC_Gls_label();
                                            $glsLabel->create(array(
                                                'order_id' => $order->id,
                                                'shipping_number' => $p->trackId,
                                                'weight' => $data['parcels'][$k]['weight'],
                                                'gls_product' => $gls_product,
                                                'delivery_date' => $data['shipmentDate'],
                                                'reference1' => $reference1,
                                                'reference2' => $reference2,
                                            ));
                                        }
                                    }
                                }
                            }

                        } else {

                            $return['hasError'] = true;
                            $return['errors'] = __('An error occured , please contact technical support.', 'woocommerce-gls');

                        }

                        if (!$return['hasError']) {

                            if ($_POST['gls_label_single_type'] == 'return' || $_POST['gls_label_single_type'] == 'shipment') {
                                $new_order_state = $this->settings['label_single_new_order_state'];
                            } else {
                                $new_order_state = $this->settings['label_new_order_state'];
                            }

                            

                            if(!empty($new_order_state) && $new_order_state != $order->get_status()) {
                                $order->update_status($new_order_state);
                            }

                            

                            if ($_POST['gls_label_single_type'] == 'return'
                                && get_option( 'gls_settings_api_shop_return_email_alert' )
                                && isset($result->location)
                                && !empty($result->location)
                                && isset($result->labels)
                                && is_array($result->labels)
                                && count($result->labels) > 0) {

                                

                                $note = __('Return package tracking link :', 'woocommerce-gls') . ' <a href="'.$result->location.'">'.$result->location.'</a>';
                                if (!$order->add_order_note($note, 0, true)) {
                                    $return['hasError'] = true;
                                    $return['errors'] = __('The admin order return note cannot be created.', 'woocommerce-gls');
                                }

                                $file_attachment = array();
                                $i = 0;
                                foreach ($result->labels as $label) {
                                    $i++;
                                    $file_attachment[] = array(
                                        'name' => $order->get_order_number().'-return'.$i.'.pdf',
                                        'content' => base64_decode($label),
                                        'mime' => 'application/pdf',
                                    );
                                }

                                do_action( 'woocommerce_gls_generate_single_return_label' , array(
                                    'lastname' => $customer_invoice_address['lastname'],
                                    'firstname' => $customer_invoice_address['firstname'],
                                    'followup' => $result->location,
                                    'order_id' => $order->get_id(),
                                    'file_attachment' => $file_attachment,
                                ) );

                            }

                            $return['data'] = $result;
                        }
                    }
                }

                if (isset($_POST['local_print']) && $_POST['local_print'] == 1 && $return['hasError'] === false) {
                    if (isset($return['data']->labels) && is_array($return['data']->labels)) {
                        $i = 0;
                        $dirname = GLS_PLUGIN_PATH . $this->tmpDirectory . '/';
                        foreach ($return['data']->labels as $label) {
                            $i++;
                            $pdf = fopen($dirname.'order-'.$order->id.'-label-'.($return_label?'return-':'').$i. '.pdf', 'w');
                            fwrite($pdf, base64_decode($label));
                            fclose($pdf);
                        }
                    }
                    $return['data'] = 'local_print';
                }

                ob_end_clean();

                header('Content-Type: application/json');
                wp_die(
                    wp_json_encode($return)
                );

            } else {
                
            }

        } else {
            
        }

        return false;
    }

    public function generate_all_labels() {

        check_ajax_referer( 'gls-admin-ajax-request' );

        $return = array(
            'hasError' => false,
            'errors' => '',
        );

        $dirname = GLS_PLUGIN_PATH . $this->tmpDirectory . '/';

        
        if (isset($_POST['prepareMerge']) && $_POST['prepareMerge'] == 1) {
            foreach (scandir($dirname) as $file) {
                if ($file != '.' && $file != '..' && $file != 'index.php') {
                    unlink($dirname.$file);
                }
            }
        } elseif (isset($_POST['mergePDF']) && $_POST['mergePDF'] == 1) {
            $filename = 'orders-'.date('dmY-His').'.pdf';

            if (get_option( 'gls_settings_api_delivery_label_format' ) == 'A5') {
                $orientation = 'horizontal';
            } else {
                $orientation = 'vertical';
            }

            $pdf = new \Jurosh\PDFMerge\PDFMerger;
            $i = 0;
            foreach (scandir($dirname) as $file) {
                if ($file != '.' && $file != '..' && $file != 'index.php') {
                    $pdf->addPDF($dirname . $file, 'all', $orientation);
                    $i++;
                }
            }
            if ($i > 0) {
                $pdf->merge('file', $dirname . $filename);
                $return['data'] = array('pdf' => $filename);
            } else {
                $return['hasError'] = true;
            }
        }

        header('Content-Type: application/json');
        wp_die(
            wp_json_encode($return)
        );
    }

    

    private function formatData($data)
    {
        
        if (isset($data['addresses']['delivery']['zipCode']) && isset($data['addresses']['delivery']['country'])) {
            switch ($data['addresses']['delivery']['country']) {
                case 'LV':
                    $data['addresses']['delivery']['zipCode'] = preg_replace('/[^0-9]/', '', $data['addresses']['delivery']['zipCode']);
                    break;
                default:
                    break;
            }
        }
        if (isset($data['addresses']['pickup']['zipCode']) && isset($data['addresses']['pickup']['country'])) {
            switch ($data['addresses']['pickup']['country']) {
                case 'LV':
                    $data['addresses']['pickup']['zipCode'] = preg_replace('/[^0-9]/', '', $data['addresses']['pickup']['zipCode']);
                    break;
                default:
                    break;
            }
        }
        return $data;
    }

}

endif;

$gls_admin_order_label = new WC_Gls_Admin_Order_Label();
add_action( 'admin_menu', array( $gls_admin_order_label, 'init' ) );
add_action( 'admin_init', array( $gls_admin_order_label, 'save' ) );
add_action( 'wp_ajax_gls_generate_label', array( $gls_admin_order_label, 'generate_label' ) );
add_action( 'wp_ajax_nopriv_gls_generate_label', array( $gls_admin_order_label, 'generate_label' ) );
add_action( 'wp_ajax_gls_generate_all_labels', array( $gls_admin_order_label, 'generate_all_labels' ) );
add_action( 'wp_ajax_nopriv_gls_generate_all_labels', array( $gls_admin_order_label, 'generate_all_labels' ) );
