<?php
/**
 *  Module made by Nukium
 *
 *  @author    Nukium
 *  @copyright 2021 Nukium SAS
 *  @license   All rights reserved
 *
 * ███    ██ ██    ██ ██   ██ ██ ██    ██ ███    ███
 * ████   ██ ██    ██ ██  ██  ██ ██    ██ ████  ████
 * ██ ██  ██ ██    ██ █████   ██ ██    ██ ██ ████ ██
 * ██  ██ ██ ██    ██ ██  ██  ██ ██    ██ ██  ██  ██
 * ██   ████  ██████  ██   ██ ██  ██████  ██      ██
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

class GlsApi
{
	

	private	$rest_api_url_test = 'https://api-qs.gls-group.eu/public/v1/';
	private	$rest_api_url = 'https://api.gls-group.eu/public/v1/';

	

	private $api_login = '';

	

	private $api_pwd = '';

	

	private $debug = false;

    

    private $force_debug = false;

	

	private $test_mode = false;

	

	private $lang = 'en';

	

	public $error = array();

	public function __construct($login, $pwd, $_lang = '', $test_mode = false, $debug = false)
	{
	    if (!extension_loaded('curl')) {
            return false;
	    }

	    if (!empty($login) && !empty($pwd)) {
	        $this->api_login = $login;
		    $this->api_pwd = $pwd;
		} else {
		    return false;
		}

        if (empty($_lang)) {
            
            $_lang = $this->lang;
        }

		if (strlen($_lang) == 2) {
		    $this->lang = $_lang;
		} else {
		    
		    return false;
		}

		$this->debug = $debug;

        if ($this->force_debug) {
            $this->debug = true;
        }

		$this->test_mode = $test_mode;
	}

	private function _executeRequest($_method, $_resource, $_body = '')
	{
        $credentials = $this->api_login.':'.$this->api_pwd;

	    if ($_body) {
	        $data = json_encode($_body);
	    } else {
	        $data = '';
	    }

	    
	    if ($this->test_mode) {
	        $url = $this->rest_api_url_test;
	    } else {
	        $url = $this->rest_api_url;
	    }
	    $session = curl_init($url.$_resource);

	    $curl_options = array(
	        CURLOPT_RETURNTRANSFER => 1,
	        CURLOPT_TIMEOUT => 60,
	        CURLOPT_ENCODING => 'gzip,deflate',
	        CURLOPT_HTTPHEADER => array(
	            'Accept-Language: ' . $this->lang,
	            'Accept: application/json',
	            'Content-Type: application/json',
	            'Authorization: Basic ' . base64_encode($credentials)
	        ),
	        CURLOPT_CUSTOMREQUEST => $_method,
            
            
	    );

		if (get_option( 'gls_settings_ssl_patch' ) === 'yes') {
			
            $curl_options[CURLOPT_SSLVERSION] = CURL_SSLVERSION_TLSv1_2;
            
            $curl_options[CURLOPT_SSL_CIPHER_LIST] = 'DEFAULT@SECLEVEL=1';
		}

	    if(!empty($_body)) {
	        $curl_options[CURLOPT_POSTFIELDS] = $data;
	    }

	    curl_setopt_array($session, $curl_options);
	    $response = curl_exec($session);

	    if ($response === false) {
	        trigger_error(curl_error($session));
            $this->error[] = 'Bad response (CURL Error: ' . curl_error($session) . ')';
	    }

	    if (empty($this->error)) {

            if($this->debug) {
                $this->printDebug('HTTP REQUEST HEADER', curl_getinfo($session, CURLINFO_HEADER_OUT));
        	    if(!empty($_body)) {
        	        $this->printDebug('DATA SENT', $curl_options[CURLOPT_POSTFIELDS]);
        	    }
            }
            

            $result = json_decode($response);
            if (isset($result->errors) && is_array($result->errors) && count($result->errors) > 0) {
                foreach ($result->errors as $value) {
                    $this->error[] = array('code' => $value->exitCode, 'message' => $value->description);
                }
            }














            curl_close($session);
	    }

        if (count($this->error) > 0) {
            if ($this->debug) {
                foreach ($this->error as $value) {
                    $this->printDebug('Error', $value);
                }
            }
            return false;
        } else {
            return $result;
        }
	}

	

	public function post($_resource, $_body = '')
	{
        return $this->_executeRequest('POST', $_resource, $_body);
	}

    

    public function get($_resource)
    {
        return $this->_executeRequest('GET', $_resource);
    }

	

	public function printDebug($_title, $_content)
	{
	    if (is_array($_content)) {
            foreach ($_content as $key => $value) {
        	    echo '<div style="display:table;background:#232832;font-size:1rem;padding:10px">';
        	    echo '<h6 style="color:#00b7f3;font-size:1rem;margin:0">'.$key.'</h6>';
        	    echo '<pre style="color:#fff">'.$value.'</pre>';
        	    echo '</div>';
            }
	    } else {
	        echo '<div style="display:table;background:#232832;font-size:1rem;padding:10px">';
	        echo '<h6 style="color:#00b7f3;font-size:1rem;margin:0">'.$_title.'</h6>';
	        echo '<pre style="color:#fff">'.$_content.'</pre>';
	        echo '</div>';
	    }
	}

    

    public function reset()
    {
        $this->error = array();
    }
}