/*
 *	Module made by Nukium
 *
 *  @author    Nukium
 *  @copyright 2021 Nukium SAS
 *  @license   All rights reserved
 *
 * ███    ██ ██    ██ ██   ██ ██ ██    ██ ███    ███
 * ████   ██ ██    ██ ██  ██  ██ ██    ██ ████  ████
 * ██ ██  ██ ██    ██ █████   ██ ██    ██ ██ ████ ██
 * ██  ██ ██ ██    ██ ██  ██  ██ ██    ██ ██  ██  ██
 * ██   ████  ██████  ██   ██ ██  ██████  ██      ██
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
var glsmap,infowindow,bounds;

jQuery(document).ready(function() {

	if (typeof jQuery.fn.tipTip === "function") {
        var tiptip_args = {
            'attribute': 'data-tip',
            'fadeIn': 50,
            'fadeOut': 50,
            'delay': 200
        };

	    jQuery( '.tips, .help_tip, .woocommerce-help-tip' ).tipTip( tiptip_args );
    }

	jQuery('#woocommerce_gls_admin_order_export_export_automation, #woocommerce_gls_admin_order_import_import_automation').each(function() {

		if(jQuery(this).is( ":checked" )) {
			jQuery(this).closest('.form-table').next('.automation-help').show();
		} else {
			jQuery(this).closest('.form-table').next('.automation-help').hide();
		}

	});

	jQuery('#woocommerce_gls_admin_order_export_export_automation, #woocommerce_gls_admin_order_import_import_automation').on('change', function() {

		if(jQuery(this).is( ":checked" )) {
			jQuery(this).closest('.form-table').next('.automation-help').stop(true, true).slideDown();
		} else {
			jQuery(this).closest('.form-table').next('.automation-help').stop(true, true).slideUp();
		}

	});

	jQuery('.copy-button').on('click', function(e) {

		e.preventDefault();
		var input = jQuery(this).parent().prev('.copy-input');
		jQuery(input).prop('disabled', false).select();
		document.execCommand('copy');
		jQuery(input).prop('disabled', true);

	});

	if(jQuery('#cb-select-all-1').length > 0) {
		jQuery('#cb-select-all-1').trigger('click');
	}

	// Web API shop return address
	jQuery( 'input#gls_settings_api_shop_return_service' ).on('change', function() {

		if(jQuery(this).is( ':checked' )) {

			jQuery('input.gls_settings-return-address').each( function () {
				jQuery(this).closest('tr').stop(true, false).slideDown();
			});
			jQuery('.gls-settings-return-address').stop(true, false).slideDown();

		} else {

			jQuery('input.gls_settings-return-address').each( function () {
				jQuery(this).closest('tr').stop(true, false).slideUp();
			});
			jQuery('.gls-settings-return-address').stop(true, false).slideUp();


		}

    }).change();


	// Web API shop return address
	jQuery( 'input#gls_settings_gmaps_enable' ).on('change', function() {

		if(jQuery(this).is( ':checked' )) {

            jQuery('input.gls_settings-google-maps').closest('tr').nextAll('tr').slice(0, 2).stop(true, false).slideDown();


		} else {

			jQuery('input.gls_settings-google-maps').closest('tr').nextAll('tr').slice(0, 2).stop(true, false).slideUp();

		}

    }).change();

	jQuery('body').on('click', '#orderGenerateLabelStep3', function(e) {
        e.preventDefault();
        var status = jQuery('#GLS_LABEL_SINGLE_NEW_ORDER_STATE').val();
        jQuery('input[name="woocommerce_gls_admin_order_label_label_single_new_order_state"]').val(status);
        jQuery('#gls-admin-order-print-label').submit();
    });

    gls_init_dialog();

    jQuery('body').on('click', '#orderGlsChangeRelayModal', function(e) {
        e.preventDefault();
        jQuery('#glsChangeRelayModal').dialog('open');
    });

    jQuery('body').on('click', '#updateTrackingState', function(e) {

        e.preventDefault();

        jQuery('#updateTrackingState').prop( "disabled", true );
        jQuery('.gls-tracking-information .notice').remove();

        jQuery.ajax({
            type: 'POST',
            url: gls_var.ajaxurl,
            cache: false,
            dataType: 'json',
            context: this,
            data: {
                action: 'gls_update_tracking_state',
                gls_id_order: jQuery("#updateTrackingState").attr('data-order-id'),
            }
        }).done(function(data) {

            if(!data.result) {
                jQuery('.gls-tracking-information').prepend('<div class="notice notice-error" role="alert"><p>'+data.message+'</p></div>');
            } else {
                if (data.current_state != '' && data.current_state_date != '') {
                    jQuery('.gls-tracking-current-state').html(data.current_state);
                    jQuery('.gls-tracking-current-state-date').html(data.current_state_date);
                    if(typeof jQuery('.gls-tracking-information-empty-template').html() !== 'undefined' && !jQuery('.gls-tracking-information-empty-template').is(':visible')) {
                        jQuery('.gls-tracking-information-empty-template').show();
                        jQuery('.gls-tracking-information-unavailable').remove();
                    }
                }
                if (data.message != '') {
                    jQuery('.gls-tracking-information').prepend('<div class="notice notice-info" role="alert"><p>'+data.message+'</p></div>')
                } else {
                    jQuery('.gls-tracking-information').prepend('<div class="notice notice-success" role="alert"><p>'+gls_var.gls_js_update_success+'</p></div>')
                }
            }
            jQuery('#updateTrackingState').prop( "disabled", false );

        }).fail(function() {
            jQuery('.gls-tracking-information').prepend('<div class="notice notice-error" role="alert"><p>'+gls_var.gls_js_general_error+'</p></div>');
            jQuery('#updateTrackingState').prop( "disabled", false );
            return false;
        });

    });

	jQuery('body').on('click', '.gls-search-form-toggler', function(e) {
		e.preventDefault();
		jQuery('#gls-search-form').slideToggle();
    });

	/**
	 * Recherche de nouveaux GLS Relais
	 */
	jQuery('body').on('click', '.gls-search-relay', function(e) {

		e.preventDefault();
		if(jQuery('#gls-search').val()) {

			if(typeof jQuery.fn.block !== 'undefined') {
				jQuery('.gls-relay-list').addClass( 'processing' ).block({
					message: null,
					overlayCSS: {
						background: '#fff',
						opacity: 0.6
					}
				});
			}

			jQuery.ajax({
				type: 'POST',
				url: gls_var.ajaxurl,
				cache: false,
		        dataType: 'json',
		        context: this,
		        data: {action: 'gls_search_relay', search: jQuery('#gls-search').val(), from_admin_order: 1}
			}).done(function(data) {
				if(typeof jQuery.fn.unblock !== 'undefined') {
					jQuery('.gls-relay-list').removeClass( 'processing' ).unblock();
				}
				if(!data.result) {
					alert(data.message);
				} else {
					jQuery('.gls-relay-list').html(data.point_relay_tpl).show();
					jQuery('.gls-relay-map').show();
					initGlsMap();
					jQuery('.gls-container > .alert').hide();
				}
			}).fail(function() {
				alert(gls_var.gls_js_general_error)
				return false;
			});

		} else {
			alert(gls_var.gls_js_search_error)
		}
		return false;

	});

	jQuery('body').on('keypress', '#gls-search', function(e) {
		if(e.which == 13) {
			e.preventDefault();
	        jQuery('.gls-search-relay').trigger('click');
	    }
	});

	jQuery('body').on('search', '#gls-search', function(e) {
		e.preventDefault();
        jQuery('.gls-search-relay').trigger('click');
	});

    // Action on checkout change or loaded
	jQuery(document.body).on('items_saved', function(params) {
        setTimeout( function () {
            //refresh meta-boxes GLS
            jQuery.ajax({
                type: 'POST',
                url: gls_var.ajaxurl,
                cache: false,
                dataType: 'json',
                context: this,
                data: {
                    action: 'gls_refresh_meta_box',
                    gls_id_order: jQuery('#glsWCOrderId').val(),
                }
            }).done(function(data) {
                if(!data.result) {
                    alert(data.message);
                } else {
                    jQuery('#woocommerce-gls-order-label div.inside').html(data.content);

                    gls_init_dialog();
                }
            }).fail(function() {
                alert(gls_var.gls_js_general_error)
                return false;
            });
        } , 400);
	});

});

function gls_init_dialog() {

    if (jQuery('#glsChangeRelayModal').length > 0) {

        jQuery('#glsChangeRelayModal').dialog({
            autoOpen: false,
            width: 900,
            modal: true,
            closeOnEscape: true,
            draggable: false,
            resizable: false,
            open: function( event, ui ) {
                setTimeout(function() {
                    initGlsMap();
                }, 500);
            }
            ,buttons: [
                {
                    text: gls_var.btn_cancel_title,
                    click: function() {
                        jQuery('#glsChangeRelayModal').dialog( 'close' );
                    },
                },
                {
                    text: gls_var.btn_save_title,
                    click: function() {
                        if(typeof jQuery.fn.block !== 'undefined') {
                            jQuery('.ui-dialog-buttonpane').addClass( 'processing' ).block({
                                message: null,
                                overlayCSS: {
                                    background: '#fff',
                                    opacity: 0.6
                                }
                            });
                        }

                        jQuery.ajax({
                            type: 'POST',
                            url: gls_var.ajaxurl,
                            cache: false,
                            dataType: 'json',
                            context: this,
                            data: {
                                action: 'gls_change_relay_point',
                                gls_relay_id: jQuery("input[name='gls_relay']:checked").val(),
                                gls_id_order: jQuery("input[name='woocommerce_gls_admin_order_label_label_order_id']").val(),
                            }
                        }).done(function(data) {
                            if(!data.result) {
                                if(typeof jQuery.fn.unblock !== 'undefined') {
                                        jQuery('.ui-dialog-buttonpane').removeClass( 'processing' ).unblock();
                                }
                                alert(data.message);
                            } else {
                                document.location.reload();
                            }
                        }).fail(function() {
                            if(typeof jQuery.fn.unblock !== 'undefined') {
                                    jQuery('.ui-dialog-buttonpane').removeClass( 'processing' ).unblock();
                            }
                            alert(gls_var.gls_js_general_error)
                            return false;
                        });
                    }
                }
            ]
        });
    }

}
/**
 * Initialisation de la carte
 */
function initGlsMap() {

	if(document.getElementById('gls-map')) {

        if(gls_var.google_maps_enable && typeof google !== 'undefined') {

            glsmap = new google.maps.Map(document.getElementById('gls-map'), {
                zoom: 12,
                maxZoom: 18,
                mapTypeId: google.maps.MapTypeId.ROADMAP,
                fullscreenControl: false
            });

            infowindow = new google.maps.InfoWindow({ });

            bounds = new google.maps.LatLngBounds();

            //__ Si des marqueurs google maps existent, on les ajoute sur la carte
            if(typeof glsGmapsMarkers !== 'undefined') {
                if(glsGmapsMarkers.length > 0) {
                    glsGmapsMarkers.forEach(function(item, index) {
                        addGlsMapMarker(new google.maps.LatLng(item['lat'], item['lng']), item['name'], item['id'], item['infos']);
                    });
                }
            }

            glsmap.fitBounds(bounds);

        } else {

            if(typeof glsmap !== 'undefined') {
                glsmap.remove();
            }
            glsmap = L.map('gls-map', {
                zoom: 12,
                scrollWheelZoom: false
            });
            L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'
            }).addTo(glsmap);

            bounds = [];

            //__ Si des marqueurs existent, on les ajoute sur la carte
            if(typeof glsGmapsMarkers !== 'undefined') {
                if(glsGmapsMarkers.length > 0) {
                    glsGmapsMarkers.forEach(function(item, index) {
                        addGlsMapMarker([item['lat'], item['lng']], item['name'], item['id'], item['infos']);
                    });
                }
            }

            glsmap.fitBounds(new L.LatLngBounds(bounds));
            setTimeout(function() {
                glsmap.invalidateSize();
            }, 50);

        }

	}

}

/**
 * Ajout des GLS Relais sur la carte
 */
function addGlsMapMarker(lat_lng, name, id, infos) {

    if (gls_var.google_maps_enable) {

        var marker = new google.maps.Marker({
            position: lat_lng,
            label: id,
            map: glsmap
        });

        bounds.extend(marker.position);

        google.maps.event.addListener(marker, 'click', (function (marker, name, infos) {

            return function () {
                infowindow.setContent('<div id="content" style="padding-right:17px;">'+
                    '<div id="firstHeading" class="h6">' + name + '</div>'+
                    '<div id="bodyContent" style="width:180px">' + infos + '</div>'+
                '</div>');
                infowindow.open(glsmap, marker);
            }

        })(marker, name, infos));

    } else {

        var marker = L.marker(lat_lng, {
            title: id,
            alt: name,
            icon: L.divIcon({
                className: 'nkmgls-osmap-marker-icon',
                html: '<div class="gls-marker-wrapper" data-marker-id="' + id + '"><img class="gls-marker-img" src="' + gls_var.gls_marker_path + 'gls-marker.png" alt="' + id + '"></div>',
                iconSize:[54,40],
                iconAnchor:[27,40],
                popupAnchor:[0,-36]
            })
        }).addTo(glsmap);
        marker.bindPopup('<div id="content" style="padding-right:17px;">'+
            '<div id="firstHeading" class="h6">' + name + '</div>'+
            '<div id="bodyContent" style="width:180px">' + infos + '</div>'+
        '</div>');

        bounds.push(lat_lng);

    }
}
