<?php


if (!defined('ABSPATH'))
    exit;



include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
if ( is_plugin_active( 'woocommerce/woocommerce.php' ) ) {

	class WC_Gls_Table_Rate_Shipping extends WC_Shipping_Method {

		public function __construct() {

			$this->table_rate_option            = $this->id.'_table_rates';
			$this->last_table_rate_id_option    = $this->id.'_last_table_rate_id';
			$this->zones_option                 = $this->id.'_zones';
			$this->last_zone_id_option          = $this->id.'_last_zone_id';

			
			$this->get_zones();
			$this->get_last_zone_id();

			$this->get_table_rates();
			$this->get_last_table_rate_id();
		}

		public function init() {

			add_action( 'woocommerce_update_options_shipping_' . $this->id, array( $this, 'process_zones' ) );
			add_action( 'woocommerce_update_options_shipping_' . $this->id, array( $this, 'process_table_rates' ) );

		}

		public function table_rate_construct() {

			$this->table_rate_option            = $this->id.'_table_rates';
			$this->last_table_rate_id_option    = $this->id.'_last_table_rate_id';
			$this->zones_option                 = $this->id.'_zones';
			$this->last_zone_id_option          = $this->id.'_last_zone_id';

			
			$this->get_zones();
			$this->get_last_zone_id();

			$this->get_table_rates();
			$this->get_last_table_rate_id();
		}

		public function table_rate_init() {

			add_action( 'woocommerce_update_options_shipping_' . $this->id, array( $this, 'process_zones' ) );
			add_action( 'woocommerce_update_options_shipping_' . $this->id, array( $this, 'process_table_rates' ) );

		}

    	public function generate_options() {

    		$option_arr = array();

    		

    		foreach($this->zones as $option) {
    			$option_arr['table_rate_zone'][esc_attr($option['id'])] = esc_js($option['name']);
    		}

    		$option_arr['table_rate_zone']['0'] = __( 'Everywhere Else', 'woocommerce-gls');

    		

    		foreach (WC()->countries->get_shipping_countries() as $id => $value) {
    			$option_arr['country'][esc_attr($id)] = esc_js($value);
    		}

    		

    		$option_arr['rate_basis']['weight'] = sprintf(__( 'Weight (%s)', 'woocommerce-gls' ), get_option('woocommerce_weight_unit'));
    		$option_arr['rate_basis']['price'] = sprintf(__( 'Total (%s)', 'woocommerce-gls' ), get_woocommerce_currency_symbol());

    		return $option_arr;
    	}

    	

    	public function admin_options() {
    		?>
            <script type="text/javascript">

                var glstablerateoptions = <?php echo json_encode($this->generate_options()); ?>;

                function generateSelectOptionsHtml(options, selected) {
                    var html;
                    var selectedHtml;

                    for (var key in options) {
                        var value = options[key];

                        if (selected instanceof Array) {
                            if (selected.indexOf(key) != -1) {
                                selectedHtml = ' selected="selected"';
                            } else {
                                selectedHtml = '';
                            }
                        } else {
                            if (key == selected) {
                                selectedHtml = ' selected="selected"';
                            } else {
                                selectedHtml = '';
                            }
                        }

                        html += '<option value="' + key +'"' + selectedHtml + '>' + value + '</option>';
                    }

                    return html;
                }
            </script>
            <style>
                .debug-col {
                    display: none;
                }
                table.shippingrows tr th {
                    padding-left: 10px;
                }
                .zone td {
                    vertical-align: top;
                }
                .zone textarea {
                    width: 100%;
                }

            </style>
            <?php
            parent::admin_options();
		}

		

		public function generate_zones_table_html() {
			ob_start();
			?>
            <tr valign="top">
                <th scope="row" class="titledesc"><?php _e( 'Shipping Zones', 'woocommerce-gls' ); ?></th>
                <td class="forminp" id="<?php echo $this->id; ?>_zones">
                    <p style="padding-bottom: 10px;"><?php _e( 'After adding a shipping zone, hit "Save changes" so that it appears as an option in the table rate section.', 'woocommerce-gls' ); ?></p>
                    <table class="shippingrows widefat" cellspacing="0">
                        <col style="width:0%">
                        <col style="width:0%">
                        <col style="width:100%;">
                        <thead>
                            <tr>
                                <th class="check-column"><input type="checkbox"></th>
                                <!--<th class="debug-col"><?php _e( 'ID', 'woocommerce-gls' ); ?></th>-->
                                <th><?php _e( 'Name', 'woocommerce-gls' ); ?> <a class="tips" data-tip="<?php _e( 'Shipping zone name, will appear in table rates table.', 'woocommerce-gls' ); ?>">[?]</a></th>
                                <th><?php _e( 'Countries', 'woocommerce-gls' ); ?> <a class="tips" data-tip="<?php _e( 'Add one or more countries that are part of this shipping zone.', 'woocommerce-gls' ); ?>">[?]</a></th>
                            </tr>
                        </thead>
                        <tfoot>
                            <tr>
                                <th colspan="3"><a href="#" class="add button"><?php _e( 'Add Shipping Zone', 'woocommerce-gls' ); ?></a> <a href="#" class="remove button"><?php _e( 'Delete Selected Zones', 'woocommerce-gls' ); ?></a></th>
                            </tr>
                        </tfoot>
                        <tbody class="zones">
                            <tr class="zone">
                                <th></th>
                                <!--<td class="debug-col">0</td>-->
                                <td><div style="width: 200px;"><?php _e( 'Default Zone (everywhere else)', 'woocommerce-gls' ); ?></div></td>
                                <td><em><?php _e( 'All allowed countries', 'woocommerce-gls' ); ?></em></td>
                            </tr>
                        </tbody>
                    </table>
                    <script type="text/javascript">

                        var lastZoneId = <?php echo $this->last_zone_id; ?>;

                        <?php
                        foreach ($this->zones as $zone):
                            $js_array = json_encode($zone);
                            echo "jQuery('#{$this->id}_zones table tbody tr:last').before(addZoneRowHtml(false, {$js_array}));\n";
                        endforeach;
                        ?>

                        function addZoneRowHtml(isNew, rowArr) {

                            if (isNew) {
                                lastZoneId++;
                                rowArr = {};
                                rowArr['id'] = lastZoneId;
                                rowArr['name'] = '';
                                rowArr['country'] = '';
                                rowArr['type'] = 'country';
                                rowArr['include'] = '';
                                rowArr['exclude'] = '';
                                rowArr['enabled'] = '1';
                            }

                            var size = jQuery('#<?php echo $this->id; ?>_zones tbody .zone').length;
                            var html = '\
                                    <tr class="zone">\
                                        <input type="hidden" name="<?php echo $this->id; ?>_zone_id[' + size + ']" value="' + rowArr['id'] + '" />\
                                        <input type="hidden" name="<?php echo $this->id; ?>_zone_type[' + size + ']" value="' + rowArr['type'] + '" />\
                                        <input type="hidden" name="<?php echo $this->id; ?>_zone_include[' + size + ']" value="' + rowArr['include'] + '" />\
                                        <input type="hidden" name="<?php echo $this->id; ?>_zone_exclude[' + size + ']" value="' + rowArr['exclude'] + '" />\
                                        <input type="hidden" name="<?php echo $this->id; ?>_zone_enabled[' + size + ']" value="' + rowArr['enabled'] + '" />\
                                        <th class="check-column"><input type="checkbox" name="select" /></th>\
                                        <!--<td class="debug-col">\
                                            ' + rowArr['id'] + '\
                                        </td>-->\
                                        <td>\
                                            <input type="text" name="<?php echo $this->id; ?>_zone_name[' + size + ']" value="' + rowArr['name'] + '" size="30" placeholder="" />\
                                        </td>\
                                        <td style="overflow:visible;">\
                                            <select multiple="multiple" name="<?php echo $this->id; ?>_zone_country[' + size + '][]" class="multiselect chosen_select">\
                                                ' + generateSelectOptionsHtml(glstablerateoptions['country'], rowArr['country']) + '\
                                            </select>\
                                        </td>\
                                    </tr>';
                            return html;
                        }

                        jQuery(function() {

                            jQuery('#<?php echo $this->id; ?>_zones').on( 'click', 'a.add', function(){

                                jQuery('#<?php echo $this->id; ?>_zones table tbody tr:last').before(addZoneRowHtml(true, false));

                                if (jQuery().chosen) {
                                    jQuery("select.chosen_select").chosen({
                                        width: '350px',
                                        disable_search_threshold: 5
                                    });
                                } else {
                                    jQuery("select.chosen_select").select2();
                                }

                                return false;
                            });

                            // Remove row
                            jQuery('#<?php echo $this->id; ?>_zones').on( 'click', 'a.remove', function(){

                                var answer = confirm("<?php _e( 'Delete the selected zones?', 'woocommerce-gls' ); ?>");
                                if (answer) {
                                    jQuery('#<?php echo $this->id; ?>_zones table tbody tr th.check-column input:checked').each(function(i, el){
                                        jQuery(el).closest('tr').remove();
                                    });
                                }
                                return false;
                            });

                        });
                    </script>
                </td>
            </tr>
            <?php
            return ob_get_clean();
        }

        

        public function generate_table_rates_table_html() {
            ob_start();
            ?>
            <tr valign="top">
                <th scope="row" class="titledesc"><?php _e( 'Table Rates', 'woocommerce-gls' ); ?></th>
                <td class="forminp" id="<?php echo $this->id; ?>_table_rates">
                    <table class="shippingrows widefat" cellspacing="0">
                        <col style="width:0%">
                        <col style="width:0%">
                        <col style="width:0%">
                        <col style="width:0%">
                        <col style="width:0%">
                        <col style="width:100%;">
                        <thead>
                            <tr>
                                <th class="check-column"><input type="checkbox"></th>
                                <th class="debug-col"><?php _e( 'ID', 'woocommerce-gls' ); ?></th>
                                <th><?php _e( 'Zone', 'woocommerce-gls' ); ?> <a class="tips" data-tip="<?php _e( 'Shipping zone, as defined in Shipping Zones table.', 'woocommerce-gls' ); ?>">[?]</a></th>
                                <th><?php _e( 'Condition', 'woocommerce-gls' ); ?> <a class="tips" data-tip="<?php _e( 'Choose which metric to base your table rate on.', 'woocommerce-gls' ); ?>">[?]</a></th>
                                <th><?php _e( 'Min', 'woocommerce-gls' ); ?> <a class="tips" data-tip="<?php _e( 'Minimum, in decimal format. Inclusive.', 'woocommerce-gls' ); ?>">[?]</a></th>
                                <th><?php _e( 'Max', 'woocommerce-gls' ); ?> <a class="tips" data-tip="<?php _e( 'Maximum, in decimal format. Inclusive. To impose no upper limit, use *".', 'woocommerce-gls' ); ?>">[?]</a></th>
                                <th><?php _e( 'Cost', 'woocommerce-gls' ); ?> <a class="tips" data-tip="<?php _e( 'Cost, excluding tax.', 'woocommerce-gls' ); ?>">[?]</a></th>
                            </tr>
                        </thead>
                        <tfoot>
                            <tr>
                                <th colspan="7"><a href="#" class="add button"><?php _e( 'Add Table Rate', 'woocommerce-gls' ); ?></a> <a href="#" class="remove button"><?php _e( 'Delete Selected Rates', 'woocommerce-gls' ); ?></a></th>
                            </tr>
                        </tfoot>
                        <tbody class="table_rates">

                        </tbody>
                    </table>
                    <script type="text/javascript">

                        var lastTableRateId = <?php echo $this->last_table_rate_id; ?>;

                        <?php
                        foreach ($this->table_rates as $table_rate):
                            $js_array = json_encode($table_rate);
                            echo "jQuery(addTableRateRowHtml(false, {$js_array})).appendTo('#{$this->id}_table_rates table tbody');\n";
                        endforeach;
                        ?>

                        function addTableRateRowHtml(isNew, rowArr) {

                            if (isNew) {
                                lastTableRateId++;
                                rowArr = {};
                                rowArr['id'] = lastTableRateId;
                                rowArr['zone'] = '<?php echo (!empty($this->zones[0]['id'])) ? $this->zones[0]['id'] : 0; ?>';
                                rowArr['basis'] = 'weight';
                                rowArr['min'] = '0';
                                rowArr['max'] = '*';
                                rowArr['cost'] = '0';
                                rowArr['enabled'] = '1';
                            }

                            var size = jQuery('#<?php echo $this->id; ?>_table_rates tbody .table_rate').length;
                            var html = '\
                                    <tr class="table_rate">\
                                        <input type="hidden" name="<?php echo $this->id; ?>_table_rate_id[' + size + ']" value="' + rowArr['id'] + '" />\
                                        <input type="hidden" name="<?php echo $this->id; ?>_table_rate_enabled[' + size + ']" value="' + rowArr['enabled'] + '" />\
                                        <th class="check-column"><input type="checkbox" name="select" /></th>\
                                        <td class="debug-col">\
                                            ' + rowArr['id'] + '\
                                        </td>\
                                        <td>\
                                            <select name="<?php echo $this->id; ?>_table_rate_zone[' + size + ']">\
                                                ' + generateSelectOptionsHtml(glstablerateoptions['table_rate_zone'], rowArr['zone']) + '\
                                            </select>\
                                        </td>\
                                        <td>\
                                            <select name="<?php echo $this->id; ?>_table_rate_basis[' + size + ']">\
                                                ' + generateSelectOptionsHtml(glstablerateoptions['rate_basis'], rowArr['basis']) + '\
                                            </select>\
                                        </td>\
                                        <td>\
                                            <input type="text" name="<?php echo $this->id; ?>_table_rate_min[' + size + ']" value="' + rowArr['min'] + '" placeholder="0" size="4" />\
                                        </td>\
                                        <td>\
                                            <input type="text" name="<?php echo $this->id; ?>_table_rate_max[' + size + ']" value="' + rowArr['max'] + '" placeholder="*" size="4" />\
                                        </td>\
                                        <td>\
                                            <input type="text" name="<?php echo $this->id; ?>_table_rate_cost[' + size + ']" value="' + rowArr['cost'] + '" placeholder="<?php echo wc_format_localized_price( 0 ); ?>" size="4" class="wc_input_price" />\
                                        </td>\
                                    </tr>';
                            return html;
                        }

                        jQuery(function() {

                            jQuery('#<?php echo $this->id; ?>_table_rates').on( 'click', 'a.add', function(){

                                jQuery(addTableRateRowHtml(true, false)).appendTo('#<?php echo $this->id; ?>_table_rates table tbody');

                                return false;
                            });

                            // Remove row
                            jQuery('#<?php echo $this->id; ?>_table_rates').on( 'click', 'a.remove', function(){
                                var answer = confirm("<?php _e( 'Delete the selected rates?', 'woocommerce-gls' ); ?>");
                                if (answer) {
                                    jQuery('#<?php echo $this->id; ?>_table_rates table tbody tr th.check-column input:checked').each(function(i, el){
                                        jQuery(el).closest('tr').remove();
                                    });
                                }
                                return false;
                            });

                        });
                    </script>
                </td>
            </tr>
            <?php
            return ob_get_clean();
        }

        

        public function process_zones()
        {
        	
        	$zone_id = array();
        	$zone_name = array();
        	$zone_country = array();
        	$zone_include = array();
        	$zone_exclude = array();
        	$zone_type = array();
        	$zone_enabled = array();

        	$zones = array();

        	if ( isset( $_POST[ $this->id . '_zone_id'] ) ) $zone_id = array_map( 'wc_clean', $_POST[ $this->id . '_zone_id'] );
        	if ( isset( $_POST[ $this->id . '_zone_name'] ) ) $zone_name = array_map( 'wc_clean', $_POST[ $this->id . '_zone_name'] );
        	if ( isset( $_POST[ $this->id . '_zone_country'] ) ) $zone_country =  $_POST[ $this->id . '_zone_country'];
        	if ( isset( $_POST[ $this->id . '_zone_include'] ) ) $zone_include = array_map( 'wc_clean', $_POST[ $this->id . '_zone_include'] );
        	if ( isset( $_POST[ $this->id . '_zone_exclude'] ) ) $zone_exclude = array_map( 'wc_clean', $_POST[ $this->id . '_zone_exclude'] );
        	if ( isset( $_POST[ $this->id . '_zone_type'] ) ) $zone_type = array_map( 'wc_clean', $_POST[ $this->id . '_zone_type'] );
        	if ( isset( $_POST[ $this->id . '_zone_enabled'] ) ) $zone_enabled = array_map( 'wc_clean', $_POST[ $this->id . '_zone_enabled'] );

        	
        	$values = $zone_id;
        	ksort( $values );
        	$value = end( $values );
        	$key = key( $values );

        	for ( $i = 0; $i <= $key; $i++ ) {
        		if ( isset( $zone_id[ $i ] )
        				&& ! empty( $zone_name[ $i ] )
        				&& ! empty( $zone_country[ $i ] )
        				&& isset( $zone_include[ $i ] )
        				&& isset( $zone_exclude[ $i ] )
        				&& isset( $zone_type[ $i ] )
        				&& isset( $zone_enabled[ $i ] ) ){

        					
        					$zones[] = array(
        							'id' => $zone_id[ $i ],
        							'name' => $zone_name[ $i ],
        							'country' => $zone_country[ $i ],
        							'include' => $zone_include[ $i ],
        							'exclude' => $zone_exclude[ $i ],
        							'type' => $zone_type[ $i ],
        							'enabled' => $zone_enabled[ $i ],
        					);
        		}
        	}

        	if ( (!empty($zone_id[$key]))
        			&& ($zone_id[$key] > $this->last_zone_id)
        			&& (is_numeric($zone_id[$key]))) {
        				$highest_zone_id = $zone_id[$key];
        				update_option( $this->last_zone_id_option, $highest_zone_id );
        			}

        			update_option( $this->zones_option, $zones );

        			$this->get_zones();

        }

        

        public function get_zones()
        {
        	$this->zones = array_filter( (array) get_option( $this->zones_option ) );
        }

        

        public function get_last_zone_id()
        {
        	$this->last_zone_id = (int)get_option( $this->last_zone_id_option );
        }

        

        public function process_table_rates()
        {
        	
        	$table_rate_id = array();
        	$table_rate_zone = array();
        	$table_rate_basis = array();
        	$table_rate_min = array();
        	$table_rate_max = array();
        	$table_rate_cost = array();
        	$table_rate_enabled = array();

        	$table_rates = array();

        	if ( isset( $_POST[ $this->id . '_table_rate_id'] ) ) $table_rate_id = array_map( 'wc_clean', $_POST[ $this->id . '_table_rate_id'] );
        	if ( isset( $_POST[ $this->id . '_table_rate_zone'] ) ) $table_rate_zone = array_map( 'wc_clean', $_POST[ $this->id . '_table_rate_zone'] );
        	if ( isset( $_POST[ $this->id . '_table_rate_basis'] ) ) $table_rate_basis = array_map( 'wc_clean', $_POST[ $this->id . '_table_rate_basis'] );
        	if ( isset( $_POST[ $this->id . '_table_rate_min'] ) )   $table_rate_min   = array_map( 'stripslashes', $_POST[ $this->id . '_table_rate_min'] );
        	if ( isset( $_POST[ $this->id . '_table_rate_max'] ) )   $table_rate_max   = array_map( 'stripslashes', $_POST[ $this->id . '_table_rate_max'] );
        	if ( isset( $_POST[ $this->id . '_table_rate_cost'] ) )  $table_rate_cost  = array_map( 'stripslashes', $_POST[ $this->id . '_table_rate_cost'] );
        	if ( isset( $_POST[ $this->id . '_table_rate_enabled'] ) ) $table_rate_enabled = array_map( 'wc_clean', $_POST[ $this->id . '_table_rate_enabled'] );

        	
        	$values = $table_rate_id;
        	ksort( $values );
        	$value = end( $values );
        	$key = key( $values );

        	for ( $i = 0; $i <= $key; $i++ ) {
        		if ( isset( $table_rate_id[ $i ] )
        				&& isset( $table_rate_zone[ $i ] )
        				&& isset( $table_rate_basis[ $i ] )
        				&& isset( $table_rate_min[ $i ] )
        				&& isset( $table_rate_max[ $i ] )
        				&& isset( $table_rate_cost[ $i ] )
        				&& isset( $table_rate_enabled[ $i ] ) ) {

        					$table_rate_cost[ $i ] = wc_format_decimal( $table_rate_cost[$i] );

        					
        					$table_rates[] = array(
        							'id' => $table_rate_id[ $i ],
        							'zone' => $table_rate_zone[ $i ],
        							'basis' => $table_rate_basis[ $i ],
        							'min' => $table_rate_min[ $i ],
        							'max' => $table_rate_max[ $i ],
        							'cost' => $table_rate_cost[ $i ],
        							'enabled' => $table_rate_enabled[ $i ],
        					);
        				}
        	}

        	if ( (!empty($table_rate_id[$key]))
        			&& ($table_rate_id[$key] > $this->last_table_rate_id)
        			&& (is_numeric($table_rate_id[$key]))) {
        				$highest_table_rate_id = $table_rate_id[$key];
        				update_option( $this->last_table_rate_id_option, $highest_table_rate_id );
        			}

        			update_option( $this->table_rate_option, $table_rates );

        			$this->get_table_rates();

        }

        

        public function get_table_rates()
        {
        	$this->table_rates = array_filter( (array) get_option( $this->table_rate_option ) );
        }

        

        public function get_last_table_rate_id()
        {
        	$this->last_table_rate_id = (int)get_option( $this->last_table_rate_id_option );
        }

        

        public function get_available_zones($package)
        {

        	$destination_country = $package['destination']['country'];
        	$available_zones = array();

        	foreach ($this->zones as $zone):
        	if ( !empty($zone['country']) && in_array($destination_country, $zone['country']) ) {
        		$available_zones[] = $zone['id'];
        	}
        	endforeach;

        	if (empty($available_zones)) {
        		$found = false;
        		foreach (WC()->countries->get_shipping_countries() as $id => $value):
        		if ($destination_country == $id) {
        			$found = true;
        		}
        		endforeach;
        		if ($found) {
        			$available_zones[] = '0'; 
        		}
        	}

        	return $available_zones;
        }

        

        public function get_available_table_rates($package)
        {
        	global $woocommerce;

        	$available_zones = $this->get_available_zones($package);
        	$available_table_rates = array();
        	$weight = $this->get_cart_weight($package);
        	if (WC()->version >= '3.2.0') {
        		$cart_taxes = array_sum($woocommerce->cart->get_cart_contents_taxes());
        	} else {
        		$cart_taxes = array_sum($woocommerce->cart->taxes);
        	}
        	$total = $woocommerce->cart->cart_contents_total + $cart_taxes;

        	foreach ($this->table_rates as $table_rate) {
        		
        		$zone_pass = (in_array($table_rate['zone'], $available_zones));

        		
        		if ($table_rate['basis'] == 'weight') {
        			$weight_pass = (($weight >= $table_rate['min']) && ($this->is_less_than($weight, $table_rate['max'])));
        		} else {
        			$weight_pass = true;
        		}

        		
        		if ($table_rate['basis'] == 'price') {
        			$total_pass = (($total >= $table_rate['min']) && ($this->is_less_than($total, $table_rate['max'])));
        		} else {
        			$total_pass = true;
        		}

        		
        		if ($zone_pass && $weight_pass && $total_pass) {
        			$available_table_rates[] = $table_rate;
        		}
        	}
        	return $available_table_rates;
        }

        

        public function get_cart_weight($package) {
        	$total = 0;
        	foreach ( $package['contents'] as $cart_item_key => $cart_item ) {
        		$product = $cart_item['data'];
        		$total += ((float)$product->get_weight() * $cart_item['quantity']);
        	}
        	return $total;
        }

        

        public function is_less_than($value, $max)
        {
        	if ($max == '*')
        		return true;
        		else
        			return ($value <= $max);
        }

        

        public function find_by_id($array, $id)
        {
        	foreach($array as $a):
        	if ($a['id'] == $id)
        		return $a;
        		endforeach;
        		return false;
        }

        

        public function pick_cheapest_table_rate($table_rates)
        {
        	$cheapest = false;
        	foreach ($table_rates as $table_rate) {
                $table_rate['cost'] = floatval(str_replace(',', '.', $table_rate['cost']));
        	    if ($cheapest == false) {
        		    $cheapest = $table_rate;
                } elseif ($table_rate['cost'] < $cheapest['cost']) {
        				$cheapest = $table_rate;
        		}
            }
            return $cheapest;
        }

	}
}