<?php
/**
 *	Module made by Nukium
 *
 *  @author    Nukium
 *  @copyright 2021 Nukium SAS
 *  @license   All rights reserved
 *
 * ███    ██ ██    ██ ██   ██ ██ ██    ██ ███    ███
 * ████   ██ ██    ██ ██  ██  ██ ██    ██ ████  ████
 * ██ ██  ██ ██    ██ █████   ██ ██    ██ ██ ████ ██
 * ██  ██ ██ ██    ██ ██  ██  ██ ██    ██ ██  ██  ██
 * ██   ████  ██████  ██   ██ ██  ██████  ██      ██
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>
<div class="wrap woocommerce">
    <div class="panel">
        <h3><?php if (isset($gls_label_single_type) && $gls_label_single_type == 'return'): ?><?php _e( 'Printing return label', 'woocommerce-gls' ); ?><?php else: ?><?php _e( 'Printing delivery labels', 'woocommerce-gls' ); ?><?php endif; ?></h3>
        <div class="notice notice-info inline">
            <p><?php echo count($list); ?> <?php _e( 'selected orders', 'woocommerce-gls' ); ?></p>
        </div>
        <div class="table-responsive-row clearfix">
            <table id="table-labels" class="table wp-list-table widefat striped posts">
                <thead>
                    <tr class="nodrag nodrop">
                        <th class="fixed-width-xs text-center">
                            <a href="#" class="toggler tips" data-tip="<?php _e( 'Expand / collapse all', 'woocommerce-gls' ); ?>" aria-expanded="false">
                                <i class="icon icon-angle-down icon-lg"></i>
                            </a>
                        </th>
                        <th scope="col" id="order_title" class="manage-column column-order_title column-primary title_box"><?php _e( 'Order', 'woocommerce' )?></th>
                        <th scope="col" id="shipping_address" class="manage-column column-shipping_address title_box"><?php _e( 'Ship to', 'woocommerce' ); ?></th>
                        <th scope="col" id="order_date" class="manage-column column-order_date title_box"><?php _e( 'Date', 'woocommerce' ); ?></th>
                        <th scope="col" id="order_status" class="manage-column column-order_status title_box"><?php _e( 'Status', 'woocommerce' ) ?></th>
                        <th scope="col" id="order_total" class="manage-column column-order_total title_box"><?php _e( 'Total', 'woocommerce' );?></th>
                        <th class="fixed-width-xs">
                            <span class="title-box"><?php _e( 'Printable', 'woocommerce-gls' ); ?></span>
                        </th>
                        <th class="action fixed-width-xs">
                            <span class="title-box"></span>
                        </th>
                    </tr>
                </thead>
                <tbody>
                <?php if (count($list)): ?>
                    <?php foreach ($list as $tr): ?>
                        <?php
                        $the_order = wc_get_order($tr->ID);

                        $order_weight = 0;
                        foreach ($the_order->get_items() as $item) {
                            if ((int)$item['qty'] > 0) {
                                if ((int)$item['variation_id'] > 0) {
                                    $product = wc_get_product($item['variation_id']);
                                } else {
                                    $product = wc_get_product($item['product_id']);
                                }

                                if ($product) {
                                    $order_weight += (float)$product->get_weight() * $item['qty'] * $weight_ratio;
                                }
                            }
                        }
                        $order_weight = round($order_weight,2);
                        ?>
                        <tr>
                            <td class="fixed-width-xs text-center">
                                <a href="#" class="toggler" aria-expanded="false">
                                    <i class="icon icon-angle-down icon-lg"></i>
                                </a>
                            </td>
                            <td class="order_title column-order_title has-row-actions column-primary">
                                <?php
                                if ( $the_order->get_customer_id() ) {
                                    $user     = get_user_by( 'id', $the_order->get_customer_id() );
                                    $username = esc_html( ucwords( $user->display_name ) );
                                } elseif ( $the_order->get_billing_first_name() || $the_order->get_billing_last_name() ) {
                                    

                                    $username = trim( sprintf( _x( '%1$s %2$s', 'full name', 'woocommerce' ), $the_order->get_billing_first_name(), $the_order->get_billing_last_name() ) );
                                } elseif ( $the_order->get_billing_company() ) {
                                    $username = trim( $the_order->get_billing_company() );
                                } else {
                                    $username = __( 'Guest', 'woocommerce' );
                                }

                                

                                printf(
                                    __( '%1$s by %2$s', 'woocommerce-gls' ),
                                    '<strong>#' . esc_attr( $the_order->get_order_number() ) . '</strong>',
                                    $username
                                );

                                if ( $the_order->get_billing_email() ) {
                                    echo '<br><small class="meta email"><a href="' . esc_url( 'mailto:' . $the_order->get_billing_email() ) . '">' . esc_html( $the_order->get_billing_email() ) . '</a></small>';
                                }
                                ?>
                            </td>
                            <td class="shipping_address column-shipping_address">
                                <?php
                                if ( $address = $the_order->get_formatted_shipping_address() ) {
                                    echo '<a target="_blank" href="' . esc_url( $the_order->get_shipping_address_map_url() ) . '">' . esc_html( preg_replace( '#<br\s*/?>#i', ', ', $address ) ) . '</a>';
                                } else {
                                    echo '&ndash;';
                                }

                                if ( $the_order->get_shipping_method() ) {
                                    echo '<br><small class="meta">' . __( 'With', 'woocommerce-gls' ) . ' ' . esc_html( $the_order->get_shipping_method() ) . '</small>';
                                }
                                ?>
                            </td>
                            <td class="order_date column-order_date">
                                <?php
                                printf(
                                    '<time datetime="%1$s" title="%2$s">%3$s</time>',
                                    esc_attr( $the_order->get_date_created()->date( 'c' ) ),
                                    esc_html( $the_order->get_date_created()->date_i18n( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ) ) ),
                                    esc_html( $the_order->get_date_created()->date_i18n( apply_filters( 'woocommerce_admin_order_date_format', get_option( 'date_format' ) ) ) )
                                );
                                ?>
                            </td>
                            <td class="order_status column-order_status">
                                <?php
                                printf( '<mark class="order-status status-%s"><span>%s</span></mark>', esc_attr( sanitize_html_class( $the_order->get_status() ) ), esc_attr( wc_get_order_status_name( $the_order->get_status() ) ), esc_html( wc_get_order_status_name( $the_order->get_status() ) ) );
                                ?>
                            </td>
                            <td class="order_total column-order_total">
                                <?php
                                echo $the_order->get_formatted_order_total();

                                if ( $the_order->get_payment_method_title() ) {
                                    echo '<br><small class="meta">' . __( 'Via', 'woocommerce-gls' ) . ' ' . esc_html( $the_order->get_payment_method_title() ) . '</small>';
                                }
                                ?>
                            </td>
                            <td class="printable">
                                <span class="progress-text"><?php _e( 'Printable', 'woocommerce-gls' ); ?></span>
                                <div class="progress" id="printing-progress-<?php echo $tr->ID; ?>">
                                    <div class="progress-bar bg-primary" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100"></div>
                                </div>
                            </td>
                            <td class="action text-center">
                                <button type="button" id="button-print-<?php echo $tr->ID; ?>" class="button button-primary button-print btn-disabled tips" data-tip="<?php _e( 'Fill in the order informations before you can print the associated label', 'woocommerce-gls' ); ?>"><i class="icon icon-print icon-lg"></i><span class="text"><?php _e( 'Print', 'woocommerce-gls' ); ?></span></button>
                            </td>
                        </tr>
                        <tr class="extra-content">
                            <td colspan="8">
                                <form action="#" id="extra-content-form-<?php echo $tr->ID; ?>" class="extra-content-form" style="display: none;">
                                    <input type="hidden" name="order" value="<?php echo $tr->ID; ?>" />
                                    <input type="hidden" id="local_print_<?php echo $tr->ID; ?>" name="local_print" value="0" />
                                    <div class="form-wrapper clearfix">
                                        <div class="row big-gutters">
                                            <div class="col-md-4">
                                                <div class="card packages">
                                                    <div class="card-header">
                                                        <?php _e( 'Packages', 'woocommerce-gls' ); ?> <span class="packages-count badge badge-primary">1</span>
                                                      </div>
                                                    <div class="card-body">
                                                        <div class="row package">
                                                            <div class="col-12 package-title d-flex justify-content-between align-items-center">
                                                                <strong><?php _e( 'Package #', 'woocommerce-gls' ); ?><span class="package-index">1</span></strong>
                                                                <button type="button" class="button button-danger-outline remove-package d-none"><i class="icon icon-trash"></i></button>
                                                            </div>
                                                            <div class="col-12">
                                                                <div class="form-group">
                                                                    <label class="control-label required">
                                                                        <?php _e( 'Weight', 'woocommerce-gls' ); ?>
                                                                    </label>
                                                                    <div class="input-group" lang="en-US">
                                                                        <input name="weight[]" class="form-control weight-control" required="required" type="number" step="0.001" min="0.1" max="30" value="<?php if ($order_weight > 0): ?><?php echo number_format($order_weight, 3); ?><?php endif; ?>" />
                                                                        <span class="input-group-addon"><?php _e( 'kg', 'woocommerce-gls' ); ?></span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </diV>
                                                    <div class="card-footer text-right">
                                                        <button type="button" class="button button-primary-outline add-package"><i class="icon icon-plus"></i> <?php _e( 'Add a package', 'woocommerce-gls' ); ?></button>
                                                    </div>
                                                </div>
                                            </div>
                                            <?php if (!isset($gls_label_single_type) || $gls_label_single_type != 'return'): ?>
                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        <label class="control-label required">
                                                            <?php _e( 'GLS service', 'woocommerce-gls' ); ?>
                                                        </label>
                                                        <div>
                                                            <select name="gls_service" class="gls-service form-control" required="required">

                                                                <option value=""></option>

                                                                <?php foreach ($carriers as $value): ?>

                                                                    <?php if ( array_key_exists($value->id, $gls_carriers)):?>

                                                                    <?php if ($tr->shipping_method_id == $value->id || (!is_null($tr->method_id) && $tr->method_id == $value->id)): ?>
                                                                        <option value="<?php echo $value->id; ?>" selected="selected"<?php if ($gls_carriers[$value->id]['mobile']): ?> data-mobile-required="true"<?php endif; ?>><?php echo esc_html( $the_order->get_shipping_method() ); ?> (<?php _e( 'ID:', 'woocommerce-gls' ); ?> <?php echo $value->id; ?>)</option>
                                                                        <?php continue; ?>
                                                                    <?php endif; ?>

                                                                    <?php if ( array_key_exists($value->id, $gls_carriers) && $value->id != 'gls_relais' && $value->id != 'gls_13h' ): ?>
                                                                        <option value="<?php echo $value->id; ?>"<?php if ($gls_carriers[$value->id]['mobile']): ?> data-mobile-required="true"<?php endif; ?>><?php echo esc_html( $value->get_method_title() ); ?> (<?php _e( 'ID:', 'woocommerce-gls' ); ?> <?php echo $value->id; ?>)</option>
                                                                    <?php endif; ?>

                                                                    <?php endif; ?>

                                                                <?php endforeach; ?>

                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="form-group">
                                                        <label class="control-label required">
                                                            <?php _e( 'Shipping date', 'woocommerce-gls' ); ?>
                                                        </label>
                                                        <div class="input-group">
                                                            <input id="delivery-date-alt-<?php echo $tr->ID; ?>" name="delivery_date_alt" value="<?php echo date('d/m/Y'); ?>" class="form-control datepicker" required="required" type="text" />
                                                            <input id="delivery-date-<?php echo $tr->ID; ?>" name="delivery_date" value="<?php echo date('Y-m-d'); ?>" type="hidden" />
                                                            <div class="input-group-addon">
                                                                <i class="icon icon-calendar-o"></i>
                                                            </div>
                                                        </div>
                                                        <script type="text/javascript">
                                                            jQuery(document).ready(function() {

                                                                jQuery(function(){
                                                                    jQuery('#delivery-date-alt-<?php echo $tr->ID; ?>').datepicker({
    																	dateFormat: 'dd/mm/yy',
                                                                        altFormat: 'yy-mm-dd',
                                                                        altField: '#delivery-date-<?php echo $tr->ID; ?>',
                                                                        showButtonPanel: false,
                                                                        minDate: 0,
                                                                        onSelect: function(date) {
                                                                            jQuery(this).datepicker('hide');
                                                                        }
                                                                    });
                                                                    jQuery(document.body).on('click', '.datepicker:not(:disabled) ~ .input-group-addon', function() {
                                                                        jQuery(this).siblings('.datepicker').datepicker('show');
                                                                    });
                                                                });

                                                            });
                                                        </script>
                                                    </div>
                                                    <div class="form-group mobile-group" style="display: none;">
                                                        <label class="control-label required">
                                                            <?php _e( 'Mobile', 'woocommerce-gls' ); ?>
                                                        </label>
                                                        <div>
                                                            <input class="form-control" type="tel" name="mobile" value="<?php echo esc_html( ( !empty( $tr->customer_phone_mobile ) ? $tr->customer_phone_mobile : $the_order->get_billing_phone() ) ); ?>" required="required" />
                                                        </div>
                                                    </div>
                                                    <?php if (!in_array($the_order->get_shipping_country(), $cee_countries)): ?>
                                                        <div class="form-group">
                                                            <label class="control-label required">
                                                                <?php _e( 'Incoterm', 'woocommerce-gls' ); ?>
                                                            </label>
                                                            <div>
                                                                <select name="incoterm" class="form-control" required="required">
                                                                    <option value=""></option>
                                                                    <option value="10"><?php _e( 'DDP', 'woocommerce-gls' ); ?> - <?php _e( 'Delivered goods, all costs paid including export and import duties and taxes.', 'woocommerce-gls' ); ?></option>
                                                                    <option value="20"><?php _e( 'DAP', 'woocommerce-gls' ); ?> - <?php _e( 'Goods delivered, unpaid clearance, unpaid taxes.', 'woocommerce-gls' ); ?></option>
                                                                    <option value="30"><?php _e( 'DDP, VAT unpaid', 'woocommerce-gls' ); ?> - <?php _e( 'Goods delivered, export and import duties paid, unpaid taxes.', 'woocommerce-gls' ); ?></option>
                                                                    <option value="40"><?php _e( 'DAP, cleared', 'woocommerce-gls' ); ?> - <?php _e( 'Goods delivered, no clearance, no taxes.', 'woocommerce-gls' ); ?></option>
                                                                    <option value="50"><?php _e( 'DDP', 'woocommerce-gls' ); ?> - <?php _e( 'Goods delivered, export and import duties paid, low value exemption free authorization.', 'woocommerce-gls' ); ?></option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                    <?php endif; ?>
                                                    <?php if ($shop_return_service === 'yes' && $the_order->get_shipping_country() == 'FR'): ?>
                                                        <div class="form-group">
                                                            <label class="control-label"><?php _e( 'Include return label', 'woocommerce-gls' ); ?></label>
                                                            <div class="switch-toggle">
                                                                <label for="return-label-<?php echo $tr->ID; ?>">
                                                                    <input id="return-label-<?php echo $tr->ID; ?>" name="return_label" value="1" type="checkbox" />
                                                                    <span class="wc-gls-toggle-switch"></span>
                                                                    <span class="wc-gls-toggle-checked-label"><?php _e( 'Yes', 'woocommerce-gls' ); ?></span>
                                                                    <span class="wc-gls-toggle-unchecked-label"><?php _e( 'No', 'woocommerce-gls' ); ?></span>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                            <?php endif; ?>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label">
                                                        <?php _e( 'Supp reference 1', 'woocommerce-gls' ); ?>
                                                    </label>
                                                    <div>
                                                        <input class="form-control" type="text" name="reference1" value="<?php echo $tr->ID; ?>" maxlength="20" />
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label class="control-label">
                                                        <?php _e( 'Supp reference 2', 'woocommerce-gls' ); ?>
                                                    </label>
                                                    <div>
                                                        <input class="form-control" type="text" name="reference2" value="" maxlength="20" />
                                                    </div>
                                                </div>
                                                <input type="hidden" name="gls_label_single_type" value="<?php echo $gls_label_single_type; ?>" />
                                            </div>
                                        </div>
                                      </div>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td class="list-empty" colspan="11">
                            <div class="list-empty-msg">
                                <?php _e( 'No records found', 'woocommerce-gls' ); ?>
                            </div>
                        </td>
                    </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
        <div class="panel-footer">
            <form action="<?php  echo esc_url($admin_url); ?>" method="post" class="form-horizontal clearfix" id="form-back">
                <p class="submit">
                    <button type="submit" <?php if (empty($gls_label_single_type)): ?>id="generateLabelStep3Cancel" name="generateLabelStep3Cancel" <?php endif; ?>class="button-secondary woocommerce-save-button" value="1"><?php _e( 'Back', 'woocommerce-gls' ); ?></button>
                    <button type="button" id="gls-btn-print-all" class="btn btn-default button-primary tips" data-tip="<?php _e( 'This will print all labels with valid order\'s informations.', 'woocommerce-gls' ); ?>" data-counter="0" disabled>
                        <span><i class="process-icon-print icon icon-print icon-lg"></i></span>
                        <?php _e( 'Print all', 'woocommerce-gls' ); ?>
                    </button>
                </p>
            </form>
        </div>
    </div>

</div>

<div class="modal fade" id="modalMergeLabels" tabindex="-1" role="dialog" aria-labelledby="modalMergeLabelsTitle" aria-hidden="true" title="<?php _e( 'Please wait, file is being prepared', 'woocommerce-gls' ); ?>">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <div class="d-flex flex-column justify-content-center align-items-center">
                    <img src="<?php  echo esc_url(WC_Gls::plugin_url() . '/views/img/admin/gls-file.gif'); ?>" alt="icône" class="merging-icon">
                    <div class="progress">
                        <div class="progress-bar bg-primary" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" style="width: 0%;"></div>
                    </div>
                    <ul class="progress-steps">
                        <li><span class="icon-stack"><i class="icon icon-circle icon-stack-2x text-muted"></i><i class="icon icon-check icon-stack-1x icon-inverse hidden"></i></span> <?php _e( 'Preparation of the environment', 'woocommerce-gls' ); ?></li>
                        <li><span class="icon-stack"><i class="icon icon-circle icon-stack-2x text-muted"></i><i class="icon icon-check icon-stack-1x icon-inverse hidden"></i></span> <?php _e( 'Generation of labels', 'woocommerce-gls' ); ?> <span class="counter">0</span> / <span class="total-counter">0</span></li>
                        <li><span class="icon-stack"><i class="icon icon-circle icon-stack-2x text-muted"></i><i class="icon icon-check icon-stack-1x icon-inverse hidden"></i></span> <?php _e( 'Generation of final PDF file', 'woocommerce-gls' ); ?></li>
                    </ul>
                    <div id="gls-generate-label-error" class="notice notice-error" role="alert" style="display: none;">
                        <p><?php _e( 'An error occured , please contact technical support.', 'woocommerce-gls' ); ?></p>
                    </div>
                    <div id="gls-generate-label-warning" class="notice notice-warning" role="alert" style="display: none;">
                        <p><?php _e( 'You can download successfully generated labels, some are in error and have to be regenerated.', 'woocommerce-gls' ); ?></p>
                    </div>
                    <button class="btn button-primary" disabled><?php _e( 'Download labels', 'woocommerce-gls' ); ?></button>
                </div>
            </div>
        </div>
    </div>
</div>