<?php
/**
 *	Module made by Nukium
 *
 *  @author    Nukium
 *  @copyright 2021 Nukium SAS
 *  @license   All rights reserved
 *
 * ███    ██ ██    ██ ██   ██ ██ ██    ██ ███    ███
 * ████   ██ ██    ██ ██  ██  ██ ██    ██ ████  ████
 * ██ ██  ██ ██    ██ █████   ██ ██    ██ ██ ████ ██
 * ██  ██ ██ ██    ██ ██  ██  ██ ██    ██ ██  ██  ██
 * ██   ████  ██████  ██   ██ ██  ██████  ██      ██
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<?php if ($display_form === true): ?>
    <form id="gls-admin-order-print-label" action="<?php echo esc_url(admin_url( 'admin.php?page=woocommerce-gls-label' )); ?>" method="post">
        <input type="hidden" name="woocommerce_gls_admin_order_label_label_single_type" value="shipment" />
        <input type="hidden" name="woocommerce_gls_admin_order_label_label_order_id" value="<?php echo $id_order ?>" />
        <input type="hidden" name="woocommerce_gls_admin_order_label_label_single_new_order_state" value="" />
        <input type="hidden" name="gls_print_label_from_order" value="1" />
        <input type="hidden" name="generateLabelStep3Single" value="1" />
    </form>

<?php else: ?>

    <p class="gls-logo"><img src="<?php  echo esc_url(WC_Gls::plugin_url() . '/views/img/admin/gls-logo.jpg'); ?>" alt="GLS" class="img-responsive center-block" /></p>

    <?php if ($display_btn_change_relay === true): ?>
        <p>
            <button type="button" id="orderGlsChangeRelayModal" name="orderGlsChangeRelayModal" class="button button-primary">
                <?php if (!empty($current_relay)): ?>
                    <?php _e( 'Change GLS Relais', 'woocommerce-gls' ); ?>
                <?php else: ?>
                    <?php _e( 'Add GLS Relais', 'woocommerce-gls' ); ?>
                <?php endif; ?>
            </button>
        </p>

        <div class="modal fade" id="glsChangeRelayModal" tabindex="-1" role="dialog" aria-labelledby="glsChangeRelayModalLabel" aria-hidden="true" title="<?php _e( 'Change GLS Relais', 'woocommerce-gls' ); ?>">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-body">
                        <div class="col-12 gls-container">

                        <?php if (!$error || (isset($error['code']) && $error['code'] == 998 || $error['code'] == 999)): ?>
                            <div class="row">
                                <div class="col-12">
                                    <div class="gls-heading">
                                        <h4><?php _e( 'The following GLS Relais are available around the address', 'woocommerce-gls' ); ?></h4>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="gls-search">
                                        <a href="#gls-search-form" class="gls-search-form-toggler"><?php _e( '> Find GLS Relais around another address', 'woocommerce-gls' ); ?></a>
                                        <div id="gls-search-form" style="display: none;">
                                                <div class="form-row input-group mb-0">
                                                    <input type="search" name="gls_search" id="gls-search" class="form-control input-text" placeholder="<?php _e( 'Postcode (required), City (optional)', 'woocommerce-gls' ); ?>" />
                                                    <div class="input-group-btn input-group-append">
                                                        <button type="button" class="button button-primary gls-search-relay">
                                                            <?php _e( 'Search', 'woocommerce-gls' ); ?>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php if ($relay_points): ?>
                                        <div class="col-5 gls-relay-list">
                                            <?php foreach ($relay_points as $k => $v): ?>
                                                <?php if ($k < 10  && (!$only_xl || ($only_xl && substr($v->Parcelshop->Address->Name1, -2) == 'XL') )): ?>
                                                    <div class="row <?php echo ($k > 10 ? 'hidden relay-disable' : 'show relay-enable'); ?>">
                                                        <div class="col-12">
                                                            <div class="card gls-relay-infos">
                                                                <div class="card-body">
                                                                    <div class="row gutters-sm">
                                                                        <div class="col-auto col-select-relay">
                                                                            <input type="radio" name="gls_relay" id="gls-relay-<?php echo $v->Parcelshop->ParcelShopId?>" class="gls-select-relay" data-glsrelayid="<?php echo $v->Parcelshop->ParcelShopId?>" value="<?php echo $v->Parcelshop->ParcelShopId?>"<?php if ($current_relay == $v->Parcelshop->ParcelShopId):?> checked<?php endif;?> />
                                                                        </div>
                                                                        <label class="col" for="gls-relay-<?php echo $v->Parcelshop->ParcelShopId?>">
                                                                            <div class="card-title">
                                                                                <span class="gls-relay-name"><strong><?php echo $v->Parcelshop->Address->Name1?></strong></span><span class="separator"> - </span><span class="gls-relay-label"><?php echo substr($labels, $k, 1); ?></span>
                                                                            </div>
                                                                            <div class="card-text">
                                                                                <div class="gls-relay-address">
                                                                                    <?php echo $v->Parcelshop->Address->Street1?>
                                                                                    <br/>
                                                                                    <?php echo $v->Parcelshop->Address->ZipCode?> <?php echo $v->Parcelshop->Address->City?>
                                                                                </div>
                                                                            </div>
                                                                        </label>
                                                                        <div class="col-auto">
                                                                            <div class="gls-relay-distance text-muted">
                                                                                <?php echo number_format($v->AirLineDistance, 2)?> <?php _e( 'km' , 'woocommerce-gls' )?>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                            <?php endforeach; ?>
                                            <script type="text/javascript">
                                                var glsGmapsMarkers = [];
                                                <?php foreach ($relay_points as $k => $v): ?>
                                                    <?php if ($k < 10 && (!$only_xl || ($only_xl && substr($v->Parcelshop->Address->Name1, -2) == 'XL') )): ?>
                                                        var opening_hours = "";
                                                        <?php if (isset($v->Parcelshop->GLSWorkingDay) && is_array($v->Parcelshop->GLSWorkingDay) && count($v->Parcelshop->GLSWorkingDay) > 0): ?>
                                                            opening_hours += '<table class="gls-relay-info-open-hours"><tbody>';
                                                            <?php foreach ($trans_days as $day => $dname): ?>
                                                                opening_hours += '<tr';
                                                                    <?php if(((int)date('w') - 1) == (int)$day): ?>
                                                                        opening_hours += ' class="today"';
                                                                    <?php endif;?>
                                                                    opening_hours += '>';
                                                                    <?php if (isset($v->Parcelshop->GLSWorkingDay[$day])): ?>
                                                                        opening_hours += '<th><?php echo $dname; ?></th>';
                                                                        opening_hours += '<td><?php echo substr($v->Parcelshop->GLSWorkingDay[$day]->OpeningHours->Hours->From, 0, 2)?>:<?php echo substr($v->Parcelshop->GLSWorkingDay[$day]->OpeningHours->Hours->From, 2, 2)?> - ';
                                                                            <?php if (!empty($v->Parcelshop->GLSWorkingDay[$day]->Breaks->Hours->From)):?>
                                                                                opening_hours += '<?php echo substr($v->Parcelshop->GLSWorkingDay[$day]->Breaks->Hours->From, 0, 2)?>:<?php echo substr($v->Parcelshop->GLSWorkingDay[$day]->Breaks->Hours->From, 2, 2)?><br/><?php echo substr($v->Parcelshop->GLSWorkingDay[$day]->Breaks->Hours->To, 0, 2)?>:<?php echo substr($v->Parcelshop->GLSWorkingDay[$day]->Breaks->Hours->To, 2, 2)?> - <?php echo substr($v->Parcelshop->GLSWorkingDay[$day]->OpeningHours->Hours->To, 0, 2)?>:<?php echo substr($v->Parcelshop->GLSWorkingDay[$day]->OpeningHours->Hours->To, 2, 2)?>';
                                                                            <?php else: ?>
                                                                                opening_hours += '<?php echo substr($v->Parcelshop->GLSWorkingDay[$day]->OpeningHours->Hours->To, 0, 2)?>:<?php echo substr($v->Parcelshop->GLSWorkingDay[$day]->OpeningHours->Hours->To, 2, 2)?>';
                                                                            <?php endif; ?>
                                                                        opening_hours += '</td>';
                                                                    <?php else:?>
                                                                        opening_hours += '<th><?php echo $dname; ?></th><td><?php _e( 'Closed' , 'woocommerce-gls' ); ?></td>';
                                                                    <?php endif; ?>
                                                                opening_hours += '</tr>';
                                                            <?php endforeach; ?>
                                                            opening_hours += '</tbody></table>';
                                                        <?php endif; ?>
                                                        glsGmapsMarkers.push({"lat" : <?php echo $v->Parcelshop->GLSCoordinates->Latitude?>, "lng" : <?php echo $v->Parcelshop->GLSCoordinates->Longitude?>, "name" : "<?php echo $v->Parcelshop->Address->Name1?>", "id" : "<?php echo substr($labels, $k, 1); ?>", "infos" : opening_hours});
                                                    <?php endif; ?>
                                                <?php endforeach; ?>
                                            </script>
                                        </div>
                                        <div class="col-7 gls-relay-map">
                                            <div id="gls-map"></div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>

                            <?php if ($error): ?>
                                <div class="woocommerce-error" role="alert">
                                    <span data-title="<?php if (!empty($error['code'])):?><?php _e( sprintf('Code: %s', $error['code']) , 'woocommerce-gls' ); ?><?php endif; ?>" class="alert-text"><?php echo $error['message']?></span>
                                </div>
                            <?php endif; ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>

        <hr/>

    <?php endif; ?>

    <?php if ($is_gls) :?>

        <h4><?php _e('GLS Tracking information', 'woocommerce-gls' ); ?></h4>
        <div class="gls-tracking-information">
            <?php if ($current_state != '') :?>
                <p>
                    <b><?php _e('State:', 'woocommerce-gls' ); ?></b> <span class="gls-tracking-current-state"><?php echo $current_state ?></span>
                    <br/>
                    <i><?php _e('Updated on:', 'woocommerce-gls' ); ?> <span class="gls-tracking-current-state-date"><?php echo $trackingStateTimeDisplayed ?></span></i>
                </p>
            <?php else :?>
                <p class="gls-tracking-information-empty-template" style="display: none">
                    <b><?php _e('State:', 'woocommerce-gls' ); ?></b> <span class="gls-tracking-current-state"></span>
                    <br/>
                    <i><?php _e('Updated on:', 'woocommerce-gls' ); ?> <span class="gls-tracking-current-state-date"></span></i>
                </p>
                <p class="gls-tracking-information-unavailable"><?php _e('Information not available', 'woocommerce-gls' ); ?></p>
            <?php endif; ?>
            <button type="button" id="updateTrackingState" name="updateTrackingState" class="button button-primary" data-order-id="<?php echo $id_order ?>"><?php _e('Check state', 'woocommerce-gls' ); ?></button>
        </div>

        <hr/>

    <?php endif; ?>

    <p class="help"><?php _e( 'You can print a GLS shipping label even if a GLS carrier is not associated to this order. Additional information will be required before the shipping label is generated.', 'woocommerce-gls' ); ?></p>

    <div class="form-field form-required gls_order_label">
        <p>
            <label for="GLS_LABEL_SINGLE_NEW_ORDER_STATE"><?php _e( 'Change order status to', 'woocommerce-gls' ); ?></label>
            <select name="GLS_LABEL_SINGLE_NEW_ORDER_STATE" class="form-control" id="GLS_LABEL_SINGLE_NEW_ORDER_STATE">
                <option value="0"><?php _e( '(No change)', 'woocommerce-gls' ); ?></option>
                <?php foreach (wc_get_order_statuses() as $key => $value) : ?>
                    <option value="<?php echo $key; ?>" <?php if ($order_status_selected == $key): ?>selected="selected"<?php endif; ?>><?php echo $value; ?></option>
                <?php endforeach; ?>
            </select>
            <input type="hidden" id="glsWCOrderId" name="glsWCOrderId" value="<?php echo $id_order ?>" />
        </p>
        <p>
            <button type="button" id="orderGenerateLabelStep3" name="orderGenerateLabelStep3" class="button button-primary"><?php _e( 'Print label', 'woocommerce-gls' ); ?></button>
        </p>
    </div>

<?php endif; ?>
