<?php
/**
 *	Module made by Nukium
 *
 *  @author    Nukium
 *  @copyright 2021 Nukium SAS
 *  @license   All rights reserved
 *
 * ███    ██ ██    ██ ██   ██ ██ ██    ██ ███    ███
 * ████   ██ ██    ██ ██  ██  ██ ██    ██ ████  ████
 * ██ ██  ██ ██    ██ █████   ██ ██    ██ ██ ████ ██
 * ██  ██ ██ ██    ██ ██  ██  ██ ██    ██ ██  ██  ██
 * ██   ████  ██████  ██   ██ ██  ██████  ██      ██
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; 
}

if ( ! class_exists( 'WC_Gls_Settings' ) ) :

class WC_Gls_Settings {

	public static $id = 'gls_settings';

	public static function init() {
		add_filter( 'woocommerce_settings_tabs_array', __CLASS__ . '::add_settings_tab', 50 );
		add_action( 'woocommerce_settings_'.self::$id, __CLASS__ . '::settings_tab' );
		add_action( 'woocommerce_update_options_'.self::$id, __CLASS__ . '::update_settings' );

		add_action( 'woocommerce_settings_' . self::$id . '_section_title_3_after' , __CLASS__ . '::open_html_section_after' );
		add_action( 'woocommerce_settings_' . self::$id . '_section_title_4_after' , __CLASS__ . '::close_html_section_after' );
        add_action( 'woocommerce_admin_field_gls_custom_html', __CLASS__ . '::action_woocommerce_admin_field_gls_custom_html', 10, 1 );

		add_action( 'admin_enqueue_scripts', 'wc_gls_admin_scripts_styles' );
	}

	

	public static function add_settings_tab( $settings_tabs ) {
		$settings_tabs[self::$id] = __( 'GLS', 'woocommerce-gls' );
		return $settings_tabs;
	}
	

	public static function settings_tab() {

        if (isset($_POST['updateOrderTracking'])) {

            $result = WC_Gls::cronGetTracking();

            if ($result === true) {
                
                ?>
                <div class="notice notice-success is-dismissible">
                    <p><?php _e('Successfully updated', 'woocommerce-gls') ?></p>
                </div>
                <?php
            } elseif (is_array($result) && isset($result['error']) && $result['error'] &&
                isset($result['message']) && !empty($result['message'])) {
                
                ?>
                <div class="notice notice-error is-dismissible">
                    <p><?php echo $result['message']; ?></p>
                </div>
                <?php
            } else {
                
                ?>
                <div class="notice notice-error is-dismissible">
                    <p><?php _e('An error occured , please contact technical support.', 'woocommerce-gls') ?></p>
                </div>
                <?php
            }

        }

	    echo '<div class="notice notice-warning"><p>' . __( 'You must be a GLS customer to use this module, if you are not yet', 'woocommerce-gls' )
            . ' <a class="alert-link" href="'
            . __( 'https://gls-group.eu/EU/en/contact-form', 'woocommerce-gls' ) . '" target="_blank" rel="noopener">'
            . __( 'contact us', 'woocommerce-gls' ) . '</a>' . '</p></div>';
        echo '<div class="notice notice-info"><p>'
            . ' <a class="alert-link" href="'
            . GLS_PLUGIN_URL . '/' .  __( 'readme_fr.pdf', 'woocommerce-gls' ) . '" target="_blank" rel="noopener">'
            . __( 'Read the documentation.', 'woocommerce-gls' ) . '</a>' . '</p></div>';

		woocommerce_admin_fields( self::get_settings() );
	}
	

	public static function update_settings() {

        woocommerce_update_options( self::get_settings() );

	}

	public static function open_html_section_after() {
	    echo '<div class="gls-settings-return-address">';
	}
	public static function close_html_section_after() {
	    echo '</div>';
    }

    public static function action_woocommerce_admin_field_gls_custom_html( $value ) {
        if (isset($value['title']) && !empty($value['title'])) {
            echo $value['title'];
        }
    }
	

	public static function get_settings() {

        $settings = array(
			'section_title' => array(
                'name'     	=> __( 'Fill in your account details', 'woocommerce-gls' ),
                'type'     	=> 'title',
				'id'		=> self::$id.'_section_title',
            ),
            'wslogin' => array(
				'title'             => __( 'Webservice login', 'woocommerce-gls' ),
				'type'              => 'text',
				'desc'       => __( 'Information required to search and display GLS Relais', 'woocommerce-gls' ),
				'desc_tip'          => true,
		        'default'           => '',
                'id' => self::$id.'_wslogin',
			),
			'wspwd' => array(
				'title'             => __( 'Webservice password', 'woocommerce-gls' ),
				'type'              => 'text',
				'desc'       => __( 'Information required to search and display GLS Relais', 'woocommerce-gls' ),
				'desc_tip'          => true,
		        'default'           => '',
                'id' => self::$id.'_wspwd',
			),
			'agency_code' => array(
				'title'             => __( 'GLS agency code', 'woocommerce-gls' ),
				'type'              => 'text',
				'desc'       => __( 'Fill in the GLS agency code from where the package is sent.', 'woocommerce-gls' ),
				'desc_tip'          => true,
				'default'           => '',
            		'id' => self::$id.'_agency_code',
            ),
		    'api_login' => array(
                'title'             => __( 'Web API login', 'woocommerce-gls' ),
                'type'              => 'text',
		        'desc'       => __( 'Information required to use labels printing and to automatically update the order\'s state depending of the gls tracking status', 'woocommerce-gls' ),
				'desc_tip'          => true,
		        'default'           => '',
		        'id' => self::$id.'_api_login',
		    ),
		    'api_pwd' => array(
		        'title'             => __( 'Web API password', 'woocommerce-gls' ),
		        'type'              => 'text',
		        'desc'       => __( 'Information required to use labels printing and to automatically update the order\'s state depending of the gls tracking status', 'woocommerce-gls' ),
				'desc_tip'          => true,
		        'default'           => '',
		        'id' => self::$id.'_api_pwd',
		    ),
		    'api_customer_id' => array(
		        'title'             => __( 'Customer ID (Web API)', 'woocommerce-gls' ),
		        'type'              => 'text',
		        'desc'       => __( 'Information required to use labels printing', 'woocommerce-gls' ),
				'desc_tip'          => true,
		        'default'           => '',
		        'id' => self::$id.'_api_customer_id',
		    ),
		    'api_contact_id' => array(
		        'title'             => __( 'Contact ID (Web API)', 'woocommerce-gls' ),
		        'type'              => 'text',
		        'desc'       => __( 'Information required to use labels printing', 'woocommerce-gls' ),
				'desc_tip'          => true,
		        'default'           => '',
		        'id' => self::$id.'_api_contact_id',
		    ),
			'section_end' => array(
				'type' => 'sectionend',
				'id' => self::$id.'_section_title',
			),
		    'section_title_2' => array(
		        'name'     	=> __( 'GLS Relais display', 'woocommerce-gls' ),
		        'type'     	=> 'title',
		        'id'		=> self::$id.'_section_title_2',
		    ),
            'gmaps_enable' => array(
				'title'             => __( 'Use Google Maps instead of OpenStreetMap', 'woocommerce-gls' ),
				'type'              => 'checkbox',
				'label'             => __( 'Google Maps API', 'woocommerce-gls' ),
                'default'           => 'no',
                'class' => self::$id.'-google-maps',
				'desc'       => __( 'Enable this option if you have a problem to display the map with OpenStreetMap or if you have a google account well configured.', 'woocommerce-gls' ),
				'desc_tip'          => true,
            		'id' => self::$id.'_gmaps_enable',
			),
			'gmaps_api_key' => array(
				'title'             => __( 'Google Maps API Key', 'woocommerce-gls' ),
				'type'              => 'text',
				'desc'       => '<a href="https://developers.google.com/maps/documentation/javascript/get-api-key" target="_blank">'
					.__( 'Click here to retrieve your Google Maps API Key', 'woocommerce-gls' )
					.'</a>',
				'default'           => '',
            		'id' => self::$id.'_gmaps_api_key',
			),
			'gmaps_api_script' => array(
				'title'             => __( 'Include Google Maps API Script', 'woocommerce-gls' ),
				'type'              => 'checkbox',
				'label'             => __( 'Google Maps API Script', 'woocommerce-gls' ),
				'default'           => 'yes',
				'desc'       => __( 'Disable this option if you have a problem to display the map.', 'woocommerce-gls' ),
				'desc_tip'          => true,
				'id' => self::$id.'_gmaps_api_script',
			),
			'order_prefix' => array(
				'title'             => __( 'Include an order prefix in GLS export/import', 'woocommerce-gls' ),
				'type'              => 'checkbox',
				'label'             => __( 'Export/import order prefix', 'woocommerce-gls' ),
				'default'           => 'yes',
				'desc'       => __( 'This option is required for multishops, it is enabled by default.', 'woocommerce-gls' ),
				'desc_tip'          => true,
            		'id' => self::$id.'_order_prefix',
			),
			'section_end_2' => array(
				'type' => 'sectionend',
				'id' => self::$id.'_section_title_2',
			),
		    'section_title_3' => array(
		        'name'     	=> __( 'Labels printing', 'woocommerce-gls' ),
		        'type'     	=> 'title',
		        'id'		=> self::$id.'_section_title_3',
		    ),
		    'api_delivery_label_format' => array(
		        'title' 		=> __( 'Delivery label format', 'woocommerce-gls' ),
		        'type' 			=> 'select',
		        'default' 		=> 'A6',
		        'options'		=> array(
		            'A4' 	=> __( 'A4', 'woocommerce-gls' ),
		            'A5'	=> __( 'A5', 'woocommerce-gls' ),
		            'A6'	=> __( 'A6', 'woocommerce-gls' ),
		        ),
		        'id' => self::$id.'_api_delivery_label_format',
		    ),
		    'api_shop_return_service' => array(
		        'title'             => __( 'Enable shop return service', 'woocommerce-gls' ),
		        'type'              => 'checkbox',
		        'label'             => __( 'Shop return service', 'woocommerce-gls' ),
		        'default'           => 'no',
		        'id' => self::$id.'_api_shop_return_service',
		    ),
		    'api_shop_return_email_alert' => array(
		        'title'             => __( 'Enable shop return notification email', 'woocommerce-gls' ),
		        'type'              => 'checkbox',
		        'label'             => __( 'Shop return notification email', 'woocommerce-gls' ),
		        'default'           => 'no',
		        'desc'       => __( 'Enable this option if you want to notify the customer after return label is generated.', 'woocommerce-gls' ),
		        'desc_tip'          => true,
		        'class' => self::$id.'-return-address',
		        'id' => self::$id.'_api_shop_return_email_alert',
		    ),
		    'section_end_3' => array(
		        'type' => 'sectionend',
		        'id' => self::$id.'_section_title_3',
		    ),
		    'section_title_4' => array(
		        'name'     	=> __( 'Shipping address', 'woocommerce-gls' ),
		        'type'     	=> 'title',
		        'id'		=> self::$id.'_section_title_4',
		    ),
		    'api_shop_return_address_name' => array(
		        'title'             => __( 'Company or return contact name', 'woocommerce-gls' ),
		        'type'              => 'text',
		        'default'           => '',
		        'id' => self::$id.'_api_shop_return_address_name',
		        'autoload' => false,
		    ),
		    'api_shop_return_address_address1' => array(
		        'title'             => __( 'Address', 'woocommerce-gls' ),
		        'type'              => 'text',
		        'default'           => get_option( 'woocommerce_store_address', '' ),
		        'id' => self::$id.'_api_shop_return_address_address1',
		        'autoload' => false,
		    ),
		    'api_shop_return_address_address2' => array(
		        'title'             => __( 'Address (2)', 'woocommerce-gls' ),
		        'type'              => 'text',
		        'default'           => get_option( 'woocommerce_store_address_2', '' ),
		        'id' => self::$id.'_api_shop_return_address_address2',
		        'autoload' => false,
		    ),
		    'api_shop_return_address_postcode' => array(
		        'title'             => __( 'Zip/postal code', 'woocommerce-gls' ),
		        'type'              => 'text',
		        'default'           => get_option( 'woocommerce_store_postcode', '' ),
		        'id' => self::$id.'_api_shop_return_address_postcode',
		        'autoload' => false,
		    ),
		    'api_shop_return_address_city' => array(
		        'title'             => __( 'City', 'woocommerce-gls' ),
		        'type'              => 'text',
		        'default'           => get_option( 'woocommerce_store_city', '' ),
		        'id' => self::$id.'_api_shop_return_address_city',
		        'autoload' => false,
		    ),
		    'api_shop_return_address_country' => array(
		        'title'             => __( 'Country', 'woocommerce-gls' ),
		        'type'              => 'single_select_country',
		        'default'           => get_option( 'woocommerce_default_country', '' ),
		        'id' => self::$id.'_api_shop_return_address_country',
		        'autoload' => false,
		    ),
		    'section_end_4' => array(
		        'type' => 'sectionend',
		        'id' => self::$id.'_section_title_4',
            ),
            'section_title_5' => array(
		        'name'     	=> __( 'Tracking configuration', 'woocommerce-gls' ),
		        'type'     	=> 'title',
                'id'		=> self::$id.'_section_title_5',
                'desc' => __('You can update manually orders states depending on gls tracking status by clicking the button bellow:', 'woocommerce-gls' ),
            ),
		    'tracking_exec_btn' => array(
                'title'             => '
                    <tr valign="top">
                        <th></th>
                        <td><button class="button-secondary exec-button" type="submit" name="updateOrderTracking" value="'.__( 'Run the automatic update now', 'woocommerce-gls' ).'">'.__( 'Run the automatic update now', 'woocommerce-gls' ).'</button></td>
                    </tr>',
		        'type'              => 'gls_custom_html',
            ),
		    'tracking_mapping_title' => array(
                'title' => '
                    <tr valign="top">
                        <th><label>' . __('GLS Tracking status', 'woocommerce-gls' ) . '</label></th>
                        <td><b>' . __('WooCommerce order statuses', 'woocommerce-gls' ) . '</b></td>
                    </tr>',
                'type' => 'gls_custom_html',
		    )
        );

        $order_state = wc_get_order_statuses();
        array_unshift($order_state, __( '(No change)', 'woocommerce-gls' ));

        
        foreach (WC_Gls::$trackingStates as $key => $value) {
            array_push(
                $settings,
                array(
                    'title' 		=> $value,
                    'type' 			=> 'select',
                    'options'		=> $order_state,
                    'id' => self::$id.'_tracking_api_order_state_'.$key,
                    'class' => 'tracking-states'
                )
            );
        }

        $settings['section_end_5'] = array(
            'type' => 'sectionend',
            'id' => self::$id.'_section_title_5',
		);

		$settings['section_title_6'] = array(
			'name' => __( 'Support', 'woocommerce-gls' ),
			'type' => 'title',
			'id' => self::$id.'_section_title_6',
		);
		$settings['ssl_patch'] = array(
			'title' => __( 'Enable SSL V1 configuration', 'woocommerce-gls' ),
			'type' => 'checkbox',
			'label' => __( 'Enable SSL V1 configuration', 'woocommerce-gls' ),
			'default' => 'no',
			'desc' => __( 'Enable this option if you have a bad response error when printing a label', 'woocommerce-gls' ),
			'desc_tip' => true,
			'id' => self::$id.'_ssl_patch',
		);
		$settings['section_end_6'] = array(
			'type' => 'sectionend',
			'id' => self::$id.'_section_title_6',
		);

		return apply_filters( 'woocommerce_get_settings_' . self::$id, $settings );
	}

}

WC_Gls_Settings::init();

endif;