<?php


if (!defined('ABSPATH'))
    exit;



include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
if ( is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
	

	function woocommerce_gls_chezvous_init() {

		if ( !class_exists('WC_Gls_Chezvous') && class_exists( 'WC_Gls_Table_Rate_Shipping' )) {

			

			class WC_Gls_Chezvous extends WC_Gls_Table_Rate_Shipping {

				public function __construct() {

					$this->id 					= 'gls_chezvous';
					$this->title 				= 'Gls Chez vous';
					$this->method_description 	= ''; 
					$this->method_title 		= __( WC_Gls::$carrier_definition[$this->id]['name'] );

					parent::__construct();
					$this->init();
				}

				function init() {

					
					$this->init_form_fields(); 
					$this->init_settings(); 

					$this->enabled = $this->settings['enabled'];
					$this->title = $this->settings['title']; 

					
					add_action( 'woocommerce_update_options_shipping_' . $this->id, array( $this, 'process_admin_options' ) );

					parent::init();
				}

				

				function init_form_fields() {

					if (isset(WC_Gls::$carrier_definition[$this->id]['delay'][get_locale()])) {
						$description 	= __( WC_Gls::$carrier_definition[$this->id]['delay'][get_locale()] ); 
					} else {
						$description 	= __( WC_Gls::$carrier_definition[$this->id]['delay']['default'] ); 
					}

					$this->form_fields = array(
						'enabled' => array(
							'title' 		=> __( 'Enable', 'woocommerce-gls' ),
							'type' 			=> 'checkbox',
							'label' 		=> __( 'Enable this shipping method', 'woocommerce-gls' ),
							'default' 		=> 'no',
						),
						'title' => array(
							'title' => __( 'Title', 'woocommerce' ),
							'type' => 'text',
							'description' => __( 'This controls the title which the user sees during checkout.', 'woocommerce-gls' ),
							'default' => __( $this->method_title, 'woocommerce-gls' )
						),
						'description' => array(
							'title' => __( 'Description', 'woocommerce-gls' ),
							'type' => 'textarea',
							'description' => __( 'This controls the description which the user sees during checkout.', 'woocommerce-gls' ),
							'default' => __( $description , 'woocommerce-gls')
						),
						'tax_status' => array(
							'title' 		=> __( 'Tax Status', 'woocommerce-gls' ),
							'type' 			=> 'select',
							'default' 		=> 'taxable',
							'options'		=> array(
								'taxable' 	=> __( 'Taxable', 'woocommerce-gls' ),
								'none' 		=> __( 'None', 'woocommerce-gls' ),
							),
						),
	                    'handling_fee' => array(
                            'title' 		=> __( 'Handling Fee', 'woocommerce-gls' ),
                            'description' 		=> __( 'Fee, excluding tax. Leave blank to disable.', 'woocommerce-gls' ),
                            'type' 			=> 'price',
                            'default' 		=> '0.00',
                            'desc_tip'     => true,
						),
						'disable_add_price_free_shipping' => array(
							'title' 		=> __( 'Additional price', 'woocommerce-gls' ),
							'type' 			=> 'checkbox',
							'label' 		=> __( 'Disable additionnal price even if the delivery is free', 'woocommerce-gls' ),
							'default' 		=> 'no',
						),
						'add_price_mountain' => array(
                            'title' 		=> __( 'Additional price for mountain area', 'woocommerce-gls' ),
                            'type' 			=> 'price',
                            'default' 		=> '0.00',
						),
						'add_price_fr_island' => array(
                            'title' 		=> __( 'Additional price for French islands', 'woocommerce-gls' ),
                            'description' 		=> __( 'Corsica and DOM-TOM excluded.', 'woocommerce-gls' ),
                            'type' 			=> 'price',
                            'default' 		=> '0.00',
                            'desc_tip'     => true,
						),
						'add_price_corsica' => array(
                            'title' 		=> __( 'Additional price for Corsica', 'woocommerce-gls' ),
                            'type' 			=> 'price',
                            'default' 		=> '0.00',
						),
						'add_price_gb_island' => array(
                            'title' 		=> __( 'Additional price for British islands', 'woocommerce-gls' ),
                            'type' 			=> 'price',
                            'default' 		=> '0.00',
						),
						'add_price_sp_pt_island' => array(
                            'title' 		=> __( 'Additional price for Spanish and Portuguese islands', 'woocommerce-gls' ),
                            'description' 		=> __( 'Balearic Islands excluded.', 'woocommerce-gls' ),
                            'type' 			=> 'price',
                            'default' 		=> '0.00',
                            'desc_tip'     => true,
						),
						'add_price_islands' => array(
                            'title' 		=> __( 'Additional price for islands from other countries', 'woocommerce-gls' ),
                            'type' 			=> 'price',
                            'default' 		=> '0.00',
                        ),
                        'disable_corsica' => array(
                            'title' 		=> __( 'Corsica delivery zone', 'woocommerce-gls' ),
							'type' 			=> 'checkbox',
							'label' 		=> __( 'Disable delivery in Corsica', 'woocommerce-gls' ),
							'default' 		=> 'no',
						),
                        'disable_dom_tom' => array(
                            'title' 		=> __( 'DROM-COM delivery zone', 'woocommerce-gls' ),
							'type' 			=> 'checkbox',
							'label' 		=> __( 'Disable delivery in DROM-COM', 'woocommerce-gls' ),
							'default' 		=> 'no',
						),
						'zones_table' => array(
							'type'				=> 'zones_table',
						),
						'table_rates_table' => array(
							'type'				=> 'table_rates_table'
						),
					);
				}

                

                public function calculate_shipping($package = array())
                {
                	global $woocommerce;

                	$available_table_rates = $this->get_available_table_rates($package);
                	$table_rate = $this->pick_cheapest_table_rate($available_table_rates);

                	if ($this->settings['tax_status'] == 'none') {
                		$tax = false;
                	} else {
                		$tax = '';
                	}

                	if ($table_rate != false) {

                        if (WC_Gls::isDisableForZone($woocommerce->customer->get_shipping_country(), $woocommerce->customer->get_shipping_postcode(), $this->settings)) {
                            return false;
                        }

                        $cost = $table_rate['cost'] + $this->settings['handling_fee'];

						if ( !isset($this->settings['disable_add_price_free_shipping']) ||
							( isset($this->settings['disable_add_price_free_shipping']) && $this->settings['disable_add_price_free_shipping'] == 'no')
						) {
							$extra_price = WC_Gls::getAdditionalPrice($woocommerce->customer->get_shipping_country(), $woocommerce->customer->get_shipping_postcode(), $this->settings);
							if (is_numeric($extra_price) && (float)$extra_price > 0) {
								$cost += (float)$extra_price;
							}
						}

						$rate = array(
                			'id' => $this->id,
                			'label' => $this->title,
                			'cost' => $cost,
                			'taxes' => $tax,
                			'calc_tax' => 'per_order'
						);

                		
                		$this->add_rate( $rate );
					}
                }

			}

		}

	}

	add_action( 'woocommerce_shipping_init', 'woocommerce_gls_chezvous_init' );

	function add_gls_chezvous_shipping_method( $methods ) {
		$methods[] = 'WC_Gls_Chezvous';
		return $methods;
	}

	add_filter( 'woocommerce_shipping_methods', 'add_gls_chezvous_shipping_method' );

}
