<?php
/**
 *	Module made by Nukium
 *
 *  @author    Nukium
 *  @copyright 2021 Nukium SAS
 *  @license   All rights reserved
 *
 * ███    ██ ██    ██ ██   ██ ██ ██    ██ ███    ███
 * ████   ██ ██    ██ ██  ██  ██ ██    ██ ████  ████
 * ██ ██  ██ ██    ██ █████   ██ ██    ██ ██ ████ ██
 * ██  ██ ██ ██    ██ ██  ██  ██ ██    ██ ██  ██  ██
 * ██   ████  ██████  ██   ██ ██  ██████  ██      ██
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; 
}

require dirname(__FILE__).'/../vendor/autoload.php';

if (!class_exists('Nukium'))
    require_once( GLS_PLUGIN_PATH . 'lib/Nukium.php' );

include ( GLS_PLUGIN_PATH . 'lib/NkmHelper.php' );

if ( ! class_exists( 'WC_Gls_Admin_Packing_List' ) ) :

class WC_Gls_Admin_Packing_List extends WC_Settings_API {

	public $id = 'gls_admin_packing_list';

	public $errors = array();

	public $debug = false;

	public function __construct() {

		
		$this->init_settings();

	}

	public function init() {
		add_submenu_page('woocommerce', __('GLS packing list', 'woocommerce-gls'), __('GLS packing list', 'woocommerce-gls'), 'manage_woocommerce', 'woocommerce-gls-packing-list', array($this, 'display_page'), 8);
		add_action( 'admin_enqueue_scripts', 'wc_gls_admin_scripts_styles' );
		add_action('admin_notices', array($this, 'display_notices'));

		
        load_plugin_textdomain( 'woocommerce-gls', false, basename( dirname( __FILE__ ) ) . '/languages/' );

        $this->init_form_fields();
	}

	

	public function display_notices() {
    	settings_errors( 'gls-packing-list-error' );
	}

	public function display_page() {

	    
	    $this->init_settings();

		$this->admin_options();
	}

	

	public function init_form_fields() {

	    $this->form_fields    = array(
	        'export_section_title' =>    array(
	            'title' 	=> __( 'Packing list printing', 'woocommerce-gls' ),
	            'type' 		=> 'title',
	            'id' 		=> 'gls-packing-list-title',
	            'description' => __('Generate your GLS packing list', 'woocommerce-gls'),
	        ),
            'order_date_from' => array(
                'title'             => __( 'From', 'woocommerce-gls' ),
                'type'              => 'gls_datepicker',
                'id'                => 'woocommerce_gls_admin_packing_list_order_date_from',
                'default'           => '',
                'class'             => 'required',
            ),
            'order_date_to' => array(
                'title'             => __( 'To', 'woocommerce-gls' ),
                'type'              => 'gls_datepicker',
                'id'                => 'woocommerce_gls_admin_packing_list_order_date_to',
                'default'           => '',
                'class'             => 'required',
            ),
            'export_status' =>    array(
                'title' => __( 'Order statuses', 'woocommerce-gls' ),
                'type' => 'multiselect',
                'options'     => wc_get_order_statuses(),
	        ),
            'packing_list_section_end' => array(
                'type' => 'packing_list_section_end',
                'id' => 'printPackingListStep2',
                'title' => __( 'Next', 'woocommerce-gls' ),
            ),
        );
	}

    public function admin_options() {

        if (isset($_POST['printPackingList'])) {

    		
    		$this->printPackingList();

        }

        
		ob_start();
		parent::admin_options();
		$buffer = ob_get_contents();
        @ob_end_clean();

        $admin_url = admin_url( 'admin.php?page=woocommerce-gls-packing-list' );

        if (isset($_POST['printPackingListStep2'])) {

            $error = true;

            $data_package = $this->getPackages();
            if (!empty($data_package)) {
                

                $error = false;
                Nukium::load_view('admin/packing-list', array('orders' => $data_package, 'admin_url' => $admin_url));
            }

            if ($error) {
                add_settings_error( 'gls-packing-list-error', 'gls-export-order-error', __('No package has been found.', 'woocommerce-gls'), 'error' );

                settings_errors( 'gls-packing-list-error' );
                Nukium::load_view('admin/order-label', array(
                    'settings' => $buffer,
                    'admin_url' => $admin_url,
                ));
            }

        } else {
            settings_errors( 'gls-packing-list-error' );
            Nukium::load_view('admin/order-label', array(
                'settings' => $buffer,
                'admin_url' => $admin_url,
            ));
        }
    }

    public function generate_gls_datepicker_html ( $key, $data ) {

        $defaults  = array(
            'title'             => '',
            'class'             => '',
            'css'               => '',
        );

        $data = wp_parse_args( $data, $defaults );

        $data['input_name'] = $data['id'];

        return Nukium::load_view('admin/input-type-datepicker', $data, true);
    }

    public function generate_packing_list_section_end_html( $key, $data ) {

        $defaults  = array(
            'title'             => '',
            'class'             => '',
            'css'               => '',
        );
        $data = wp_parse_args( $data, $defaults );

        return Nukium::load_view('admin/packing-list-btn', array('input_name' => $data['id'], 'input_value' => $data['title']), true);
    }


    

    private function getPackages() {

        global $wpdb;

        $_orders = array();

        $label_order_state = $this->settings['export_status'];

        if ( ( is_array($label_order_state) && count($label_order_state) > 0)
            && isset($_POST['woocommerce_gls_admin_packing_list_order_date_from_hidden']) && !empty($_POST['woocommerce_gls_admin_packing_list_order_date_from_hidden'])
            && isset($_POST['woocommerce_gls_admin_packing_list_order_date_to_hidden']) && !empty($_POST['woocommerce_gls_admin_packing_list_order_date_to_hidden'])) {

            $filter_date_from  = new DateTime($_POST['woocommerce_gls_admin_packing_list_order_date_from_hidden']);
            $filter_date_to  = new DateTime($_POST['woocommerce_gls_admin_packing_list_order_date_to_hidden']);

            $sql = "SELECT p.*, gl.* FROM {$wpdb->prefix}woocommerce_gls_label gl
                        INNER JOIN {$wpdb->posts} p ON p.id = gl.order_id
                        WHERE p.post_type = 'shop_order'
                        AND p.post_status IN ('".implode('\',\'', $label_order_state)."')
                        AND DATE_FORMAT(gl.`date_add`, '%Y-%m-%d') >= '".$filter_date_from->format('Y-m-d')."'
                        AND DATE_FORMAT(gl.`date_add`, '%Y-%m-%d') <= '".$filter_date_to->format('Y-m-d')."'";

            return $wpdb->get_results( $sql );
        }
        return false;
    }


    public function save() {
        if ( $this->get_post_data() && isset($_POST['printPackingListStep2']) ) {
            parent::process_admin_options();
        }
    }

    

    public function printPackingList()
    {
        global $wpdb;

        if (!isset($_POST['packagePost']) ||
            (isset($_POST['packagePost']) && (
                !is_array($_POST['packagePost'])
                || (is_array($_POST['packagePost']) && count($_POST['packagePost']) <= 0)))
        ) {

            add_settings_error( 'gls-packing-list-error', 'gls-print-packing-list-error', __('Please select at least one package', 'woocommerce-gls'), 'error' );

        } else {

            @ob_end_clean();

            $packages = array();

            $sql = "SELECT p.*, gl.* FROM {$wpdb->prefix}woocommerce_gls_label gl
                        INNER JOIN {$wpdb->posts} p ON p.id = gl.order_id
                        WHERE p.post_type = 'shop_order'
                        AND gl.id IN (".implode(',', array_map('intval', $_POST['packagePost'])).")";

            $packages = $wpdb->get_results( $sql );

            $html = Nukium::load_view('pdf/pdf-packing-list.style-tab', array(), true);
            $html .= Nukium::load_view('pdf/pdf-packing-list', array('packages' => $packages, 'gls_product_code' => WC_Gls::$product_code), true);

            $pdf = new GlsPDF('L');
            $pdf->packages = $packages;
            $pdf->SetHeaderMargin(5);
            $pdf->SetFooterMargin(21);
            $pdf->setMargins(10, 40, 10);
            $pdf->AddPage();
            $pdf->WriteHTML($html, true, false, true, false, '');
            $pdf->Output('packing-list-'.date('Y-m-d_H-i').'.pdf', 'I');
        }
    }

}

endif;

$gls_admin_packing_list = new WC_Gls_Admin_Packing_List();
add_action( 'admin_menu', array( $gls_admin_packing_list, 'init' ) );
add_action( 'admin_init', array( $gls_admin_packing_list, 'save' ) );

if ( ! class_exists( 'GlsPDF' ) ) :

class GlsPDF extends TCPDF {

    public $packages;

    
    public function Header() {

        
        $shop_address = array(
            'firstname' => '',
            'lastname' => '',
            'company' => get_option( 'gls_settings_api_shop_return_address_name' ),
            'address1' => get_option( 'gls_settings_api_shop_return_address_address1' ),
            'address2' => get_option( 'gls_settings_api_shop_return_address_address2' ),
            'city' => get_option( 'gls_settings_api_shop_return_address_city' ),
            'postcode' => get_option( 'gls_settings_api_shop_return_address_postcode' ),
            'country' => get_option( 'gls_settings_api_shop_return_address_country' ),
        );

        $glsLogo = WC_Gls::plugin_url() . '/views/img/admin/gls-logo-print.jpg';
        $width = 171;
        $height = 46;

        $nbLabels = $total_weight = 0;
        if (is_array($this->packages) && count($this->packages) > 0) {
            $nbLabels = count($this->packages);
            foreach ($this->packages as $value) {
                $total_weight += floatval($value->weight);
            }
        }

        $html = Nukium::load_view('pdf/pdf-packing-list.style-tab', array(), true);

        $html .= Nukium::load_view('pdf/pdf-packing-list-header', array(
            'gls_logo' => $glsLogo,
            'width_logo' => $width,
            'height_logo' => $height,
            'shop_address' => $shop_address,
            'shop_url' => get_site_url(),
            'client_number' => get_option( 'gls_settings_api_customer_id' ).' '.get_option( 'gls_settings_api_contact_id' ),
            'nb_labels' => $nbLabels,
            'total_weight' => $total_weight,
        ), true);

        $this->WriteHTML($html, true, false, true, false, '');
    }

    
    public function Footer() {
        
        $this->SetY(-15);
        
        $this->SetFont('helvetica', 'I', 8);
        
        $this->Cell(0, 10, $this->getAliasNumPage().' / '.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

endif;
