<?php
/**
 *	Module made by Nukium
 *
 *  @author    Nukium
 *  @copyright 2021 Nukium SAS
 *  @license   All rights reserved
 *
 * ███    ██ ██    ██ ██   ██ ██ ██    ██ ███    ███
 * ████   ██ ██    ██ ██  ██  ██ ██    ██ ████  ████
 * ██ ██  ██ ██    ██ █████   ██ ██    ██ ██ ████ ██
 * ██  ██ ██ ██    ██ ██  ██  ██ ██    ██ ██  ██  ██
 * ██   ████  ██████  ██   ██ ██  ██████  ██      ██
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; 
}

if (!class_exists('Nukium'))
    require_once( GLS_PLUGIN_PATH . 'lib/Nukium.php' );

include ( GLS_PLUGIN_PATH . 'lib/NkmHelper.php' );

if ( ! class_exists( 'WC_Gls_Admin_Order_Export' ) ) :

class WC_Gls_Admin_Order_Export extends WC_Settings_API {

	public $id = 'gls_admin_order_export';

	public $errors = array();

	public $exportDirectory = 'export';

	public $fromCron = false;

	public $debug = false;

	public function __construct() {

		
		$this->init_settings();

	}

	public function init() {
		add_submenu_page('woocommerce', __('GLS Export', 'woocommerce-gls'), __('GLS Export', 'woocommerce-gls'), 'manage_woocommerce', 'woocommerce-gls-export', array($this, 'display_page'), 8);
		add_action( 'admin_enqueue_scripts', 'wc_gls_admin_scripts_styles' );
		add_action('admin_notices', array($this, 'display_notices'));

		
		load_plugin_textdomain( 'woocommerce-gls', false, basename( dirname( __FILE__ ) ) . '/languages/' );

		
		$prefix = get_option( 'gls_export_prefix' );
		if (empty($prefix)) {
		    add_option( 'gls_export_prefix', 'wc' . rand(1000, 9999) );
        }

        
		$prefix_option = get_option( 'gls_settings_order_prefix' );
		if (empty($prefix_option)) {
		    add_option( 'gls_settings_order_prefix', 'yes' );
		}

        $this->init_form_fields();
	}

	

	public function display_notices() {
    	settings_errors( 'gls-order-error' );
	}

	public function display_page() {

	    
	    $this->init_settings();

		$this->admin_options();
	}

	

	public function init_form_fields() {

	    $order_state = wc_get_order_statuses();
	    array_unshift($order_state, __( '(No change)', 'woocommerce-gls' ));

	    $this->form_fields    = array(
	        'export_section_title' =>    array(
	            'title' 	=> __( 'Export GLS Orders', 'woocommerce-gls' ),
	            'type' 		=> 'title',
	            'id' 		=> 'gls-export-order-title',
	            'description' => __('Export your GLS orders by choosing one or more order statuses and click on the export button.', 'woocommerce-gls')
	               .'<br>'.__('The file can be directly integrated on the software Winexpe by GLS.', 'woocommerce-gls')
	               .'<br>'.__('It\'s possibe to change automatically the order status after exportation.', 'woocommerce-gls'),
	        ),
            'export_status' =>    array(
                'title' => __( 'Order statuses', 'woocommerce-gls' ),
                'type' => 'multiselect',
                'options'     => wc_get_order_statuses(),
	        ),
	        'export_new_order_state'         => array(
	            'title'       => __( 'Change order status to', 'woocommerce-gls' ),
	            'type'        => 'select',
	            'options'     => $order_state,
	        ),
	        'export_automation'         => array(
				'title'       => __( 'Enable/Disable automation', 'woocommerce-gls' ),
				'type'        => 'checkbox',
	        	'label'       => ' ',
				'default'     => 'no',
	            'description' => __('The automation allows the integration of your GLS orders directly into the Winexpe software.', 'woocommerce-gls'),
	            'desc_tip'    => true,
			),
        );
	}

    public function admin_options() {

    	global $wpdb;

    	if (isset($_POST['exportOrderAutomatic'])) {

    	    $this->fromCron = true;
    	    $this->exportWinexpe();

            if (count($this->errors) == 0) {
                
                add_settings_error( 'gls-order-error', 'gls-export-order-error', __('Orders exported successfully.', 'woocommerce-gls'), 'updated' );
            } else {
                foreach ($this->errors as $value) {
                    add_settings_error( 'gls-order-error', 'gls-export-order-error', $value, 'error' );
                }
            }

    	} elseif (isset($_POST['exportOrder']) || isset($_POST['exportOrderFromStep2'])) {

    		
    		$this->exportWinexpe();

		}

		
		ob_start();
		parent::admin_options();
		$buffer = ob_get_contents();
		@ob_end_clean();

		$admin_url = admin_url( 'admin.php?page=woocommerce-gls-export' );

		if (isset($_POST['exportOrderStep2'])) {

			$error = true;

			$export_order_state = $this->settings['export_status'];
			if ((is_array($export_order_state) && count($export_order_state) > 0)) {

				
				$sql = "SELECT * FROM {$wpdb->posts} p, {$wpdb->prefix}woocommerce_gls_cart_carrier gls
					WHERE p.id = gls.order_id AND post_type = 'shop_order'
					AND p.post_status IN ('".implode('\',\'', $export_order_state)."')";
				$data_order = $wpdb->get_results( $sql );

				if (!empty($data_order)) {
					

                    $error = false;

                    
                    $weight_ratio = 1;
                    if (get_option('woocommerce_weight_unit') == 'g') {
                        $weight_ratio = 0.001;
                    }

					Nukium::load_view('admin/order-export-step2', array('orders' => $data_order, 'admin_url' => $admin_url, 'weight_ratio' => $weight_ratio));
				}
			}

			if ($error) {
				add_settings_error( 'gls-order-error', 'gls-export-order-error', __('No order has been found.', 'woocommerce-gls'), 'error' );

				settings_errors( 'gls-order-error' );
				Nukium::load_view('admin/order-export', array(
				    'settings' => $buffer,
				    'export_path' => GLS_PLUGIN_PATH . $this->exportDirectory . '/',
				    'admin_url' => $admin_url,
				));
			}

		} else {
			settings_errors( 'gls-order-error' );
			Nukium::load_view('admin/order-export', array(
			    'settings' => $buffer,
				'export_path' => GLS_PLUGIN_PATH . $this->exportDirectory . '/',
			    'admin_url' => $admin_url,
			));
		}
    }

    public function save() {
    	if ($this->get_post_data()
			&& !isset($_POST['exportOrderFromStep2'])
    		&& (isset($_POST['exportOrder'])
    			|| isset($_POST['saveExportOrder'])
    			|| isset($_POST['exportOrderStep2'])
    		    || isset($_POST['exportOrderAutomatic'])
    		)
    	) {
	    	parent::process_admin_options();
    	}
    }

    

    public function exportWinexpe()
    {
        global $wpdb;

        $_orders = array();
        if (isset($_POST['exportOrderFromStep2'])) {
        	if (!empty($_POST['orderPost'])) {
        		$_orders = $_POST['orderPost'];
        	} else {
        		add_settings_error( 'gls-order-error', 'gls-export-detail-order-error', __('Please select one or more order.', 'woocommerce-gls'), 'error' );
        		return;
        	}
        }

        $export_order_state = $this->settings['export_status'];
        if ((is_array($export_order_state) && count($export_order_state) > 0) || count($_orders) > 0) {

            
            $sql = "SELECT * FROM {$wpdb->posts} p, {$wpdb->prefix}woocommerce_gls_cart_carrier gls
                WHERE p.id = gls.order_id AND post_type = 'shop_order'";

            if (count($_orders) > 0) {
                $sql .= ' AND p.ID IN ('.implode(',', $_orders).')';
            } else {
                $sql .= ' AND p.post_status IN (\''.implode('\',\'', $export_order_state).'\')';
            }

            $data_order = $wpdb->get_results( $sql );
            if ($data_order) {

                $export_header = array(
                    'ORDERID' => 'ORDERID',
                    'ORDERNAME' => 'ORDERNAME',
                    'PRODUCTNO' => 'PRODUCTNO',
                    'ORDERWEIGHTOT' => 'ORDERWEIGHTOT',
                    'CONSID' => 'CONSID',
                    'CONTACT' => 'CONTACT',
                    'CONTACTMAIL' => 'CONTACTMAIL',
                    'CONTACTMOBILE' => 'CONTACTMOBILE',
                    'CONTACTPHONE' => 'CONTACTPHONE',
                    'STREET1' => 'STREET1',
                    'STREET2' => 'STREET2',
                    'STREET3' => 'STREET3',
                    'COUNTRYCODE' => 'COUNTRYCODE',
                    'CITY' => 'CITY',
                    'ZIPCODE' => 'ZIPCODE',
                    'REFPR' => 'REFPR');

                $csv_file = new NkmCsv();
                $csv_file->createTemplate($export_header);
                $csv_file->csvDelimeter = ';';

                
                $weight_ratio = 1;
                if (get_option('woocommerce_weight_unit') == 'g') {
                    $weight_ratio = 0.001;
                }

                foreach ($data_order as $row) {

                    $order = wc_get_order($row->ID);

                    $order_weight = 0;
                    foreach ($order->get_items() as $value) {
                        if ((int)$value['qty'] > 0) {
                            if ((int)$value['variation_id'] > 0) {
                                $product = wc_get_product($value['variation_id']);
                            } else {
                                $product = wc_get_product($value['product_id']);
                            }

                            if ($product) {
                                $order_weight += (float)$product->get_weight() * $value['qty'] * $weight_ratio;
                            }
                        }
                    }
                    $order_weight = round($order_weight,2);

                    $customer_delivery_address = $order->get_address('shipping');
                    if (!empty($row->parcel_shop_id) && $row->gls_product == '17') {
                        $customer_address = $order->get_address();
                    } else {
                        $customer_address = $customer_delivery_address;
                    }

                    $customer_country_iso = $customer_address['country'];

                    $csv_line = array();
                    
                    if (get_option( 'gls_settings_order_prefix' ) === 'yes') {
                        $csv_line['ORDERID'] = get_option( 'gls_export_prefix' ).'-'.$row->ID;
                    } else {
                        $csv_line['ORDERID'] = $row->ID;
                    }

                    
                    if (!empty($customer_address['company'])) {
                        $csv_line['ORDERNAME'] = strtoupper(nkmStripAccents($customer_address['company']));
                    } else {
                        $csv_line['ORDERNAME'] = strtoupper(nkmStripAccents($customer_address['first_name'].' '.$customer_address['last_name']));
                    }

                    
                    if (!empty($row->gls_product)) {
                        $csv_line['PRODUCTNO'] = $row->gls_product;
                    } else {
                        
                        $csv_line['PRODUCTNO'] = WC_Gls::get_gls_product($row->shipping_method_id, $customer_country_iso);
                    }

                    
                    if (isset($_POST['order_weight_'.$row->ID]) && is_numeric($_POST['order_weight_'.$row->ID])) {
                        $csv_line['ORDERWEIGHTOT'] = round(str_replace(',', '.', $_POST['order_weight_'.$row->ID]), 3);
                    } else {
                        $csv_line['ORDERWEIGHTOT'] = $order_weight;
                    }

                    
                    $csv_line['CONSID'] = $order->get_customer_id();

                    
                    $csv_line['CONTACT'] = strtoupper(nkmStripAccents($customer_delivery_address['first_name'].' '.$customer_delivery_address['last_name']));

                    
                    $csv_line['CONTACTMAIL'] = $order->get_billing_email();

                    
                    if (!empty($row->customer_phone_mobile)) {
                        $csv_line['CONTACTMOBILE'] = preg_replace('/[^0-9\+]/', '', $row->customer_phone_mobile);
                    } elseif (!empty($customer_address['phone'])) {
                        $csv_line['CONTACTMOBILE'] = preg_replace('/[^0-9\+]/', '', $customer_address['phone']);
                    } else {
                        $csv_line['CONTACTMOBILE'] = preg_replace('/[^0-9\+]/', '', $order->get_billing_phone());
                    }

                    
                    $csv_line['CONTACTPHONE'] = $csv_line['CONTACTMOBILE'];

                    
                    $tab_adresse = nkmCutSentenceMulti($customer_address['address_1'], 35);
                    
                    $csv_line['STREET1'] = strtoupper(nkmStripAccents($tab_adresse[0]));

                    if (isset($tab_adresse[1])) {
                        
                        $csv_line['STREET2'] = strtoupper(nkmStripAccents($tab_adresse[1]));
                        
                        $csv_line['STREET3'] = substr(strtoupper(nkmStripAccents($customer_address['address_2'])), 0, 35);
                    } else {
                        
                        $csv_line['STREET2'] = substr(strtoupper(nkmStripAccents($customer_address['address_2'])), 0, 35);
                        
                        $csv_line['STREET3'] = '';
                    }

                    
                    $csv_line['COUNTRYCODE'] = $customer_country_iso;
                    
                    $csv_line['CITY'] = substr(strtoupper(nkmStripAccents($customer_address['city'])), 0, 35);
                    
                    $csv_line['ZIPCODE'] = $customer_address['postcode'];
                    
                    if (!empty($row->parcel_shop_id)) {
                        $csv_line['REFPR'] = $row->parcel_shop_id;
                    } else {
                        $csv_line['REFPR'] = '';
                    }
                    $csv_file->addEntry($csv_line);

                    
                    if (!empty($this->settings['export_new_order_state']) && $this->settings['export_new_order_state'] != $row->post_status) {
                        $order->update_status($this->settings['export_new_order_state']);
                    }
                }

                if ($this->fromCron) {

                    
                    file_put_contents(GLS_PLUGIN_PATH . $this->exportDirectory . '/GlsCmd_'.nkmUdate('YmdHisu').'.csv', $csv_file->buildDoc());
                    return true;

                } else {

                    while (@ob_end_clean());
                	header('Content-type: text/csv');
                    header('Content-Type: application/force-download; charset=ISO-8859-1');
                    header('Cache-Control: no-store, no-cache');
                    header('Content-disposition: attachment; filename="GlsCmd_'.nkmUdate('YmdHisu').'.csv"');

                    exit($csv_file->buildDoc());
                }

            } else {
                if ($this->fromCron) {
                    $this->errors[] = __('No order has been found.', 'woocommerce-gls');
                } else {
                    add_settings_error( 'gls-order-error', 'gls-export-order-error', __('No order has been found.', 'woocommerce-gls'), 'error' );
                }
            }

        } else {
            if (!$this->fromCron) {
                add_settings_error( 'gls-order-error', 'gls-export-order-error', __('Please select one or more order status.', 'woocommerce-gls'), 'error' );
            }
        }
    }

    

    public function cronTask() {

        if ($this->settings['export_automation'] === 'yes') {
            $this->fromCron = true;
            $this->exportWinexpe();
        }
        if (count($this->errors) > 0 && $this->debug) {


        }
    }

}

endif;

if ( ! class_exists( 'WC_Gls_Admin_Order_Import' ) ) {

    class WC_Gls_Admin_Order_Import extends WC_Settings_API {

        public $id = 'gls_admin_order_import';

        public $errors = array();

        public $importDirectory = 'import/winexpe';

        public $fromCron = false;
        public $localImport = false;

        public $debug = false;

        public function __construct() {

            
            $this->init_settings();
        }

        public function init() {

            $page = add_submenu_page('woocommerce', __('GLS Import', 'woocommerce-gls'), __('GLS Import', 'woocommerce-gls'), 'manage_woocommerce', 'woocommerce-gls-import', array($this, 'display_page'), 8);
    		add_action( 'admin_enqueue_scripts', 'wc_gls_admin_scripts_styles' );
            add_action('admin_notices', array($this, 'display_notices'));

            
            load_plugin_textdomain( 'woocommerce-gls', false, basename( dirname( __FILE__ ) ) . '/languages/' );

            
            $prefix = get_option( 'gls_export_prefix' );
            if (empty($prefix)) {
                add_option( 'gls_export_prefix', 'wc' . rand(1000, 9999) );
            }

            
            $prefix_option = get_option( 'gls_settings_order_prefix' );
            if (empty($prefix_option)) {
                add_option( 'gls_settings_order_prefix', 'yes' );
            }

            $this->init_form_fields();
        }

        

        public function display_notices() {
            settings_errors( 'gls-order-error' );
        }

        public function display_page() {

            
            $this->init_settings();
            $this->admin_options();
        }

        

        public function init_form_fields() {

            $order_state = wc_get_order_statuses();
            array_unshift($order_state, __('(No change)'));

            $this->form_fields    = array(
                'import_section_title' =>    array(
                    'title' 	=> __( 'Import GLS tracking numbers', 'woocommerce-gls' ),
                    'type' 		=> 'title',
                    'id' 		=> 'gls-import-order-title',
                    'description' => __('Import the CSV file provided by the Winexpe software to update the tracking numbers and keep your customers informed about their order\'s delivery.', 'woocommerce-gls'),
                ),
                'winexpe_file' =>    array(
                    'title' => __( 'GLS File', 'woocommerce-gls' ),
                    'type' => 'file',
                ),
                'import_new_order_state'         => array(
                    'title'       => __( 'Change order status to', 'woocommerce-gls' ),
                    'type'        => 'select',
                    'options'     => $order_state,
                ),
                'import_automation'         => array(
                    'title'       => __( 'Enable/Disable automation', 'woocommerce-gls' ),
                    'type'        => 'checkbox',
                	'label'       => ' ',
                    'default'     => 'no',
                    'description' => __('The automation allows the integration of tracking numbers in your GLS orders and automatically notify customers.', 'woocommerce-gls'),
                    'desc_tip'    => true,
                ),
            );
        }

        public function admin_options() {

            global $wpdb;

            if (isset($_POST['importOrder'])) {

                
                $this->importWinexpe();

            } elseif (isset($_POST['importOrderAutomatic'])) {

                $this->fromCron = false;
                $this->localImport = true;
                $this->importWinexpe();

            }

            
            ob_start();
            parent::admin_options();
            $buffer = ob_get_contents();
            @ob_end_clean();

            $admin_url = admin_url( 'admin.php?page=woocommerce-gls-import' );

            settings_errors( 'gls-order-error' );
            Nukium::load_view('admin/order-import', array(
                'settings' => $buffer,
                'import_path' => GLS_PLUGIN_PATH . $this->importDirectory . '/',
                'admin_url' => $admin_url,
            ));
        }

        public function save() {
            if ( $this->get_post_data() && (isset($_POST['saveImportOrder']) || isset($_POST['importOrder']) || isset($_POST['importOrderAutomatic'])) ) {
                parent::process_admin_options();
            }
        }

        

        public function importWinexpe()
        {
            global $wpdb;

            $files = array();
            if ($this->localImport) {

                
        		$files = self::getCsvFiles(GLS_PLUGIN_PATH . $this->importDirectory . '/');

            } else {

                $extension = array('.txt', '.csv');

                
                if (isset($_FILES['woocommerce_'.$this->id.'_winexpe_file']['name'])
                    && !empty($_FILES['woocommerce_'.$this->id.'_winexpe_file']['name'])
                    && !empty($_FILES['woocommerce_'.$this->id.'_winexpe_file']['tmp_name'])
                    && $_FILES['woocommerce_'.$this->id.'_winexpe_file']['error'] == 0
                    && in_array(strtolower(substr($_FILES['woocommerce_'.$this->id.'_winexpe_file']['name'], -4)), $extension)
                    ) {

                        $files[] = $_FILES['woocommerce_'.$this->id.'_winexpe_file']['tmp_name'];

                    }
            }

            if (count($files) > 0) {

                $csv_file = new NkmCSVReader();

                foreach ($files as $file_path) {

                    
                    $csv_content = $csv_file->parse_file($file_path, false, true);

                    if (!$csv_content) {
                        if ($this->fromCron) {
                            $this->errors[] = __('File content empty.', 'woocommerce-gls');
                        } else {
                            add_settings_error( 'gls-order-error', 'gls-import-order-error', __('File content empty.', 'woocommerce-gls'), 'error' );
                        }
                    } else {

                        
                        $orderImported = array();

                        foreach ($csv_content as $line) {

                            
                            if (get_option( 'gls_settings_order_prefix' ) === 'yes') {
                                $order_tmp = explode('-', $line[4]);
                                if (count($order_tmp) == 2) {
                                    $order_id = $order_tmp[1];
                                    if ($order_tmp[0] != get_option( 'gls_export_prefix' )) {
                                        continue;
                                    }
                                } else {
                                    continue;
                                }
                            } else {
                                $order_id = $line[4];
                            }

                            $order = wc_get_order($order_id);
                            if ($order && $order instanceof WC_Order) {

                                
                                $sql = "SELECT * FROM {$wpdb->prefix}woocommerce_gls_cart_carrier WHERE order_id=%d";
                                $query_row = $wpdb->get_row( $wpdb->prepare( $sql , $order_id ) );

                                if($query_row) {

                                    
                                    $old_tracking_number = '';
                                    $pattern = '/'.str_replace(array('@', '/', '?'), array('', '\/', '\?'), WC_Gls::$trackingUrl).'([^"]+)/';

                                    foreach ($order->get_customer_order_notes() as $note) {
                                        if (preg_match($pattern, $note->comment_content, $matches)) {
                                            $old_tracking_number = $matches[1];
                                            break;
                                        }
                                    }

                                    if (!empty($line[17]) && (empty($old_tracking_number) || !empty($old_tracking_number) && strpos($old_tracking_number, $line[17]) === false)) {

                                        if (!empty($old_tracking_number)) {
                                            $shippingNumbers = explode(',', $old_tracking_number);
                                            $shippingNumbers[] = $line[17];
                                            $tracking_number = implode(',', $shippingNumbers);
                                        } else {
                                            $tracking_number = $line[17];
                                        }

                                        

                                        $note = __('You can track your package using the following link:', 'woocommerce-gls');
                                        $link = str_replace('@', $tracking_number, WC_Gls::$trackingUrl);
                                        $note .= ' <a href="'.$link.'">'.$link.'</a>';

                                        if (!$order->add_order_note($note, 1, true)) {
                                            if ($this->fromCron) {
                                                $this->errors[] = __('The customer order note cannot be created.', 'woocommerce-gls');
                                            } else {
                                                add_settings_error( 'gls-order-error', 'gls-import-order-error', __('The customer order note cannot be created.', 'woocommerce-gls'), 'error' );
                                            }
                                            continue;
                                        }

                                        

                                        if(!empty($this->settings['import_new_order_state']) && $this->settings['import_new_order_state'] != $order->get_status()) {
                                            $order->update_status($this->settings['import_new_order_state']);
                                        }

                                    } else {
                                        if ($this->fromCron) {
                                            $this->errors[] = sprintf(__('Tracking number is empty or already integrated for order %s.', 'woocommerce-gls'), $line[4]);
                                        } else {
                                            add_settings_error( 'gls-order-error', 'gls-import-order-error', sprintf(__('Tracking number is empty or already integrated for order %s.', 'woocommerce-gls'), $line[4]), 'error' );
                                        }
                                        continue;
                                    }

                                    $orderImported[$order_id] = $order_id;
                                }
                            }
                        }

                        if (count($orderImported) > 0 && !$this->fromCron) {
                            

                            add_settings_error( 'gls-order-error', 'gls-import-order-error', sprintf(__('%d Order(s) successfully processed.', 'woocommerce-gls'), count($orderImported)), 'updated' );
                        }
                    }

                    if ($this->localImport) {
                        unlink($file_path);
                    }
                }
            } elseif (!$this->fromCron) {
                add_settings_error( 'gls-order-error', 'gls-import-order-error', __('File not found. Make sure you upload a file on the form or on the synchronisation folder.', 'woocommerce-gls'), 'error' );
            }
        }

        

        public function cronTask() {

            if ($this->settings['import_automation'] === 'yes') {
                $this->fromCron = true;
                $this->localImport = true;
                $this->importWinexpe();
            }
            if (count($this->errors) > 0 && $this->debug) {


            }
        }

        

        protected static function getCsvFiles($directory)
        {
            $files = array();

            $dir = opendir($directory);
            while (false !== ($file = readdir($dir))) {
                if ($file == '.' || $file == '..') {
                    continue;
                }
                $fileInfo = pathinfo($directory.$file);
                if (is_file($directory.$file) && strtoupper($fileInfo['extension']) == 'CSV') {
                    $files[] = $directory.$file;
                }
            }
            closedir($dir);

            return $files;
        }

    }

}

$gls_admin_order_export = new WC_Gls_Admin_Order_Export();
add_action( 'admin_menu', array( $gls_admin_order_export, 'init' ) );
add_action( 'admin_init', array( $gls_admin_order_export, 'save' ) );
add_action( 'gls_order_export_cron',  array( $gls_admin_order_export, 'cronTask' ) );

$gls_admin_order_import = new WC_Gls_Admin_Order_Import();
add_action( 'admin_menu', array( $gls_admin_order_import, 'init' ) );
add_action( 'admin_init', array( $gls_admin_order_import, 'save' ) );
add_action( 'gls_order_import_cron',  array( $gls_admin_order_import, 'cronTask' ) );
