<?php
/*
  Plugin Name: cdurteste
  Plugin URI: https://cdurteste.fr
  Description: Fonctionalités spécifiques logibrico
  Version: 0.1
  Author: Christophe Durteste
  Author URI: https://cdurteste.fr
  License: GPL2

 */
ini_set('display_errors', '1');

function bbx_enqueue_scripts() {
    wp_enqueue_script('jquery');
}
add_action('wp_enqueue_scripts', 'bbx_enqueue_scripts');
wp_enqueue_script("cdurteste2", plugins_url() . "/CDurteste/js/cdurteste.js", array('jquery'));
wp_enqueue_style("cdurteste3", plugins_url() . "/CDurteste/css/cdurteste.css");

add_shortcode("cdNorme", "cdNorme");
add_shortcode("cdEnergie", "cdEnergie");
add_shortcode("cdFicheTechniquePdf", "cdFicheTechniquePdf");

function cdNorme($attrs) {
    $files2 = $attrs["file"];
    $files = explode(",", $files2);
    foreach ($files as $file) {
        $fichier = plugins_url() . "/CDurteste/images/$file.png";
        $path = ABSPATH . "wp-content/plugins/CDurteste/images/$file.png";

        if (file_exists($path)) {
            $return .= "<img class='cdNorme' src='$fichier'>";
        }
    }
    return $return;
}

function cdEnergie($attrs) {
    $file = $attrs["file"];
    $fichier = plugins_url() . "/CDurteste/images/$file.png";
    $path = ABSPATH . "wp-content/plugins/CDurteste/images/$file.png";

    if (file_exists($path)) {
        $return = "<img class='cdEnergie' src='$fichier'>";
        return $return;
    }
}

function cdFicheTechniquePdf($attrs) {

    $file = $attrs["file"];
    $fichier = plugins_url() . "/CDurteste/pdf/$file.pdf";
    $path = ABSPATH . "wp-content/plugins/CDurteste/pdf/$file.pdf";
    //
    if (file_exists($path)) {
        $return = "<a class='cdPdf' href='$fichier' target='_blank'>Télécharger la fiche technique en PDF</a>";
        return $return;
    }
}
