/* 
 * CDurteste 2016.
 * contact@cdurteste.fr
 * +33 6 70 80 98 84
 */
var $ = jQuery.noConflict();
$(document).ready(function () {
    $(".qte").keyup(function () {
        qteKeyup(this);
    });
    chargementPx();
    mopoLoad();
});

function mopoLoad() {
    if (typeof $("#mopoMenu").val() === "undefined")
    {
        $("#menu-mopo").css("display", "none");
    } else
    {
        var decode = atob($("#mopoMenu").val());
        $("#menu-mopo").html(decode);
        console.log($("#mopoMenu").width(), $(".menu-mopo-level1").length);

        $(".menu-mopo-level1").width(1800 / $(".menu-mopo-level1").length);


        $(".cdAccordeonButton").each(function () {
            $(this).addClass("hidden");
        });
    }

}

function chargementPx() {

    $.ajax(
            {
                type: "POST",
                data: {
                    'action': 'getGtpPx',
                    'sid': $("#sid").val(),
                },
                url: prefixe + "ajax.php",
                success: function (retour) {
                    var obj = JSON.parse(retour);
                    for (const [key, value] of Object.entries(obj)) {
                        $("#gtpPx" + `${key}`).replaceWith(`${value}`);
                    }
                },
                error: function () {

                }
            });
    $(".gtpPx").each(function () {

    });
}
function deconnect() {
    $.ajax(
            {
                type: "POST",
                data: {
                    'action': 'deconnect',
                    'sid': $("#sid").val(),
                },
                url: prefixe + "ajax.php",
                success: function (retour) {
                    location.reload();
                },
                error: function () {

                }
            });
}
function connexion() {
    $.ajax(
            {
                type: "POST",
                data: {
                    'action': 'connexion',
                    'sid': $("#sid").val(),
                    'id': $("#identifiant").val(),
                    'mdp': $("#pwd").val(),
                },
                url: prefixe + "ajax.php",
                success: function (retour) {
                    window.location.href = "https://a3jdo.cdurteste.fr";
                },
                error: function () {

                }
            });
}

function qteKeyup(elem) {
    var id = $(elem).attr("id").replace("qte", "");
    var stock = $("#stock" + id).val();
    $("#infoPdt" + id).html("");
    console.log(id, $(elem).val(), stock);
    if (parseInt($(elem).val()) > parseInt(stock)) {
        console.log($("#infoPdt" + id));
        $("#infoPdt" + id).html("Qté max dépassée");
        $(elem).val(stock);

    } else {
        var puht = $("#puht" + id).html();
        var totlig = parseInt(puht * $(elem).val() * 100) / 100;
        $("#totlig" + id).html(totlig + " €");
    }

    recapCom();
}

function recapCom() {
    var totHt = 0;
    var totQte = 0;
    var recap = "";
    var infoCart = "";
    var retour = "<table>";
    var envoi = "<tr><td colspan='6' class='right'><span class='buttonnav' onclick='envoyer()'>Passer ma commande</span></td></tr>"
    var totpuht = 0;
    $(".qte").each(function () {
        var id = $(this).attr("id").replace("qte", "");
        var qte = $("#qte" + id).val();
        if (qte !== '') {
            var puht = $("#puht" + id).html();
            var lib = $("#lib" + id).html();
            var totlig = parseInt(puht * qte * 100) / 100;
            totQte += parseInt(qte);
            totHt += totlig;
            totpuht += puht;
            retour += "<tr><td>" + lib + "</td><td class='right'>" + qte + "</td><td class='right'>" + puht + " €</td><td class='right'>" + totlig + " €</td></tr>";
        }
    });
    totHt = parseInt(totHt * 100) / 100;
    retour += "<tr><td colspan='3' class='right'><b>Total H.T. :</b> </td><td class='right'>" + totHt + " €</td></tr>";
    retour = "<table>" + retour + envoi + "</table>";
    $("#recapCommande").html(retour);
    infoCart = "<b>" + totQte + "</b> (" + totHt + "€)"
    $("#mopo-infos-cart").html(infoCart);
}

function envoyer() {
    var data = new FormData();
    data.append("action", "envoyerComm");
    data.append("sid", $("#sid").val());
    data.append("adr_livraison", $("#adr_livraison").val());
    data.append("adr_facturation", $("#adr_facturation").val());
    $("#recapCommande").html("<div class='orderSent'>Votre commande a été envoyée à A3J<br>Vous pouvez suivre son statut sur la page <a href='mes-commandes'>Mes commandes</a></div>");
    $(".qte").each(function () {
        if ($(this).val() !== "") {
            data.append($(this).attr("id"), $(this).val());
        }
    });
    $.ajax(
            {
                type: "POST",
                processData: false,
                contentType: false,
                data: data,
                url: prefixe + "/ajax.php",
                success: function (retour) {

                },
                error: function () {

                }
            });


}

function showhide(ref, elem) {
    if ($(elem).hasClass("deplie")) {
        $(elem).removeClass("deplie");
    } else
    {
        $(elem).addClass("deplie");
    }
    ref = "." + ref;
    if ($(ref).first().hasClass("hidden")) {
        $(ref).removeClass("hidden");
    } else
    {
        $(ref).addClass("hidden");
    }
}

function mopoShow(ref) {


    $(".mopoBlock").each(function () {
        if ($(this).hasClass(ref)) {
            $(this).removeClass("hidden");
        } else
        {
            $(this).addClass("hidden");
        }
    });
    if (ref !== 'mopoCart') {
        $("#mopoCart").addClass("hidden");
        $(".cdAccordeonButton").each(function () {
            $(this).addClass("hidden");
        });
    } else
    {
        $("#mopoCart").removeClass("hidden");
        $(".cdAccordeonButton").each(function () {
            $(this).removeClass("hidden");
        });
    }

}